/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineNumberListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.Transferable;

public class CopyRevisionNumberFromAnnotateAction
extends AnAction
implements LineNumberListener {
    private final UpToDateLineNumberProvider myGetUpToDateLineNumber;
    private final FileAnnotation myAnnotation;
    private int myLineNumber = -1;

    public CopyRevisionNumberFromAnnotateAction(UpToDateLineNumberProvider getUpToDateLineNumber, FileAnnotation annotation) {
        super("Copy revision number");
        this.myGetUpToDateLineNumber = getUpToDateLineNumber;
        this.myAnnotation = annotation;
    }

    public void actionPerformed(AnActionEvent e) {
        if (this.myLineNumber < 0) {
            return;
        }
        int corrected = this.myGetUpToDateLineNumber.getLineNumber(this.myLineNumber);
        VcsRevisionNumber revisionNumber = this.myAnnotation.getLineRevisionNumber(corrected);
        if (revisionNumber != null) {
            String revision = revisionNumber.asString();
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(revision));
        }
    }

    public void update(AnActionEvent e) {
        int corrected = this.myLineNumber;
        boolean enabled = this.myLineNumber >= 0 && (corrected = this.myGetUpToDateLineNumber.getLineNumber(this.myLineNumber)) >= 0 && this.myAnnotation.getLineRevisionNumber(corrected) != null;
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    public void consume(Integer integer) {
        this.myLineNumber = integer;
    }
}

