/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration.createTest;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PackageUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.ui.MemberSelectionTable;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.testIntegration.createTest.CreateTestAction;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CreateTestDialog
extends DialogWrapper {
    private static final String RECENTS_KEY = "CreateTestDialog.RecentsKey";
    private static final String RECENT_SUPERS_KEY = "CreateTestDialog.Recents.Supers";
    private static final String DEFAULT_LIBRARY_NAME_PROPERTY = CreateTestDialog.class.getName() + ".defaultLibrary";
    private static final String SHOW_INHERITED_MEMBERS_PROPERTY = CreateTestDialog.class.getName() + ".includeInheritedMembers";
    private final Project myProject;
    private final PsiClass myTargetClass;
    private final Module myTargetModule;
    private PsiDirectory myTargetDirectory;
    private TestFramework mySelectedFramework;
    private final List<JRadioButton> myLibraryButtons;
    private EditorTextField myTargetClassNameField;
    private ReferenceEditorComboWithBrowseButton mySuperClassField;
    private ReferenceEditorComboWithBrowseButton myTargetPackageField;
    private JCheckBox myGenerateBeforeBox;
    private JCheckBox myGenerateAfterBox;
    private JCheckBox myShowInheritedMethodsBox;
    private MemberSelectionTable myMethodsTable;
    private JButton myFixLibraryButton;
    private JPanel myFixLibraryPanel;
    private JLabel myFixLibraryLabel;
    private JRadioButton myDefaultLibraryButton;

    public CreateTestDialog(@NotNull Project project, @NotNull String title, PsiClass targetClass, PsiPackage targetPackage, Module targetModule) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testIntegration/createTest/CreateTestDialog", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/testIntegration/createTest/CreateTestDialog", "<init>"));
        }
        super(project, true);
        this.myLibraryButtons = new ArrayList<JRadioButton>();
        this.myProject = project;
        this.myTargetClass = targetClass;
        this.myTargetModule = targetModule;
        this.initControls(targetClass, targetPackage);
        this.setTitle(title);
        this.init();
        this.myDefaultLibraryButton.doClick();
    }

    private void initControls(PsiClass targetClass, PsiPackage targetPackage) {
        ButtonGroup group = new ButtonGroup();
        HashMap<String, JRadioButton> nameToButtonMap = new HashMap<String, JRadioButton>();
        ArrayList<Pair> attachedLibraries = new ArrayList<Pair>();
        for (final TestFramework descriptor : (TestFramework[])Extensions.getExtensions((ExtensionPointName)TestFramework.EXTENSION_NAME)) {
            final JRadioButton b = new JRadioButton(descriptor.getName());
            if (descriptor instanceof JavaTestFramework) {
                b.setMnemonic(((JavaTestFramework)descriptor).getMnemonic());
            }
            this.myLibraryButtons.add(b);
            group.add(b);
            nameToButtonMap.put(descriptor.getName(), b);
            if (descriptor.isLibraryAttached(this.myTargetModule)) {
                attachedLibraries.add(Pair.create((Object)descriptor.getName(), (Object)b));
            }
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (b.isSelected()) {
                        CreateTestDialog.this.onLibrarySelected(descriptor);
                    }
                }
            });
        }
        String defaultLibrary = this.getDefaultLibraryName();
        if (attachedLibraries.isEmpty()) {
            if (defaultLibrary != null) {
                this.myDefaultLibraryButton = (JRadioButton)nameToButtonMap.get(defaultLibrary);
            }
        } else {
            if (defaultLibrary != null) {
                for (Pair each : attachedLibraries) {
                    if (!((String)each.first).equals(defaultLibrary)) continue;
                    this.myDefaultLibraryButton = (JRadioButton)each.second;
                }
            }
            if (this.myDefaultLibraryButton == null) {
                this.myDefaultLibraryButton = (JRadioButton)((Pair)attachedLibraries.get((int)0)).second;
            }
        }
        if (this.myDefaultLibraryButton == null) {
            this.myDefaultLibraryButton = this.myLibraryButtons.get(0);
        }
        this.myFixLibraryButton = new JButton(CodeInsightBundle.message((String)"intention.create.test.dialog.fix.library", (Object[])new Object[0]));
        this.myFixLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        if (CreateTestDialog.this.mySelectedFramework instanceof JavaTestFramework) {
                            ((JavaTestFramework)CreateTestDialog.this.mySelectedFramework).setupLibrary(CreateTestDialog.this.myTargetModule);
                        } else {
                            OrderEntryFix.addJarToRoots(CreateTestDialog.this.mySelectedFramework.getLibraryPath(), CreateTestDialog.this.myTargetModule, null);
                        }
                    }
                });
                CreateTestDialog.this.myFixLibraryPanel.setVisible(false);
            }
        });
        this.myTargetClassNameField = new EditorTextField(this.suggestTestClassName(targetClass));
        this.myTargetClassNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                CreateTestDialog.this.getOKAction().setEnabled(PsiNameHelper.getInstance((Project)CreateTestDialog.this.myProject).isIdentifier(CreateTestDialog.this.getClassName()));
            }
        });
        this.mySuperClassField = new ReferenceEditorComboWithBrowseButton(new MyChooseSuperClassAction(), null, this.myProject, true, JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE, RECENT_SUPERS_KEY);
        this.mySuperClassField.setMinimumSize(this.mySuperClassField.getPreferredSize());
        String targetPackageName = targetPackage != null ? targetPackage.getQualifiedName() : "";
        this.myTargetPackageField = new PackageNameReferenceEditorCombo(targetPackageName, this.myProject, RECENTS_KEY, CodeInsightBundle.message((String)"dialog.create.class.package.chooser.title", (Object[])new Object[0]));
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                CreateTestDialog.this.myTargetPackageField.getButton().doClick();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64)), this.myTargetPackageField.getChildComponent());
        this.myGenerateBeforeBox = new JCheckBox(CodeInsightBundle.message((String)"intention.create.test.dialog.setUp", (Object[])new Object[0]));
        this.myGenerateAfterBox = new JCheckBox(CodeInsightBundle.message((String)"intention.create.test.dialog.tearDown", (Object[])new Object[0]));
        this.myShowInheritedMethodsBox = new JCheckBox(CodeInsightBundle.message((String)"intention.create.test.dialog.show.inherited", (Object[])new Object[0]));
        this.myShowInheritedMethodsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateTestDialog.this.updateMethodsTable();
            }
        });
        this.restoreShowInheritedMembersStatus();
        this.myMethodsTable = new MemberSelectionTable(Collections.<MemberInfo>emptyList(), null);
        this.updateMethodsTable();
    }

    protected String suggestTestClassName(PsiClass targetClass) {
        return targetClass.getName() + "Test";
    }

    private boolean isSuperclassSelectedManually() {
        String superClass = this.mySuperClassField.getText();
        if (StringUtil.isEmptyOrSpaces((String)superClass)) {
            return false;
        }
        for (TestFramework framework : (TestFramework[])TestFramework.EXTENSION_NAME.getExtensions()) {
            if (!superClass.equals(framework.getDefaultSuperClass())) continue;
            return false;
        }
        return true;
    }

    private void onLibrarySelected(TestFramework descriptor) {
        if (descriptor.isLibraryAttached(this.myTargetModule)) {
            this.myFixLibraryPanel.setVisible(false);
        } else {
            this.myFixLibraryPanel.setVisible(true);
            String text = CodeInsightBundle.message((String)"intention.create.test.dialog.library.not.found", (Object[])new Object[]{descriptor.getName()});
            this.myFixLibraryLabel.setText(text);
            this.myFixLibraryButton.setVisible(descriptor.getLibraryPath() != null);
        }
        String superClass = descriptor.getDefaultSuperClass();
        if (this.isSuperclassSelectedManually()) {
            if (superClass != null) {
                String currentSuperClass = this.mySuperClassField.getText();
                this.mySuperClassField.appendItem(superClass);
                this.mySuperClassField.setText(currentSuperClass);
            }
        } else {
            this.mySuperClassField.appendItem(StringUtil.notNullize((String)superClass));
            ((EditorComboBox)this.mySuperClassField.getChildComponent()).setSelectedItem(StringUtil.notNullize((String)superClass));
        }
        this.mySelectedFramework = descriptor;
    }

    private void updateMethodsTable() {
        List<MemberInfo> methods = TestIntegrationUtils.extractClassMethods(this.myTargetClass, this.myShowInheritedMethodsBox.isSelected());
        HashSet<PsiElement> selectedMethods = new HashSet<PsiElement>();
        for (MemberInfo each : this.myMethodsTable.getSelectedMemberInfos()) {
            selectedMethods.add(each.getMember());
        }
        for (MemberInfo each : methods) {
            each.setChecked(selectedMethods.contains(each.getMember()));
        }
        this.myMethodsTable.setMemberInfos(methods);
    }

    private String getDefaultLibraryName() {
        return this.getProperties().getValue(DEFAULT_LIBRARY_NAME_PROPERTY);
    }

    private void saveDefaultLibraryName() {
        this.getProperties().setValue(DEFAULT_LIBRARY_NAME_PROPERTY, this.mySelectedFramework.getName());
    }

    private void restoreShowInheritedMembersStatus() {
        String v = this.getProperties().getValue(SHOW_INHERITED_MEMBERS_PROPERTY);
        this.myShowInheritedMethodsBox.setSelected(v != null && v.equals("true"));
    }

    private void saveShowInheritedMembersStatus() {
        boolean v = this.myShowInheritedMethodsBox.isSelected();
        this.getProperties().setValue(SHOW_INHERITED_MEMBERS_PROPERTY, Boolean.toString(v));
    }

    private PropertiesComponent getProperties() {
        return PropertiesComponent.getInstance((Project)this.myProject);
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/createTest/CreateTestDialog", "createActions"));
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTargetClassNameField;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.fill = 2;
        constr.anchor = 17;
        JPanel librariesPanel = new JPanel();
        BoxLayout l = new BoxLayout(librariesPanel, 0);
        librariesPanel.setLayout(l);
        for (JRadioButton b : this.myLibraryButtons) {
            librariesPanel.add(b);
        }
        int gridy = 1;
        constr.insets = CreateTestDialog.insets(4);
        constr.gridy = gridy++;
        constr.gridx = 0;
        constr.weightx = 0.0;
        panel.add((Component)new JLabel(CodeInsightBundle.message((String)"intention.create.test.dialog.testing.library", (Object[])new Object[0])), constr);
        constr.gridx = 1;
        constr.weightx = 1.0;
        constr.gridwidth = 0;
        panel.add((Component)librariesPanel, constr);
        this.myFixLibraryPanel = new JPanel(new BorderLayout());
        this.myFixLibraryLabel = new JLabel();
        this.myFixLibraryLabel.setIcon(AllIcons.Actions.IntentionBulb);
        this.myFixLibraryPanel.add((Component)this.myFixLibraryLabel, "Center");
        this.myFixLibraryPanel.add((Component)this.myFixLibraryButton, "East");
        constr.insets = CreateTestDialog.insets(1);
        constr.gridy = gridy++;
        constr.gridx = 0;
        panel.add((Component)this.myFixLibraryPanel, constr);
        constr.gridheight = 1;
        constr.insets = CreateTestDialog.insets(6);
        constr.gridy = gridy++;
        constr.gridx = 0;
        constr.weightx = 0.0;
        constr.gridwidth = 1;
        panel.add((Component)new JLabel(CodeInsightBundle.message((String)"intention.create.test.dialog.class.name", (Object[])new Object[0])), constr);
        constr.gridx = 1;
        constr.weightx = 1.0;
        panel.add((Component)((Object)this.myTargetClassNameField), constr);
        constr.insets = CreateTestDialog.insets(1);
        constr.gridy = gridy++;
        constr.gridx = 0;
        constr.weightx = 0.0;
        panel.add((Component)new JLabel(CodeInsightBundle.message((String)"intention.create.test.dialog.super.class", (Object[])new Object[0])), constr);
        constr.gridx = 1;
        constr.weightx = 1.0;
        panel.add((Component)((Object)this.mySuperClassField), constr);
        constr.insets = CreateTestDialog.insets(1);
        constr.gridy = gridy++;
        constr.gridx = 0;
        constr.weightx = 0.0;
        panel.add((Component)new JLabel(CodeInsightBundle.message((String)"dialog.create.class.destination.package.label", (Object[])new Object[0])), constr);
        constr.gridx = 1;
        constr.weightx = 1.0;
        JPanel targetPackagePanel = new JPanel(new BorderLayout());
        targetPackagePanel.add((Component)((Object)this.myTargetPackageField), "Center");
        panel.add((Component)targetPackagePanel, constr);
        constr.insets = CreateTestDialog.insets(6);
        constr.gridy = gridy++;
        constr.gridx = 0;
        constr.weightx = 0.0;
        panel.add((Component)new JLabel(CodeInsightBundle.message((String)"intention.create.test.dialog.generate", (Object[])new Object[0])), constr);
        constr.gridx = 1;
        constr.weightx = 1.0;
        panel.add((Component)this.myGenerateBeforeBox, constr);
        constr.insets = CreateTestDialog.insets(1);
        constr.gridy = gridy++;
        panel.add((Component)this.myGenerateAfterBox, constr);
        constr.insets = CreateTestDialog.insets(6);
        constr.gridy = gridy++;
        constr.gridx = 0;
        constr.weightx = 0.0;
        JLabel membersLabel = new JLabel(CodeInsightBundle.message((String)"intention.create.test.dialog.select.methods", (Object[])new Object[0]));
        membersLabel.setLabelFor((Component)((Object)this.myMethodsTable));
        panel.add((Component)membersLabel, constr);
        constr.gridx = 1;
        constr.weightx = 1.0;
        panel.add((Component)this.myShowInheritedMethodsBox, constr);
        constr.insets = CreateTestDialog.insets(1, 8);
        constr.gridy = gridy++;
        constr.gridx = 0;
        constr.gridwidth = 0;
        constr.fill = 1;
        constr.weighty = 1.0;
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myMethodsTable)), constr);
        return panel;
    }

    private static Insets insets(int top) {
        return CreateTestDialog.insets(top, 0);
    }

    private static Insets insets(int top, int bottom) {
        return new Insets(top, 8, bottom, 8);
    }

    public String getClassName() {
        return this.myTargetClassNameField.getText();
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    @Nullable
    public String getSuperClassName() {
        String result = this.mySuperClassField.getText().trim();
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    public Collection<MemberInfo> getSelectedMethods() {
        return this.myMethodsTable.getSelectedMemberInfos();
    }

    public boolean shouldGeneratedAfter() {
        return this.myGenerateAfterBox.isSelected();
    }

    public boolean shouldGeneratedBefore() {
        return this.myGenerateBeforeBox.isSelected();
    }

    public TestFramework getSelectedTestFrameworkDescriptor() {
        return this.mySelectedFramework;
    }

    protected void doOKAction() {
        String errorMessage;
        RecentsManager.getInstance(this.myProject).registerRecentEntry(RECENTS_KEY, this.myTargetPackageField.getText());
        RecentsManager.getInstance(this.myProject).registerRecentEntry(RECENT_SUPERS_KEY, this.mySuperClassField.getText());
        try {
            this.myTargetDirectory = this.selectTargetDirectory();
            if (this.myTargetDirectory == null) {
                return;
            }
            errorMessage = RefactoringMessageUtil.checkCanCreateClass(this.myTargetDirectory, this.getClassName());
        }
        catch (IncorrectOperationException e) {
            errorMessage = e.getMessage();
        }
        if (errorMessage != null) {
            Messages.showMessageDialog((Project)this.myProject, (String)errorMessage, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        }
        this.saveDefaultLibraryName();
        this.saveShowInheritedMembersStatus();
        super.doOKAction();
    }

    @Nullable
    private PsiDirectory selectTargetDirectory() throws IncorrectOperationException {
        PackageWrapper targetPackage;
        final String packageName = this.getPackageName();
        final VirtualFile selectedRoot = (VirtualFile)new ReadAction<VirtualFile>(targetPackage = new PackageWrapper(PsiManager.getInstance((Project)this.myProject), packageName)){
            final /* synthetic */ PackageWrapper val$targetPackage;
            {
                this.val$targetPackage = packageWrapper;
            }

            protected void run(Result<VirtualFile> result) throws Throwable {
                List<Object> roots;
                HashSet<VirtualFile> testFolders = new HashSet<VirtualFile>();
                CreateTestAction.checkForTestRoots(CreateTestDialog.this.myTargetModule, testFolders);
                if (testFolders.isEmpty()) {
                    roots = ModuleRootManager.getInstance((Module)CreateTestDialog.this.myTargetModule).getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
                    if (roots.isEmpty()) {
                        return;
                    }
                } else {
                    roots = new ArrayList<VirtualFile>(testFolders);
                }
                if (roots.size() == 1) {
                    result.setResult(roots.get(0));
                } else {
                    PsiDirectory defaultDir = CreateTestDialog.this.chooseDefaultDirectory(packageName);
                    result.setResult((Object)MoveClassesOrPackagesUtil.chooseSourceRoot(this.val$targetPackage, roots, defaultDir));
                }
            }
        }.execute().getResultObject();
        if (selectedRoot == null) {
            return null;
        }
        return (PsiDirectory)new WriteCommandAction<PsiDirectory>(this.myProject, CodeInsightBundle.message((String)"create.directory.command", (Object[])new Object[0]), new PsiFile[0]){

            protected void run(Result<PsiDirectory> result) throws Throwable {
                result.setResult((Object)RefactoringUtil.createPackageDirectoryInSourceRoot(targetPackage, selectedRoot));
            }
        }.execute().getResultObject();
    }

    @Nullable
    private PsiDirectory chooseDefaultDirectory(String packageName) {
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        for (VirtualFile file : ModuleRootManager.getInstance((Module)this.myTargetModule).getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE)) {
            PsiDirectory dir = PsiManager.getInstance((Project)this.myProject).findDirectory(file);
            if (dir == null) continue;
            dirs.add(dir);
        }
        if (!dirs.isEmpty()) {
            for (PsiDirectory dir : dirs) {
                String dirName = dir.getVirtualFile().getPath();
                if (dirName.contains("generated")) continue;
                return dir;
            }
            return (PsiDirectory)dirs.get(0);
        }
        return PackageUtil.findPossiblePackageDirectoryInModule(this.myTargetModule, packageName);
    }

    private String getPackageName() {
        String name = this.myTargetPackageField.getText();
        return name != null ? name.trim() : "";
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.dialogs.createTest");
    }

    private class MyChooseSuperClassAction
    implements ActionListener {
        private MyChooseSuperClassAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeClassChooserFactory f = TreeClassChooserFactory.getInstance((Project)CreateTestDialog.this.myProject);
            TreeClassChooser dialog = f.createAllProjectScopeChooser(CodeInsightBundle.message((String)"intention.create.test.dialog.choose.super.class", (Object[])new Object[0]));
            dialog.showDialog();
            PsiClass aClass = dialog.getSelected();
            if (aClass != null) {
                String superClass = aClass.getQualifiedName();
                CreateTestDialog.this.mySuperClassField.appendItem(superClass);
                ((EditorComboBox)CreateTestDialog.this.mySuperClassField.getChildComponent()).setSelectedItem(superClass);
            }
        }
    }
}

