/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.codeInsight.lookup.LookupValueFactory;
import com.intellij.codeInsight.lookup.LookupValueWithPriority;
import com.intellij.codeInsight.lookup.LookupValueWithUIHint;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpProperty;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpPropertyImpl
extends RegExpElementImpl
implements RegExpProperty {
    private static final String[] UNICODE_BLOCKS;

    public RegExpPropertyImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public PsiReference getReference() {
        ASTNode lbrace = this.getNode().findChildByType(RegExpTT.LBRACE);
        if (lbrace == null) {
            return null;
        }
        return new MyPsiReference();
    }

    @Override
    public boolean isNegated() {
        ASTNode node = this.getNode().findChildByType(RegExpTT.PROPERTY);
        return node != null && node.textContains('P');
    }

    @Override
    @Nullable
    public ASTNode getCategoryNode() {
        return this.getNode().findChildByType(RegExpTT.NAME);
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpProperty(this);
    }

    static {
        Field[] fields = Character.UnicodeBlock.class.getFields();
        ArrayList<String> unicodeBlocks = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            if (!field.getType().equals(Character.UnicodeBlock.class) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            unicodeBlocks.add("In" + field.getName());
        }
        UNICODE_BLOCKS = ArrayUtil.toStringArray(unicodeBlocks);
    }

    private class MyPsiReference
    implements PsiReference {
        private MyPsiReference() {
        }

        public PsiElement getElement() {
            return RegExpPropertyImpl.this;
        }

        public TextRange getRangeInElement() {
            ASTNode lbrace = RegExpPropertyImpl.this.getNode().findChildByType(RegExpTT.LBRACE);
            assert (lbrace != null);
            ASTNode rbrace = RegExpPropertyImpl.this.getNode().findChildByType(RegExpTT.RBRACE);
            int to = rbrace == null ? RegExpPropertyImpl.this.getTextRange().getEndOffset() : rbrace.getTextRange().getEndOffset() - 1;
            TextRange t = new TextRange(lbrace.getStartOffset() + 1, to);
            return t.shiftRight(-RegExpPropertyImpl.this.getTextRange().getStartOffset());
        }

        @Nullable
        public PsiElement resolve() {
            return RegExpPropertyImpl.this;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.getRangeInElement().substring(this.getElement().getText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpPropertyImpl$MyPsiReference", "getCanonicalText"));
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            throw new IncorrectOperationException();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/regexp/psi/impl/RegExpPropertyImpl$MyPsiReference", "bindToElement"));
            }
            throw new IncorrectOperationException();
        }

        public boolean isReferenceTo(PsiElement element) {
            return false;
        }

        @NotNull
        public Object[] getVariants() {
            ASTNode categoryNode = RegExpPropertyImpl.this.getCategoryNode();
            if (categoryNode != null && categoryNode.getText().startsWith("In") && !categoryNode.getText().startsWith("Intelli")) {
                Object[] objectArray = UNICODE_BLOCKS;
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpPropertyImpl$MyPsiReference", "getVariants"));
                }
                return objectArray;
            }
            String[][] knownProperties = RegExpLanguageHosts.getInstance().getAllKnownProperties(this.getElement());
            Object[] objects = new Object[knownProperties.length];
            for (int i = 0; i < objects.length; ++i) {
                String[] prop = knownProperties[i];
                objects[i] = new MyLookupValue(prop);
            }
            if (objects == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpPropertyImpl$MyPsiReference", "getVariants"));
            }
            return objects;
        }

        public boolean isSoft() {
            return true;
        }

        private class MyLookupValue
        extends LookupValueFactory.LookupValueWithIcon
        implements LookupValueWithPriority,
        LookupValueWithUIHint {
            private final String[] myProp;

            public MyLookupValue(String[] prop) {
                super(prop[0], PlatformIcons.PROPERTY_ICON);
                this.myProp = prop;
            }

            @Override
            public String getPresentation() {
                ASTNode categoryNode = RegExpPropertyImpl.this.getCategoryNode();
                if (categoryNode != null && categoryNode.getText().startsWith("Is")) {
                    return "Is" + super.getPresentation();
                }
                return super.getPresentation();
            }

            @Override
            public int getPriority() {
                String name = this.myProp[0];
                if (name.equals("all")) {
                    return 3;
                }
                if (name.startsWith("java")) {
                    return 1;
                }
                return name.length() > 2 ? 2 : 0;
            }

            @Override
            public String getTypeHint() {
                return this.myProp.length > 1 ? this.myProp[1] : "Character.is" + this.myProp[0].substring("java".length()) + "()";
            }

            @Override
            @Nullable
            public Color getColorHint() {
                return null;
            }

            @Override
            public boolean isBold() {
                return false;
            }
        }
    }
}

