/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderUtil;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.SingleConnectionNetService;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.MessageDecoder;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.FastCgiDecoder;
import org.jetbrains.io.fastCgi.FastCgiRequest;

public abstract class FastCgiService
extends SingleConnectionNetService {
    protected static final Logger LOG = Logger.getInstance(FastCgiService.class);
    private final AtomicInteger requestIdCounter;
    protected final ConcurrentIntObjectMap<Channel> requests;

    public FastCgiService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/io/fastCgi/FastCgiService", "<init>"));
        }
        super(project);
        this.requestIdCounter = new AtomicInteger();
        this.requests = ContainerUtil.createConcurrentIntObjectMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeProcessConnections() {
        try {
            super.closeProcessConnections();
        }
        finally {
            this.requestIdCounter.set(0);
            if (!this.requests.isEmpty()) {
                List waitingClients = ContainerUtil.toList((Enumeration)this.requests.elements());
                this.requests.clear();
                for (Channel channel : waitingClients) {
                    FastCgiService.sendBadGateway(channel);
                }
            }
        }
    }

    private static void sendBadGateway(@NotNull Channel channel) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/io/fastCgi/FastCgiService", "sendBadGateway"));
        }
        try {
            if (channel.isActive()) {
                Responses.sendStatus(HttpResponseStatus.BAD_GATEWAY, channel);
            }
        }
        catch (Throwable e) {
            NettyUtil.log(e, LOG);
        }
    }

    @Override
    protected void configureBootstrap(@NotNull Bootstrap bootstrap, final @NotNull Consumer<String> errorOutputConsumer) {
        if (bootstrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bootstrap", "org/jetbrains/io/fastCgi/FastCgiService", "configureBootstrap"));
        }
        if (errorOutputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorOutputConsumer", "org/jetbrains/io/fastCgi/FastCgiService", "configureBootstrap"));
        }
        bootstrap.handler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast("fastCgiDecoder", (ChannelHandler)new FastCgiDecoder((Consumer<String>)errorOutputConsumer, FastCgiService.this));
                channel.pipeline().addLast("exceptionHandler", ChannelExceptionHandler.getInstance());
            }
        });
    }

    public void send(final @NotNull FastCgiRequest fastCgiRequest, @NotNull ByteBuf content) {
        ByteBuf notEmptyContent;
        if (fastCgiRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fastCgiRequest", "org/jetbrains/io/fastCgi/FastCgiService", "send"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/io/fastCgi/FastCgiService", "send"));
        }
        if (content.isReadable()) {
            content.retain();
            notEmptyContent = content;
            notEmptyContent.touch();
        } else {
            notEmptyContent = null;
        }
        try {
            if (this.processHandler.has()) {
                fastCgiRequest.writeToServerChannel(notEmptyContent, this.processChannel);
            } else {
                this.processHandler.get().done((Consumer)new Consumer<OSProcessHandler>(){

                    public void consume(OSProcessHandler osProcessHandler) {
                        fastCgiRequest.writeToServerChannel(notEmptyContent, FastCgiService.this.processChannel);
                    }
                }).rejected((Consumer)new Consumer<Throwable>(){

                    public void consume(Throwable error) {
                        LOG.error(error);
                        FastCgiService.this.handleError(fastCgiRequest, notEmptyContent);
                    }
                });
            }
        }
        catch (Throwable e) {
            LOG.error(e);
            this.handleError(fastCgiRequest, notEmptyContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(@NotNull FastCgiRequest fastCgiRequest, @Nullable ByteBuf content) {
        if (fastCgiRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fastCgiRequest", "org/jetbrains/io/fastCgi/FastCgiService", "handleError"));
        }
        try {
            if (content != null && content.refCnt() != 0) {
                content.release();
            }
        }
        finally {
            Channel channel = (Channel)this.requests.remove(fastCgiRequest.requestId);
            if (channel != null) {
                FastCgiService.sendBadGateway(channel);
            }
        }
    }

    public int allocateRequestId(@NotNull Channel channel) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/io/fastCgi/FastCgiService", "allocateRequestId"));
        }
        int requestId = this.requestIdCounter.getAndIncrement();
        if (requestId >= Short.MAX_VALUE) {
            this.requestIdCounter.set(0);
            requestId = this.requestIdCounter.getAndDecrement();
        }
        this.requests.put(requestId, (Object)channel);
        return requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void responseReceived(int id, @Nullable ByteBuf buffer) {
        Channel channel = (Channel)this.requests.remove(id);
        if (channel == null || !channel.isActive()) {
            if (buffer != null) {
                buffer.release();
            }
            return;
        }
        if (buffer == null) {
            Responses.sendStatus(HttpResponseStatus.BAD_GATEWAY, channel);
            return;
        }
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buffer);
        try {
            FastCgiService.parseHeaders((HttpResponse)httpResponse, buffer);
            Responses.addServer((HttpResponse)httpResponse);
            if (!HttpHeaderUtil.isContentLengthSet((HttpMessage)httpResponse)) {
                HttpHeaderUtil.setContentLength((HttpMessage)httpResponse, (long)buffer.readableBytes());
            }
        }
        catch (Throwable e) {
            buffer.release();
            try {
                LOG.error(e);
            }
            finally {
                Responses.sendStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR, channel);
            }
            return;
        }
        channel.writeAndFlush((Object)httpResponse);
    }

    private static void parseHeaders(@NotNull HttpResponse response, @NotNull ByteBuf buffer) {
        if (response == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "org/jetbrains/io/fastCgi/FastCgiService", "parseHeaders"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/fastCgi/FastCgiService", "parseHeaders"));
        }
        StringBuilder builder = new StringBuilder();
        while (buffer.isReadable()) {
            byte b;
            builder.setLength(0);
            String key = null;
            boolean valueExpected = true;
            while ((b = buffer.readByte()) >= 0 && b != 10) {
                if (b == 13) continue;
                if (valueExpected && b == 58) {
                    valueExpected = false;
                    key = builder.toString();
                    builder.setLength(0);
                    MessageDecoder.skipWhitespace(buffer);
                    continue;
                }
                builder.append((char)b);
            }
            if (builder.length() == 0) {
                return;
            }
            if (StringUtil.isEmpty(key) || StringUtilRt.startsWithIgnoreCase(key, (String)"http") || StringUtilRt.startsWithIgnoreCase(key, (String)"X-Accel-")) continue;
            String value = builder.toString();
            if (key.equalsIgnoreCase("status")) {
                int index = value.indexOf(32);
                if (index == -1) {
                    LOG.warn("Cannot parse status: " + value);
                    response.setStatus(HttpResponseStatus.OK);
                    continue;
                }
                response.setStatus(HttpResponseStatus.valueOf((int)Integer.parseInt(value.substring(0, index))));
                continue;
            }
            if (key.startsWith("http") || key.startsWith("HTTP")) continue;
            response.headers().add(key, (Object)value);
        }
    }
}

