/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.rmi.RemoteProcessSupport;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.annotations.Attribute;
import gnu.trove.THashMap;
import java.io.File;
import java.io.FilenameFilter;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.server.MavenIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerConsole;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerIndicesProcessor;
import org.jetbrains.idea.maven.server.MavenServerLogger;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.slf4j.Logger;
import org.slf4j.impl.Log4jLoggerFactory;

@com.intellij.openapi.components.State(name="MavenVersion", storages={@Storage(file="$APP_CONFIG$/mavenVersion.xml")})
public class MavenServerManager
extends RemoteObjectWrapper<MavenServer>
implements PersistentStateComponent<State> {
    public static final String BUNDLED_MAVEN_2 = "Bundled (Maven 2)";
    public static final String BUNDLED_MAVEN_3 = "Bundled (Maven 3)";
    @NonNls
    private static final String MAIN_CLASS = "org.jetbrains.idea.maven.server.RemoteMavenServer";
    private static final String DEFAULT_VM_OPTIONS = "-Xmx512m";
    private static final String FORCE_MAVEN2_OPTION = "-Didea.force.maven2";
    private final RemoteProcessSupport<Object, MavenServer, Object> mySupport;
    private final RemoteMavenServerLogger myLogger = new RemoteMavenServerLogger();
    private final RemoteMavenServerDownloadListener myDownloadListener = new RemoteMavenServerDownloadListener();
    private boolean myLoggerExported;
    private boolean myDownloadListenerExported;
    private final Alarm myShutdownAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
    private State myState = new State();
    private final File myBundledMaven2Home;
    private final File myBundledMaven3Home;

    public static MavenServerManager getInstance() {
        return (MavenServerManager)ServiceManager.getService(MavenServerManager.class);
    }

    public MavenServerManager() {
        super(null);
        File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        String root = pluginFileOrDir.getParent();
        if (pluginFileOrDir.isDirectory()) {
            File parentFile = MavenServerManager.getMavenPluginParentFile();
            this.myBundledMaven2Home = new File(parentFile, "maven2-server-impl/lib/maven2");
            this.myBundledMaven3Home = new File(parentFile, "maven30-server-impl/lib/maven3");
        } else {
            this.myBundledMaven2Home = new File(root, "maven2");
            this.myBundledMaven3Home = new File(root, "maven3");
        }
        this.mySupport = new RemoteProcessSupport<Object, MavenServer, Object>(MavenServer.class){

            protected void fireModificationCountChanged() {
            }

            protected String getName(Object file) {
                return MavenServerManager.class.getSimpleName();
            }

            protected RunProfileState getRunProfileState(Object target, Object configuration, Executor executor) {
                return MavenServerManager.this.createRunProfileState();
            }
        };
        ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

            @Override
            public void run() {
                MavenServerManager.this.shutdown(false);
            }
        });
    }

    @Override
    @NotNull
    protected synchronized MavenServer create() throws RemoteException {
        MavenServer result;
        try {
            result = (MavenServer)this.mySupport.acquire((Object)this, (Object)"");
        }
        catch (Exception e) {
            throw new RemoteException("Cannot start maven service", e);
        }
        boolean bl = this.myLoggerExported = UnicastRemoteObject.exportObject((Remote)((Object)this.myLogger), 0) != null;
        if (!this.myLoggerExported) {
            throw new RemoteException("Cannot export logger object");
        }
        boolean bl2 = this.myDownloadListenerExported = UnicastRemoteObject.exportObject((Remote)((Object)this.myDownloadListener), 0) != null;
        if (!this.myDownloadListenerExported) {
            throw new RemoteException("Cannot export download listener object");
        }
        result.set((MavenServerLogger)this.myLogger, (MavenServerDownloadListener)this.myDownloadListener);
        MavenServer mavenServer = result;
        if (mavenServer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager", "create"));
        }
        return mavenServer;
    }

    public synchronized void shutdown(boolean wait) {
        this.mySupport.stopAll(wait);
        this.cleanup();
    }

    @Override
    protected synchronized void cleanup() {
        super.cleanup();
        if (this.myLoggerExported) {
            try {
                UnicastRemoteObject.unexportObject((Remote)((Object)this.myLogger), true);
            }
            catch (RemoteException e) {
                MavenLog.LOG.error((Throwable)e);
            }
            this.myLoggerExported = false;
        }
        if (this.myDownloadListenerExported) {
            try {
                UnicastRemoteObject.unexportObject((Remote)((Object)this.myDownloadListener), true);
            }
            catch (RemoteException e) {
                MavenLog.LOG.error((Throwable)e);
            }
            this.myDownloadListenerExported = false;
        }
        this.myShutdownAlarm.cancelAllRequests();
    }

    @NotNull
    private Sdk getJdk() {
        Sdk jdk;
        String javaHome;
        if (this.myState.embedderJdk.equals("#JAVA_HOME") && !StringUtil.isEmptyOrSpaces((String)(javaHome = System.getenv("JAVA_HOME"))) && (jdk = JavaSdk.getInstance().createJdk("", javaHome)) != null) {
            Sdk sdk = jdk;
            if (sdk == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager", "getJdk"));
            }
            return sdk;
        }
        for (Sdk projectJdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!projectJdk.getName().equals(this.myState.embedderJdk)) continue;
            Sdk sdk = projectJdk;
            if (sdk == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager", "getJdk"));
            }
            return sdk;
        }
        Sdk sdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
        if (sdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager", "getJdk"));
        }
        return sdk;
    }

    private RunProfileState createRunProfileState() {
        return new CommandLineState(null){

            private SimpleJavaParameters createJavaParameters() {
                String mavenEmbedderParameters;
                boolean bl;
                String arch;
                SimpleJavaParameters params = new SimpleJavaParameters();
                Sdk jdk = MavenServerManager.this.getJdk();
                params.setJdk(jdk);
                params.setWorkingDirectory(PathManager.getBinPath());
                params.setMainClass(MavenServerManager.MAIN_CLASS);
                THashMap defs = new THashMap();
                defs.putAll(MavenUtil.getPropertiesFromMavenOpts());
                for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (!(key instanceof String) || !(value instanceof String) || !((String)key).startsWith("javax.net.ssl")) continue;
                    defs.put((String)key, (String)value);
                }
                if (SystemInfo.isMac && (arch = System.getProperty("sun.arch.data.model")) != null) {
                    params.getVMParametersList().addParametersString("-d" + arch);
                }
                defs.put("java.awt.headless", "true");
                for (Map.Entry<Object, Object> entry : defs.entrySet()) {
                    params.getVMParametersList().defineProperty((String)entry.getKey(), (String)entry.getValue());
                }
                params.getVMParametersList().addProperty("idea.version=", MavenUtil.getIdeaVersionToPassToMavenProcess());
                boolean xmxSet = false;
                boolean bl2 = false;
                if (((MavenServerManager)MavenServerManager.this).myState.vmOptions != null) {
                    ParametersList mavenOptsList = new ParametersList();
                    mavenOptsList.addParametersString(((MavenServerManager)MavenServerManager.this).myState.vmOptions);
                    for (String param : mavenOptsList.getParameters()) {
                        if (param.startsWith("-Xmx")) {
                            xmxSet = true;
                        }
                        if (param.equals(MavenServerManager.FORCE_MAVEN2_OPTION)) {
                            bl = true;
                        }
                        params.getVMParametersList().add(param);
                    }
                }
                String currentMavenVersion = bl ? "2.2.1" : MavenServerManager.this.getCurrentMavenVersion();
                String version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
                if (StringUtil.compareVersionNumbers((String)currentMavenVersion, (String)"3.3.1") >= 0 && StringUtil.compareVersionNumbers((String)version, (String)"1.7") < 0) {
                    new Notification("Maven", "", "Maven 3.3.1+ requires JDK 1.7+. Please set appropriate JDK at <br>Settings | Build, Execution, Deployment | Build Tools | Maven | Importing | JDK for Importer", NotificationType.WARNING).notify(null);
                }
                ArrayList<String> classPath = new ArrayList<String>();
                classPath.add(PathUtil.getJarPathForClass(org.apache.log4j.Logger.class));
                if (currentMavenVersion == null || StringUtil.compareVersionNumbers((String)currentMavenVersion, (String)"3.1") < 0) {
                    classPath.add(PathUtil.getJarPathForClass(Logger.class));
                    classPath.add(PathUtil.getJarPathForClass(Log4jLoggerFactory.class));
                }
                classPath.addAll(PathManager.getUtilClassPath());
                ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(Query.class), classPath);
                params.getClassPath().add(PathManager.getResourceRoot(((Object)((Object)this)).getClass(), (String)"/messages/CommonBundle.properties"));
                params.getClassPath().addAll(classPath);
                params.getClassPath().addAllFiles(MavenServerManager.this.collectClassPathAndLibsFolder(bl));
                String embedderXmx = System.getProperty("idea.maven.embedder.xmx");
                if (embedderXmx != null) {
                    params.getVMParametersList().add("-Xmx" + embedderXmx);
                } else if (!xmxSet) {
                    params.getVMParametersList().add(MavenServerManager.DEFAULT_VM_OPTIONS);
                }
                String mavenEmbedderDebugPort = System.getProperty("idea.maven.embedder.debug.port");
                if (mavenEmbedderDebugPort != null) {
                    params.getVMParametersList().addParametersString("-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=" + mavenEmbedderDebugPort);
                }
                if ((mavenEmbedderParameters = System.getProperty("idea.maven.embedder.parameters")) != null) {
                    params.getProgramParametersList().addParametersString(mavenEmbedderParameters);
                }
                return params;
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/idea/maven/server/MavenServerManager$3", "execute"));
                }
                if (runner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "org/jetbrains/idea/maven/server/MavenServerManager$3", "execute"));
                }
                OSProcessHandler processHandler = this.startProcess();
                DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult(null, (ProcessHandler)processHandler, AnAction.EMPTY_ARRAY);
                if (defaultExecutionResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager$3", "execute"));
                }
                return defaultExecutionResult;
            }

            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                SimpleJavaParameters params = this.createJavaParameters();
                Sdk sdk = params.getJdk();
                assert (sdk != null) : "SDK should be defined";
                String exePath = ((JavaSdkType)sdk.getSdkType()).getVMExecutablePath(sdk);
                GeneralCommandLine commandLine = JdkUtil.setupJVMCommandLine((String)exePath, (SimpleJavaParameters)params, (boolean)false);
                OSProcessHandler processHandler = new OSProcessHandler(commandLine.createProcess(), commandLine.getCommandLineString(), commandLine.getCharset());
                processHandler.setShouldDestroyProcessRecursively(false);
                OSProcessHandler oSProcessHandler = processHandler;
                if (oSProcessHandler == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager$3", "startProcess"));
                }
                return oSProcessHandler;
            }
        };
    }

    public static File getMavenLibDirectory() {
        return new File(MavenServerManager.getInstance().getCurrentMavenHomeFile(), "lib");
    }

    @Nullable
    public String getMavenVersion(@Nullable String mavenHome) {
        return MavenUtil.getMavenVersion(this.getMavenHomeFile(mavenHome));
    }

    @Nullable
    public String getMavenVersion(@Nullable File mavenHome) {
        return MavenUtil.getMavenVersion(mavenHome);
    }

    public String getCurrentMavenVersion() {
        return this.getMavenVersion(this.myState.mavenHome);
    }

    public List<File> collectClassPathAndLibsFolder(boolean forceMaven2) {
        String currentMavenVersion;
        String string = currentMavenVersion = forceMaven2 ? "2.2.1" : this.getCurrentMavenVersion();
        File mavenHome = forceMaven2 ? this.myBundledMaven2Home : (currentMavenVersion == null ? this.myBundledMaven3Home : this.getCurrentMavenHomeFile());
        File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        ArrayList<File> classpath = new ArrayList<File>();
        String root = pluginFileOrDir.getParent();
        if (pluginFileOrDir.isDirectory()) {
            classpath.add(new File(root, "maven-server-api"));
            File parentFile = MavenServerManager.getMavenPluginParentFile();
            if (forceMaven2 || currentMavenVersion != null && StringUtil.compareVersionNumbers((String)currentMavenVersion, (String)"3") < 0) {
                classpath.add(new File(root, "maven2-server-impl"));
                MavenServerManager.addDir(classpath, new File(parentFile, "maven2-server-impl/lib"));
                if (StringUtil.compareVersionNumbers((String)currentMavenVersion, (String)"2.1.0") < 0) {
                    mavenHome = this.myBundledMaven2Home;
                }
            } else {
                classpath.add(new File(root, "maven3-server-common"));
                MavenServerManager.addDir(classpath, new File(parentFile, "maven3-server-common/lib"));
                if (currentMavenVersion == null || StringUtil.compareVersionNumbers((String)currentMavenVersion, (String)"3.1") < 0) {
                    classpath.add(new File(root, "maven30-server-impl"));
                } else {
                    classpath.add(new File(root, "maven32-server-impl"));
                }
            }
        } else {
            classpath.add(new File(root, "maven-server-api.jar"));
            if (forceMaven2 || currentMavenVersion != null && StringUtil.compareVersionNumbers((String)currentMavenVersion, (String)"3") < 0) {
                classpath.add(new File(root, "maven2-server-impl.jar"));
                MavenServerManager.addDir(classpath, new File(root, "maven2-server-lib"));
            } else {
                classpath.add(new File(root, "maven3-server-common.jar"));
                MavenServerManager.addDir(classpath, new File(root, "maven3-server-lib"));
                if (currentMavenVersion == null || StringUtil.compareVersionNumbers((String)currentMavenVersion, (String)"3.1") < 0) {
                    classpath.add(new File(root, "maven30-server-impl.jar"));
                } else {
                    classpath.add(new File(root, "maven32-server-impl.jar"));
                }
            }
        }
        MavenServerManager.addMavenLibs(classpath, mavenHome);
        return classpath;
    }

    private static File getMavenPluginParentFile() {
        File luceneLib = new File(PathUtil.getJarPathForClass(Query.class));
        return luceneLib.getParentFile().getParentFile().getParentFile();
    }

    private static void addMavenLibs(List<File> classpath, File mavenHome) {
        MavenServerManager.addDir(classpath, new File(mavenHome, "lib"));
        File bootFolder = new File(mavenHome, "boot");
        File[] classworldsJars = bootFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return StringUtil.contains((CharSequence)name, (CharSequence)"classworlds");
            }
        });
        if (classworldsJars != null) {
            Collections.addAll(classpath, classworldsJars);
        }
    }

    private static void addDir(List<File> classpath, File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File jar : files) {
            if (!jar.isFile() || !jar.getName().endsWith(".jar")) continue;
            classpath.add(jar);
        }
    }

    public MavenEmbedderWrapper createEmbedder(final Project project, final boolean alwaysOnline) {
        return new MavenEmbedderWrapper(this){

            @Override
            @NotNull
            protected MavenServerEmbedder create() throws RemoteException {
                MavenServerSettings settings = MavenServerManager.convertSettings(MavenProjectsManager.getInstance(project).getGeneralSettings());
                if (alwaysOnline && settings.isOffline()) {
                    settings = settings.clone();
                    settings.setOffline(false);
                }
                settings.setProjectJdk(MavenUtil.getSdkPath(ProjectRootManager.getInstance((Project)project).getProjectSdk()));
                MavenServerEmbedder mavenServerEmbedder = ((MavenServer)MavenServerManager.this.getOrCreateWrappee()).createEmbedder(settings);
                if (mavenServerEmbedder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager$5", "create"));
                }
                return mavenServerEmbedder;
            }
        };
    }

    public MavenIndexerWrapper createIndexer() {
        return new MavenIndexerWrapper(this){

            @Override
            @NotNull
            protected MavenServerIndexer create() throws RemoteException {
                MavenServerIndexer mavenServerIndexer = ((MavenServer)MavenServerManager.this.getOrCreateWrappee()).createIndexer();
                if (mavenServerIndexer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager$6", "create"));
                }
                return mavenServerIndexer;
            }
        };
    }

    public MavenModel interpolateAndAlignModel(final MavenModel model, final File basedir) {
        return this.perform(new RemoteObjectWrapper.Retriable<MavenModel>(){

            @Override
            public MavenModel execute() throws RemoteException {
                return ((MavenServer)MavenServerManager.this.getOrCreateWrappee()).interpolateAndAlignModel(model, basedir);
            }
        });
    }

    public MavenModel assembleInheritance(final MavenModel model, final MavenModel parentModel) {
        return this.perform(new RemoteObjectWrapper.Retriable<MavenModel>(){

            @Override
            public MavenModel execute() throws RemoteException {
                return ((MavenServer)MavenServerManager.this.getOrCreateWrappee()).assembleInheritance(model, parentModel);
            }
        });
    }

    public ProfileApplicationResult applyProfiles(final MavenModel model, final File basedir, final MavenExplicitProfiles explicitProfiles, final Collection<String> alwaysOnProfiles) {
        return this.perform(new RemoteObjectWrapper.Retriable<ProfileApplicationResult>(){

            @Override
            public ProfileApplicationResult execute() throws RemoteException {
                return ((MavenServer)MavenServerManager.this.getOrCreateWrappee()).applyProfiles(model, basedir, explicitProfiles, alwaysOnProfiles);
            }
        });
    }

    public void addDownloadListener(MavenServerDownloadListener listener) {
        this.myDownloadListener.myListeners.add(listener);
    }

    public void removeDownloadListener(MavenServerDownloadListener listener) {
        this.myDownloadListener.myListeners.remove(listener);
    }

    public static MavenServerSettings convertSettings(MavenGeneralSettings settings) {
        MavenServerSettings result = new MavenServerSettings();
        result.setLoggingLevel(settings.getOutputLevel().getLevel());
        result.setOffline(settings.isWorkOffline());
        result.setMavenHome(settings.getEffectiveMavenHome());
        result.setUserSettingsFile(settings.getEffectiveUserSettingsIoFile());
        result.setGlobalSettingsFile(settings.getEffectiveGlobalSettingsIoFile());
        result.setLocalRepository(settings.getEffectiveLocalRepository());
        result.setPluginUpdatePolicy(settings.getPluginUpdatePolicy().getServerPolicy());
        result.setSnapshotUpdatePolicy(settings.isAlwaysUpdateSnapshots() ? MavenServerSettings.UpdatePolicy.ALWAYS_UPDATE : MavenServerSettings.UpdatePolicy.DO_NOT_UPDATE);
        return result;
    }

    public static MavenServerConsole wrapAndExport(MavenConsole console) {
        try {
            RemoteMavenServerConsole result = new RemoteMavenServerConsole(console);
            UnicastRemoteObject.exportObject((Remote)((Object)result), 0);
            return result;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public static MavenServerProgressIndicator wrapAndExport(MavenProgressIndicator process) {
        try {
            RemoteMavenServerProgressIndicator result = new RemoteMavenServerProgressIndicator(process);
            UnicastRemoteObject.exportObject((Remote)((Object)result), 0);
            return result;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public static MavenServerIndicesProcessor wrapAndExport(MavenIndicesProcessor processor) {
        try {
            RemoteMavenServerIndicesProcessor result = new RemoteMavenServerIndicesProcessor(processor);
            UnicastRemoteObject.exportObject((Remote)((Object)result), 0);
            return result;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isUsedMaven2ForProjectImport() {
        return this.myState.useMaven2;
    }

    public boolean isUseMaven2() {
        String version = this.getCurrentMavenVersion();
        return StringUtil.compareVersionNumbers((String)version, (String)"3") < 0 && StringUtil.compareVersionNumbers((String)version, (String)"2") >= 0;
    }

    public void setUseMaven2(boolean useMaven2) {
        String newMavenHome;
        String string = newMavenHome = useMaven2 ? BUNDLED_MAVEN_2 : BUNDLED_MAVEN_3;
        if (!StringUtil.equals((CharSequence)this.myState.mavenHome, (CharSequence)newMavenHome)) {
            this.myState.mavenHome = newMavenHome;
            this.shutdown(false);
        }
    }

    @Nullable
    public File getMavenHomeFile(@Nullable String mavenHome) {
        if (mavenHome == null) {
            return null;
        }
        if (StringUtil.equals((CharSequence)BUNDLED_MAVEN_2, (CharSequence)mavenHome)) {
            return this.myBundledMaven2Home;
        }
        if (StringUtil.equals((CharSequence)BUNDLED_MAVEN_3, (CharSequence)mavenHome)) {
            return this.myBundledMaven3Home;
        }
        File home = new File(mavenHome);
        return MavenUtil.isValidMavenHome(home) ? home : null;
    }

    @Nullable
    public File getCurrentMavenHomeFile() {
        return this.getMavenHomeFile(this.myState.mavenHome);
    }

    public void setMavenHome(@NotNull String mavenHome) {
        if (mavenHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenHome", "org/jetbrains/idea/maven/server/MavenServerManager", "setMavenHome"));
        }
        if (!StringUtil.equals((CharSequence)this.myState.mavenHome, (CharSequence)mavenHome)) {
            this.myState.mavenHome = mavenHome;
            this.shutdown(false);
        }
    }

    @NotNull
    public String getMavenEmbedderVMOptions() {
        String string = this.myState.vmOptions;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager", "getMavenEmbedderVMOptions"));
        }
        return string;
    }

    public void setMavenEmbedderVMOptions(@NotNull String mavenEmbedderVMOptions) {
        if (mavenEmbedderVMOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenEmbedderVMOptions", "org/jetbrains/idea/maven/server/MavenServerManager", "setMavenEmbedderVMOptions"));
        }
        if (!mavenEmbedderVMOptions.trim().equals(this.myState.vmOptions.trim())) {
            this.myState.vmOptions = mavenEmbedderVMOptions;
            this.shutdown(false);
        }
    }

    @NotNull
    public String getEmbedderJdk() {
        String string = this.myState.embedderJdk;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager", "getEmbedderJdk"));
        }
        return string;
    }

    public void setEmbedderJdk(@NotNull String embedderJdk) {
        if (embedderJdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "embedderJdk", "org/jetbrains/idea/maven/server/MavenServerManager", "setEmbedderJdk"));
        }
        if (!this.myState.embedderJdk.equals(embedderJdk)) {
            this.myState.embedderJdk = embedderJdk;
            this.shutdown(false);
        }
    }

    @NotNull
    public MavenExecutionOptions.LoggingLevel getLoggingLevel() {
        MavenExecutionOptions.LoggingLevel loggingLevel = this.myState.loggingLevel;
        if (loggingLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager", "getLoggingLevel"));
        }
        return loggingLevel;
    }

    public void setLoggingLevel(MavenExecutionOptions.LoggingLevel loggingLevel) {
        if (this.myState.loggingLevel != loggingLevel) {
            this.myState.loggingLevel = loggingLevel;
            this.shutdown(false);
        }
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        if (state.vmOptions == null) {
            state.vmOptions = DEFAULT_VM_OPTIONS;
        }
        if (state.embedderJdk == null) {
            state.embedderJdk = "#JAVA_INTERNAL";
        }
        this.myState = state;
    }

    private static class RemoteMavenServerIndicesProcessor
    extends MavenRemoteObject
    implements MavenServerIndicesProcessor {
        private final MavenIndicesProcessor myProcessor;

        private RemoteMavenServerIndicesProcessor(MavenIndicesProcessor processor) {
            this.myProcessor = processor;
        }

        public void processArtifacts(Collection<MavenId> artifacts) {
            this.myProcessor.processArtifacts(artifacts);
        }
    }

    private static class RemoteMavenServerConsole
    extends MavenRemoteObject
    implements MavenServerConsole {
        private final MavenConsole myConsole;

        public RemoteMavenServerConsole(MavenConsole console) {
            this.myConsole = console;
        }

        public void printMessage(int level, String message, Throwable throwable) {
            this.myConsole.printMessage(level, message, throwable);
        }
    }

    private static class RemoteMavenServerProgressIndicator
    extends MavenRemoteObject
    implements MavenServerProgressIndicator {
        private final MavenProgressIndicator myProcess;

        public RemoteMavenServerProgressIndicator(MavenProgressIndicator process) {
            this.myProcess = process;
        }

        public void setText(String text) {
            this.myProcess.setText(text);
        }

        public void setText2(String text) {
            this.myProcess.setText2(text);
        }

        public boolean isCanceled() {
            return this.myProcess.isCanceled();
        }

        public void setIndeterminate(boolean value) {
            this.myProcess.getIndicator().setIndeterminate(value);
        }

        public void setFraction(double fraction) {
            this.myProcess.setFraction(fraction);
        }
    }

    private static class RemoteMavenServerDownloadListener
    extends MavenRemoteObject
    implements MavenServerDownloadListener {
        private final List<MavenServerDownloadListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

        private RemoteMavenServerDownloadListener() {
        }

        public void artifactDownloaded(File file, String relativePath) throws RemoteException {
            for (MavenServerDownloadListener each : this.myListeners) {
                each.artifactDownloaded(file, relativePath);
            }
        }
    }

    private static class RemoteMavenServerLogger
    extends MavenRemoteObject
    implements MavenServerLogger {
        private RemoteMavenServerLogger() {
        }

        public void info(Throwable e) {
            MavenLog.LOG.info(e);
        }

        public void warn(Throwable e) {
            MavenLog.LOG.warn(e);
        }

        public void error(Throwable e) {
            MavenLog.LOG.error(e);
        }

        public void print(String s) {
            System.out.println(s);
        }
    }

    private static class UseMavenConverter
    extends Converter<Boolean> {
        private UseMavenConverter() {
        }

        @Nullable
        public Boolean fromString(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/maven/server/MavenServerManager$UseMavenConverter", "fromString"));
            }
            return "2.x".equals(value);
        }

        @NotNull
        public String toString(@NotNull Boolean value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/maven/server/MavenServerManager$UseMavenConverter", "toString"));
            }
            String string = value != false ? "2.x" : "3.x";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager$UseMavenConverter", "toString"));
            }
            return string;
        }
    }

    static class State {
        @Deprecated
        @Attribute(value="version", converter=UseMavenConverter.class)
        public boolean useMaven2;
        @Attribute
        public String vmOptions = "-Xmx512m";
        @Attribute
        public String embedderJdk = "#JAVA_INTERNAL";
        @Attribute
        public String mavenHome;
        @Attribute
        public MavenExecutionOptions.LoggingLevel loggingLevel = MavenExecutionOptions.LoggingLevel.INFO;

        State() {
        }
    }
}

