/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.resources.Density;
import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.Navigation;
import com.android.resources.NavigationState;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenSize;
import com.android.resources.TouchScreen;
import com.android.sdklib.SystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.Camera;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Multitouch;
import com.android.sdklib.devices.Network;
import com.android.sdklib.devices.PowerType;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.ScreenType;
import com.android.sdklib.devices.Sensor;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.tools.idea.avdmanager.AvdBuilder;
import com.android.tools.idea.avdmanager.AvdEditWizard;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.DeviceDefinitionPreview;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.SkinChooser;
import com.android.tools.idea.avdmanager.StorageField;
import com.android.tools.idea.ddms.screenshot.DeviceArtDescriptor;
import com.android.tools.idea.wizard.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureDeviceOptionsStep
extends DynamicWizardStepWithHeaderAndDescription {
    private static final String DEFAULT_DEVICE_TYPE_LABEL = "Phone/Tablet";
    @Nullable
    private final Device myTemplateDevice;
    private final boolean myForceCreation;
    private DeviceDefinitionPreview myDeviceDefinitionPreview;
    private JTextField myDiagonalScreenSize;
    private JTextField myScreenResolutionWidth;
    private StorageField myRamField;
    private JCheckBox mySupportsLandscape;
    private JTextField myScreenResolutionHeight;
    private JCheckBox myHasBackFacingCamera;
    private JCheckBox myHasFrontFacingCamera;
    private JCheckBox myHasAccelerometer;
    private JCheckBox myHasGyroscope;
    private JCheckBox myHasGps;
    private JCheckBox myHasProximitySensor;
    private JCheckBox mySupportsPortrait;
    private JComboBox myNavigationControlsCombo;
    private JPanel myRootPanel;
    private JCheckBox myHasHardwareButtons;
    private JCheckBox myHasHardwareKeyboard;
    private JTextField myDeviceName;
    private JBLabel myHelpAndErrorLabel;
    private HyperlinkLabel myHardwareSkinHelpLabel;
    private SkinChooser myCustomSkinPath;
    private ComboBox myDeviceTypeComboBox;
    private final Software mySoftware;
    private final Camera myFrontCamera;
    private final Camera myBackCamera;
    private Device.Builder myBuilder;
    private static final ScopedDataBinder.ComponentBinding<Double, JTextField> DOUBLE_BINDING = new ScopedDataBinder.ComponentBinding<Double, JTextField>(){

        @Override
        public void setValue(@Nullable Double newValue, @NotNull JTextField component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$5", "setValue"));
            }
            if (newValue != null) {
                component.setText(Double.toString(newValue));
            }
        }

        @Override
        @Nullable
        public Double getValue(@NotNull JTextField component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$5", "getValue"));
            }
            String text = component.getText();
            if (text != null) {
                try {
                    return Double.parseDouble(text);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        @Nullable
        public Document getDocument(@NotNull JTextField component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$5", "getDocument"));
            }
            return component.getDocument();
        }
    };
    private static final ScopedDataBinder.ComponentBinding<Integer, JTextField> INT_BINDING = new ScopedDataBinder.ComponentBinding<Integer, JTextField>(){

        @Override
        public void setValue(@Nullable Integer newValue, @NotNull JTextField component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$6", "setValue"));
            }
            if (newValue != null) {
                component.setText(Integer.toString(newValue));
            }
        }

        @Override
        @Nullable
        public Integer getValue(@NotNull JTextField component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$6", "getValue"));
            }
            String text = component.getText();
            if (text != null) {
                try {
                    return Integer.parseInt(text);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        @Nullable
        public Document getDocument(@NotNull JTextField component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$6", "getDocument"));
            }
            return component.getDocument();
        }
    };
    private static final ScopedDataBinder.ComponentBinding<Navigation, JComboBox> NAVIGATION_BINDING = new ScopedDataBinder.ComponentBinding<Navigation, JComboBox>(){

        @Override
        public void setValue(@Nullable Navigation newValue, @NotNull JComboBox component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$7", "setValue"));
            }
            component.setSelectedItem(newValue);
        }

        @Override
        @Nullable
        public Navigation getValue(@NotNull JComboBox component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$7", "getValue"));
            }
            return (Navigation)component.getSelectedItem();
        }

        @Override
        public void addItemListener(@NotNull ItemListener listener, @NotNull JComboBox component) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$7", "addItemListener"));
            }
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep$7", "addItemListener"));
            }
            component.addItemListener(listener);
        }
    };

    public ConfigureDeviceOptionsStep(@Nullable Device templateDevice, boolean forceCreation, @Nullable Disposable parentDisposable) {
        super("Configure Hardware Profile", null, null, parentDisposable);
        this.$$$setupUI$$$();
        this.myFrontCamera = new Camera(CameraLocation.FRONT, true, true);
        this.myBackCamera = new Camera(CameraLocation.BACK, true, true);
        this.myBuilder = new Device.Builder();
        this.myTemplateDevice = templateDevice;
        this.myForceCreation = forceCreation;
        this.setBodyComponent(this.myRootPanel);
        if (templateDevice == null) {
            this.setDescriptionText("Create a new hardware profile by selecting hardware features below.");
        } else {
            this.setDescriptionText(templateDevice.getDisplayName() + " (Edited)");
        }
        this.mySoftware = new Software();
        this.mySoftware.setLiveWallpaperSupport(true);
        this.mySoftware.setGlVersion("2.0");
        this.myDeviceTypeComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(AvdWizardConstants.ALL_TAGS));
        this.myDeviceTypeComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<IdDisplay>(){

            public void customize(JList list, IdDisplay value, int index, boolean selected, boolean hasFocus) {
                if (SystemImage.DEFAULT_TAG.equals((Object)value) || value == null) {
                    this.setText(ConfigureDeviceOptionsStep.DEFAULT_DEVICE_TYPE_LABEL);
                } else {
                    this.setText(value.getDisplay());
                }
            }
        });
    }

    private static String getUniqueId(@Nullable String id) {
        return DeviceManagerConnection.getDefaultDeviceManagerConnection().getUniqueId(id);
    }

    private void createUIComponents() {
        this.myNavigationControlsCombo = new ComboBox((ComboBoxModel)new EnumComboBoxModel(Navigation.class)){

            public ListCellRenderer getRenderer() {
                return new ColoredListCellRenderer(){

                    protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                        this.append(((Navigation)value).getShortDisplayValue());
                    }
                };
            }
        };
        this.myHelpAndErrorLabel = new JBLabel();
        this.myHelpAndErrorLabel.setBackground(JBColor.background());
        this.myHelpAndErrorLabel.setForeground(JBColor.foreground());
        this.myHelpAndErrorLabel.setOpaque(true);
        this.myHardwareSkinHelpLabel = new HyperlinkLabel("How do I create a custom hardware skin?");
        this.myHardwareSkinHelpLabel.setHyperlinkTarget("http://developer.android.com/tools/devices/managing-avds.html#skins");
        this.myCustomSkinPath = new SkinChooser(this.getProject());
    }

    @Override
    public void init() {
        super.init();
        this.registerComponents();
        if (this.myTemplateDevice == null) {
            this.initDefaultParams();
        } else {
            this.initFromDevice();
        }
        this.myBuilder.setManufacturer("User");
        this.myBuilder.addSoftware(this.mySoftware);
        this.invokeUpdate(null);
    }

    @Override
    protected JLabel getDescriptionText() {
        return this.myHelpAndErrorLabel;
    }

    private void initFromDevice() {
        assert (this.myTemplateDevice != null);
        if (this.myForceCreation) {
            String name = this.myTemplateDevice.getDisplayName() + " (Edited)";
            this.myState.put(AvdWizardConstants.DEVICE_NAME_KEY, ConfigureDeviceOptionsStep.getUniqueId(name));
        } else {
            this.myState.put(AvdWizardConstants.DEVICE_NAME_KEY, this.myTemplateDevice.getDisplayName());
        }
        String tagId = this.myTemplateDevice.getTagId();
        if (tagId != null) {
            for (IdDisplay idDisplay : AvdWizardConstants.ALL_TAGS) {
                if (!idDisplay.getId().equals(tagId)) continue;
                this.myState.put(AvdWizardConstants.TAG_ID_KEY, idDisplay);
                break;
            }
        }
        for (Map.Entry entry : this.myTemplateDevice.getBootProps().entrySet()) {
            this.myBuilder.addBootProp((String)entry.getKey(), (String)entry.getValue());
        }
        Hardware defaultHardware = this.myTemplateDevice.getDefaultHardware();
        Screen screen = defaultHardware.getScreen();
        this.myState.put(AvdWizardConstants.DIAGONAL_SCREENSIZE_KEY, screen.getDiagonalLength());
        this.myState.put(AvdWizardConstants.RESOLUTION_WIDTH_KEY, screen.getXDimension());
        this.myState.put(AvdWizardConstants.RESOLUTION_HEIGHT_KEY, screen.getYDimension());
        this.myState.put(AvdWizardConstants.RAM_STORAGE_KEY, AvdBuilder.getDefaultRam(defaultHardware));
        this.myState.put(AvdWizardConstants.HAS_HARDWARE_BUTTONS_KEY, defaultHardware.getButtonType() == ButtonType.HARD);
        this.myState.put(AvdWizardConstants.HAS_HARDWARE_KEYBOARD_KEY, defaultHardware.getKeyboard() != Keyboard.NOKEY);
        this.myState.put(AvdWizardConstants.NAVIGATION_KEY, defaultHardware.getNav());
        List states = this.myTemplateDevice.getAllStates();
        this.myState.put(AvdWizardConstants.SUPPORTS_PORTRAIT_KEY, Iterables.any((Iterable)states, (Predicate)new Predicate<State>(){

            public boolean apply(State input) {
                return input.getOrientation().equals((Object)ScreenOrientation.PORTRAIT);
            }
        }));
        this.myState.put(AvdWizardConstants.SUPPORTS_LANDSCAPE_KEY, Iterables.any((Iterable)states, (Predicate)new Predicate<State>(){

            public boolean apply(State input) {
                return input.getOrientation().equals((Object)ScreenOrientation.LANDSCAPE);
            }
        }));
        this.myState.put(AvdWizardConstants.HAS_FRONT_CAMERA_KEY, defaultHardware.getCamera(CameraLocation.FRONT) != null);
        this.myState.put(AvdWizardConstants.HAS_BACK_CAMERA_KEY, defaultHardware.getCamera(CameraLocation.BACK) != null);
        this.myState.put(AvdWizardConstants.HAS_ACCELEROMETER_KEY, defaultHardware.getSensors().contains(Sensor.ACCELEROMETER));
        this.myState.put(AvdWizardConstants.HAS_GYROSCOPE_KEY, defaultHardware.getSensors().contains(Sensor.GYROSCOPE));
        this.myState.put(AvdWizardConstants.HAS_GPS_KEY, defaultHardware.getSensors().contains(Sensor.GPS));
        this.myState.put(AvdWizardConstants.HAS_PROXIMITY_SENSOR_KEY, defaultHardware.getSensors().contains(Sensor.PROXIMITY_SENSOR));
        File skinFile = AvdEditWizard.resolveSkinPath(defaultHardware.getSkinFile(), null);
        if (skinFile != null) {
            this.myState.put(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY, skinFile);
        } else {
            this.myState.put(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY, AvdWizardConstants.NO_SKIN);
        }
    }

    private void initDefaultParams() {
        this.myState.put(AvdWizardConstants.DEVICE_NAME_KEY, ConfigureDeviceOptionsStep.getUniqueId(null));
        this.myState.put(AvdWizardConstants.DIAGONAL_SCREENSIZE_KEY, 5.0);
        this.myState.put(AvdWizardConstants.RESOLUTION_WIDTH_KEY, 1080);
        this.myState.put(AvdWizardConstants.RESOLUTION_HEIGHT_KEY, 1920);
        this.myState.put(AvdWizardConstants.RAM_STORAGE_KEY, new Storage(2L, Storage.Unit.GiB));
        this.myState.put(AvdWizardConstants.HAS_HARDWARE_BUTTONS_KEY, false);
        this.myState.put(AvdWizardConstants.HAS_HARDWARE_KEYBOARD_KEY, false);
        this.myState.put(AvdWizardConstants.NAVIGATION_KEY, Navigation.NONAV);
        this.myState.put(AvdWizardConstants.SUPPORTS_PORTRAIT_KEY, true);
        this.myState.put(AvdWizardConstants.SUPPORTS_LANDSCAPE_KEY, true);
        this.myState.put(AvdWizardConstants.HAS_FRONT_CAMERA_KEY, true);
        this.myState.put(AvdWizardConstants.HAS_BACK_CAMERA_KEY, true);
        this.myState.put(AvdWizardConstants.HAS_ACCELEROMETER_KEY, true);
        this.myState.put(AvdWizardConstants.HAS_GYROSCOPE_KEY, true);
        this.myState.put(AvdWizardConstants.HAS_GPS_KEY, true);
        this.myState.put(AvdWizardConstants.HAS_PROXIMITY_SENSOR_KEY, true);
        this.myState.put(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY, AvdWizardConstants.NO_SKIN);
    }

    @Override
    public boolean validate() {
        File layoutFile;
        this.setErrorHtml("");
        if (this.myState.get(AvdWizardConstants.DIAGONAL_SCREENSIZE_KEY) == null) {
            this.setErrorHtml("Please enter a positive floating point value for the screen size");
            return false;
        }
        if (this.myState.get(AvdWizardConstants.RESOLUTION_WIDTH_KEY) == null || this.myState.get(AvdWizardConstants.RESOLUTION_HEIGHT_KEY) == null) {
            this.setErrorHtml("Please enter positive integer values for the screen resolution (width x height)");
            return false;
        }
        if (this.myState.get(AvdWizardConstants.RAM_STORAGE_KEY) == null) {
            this.setErrorHtml("Please specify a non-zero amount of RAM");
            return false;
        }
        Double dpi = this.myState.get(AvdWizardConstants.WIP_SCREEN_DPI_KEY);
        if (dpi == null || dpi <= 0.0) {
            this.setErrorHtml("The given resolution and screensize specified have a DPI that is too low.");
            return false;
        }
        Boolean supportsLandscape = this.myState.get(AvdWizardConstants.SUPPORTS_LANDSCAPE_KEY);
        supportsLandscape = supportsLandscape == null ? false : supportsLandscape;
        Boolean supportsPortrait = this.myState.get(AvdWizardConstants.SUPPORTS_PORTRAIT_KEY);
        supportsPortrait = supportsPortrait == null ? false : supportsPortrait;
        if (!supportsLandscape.booleanValue() && !supportsPortrait.booleanValue()) {
            this.setErrorHtml("A device must support at least one orientation (Portrait or Landscape)");
            return false;
        }
        File skinPath = this.myState.get(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY);
        if (skinPath != null && skinPath != AvdWizardConstants.NO_SKIN && !skinPath.isAbsolute()) {
            skinPath = new File(DeviceArtDescriptor.getBundledDescriptorsFolder(), skinPath.getPath());
        }
        if (skinPath != null && skinPath != AvdWizardConstants.NO_SKIN && !(layoutFile = new File(skinPath, "layout")).isFile()) {
            this.setErrorHtml("The skin directory does not point to a valid skin.");
        }
        return this.myState.get(AvdWizardConstants.DEVICE_DEFINITION_KEY) != null;
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        File skinFile;
        Storage ram;
        Navigation nav;
        boolean refreshAll;
        boolean bl = refreshAll = modified == null;
        if (refreshAll) {
            modified = ImmutableSet.of();
        }
        if (refreshAll || modified.contains(AvdWizardConstants.DEVICE_NAME_KEY)) {
            String name = this.myState.get(AvdWizardConstants.DEVICE_NAME_KEY);
            this.myBuilder.setName(name == null ? "" : name);
            this.myBuilder.setId(ConfigureDeviceOptionsStep.getUniqueId(name));
        }
        if (refreshAll || modified.contains(AvdWizardConstants.TAG_ID_KEY)) {
            IdDisplay tag = this.myState.get(AvdWizardConstants.TAG_ID_KEY);
            if (SystemImage.DEFAULT_TAG.equals((Object)tag) || tag == null) {
                this.myBuilder.setTagId(null);
            } else {
                this.myBuilder.setTagId(tag.getId());
            }
        }
        if (!this.myState.containsKey(AvdWizardConstants.WIP_SCREEN_KEY)) {
            Screen s = ConfigureDeviceOptionsStep.createDefaultScreen();
            this.myState.put(AvdWizardConstants.WIP_SCREEN_KEY, s);
        }
        Screen screen = this.myState.get(AvdWizardConstants.WIP_SCREEN_KEY);
        assert (screen != null);
        if (refreshAll || !Collections.disjoint(modified, ImmutableSet.of(AvdWizardConstants.DIAGONAL_SCREENSIZE_KEY, AvdWizardConstants.RESOLUTION_WIDTH_KEY, AvdWizardConstants.RESOLUTION_HEIGHT_KEY))) {
            Double diagonalLength = this.myState.get(AvdWizardConstants.DIAGONAL_SCREENSIZE_KEY);
            if (diagonalLength != null) {
                screen.setDiagonalLength(diagonalLength.doubleValue());
                screen.setSize(ConfigureDeviceOptionsStep.getScreenSize(diagonalLength));
            } else {
                diagonalLength = -1.0;
            }
            Integer resolutionWidth = this.myState.get(AvdWizardConstants.RESOLUTION_WIDTH_KEY);
            if (resolutionWidth != null) {
                screen.setXDimension(resolutionWidth.intValue());
            } else {
                resolutionWidth = 0;
            }
            Integer resolutionHeight = this.myState.get(AvdWizardConstants.RESOLUTION_HEIGHT_KEY);
            if (resolutionHeight != null) {
                screen.setYDimension(resolutionHeight.intValue());
            } else {
                resolutionHeight = 0;
            }
            double dpi = Math.sqrt(resolutionWidth * resolutionWidth + resolutionHeight * resolutionHeight) / diagonalLength;
            if (dpi >= 0.0) {
                dpi = (double)Math.round(dpi * 100.0) / 100.0;
                this.myState.put(AvdWizardConstants.WIP_SCREEN_DPI_KEY, dpi);
                screen.setYdpi(dpi);
                screen.setXdpi(dpi);
                screen.setRatio(ConfigureDeviceOptionsStep.getScreenRatio(resolutionWidth, resolutionHeight));
                if (HardwareConfigHelper.isTv((Device)this.myTemplateDevice)) {
                    screen.setPixelDensity(Density.TV);
                } else {
                    screen.setPixelDensity(ConfigureDeviceOptionsStep.getDensity(dpi));
                }
            }
        }
        if (!this.myState.containsKey(AvdWizardConstants.WIP_HARDWARE_KEY)) {
            Hardware h = ConfigureDeviceOptionsStep.createDefaultHardware();
            this.myState.put(AvdWizardConstants.WIP_HARDWARE_KEY, h);
        }
        Hardware hardware = this.myState.get(AvdWizardConstants.WIP_HARDWARE_KEY);
        assert (hardware != null);
        if (refreshAll || modified.contains(AvdWizardConstants.HAS_ACCELEROMETER_KEY)) {
            Boolean hasAccelerometer = this.myState.get(AvdWizardConstants.HAS_ACCELEROMETER_KEY);
            if (hasAccelerometer != null && hasAccelerometer.booleanValue()) {
                hardware.addSensor(Sensor.ACCELEROMETER);
            } else {
                hardware.getSensors().remove(Sensor.ACCELEROMETER);
            }
        }
        if (refreshAll || modified.contains(AvdWizardConstants.HAS_GYROSCOPE_KEY)) {
            Boolean hasGyroscope = this.myState.get(AvdWizardConstants.HAS_GYROSCOPE_KEY);
            if (hasGyroscope != null && hasGyroscope.booleanValue()) {
                hardware.addSensor(Sensor.GYROSCOPE);
            } else {
                hardware.getSensors().remove(Sensor.GYROSCOPE);
            }
        }
        if (refreshAll || modified.contains(AvdWizardConstants.HAS_GPS_KEY)) {
            Boolean hasGps = this.myState.get(AvdWizardConstants.HAS_GPS_KEY);
            if (hasGps != null && hasGps.booleanValue()) {
                hardware.addSensor(Sensor.GPS);
            } else {
                hardware.getSensors().remove(Sensor.GPS);
            }
        }
        if (refreshAll || modified.contains(AvdWizardConstants.HAS_PROXIMITY_SENSOR_KEY)) {
            Boolean hasProximitySensor = this.myState.get(AvdWizardConstants.HAS_PROXIMITY_SENSOR_KEY);
            if (hasProximitySensor != null && hasProximitySensor.booleanValue()) {
                hardware.addSensor(Sensor.PROXIMITY_SENSOR);
            } else {
                hardware.getSensors().remove(Sensor.PROXIMITY_SENSOR);
            }
        }
        if (refreshAll || modified.contains(AvdWizardConstants.HAS_FRONT_CAMERA_KEY)) {
            Boolean hasFrontCamera = this.myState.get(AvdWizardConstants.HAS_FRONT_CAMERA_KEY);
            if (hasFrontCamera != null && hasFrontCamera.booleanValue()) {
                hardware.addCamera(this.myFrontCamera);
            } else {
                hardware.getCameras().remove(this.myFrontCamera);
            }
        }
        if (refreshAll || modified.contains(AvdWizardConstants.HAS_BACK_CAMERA_KEY)) {
            Boolean hasBackCamera = this.myState.get(AvdWizardConstants.HAS_BACK_CAMERA_KEY);
            if (hasBackCamera != null && hasBackCamera.booleanValue()) {
                hardware.addCamera(this.myBackCamera);
            } else {
                hardware.getCameras().remove(this.myBackCamera);
            }
        }
        Boolean hasHardwareKeyboard = this.myState.get(AvdWizardConstants.HAS_HARDWARE_KEYBOARD_KEY);
        if (refreshAll || modified.contains(AvdWizardConstants.HAS_HARDWARE_KEYBOARD_KEY)) {
            if (hasHardwareKeyboard != null && hasHardwareKeyboard.booleanValue()) {
                hardware.setKeyboard(Keyboard.QWERTY);
            } else {
                hardware.setKeyboard(Keyboard.NOKEY);
            }
        }
        if (hasHardwareKeyboard == null) {
            hasHardwareKeyboard = false;
        }
        if (refreshAll || modified.contains(AvdWizardConstants.HAS_HARDWARE_BUTTONS_KEY)) {
            Boolean hasHardwareButtons = this.myState.get(AvdWizardConstants.HAS_HARDWARE_BUTTONS_KEY);
            if (hasHardwareButtons != null && hasHardwareButtons.booleanValue()) {
                hardware.setButtonType(ButtonType.HARD);
            } else {
                hardware.setButtonType(ButtonType.SOFT);
            }
        }
        if ((refreshAll || modified.contains(AvdWizardConstants.NAVIGATION_KEY)) && (nav = this.myState.get(AvdWizardConstants.NAVIGATION_KEY)) != null) {
            hardware.setNav(nav);
        }
        if ((refreshAll || modified.contains(AvdWizardConstants.RAM_STORAGE_KEY)) && (ram = this.myState.get(AvdWizardConstants.RAM_STORAGE_KEY)) != null) {
            hardware.setRam(ram);
        }
        if ((refreshAll || modified.contains(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY)) && (skinFile = this.myState.get(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY)) != null) {
            hardware.setSkinFile(skinFile);
        }
        hardware.setScreen(screen);
        this.setStates(hardware, hasHardwareKeyboard);
        this.myState.remove(AvdWizardConstants.DEVICE_DEFINITION_KEY);
        try {
            Device d = this.myBuilder.build();
            this.myDeviceDefinitionPreview.setDevice(d);
            this.myState.put(AvdWizardConstants.DEVICE_DEFINITION_KEY, d);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void setStates(Hardware hardware, Boolean hasHardwareKeyboard) {
        State state;
        Boolean supportsLandscape = this.myState.get(AvdWizardConstants.SUPPORTS_LANDSCAPE_KEY);
        supportsLandscape = supportsLandscape == null ? false : supportsLandscape;
        Boolean supportsPortrait = this.myState.get(AvdWizardConstants.SUPPORTS_PORTRAIT_KEY);
        supportsPortrait = supportsPortrait == null ? false : supportsPortrait;
        boolean defaultSelected = false;
        if (supportsPortrait.booleanValue()) {
            state = new State();
            state.setName("Portrait");
            state.setDescription("The device in portrait orientation");
            state.setOrientation(ScreenOrientation.PORTRAIT);
            if (hardware.getNav().equals((Object)Navigation.NONAV)) {
                state.setNavState(NavigationState.HIDDEN);
            } else {
                state.setNavState(NavigationState.EXPOSED);
            }
            if (hardware.getKeyboard().equals((Object)Keyboard.NOKEY)) {
                state.setKeyState(KeyboardState.SOFT);
            } else {
                state.setKeyState(KeyboardState.HIDDEN);
            }
            state.setHardware(hardware);
            state.setDefaultState(true);
            defaultSelected = true;
            this.myBuilder.removeState(state.getName());
            this.myBuilder.addState(state);
        }
        if (supportsLandscape.booleanValue()) {
            state = new State();
            state.setName("Landscape");
            state.setDescription("The device in landscape orientation");
            state.setOrientation(ScreenOrientation.LANDSCAPE);
            if (hardware.getNav().equals((Object)Navigation.NONAV)) {
                state.setNavState(NavigationState.HIDDEN);
            } else {
                state.setNavState(NavigationState.EXPOSED);
            }
            if (hardware.getKeyboard().equals((Object)Keyboard.NOKEY)) {
                state.setKeyState(KeyboardState.SOFT);
            } else {
                state.setKeyState(KeyboardState.HIDDEN);
            }
            state.setHardware(hardware);
            if (!defaultSelected) {
                state.setDefaultState(true);
                defaultSelected = true;
            }
            this.myBuilder.removeState(state.getName());
            this.myBuilder.addState(state);
        }
        if (hasHardwareKeyboard.booleanValue()) {
            if (supportsPortrait.booleanValue()) {
                state = new State();
                state.setName("Portrait with keyboard");
                state.setDescription("The device in portrait orientation with a keyboard open");
                state.setOrientation(ScreenOrientation.LANDSCAPE);
                if (hardware.getNav().equals((Object)Navigation.NONAV)) {
                    state.setNavState(NavigationState.HIDDEN);
                } else {
                    state.setNavState(NavigationState.EXPOSED);
                }
                state.setKeyState(KeyboardState.EXPOSED);
                state.setHardware(hardware);
                if (!defaultSelected) {
                    state.setDefaultState(true);
                    defaultSelected = true;
                }
                this.myBuilder.removeState(state.getName());
                this.myBuilder.addState(state);
            }
            if (supportsLandscape.booleanValue()) {
                state = new State();
                state.setName("Landscape with keyboard");
                state.setDescription("The device in landscape orientation with a keyboard open");
                state.setOrientation(ScreenOrientation.LANDSCAPE);
                if (hardware.getNav().equals((Object)Navigation.NONAV)) {
                    state.setNavState(NavigationState.HIDDEN);
                } else {
                    state.setNavState(NavigationState.EXPOSED);
                }
                state.setKeyState(KeyboardState.EXPOSED);
                state.setHardware(hardware);
                if (!defaultSelected) {
                    state.setDefaultState(true);
                }
                this.myBuilder.removeState(state.getName());
                this.myBuilder.addState(state);
            }
        }
    }

    private static Screen createDefaultScreen() {
        Screen s = new Screen();
        s.setXdpi(316.0);
        s.setYdpi(316.0);
        s.setMultitouch(Multitouch.JAZZ_HANDS);
        s.setMechanism(TouchScreen.FINGER);
        s.setScreenType(ScreenType.CAPACITIVE);
        return s;
    }

    private static Hardware createDefaultHardware() {
        Hardware h = new Hardware();
        h.addNetwork(Network.BLUETOOTH);
        h.addNetwork(Network.WIFI);
        h.addNetwork(Network.NFC);
        h.addSensor(Sensor.BAROMETER);
        h.addSensor(Sensor.COMPASS);
        h.addSensor(Sensor.LIGHT_SENSOR);
        h.setHasMic(true);
        h.addInternalStorage(new Storage(4L, Storage.Unit.GiB));
        h.setCpu("Generic CPU");
        h.setGpu("Generic GPU");
        h.addSupportedAbi(Abi.ARMEABI);
        h.addSupportedAbi(Abi.ARMEABI_V7A);
        h.addSupportedAbi(Abi.MIPS);
        h.addSupportedAbi(Abi.X86);
        h.setChargeType(PowerType.BATTERY);
        return h;
    }

    @NotNull
    private static ScreenSize getScreenSize(@Nullable Double diagonalSize) {
        if (diagonalSize == null) {
            ScreenSize screenSize = ScreenSize.NORMAL;
            if (screenSize == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep", "getScreenSize"));
            }
            return screenSize;
        }
        double diagonalDp = 160.0 * diagonalSize;
        if (diagonalDp >= 1200.0) {
            ScreenSize screenSize = ScreenSize.XLARGE;
            if (screenSize == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep", "getScreenSize"));
            }
            return screenSize;
        }
        if (diagonalDp >= 800.0) {
            ScreenSize screenSize = ScreenSize.LARGE;
            if (screenSize == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep", "getScreenSize"));
            }
            return screenSize;
        }
        if (diagonalDp >= 568.0) {
            ScreenSize screenSize = ScreenSize.NORMAL;
            if (screenSize == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep", "getScreenSize"));
            }
            return screenSize;
        }
        ScreenSize screenSize = ScreenSize.SMALL;
        if (screenSize == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep", "getScreenSize"));
        }
        return screenSize;
    }

    @NotNull
    private static ScreenRatio getScreenRatio(int width, int height) {
        int shortSide;
        int longSide = Math.max(width, height);
        if ((double)longSide * 1.0 / (double)(shortSide = Math.min(width, height)) >= 1.6666666666666667) {
            ScreenRatio screenRatio = ScreenRatio.LONG;
            if (screenRatio == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep", "getScreenRatio"));
            }
            return screenRatio;
        }
        ScreenRatio screenRatio = ScreenRatio.NOTLONG;
        if (screenRatio == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep", "getScreenRatio"));
        }
        return screenRatio;
    }

    @NotNull
    private static Density getDensity(double dpi) {
        double difference = Double.MAX_VALUE;
        Density bucket = Density.MEDIUM;
        for (Density d : Density.values()) {
            if (!d.isValidValueForDevice() || !(Math.abs((double)d.getDpiValue() - dpi) < difference)) continue;
            difference = Math.abs((double)d.getDpiValue() - dpi);
            bucket = d;
        }
        Density density = bucket;
        if (density == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep", "getDensity"));
        }
        return density;
    }

    private void registerComponents() {
        this.register(AvdWizardConstants.DEVICE_NAME_KEY, this.myDeviceName);
        this.setControlDescription(this.myDeviceName, "Name of the Device Profile");
        this.register(AvdWizardConstants.DIAGONAL_SCREENSIZE_KEY, this.myDiagonalScreenSize, DOUBLE_BINDING);
        this.setControlDescription(this.myDiagonalScreenSize, "Actual Android Virtual Device size of the screen, measured as the screen's diagonal");
        this.register(AvdWizardConstants.RESOLUTION_WIDTH_KEY, this.myScreenResolutionWidth, INT_BINDING);
        this.setControlDescription(this.myScreenResolutionWidth, "The total number of physical pixels on a screen. When adding support for multiple screens, applications do not work directly with resolution; applications should be concerned only with screen size and density, as specified by the generalized size and density groups.\n\nWidth in pixels\n");
        this.register(AvdWizardConstants.RESOLUTION_HEIGHT_KEY, this.myScreenResolutionHeight, INT_BINDING);
        this.setControlDescription(this.myScreenResolutionHeight, "The total number of physical pixels on a screen. When adding support for multiple screens, applications do not work directly with resolution; applications should be concerned only with screen size and density, as specified by the generalized size and density groups.\n<br>Height in pixels\n");
        this.register(AvdWizardConstants.RAM_STORAGE_KEY, this.myRamField, this.myRamField.getBinding());
        this.setControlDescription(this.myRamField, "The amount of physical RAM on the device.");
        this.register(AvdWizardConstants.HAS_HARDWARE_BUTTONS_KEY, this.myHasHardwareButtons);
        this.setControlDescription(this.myHasHardwareButtons, "Enables hardware navigation button support in Android Virtual Device");
        this.register(AvdWizardConstants.HAS_HARDWARE_KEYBOARD_KEY, this.myHasHardwareKeyboard);
        this.setControlDescription(this.myHasHardwareKeyboard, "Enables hardware keyboard  support in Android Virtual Device");
        this.register(AvdWizardConstants.NAVIGATION_KEY, this.myNavigationControlsCombo, NAVIGATION_BINDING);
        this.setControlDescription(this.myNavigationControlsCombo, "No Navigation - No navigational controls \n<br>Directional Pad - Enables direction pad support in emulator\n<br>Trackball - Enables trackball support in emulator");
        this.register(AvdWizardConstants.SUPPORTS_LANDSCAPE_KEY, this.mySupportsLandscape);
        this.setControlDescription(this.mySupportsLandscape, "Enables the landscape device screen state in emulator ");
        this.register(AvdWizardConstants.SUPPORTS_PORTRAIT_KEY, this.mySupportsPortrait);
        this.setControlDescription(this.mySupportsPortrait, "Enables the portrait device screen state in emulator ");
        this.register(AvdWizardConstants.HAS_BACK_CAMERA_KEY, this.myHasBackFacingCamera);
        this.setControlDescription(this.myHasBackFacingCamera, "Enables back-facing camera support in emulator");
        this.register(AvdWizardConstants.HAS_FRONT_CAMERA_KEY, this.myHasFrontFacingCamera);
        this.setControlDescription(this.myHasFrontFacingCamera, "Enables front- facing camera support in emulator");
        this.register(AvdWizardConstants.HAS_ACCELEROMETER_KEY, this.myHasAccelerometer);
        this.setControlDescription(this.myHasAccelerometer, "Enables accelerometer support in emulator");
        this.register(AvdWizardConstants.HAS_GYROSCOPE_KEY, this.myHasGyroscope);
        this.setControlDescription(this.myHasGyroscope, "Enables gyroscope support in emulator");
        this.register(AvdWizardConstants.HAS_GPS_KEY, this.myHasGps);
        this.setControlDescription(this.myHasGps, "Enables GPS (global positioning support) support in emulator");
        this.register(AvdWizardConstants.HAS_PROXIMITY_SENSOR_KEY, this.myHasProximitySensor);
        this.setControlDescription(this.myHasProximitySensor, "Enables proximity sensor support in emulator");
        File skinFile = this.myState.get(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY);
        this.register(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY, this.myCustomSkinPath, this.myCustomSkinPath.getBinding());
        this.myState.put(AvdWizardConstants.CUSTOM_SKIN_FILE_KEY, skinFile);
        this.setControlDescription((Component)((Object)this.myCustomSkinPath), "Path to a directory containing a custom skin");
        this.register(AvdWizardConstants.TAG_ID_KEY, (JComboBox)this.myDeviceTypeComboBox);
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Configure Device Profile" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep", "getStepName"));
        }
        return "Configure Device Profile";
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        if ("Configure Hardware Profile" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/ConfigureDeviceOptionsStep", "getStepTitle"));
        }
        return "Configure Hardware Profile";
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        StorageField storageField;
        JTextField jTextField;
        ComboBox comboBox;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        DeviceDefinitionPreview deviceDefinitionPreview;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        this.myDeviceDefinitionPreview = deviceDefinitionPreview = new DeviceDefinitionPreview();
        jPanel.add((Component)deviceDefinitionPreview, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(360, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(27, 3, new Insets(5, 5, 5, 5), -1, 5, false, false));
        jBScrollPane.setViewportView(jPanel2);
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Screen");
        jPanel2.add((Component)jBLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Memory");
        jPanel2.add((Component)jBLabel2, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Cameras");
        jPanel2.add((Component)jBLabel3, new GridConstraints(16, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Sensors");
        jPanel2.add((Component)jBLabel4, new GridConstraints(19, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHasBackFacingCamera = jCheckBox10 = new JCheckBox();
        jCheckBox10.setText("Back-facing camera");
        jCheckBox10.setSelected(true);
        jPanel2.add((Component)jCheckBox10, new GridConstraints(16, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHasFrontFacingCamera = jCheckBox9 = new JCheckBox();
        jCheckBox9.setText("Front-facing camera");
        jCheckBox9.setSelected(true);
        jPanel2.add((Component)jCheckBox9, new GridConstraints(17, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHasAccelerometer = jCheckBox8 = new JCheckBox();
        jCheckBox8.setText("Accelerometer");
        jCheckBox8.setSelected(true);
        jPanel2.add((Component)jCheckBox8, new GridConstraints(19, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHasGyroscope = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Gyroscope");
        jCheckBox7.setSelected(true);
        jPanel2.add((Component)jCheckBox7, new GridConstraints(20, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHasGps = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("GPS");
        jCheckBox6.setSelected(true);
        jPanel2.add((Component)jCheckBox6, new GridConstraints(21, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHasProximitySensor = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Proximity Sensor");
        jCheckBox5.setSelected(true);
        jPanel2.add((Component)jCheckBox5, new GridConstraints(22, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.mySupportsLandscape = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Landscape");
        jCheckBox4.setSelected(true);
        jPanel2.add((Component)jCheckBox4, new GridConstraints(14, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.mySupportsPortrait = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Portrait");
        jCheckBox3.setSelected(true);
        jPanel2.add((Component)jCheckBox3, new GridConstraints(13, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("<html>Supported<br>device states</html>");
        jPanel2.add((Component)jBLabel5, new GridConstraints(13, 0, 2, 1, 9, 0, 0, 0, null, null, null));
        this.myHasHardwareKeyboard = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Has Hardware Keyboard");
        jCheckBox2.setSelected(true);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(10, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHasHardwareButtons = jCheckBox = new JCheckBox();
        jCheckBox.setText("Has Hardware Buttons (Back/Home/Menu)");
        jCheckBox.setSelected(true);
        jPanel2.add((Component)jCheckBox, new GridConstraints(9, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Input");
        jPanel2.add((Component)jBLabel6, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeviceName = jTextField4 = new JTextField();
        jPanel2.add((Component)jTextField4, new GridConstraints(0, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setText("Device Name");
        jPanel2.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(150, -1), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(5, 1, 1, 2, 8, 2, 3, 3, null, null, null));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setText("Resolution:");
        jPanel3.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myScreenResolutionWidth = jTextField3 = new JTextField();
        jTextField3.setColumns(5);
        jPanel3.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JBLabel jBLabel9 = new JBLabel();
        jBLabel9.setText("x");
        jPanel3.add((Component)jBLabel9, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myScreenResolutionHeight = jTextField2 = new JTextField();
        jTextField2.setColumns(5);
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 3, 1, 1, 0, 0, 3, 3, null, null, null));
        JBLabel jBLabel10 = new JBLabel();
        jBLabel10.setText("px");
        jPanel3.add((Component)jBLabel10, new GridConstraints(0, 4, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(23, 0, 1, 1, 0, 2, 1, 6, new Dimension(-1, 15), new Dimension(-1, 15), null));
        JBLabel jBLabel11 = new JBLabel();
        jBLabel11.setText("Default Skin");
        jPanel2.add((Component)jBLabel11, new GridConstraints(25, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        SkinChooser skinChooser = this.myCustomSkinPath;
        jPanel2.add((Component)((Object)skinChooser), new GridConstraints(25, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myHardwareSkinHelpLabel;
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(26, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel12 = new JBLabel();
        jBLabel12.setText("Device Type");
        jPanel2.add((Component)jBLabel12, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeviceTypeComboBox = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(2, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel13 = new JBLabel();
        jBLabel13.setText("inch");
        jPanel4.add((Component)jBLabel13, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myDiagonalScreenSize = jTextField = new JTextField();
        jTextField.setColumns(10);
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JBLabel jBLabel14 = new JBLabel();
        jBLabel14.setText("Screensize:");
        jPanel4.add((Component)jBLabel14, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(7, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel15 = new JBLabel();
        jBLabel15.setText("RAM:");
        jPanel5.add((Component)jBLabel15, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRamField = storageField = new StorageField();
        jPanel5.add((Component)storageField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(11, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel16 = new JBLabel();
        jBLabel16.setText("Navigation Style:");
        jPanel6.add((Component)jBLabel16, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = this.myNavigationControlsCombo;
        jPanel6.add((Component)jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(1, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator2 = new JSeparator();
        jPanel2.add((Component)jSeparator2, new GridConstraints(3, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator3 = new JSeparator();
        jPanel2.add((Component)jSeparator3, new GridConstraints(6, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator4 = new JSeparator();
        jPanel2.add((Component)jSeparator4, new GridConstraints(8, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator5 = new JSeparator();
        jPanel2.add((Component)jSeparator5, new GridConstraints(12, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator6 = new JSeparator();
        jPanel2.add((Component)jSeparator6, new GridConstraints(15, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator7 = new JSeparator();
        jPanel2.add((Component)jSeparator7, new GridConstraints(18, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        JSeparator jSeparator8 = new JSeparator();
        jPanel2.add((Component)jSeparator8, new GridConstraints(24, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        JBLabel jBLabel17 = this.myHelpAndErrorLabel;
        jBLabel17.setVerticalTextPosition(1);
        jPanel.add((Component)jBLabel17, new GridConstraints(1, 1, 1, 1, 0, 1, 0, 0, new Dimension(-1, 150), new Dimension(360, 150), null));
        jBLabel7.setLabelFor(jTextField4);
        jBLabel8.setLabelFor(jTextField3);
        jBLabel9.setLabelFor(jTextField2);
        jBLabel14.setLabelFor(jTextField);
        jBLabel16.setLabelFor(jComboBox);
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

