/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.SystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.SystemImagePackage;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.internal.repository.sources.SdkSources;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.sdklib.repository.remote.RemoteSdk;
import com.android.tools.idea.avdmanager.ApiLevelComparator;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.LogWrapper;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.android.tools.idea.wizard.DialogWrapperHost;
import com.android.utils.ILogger;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemImageList
extends JPanel
implements ListSelectionListener {
    private final JButton myRefreshButton = new JButton(AllIcons.Actions.Refresh);
    private final JBCheckBox myShowRemoteCheckbox = new JBCheckBox("Show downloadable system images", true);
    private final JButton myInstallLatestVersionButton = new JButton("Install Latest Version...");
    private final LocalSdk mySdk;
    private final RemoteSdk myRemoteSdk;
    private final Project myProject;
    private final JPanel myRefreshPanel = new JPanel(new FlowLayout());
    private TableView<AvdWizardConstants.SystemImageDescription> myTable = new TableView();
    private ListTableModel<AvdWizardConstants.SystemImageDescription> myModel = new ListTableModel(new ColumnInfo[0]);
    private Set<SystemImageSelectionListener> myListeners = Sets.newHashSet();
    private Predicate<AvdWizardConstants.SystemImageDescription> myFilter;
    private static final Logger LOG = Logger.getInstance(SystemImageList.class);
    private static final ILogger ILOG = new LogWrapper(LOG){

        @Override
        public void error(Throwable t, String errorFormat, Object ... args) {
            LOG.error(String.format(errorFormat, args), t);
        }
    };
    private final MouseAdapter editorListener = new MouseAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            SystemImageList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SystemImageList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SystemImageList.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SystemImageList.this.possiblySwitchEditors(e);
        }
    };
    private final ColumnInfo[] ourColumnInfos = new ColumnInfo[]{new SystemImageColumnInfo("Release Name"){

        @Nullable
        public String valueOf(AvdWizardConstants.SystemImageDescription systemImage) {
            String codeName = SdkVersionInfo.getCodeName((int)systemImage.getVersion().getApiLevel());
            String maybeDeprecated = systemImage.getVersion().getApiLevel() < 8 ? " (Deprecated)" : "";
            return codeName == null ? "Unknown" : codeName + maybeDeprecated;
        }
    }, new SystemImageColumnInfo("API Level", 100){

        @Nullable
        public String valueOf(AvdWizardConstants.SystemImageDescription systemImage) {
            return systemImage.getVersion().getApiString();
        }

        @Override
        @Nullable
        public Comparator<AvdWizardConstants.SystemImageDescription> getComparator() {
            return new Comparator<AvdWizardConstants.SystemImageDescription>(){

                @Override
                public int compare(AvdWizardConstants.SystemImageDescription o1, AvdWizardConstants.SystemImageDescription o2) {
                    return o1.getVersion().getApiLevel() - o2.getVersion().getApiLevel();
                }
            };
        }
    }, new SystemImageColumnInfo("ABI", 100){

        @Nullable
        public String valueOf(AvdWizardConstants.SystemImageDescription systemImage) {
            return systemImage.getAbiType();
        }
    }, new SystemImageColumnInfo("Target"){

        @Nullable
        public String valueOf(AvdWizardConstants.SystemImageDescription systemImage) {
            IdDisplay tag = systemImage.getTag();
            String name = systemImage.getName();
            return tag == null || tag.equals((Object)SystemImage.DEFAULT_TAG) ? name : String.format("%1$s - %2$s", name, tag);
        }
    }};

    public SystemImageList(@Nullable Project project) {
        this.myProject = project;
        AndroidSdkData androidSdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (androidSdkData == null) {
            throw new RuntimeException("No SDK Found");
        }
        this.mySdk = androidSdkData.getLocalSdk();
        this.myRemoteSdk = androidSdkData.getRemoteSdk();
        this.myModel.setColumnInfos(this.ourColumnInfos);
        this.myModel.setSortable(true);
        this.myTable.setModelAndUpdateColumns(this.myModel);
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                super.setSelectionInterval(index0, index1);
                TableCellEditor editor = SystemImageList.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.cancelCellEditing();
                }
                SystemImageList.this.myTable.repaint();
                SystemImageList.this.possiblySwitchEditors(index0, 0);
            }
        };
        selectionModel.setSelectionMode(0);
        this.myTable.setSelectionModel((ListSelectionModel)selectionModel);
        this.myTable.setRowSelectionAllowed(true);
        this.myTable.addMouseListener((MouseListener)this.editorListener);
        this.myTable.addMouseMotionListener((MouseMotionListener)this.editorListener);
        this.setLayout(new BorderLayout());
        this.add((Component)ScrollPaneFactory.createScrollPane(this.myTable), "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        JPanel refreshMessageAndButton = new JPanel(new FlowLayout());
        AsyncProcessIcon refreshIcon = new AsyncProcessIcon("refresh images");
        JLabel refreshingLabel = new JLabel("Refreshing...");
        refreshingLabel.setForeground((Color)JBColor.GRAY);
        this.myRefreshPanel.add((Component)refreshIcon);
        this.myRefreshPanel.add(refreshingLabel);
        this.myRefreshPanel.setVisible(false);
        refreshMessageAndButton.add(this.myRefreshPanel);
        refreshMessageAndButton.add(this.myRefreshButton);
        southPanel.add((Component)refreshMessageAndButton, "East");
        southPanel.add((Component)this.myShowRemoteCheckbox, "West");
        this.myShowRemoteCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemImageList.this.myModel.fireTableDataChanged();
            }
        });
        this.myRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemImageList.this.refreshImages(true);
            }
        });
        this.myInstallLatestVersionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemImageList.this.installForDevice();
            }
        });
        this.add((Component)southPanel, "South");
        this.myTable.getSelectionModel().addListSelectionListener(this);
        TableRowSorter<ListTableModel<AvdWizardConstants.SystemImageDescription>> sorter = new TableRowSorter<ListTableModel<AvdWizardConstants.SystemImageDescription>>(this.myModel){

            @Override
            public Comparator<?> getComparator(int column) {
                if (column == 1) {
                    return new ApiLevelComparator();
                }
                return super.getComparator(column);
            }
        };
        sorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(1, SortOrder.DESCENDING)));
        sorter.setRowFilter(new RowFilter<ListTableModel<AvdWizardConstants.SystemImageDescription>, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends ListTableModel<AvdWizardConstants.SystemImageDescription>, ? extends Integer> entry) {
                return !((AvdWizardConstants.SystemImageDescription)SystemImageList.this.myModel.getRowValue(entry.getIdentifier().intValue())).isRemote() || SystemImageList.this.myShowRemoteCheckbox.isSelected();
            }
        });
        this.myTable.setRowSorter((RowSorter)sorter);
    }

    private void possiblySwitchEditors(MouseEvent e) {
        Point p = e.getPoint();
        int row = this.myTable.rowAtPoint(p);
        int col = this.myTable.columnAtPoint(p);
        this.possiblySwitchEditors(row, col);
    }

    private void possiblySwitchEditors(int row, int col) {
        if ((row != this.myTable.getEditingRow() || col != this.myTable.getEditingColumn()) && row != -1 && col != -1 && this.myTable.isCellEditable(row, col)) {
            this.myTable.editCellAt(row, col);
        }
    }

    public void refreshImages(final boolean forceRefresh) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Fetching available system image list"){

            public void run(@NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/android/tools/idea/avdmanager/SystemImageList$13", "run"));
                }
                SystemImageList.this.refreshImagesBackground(forceRefresh);
            }
        });
    }

    public void refreshImagesBackground(boolean forceRefresh) {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                SystemImageList.this.myRefreshPanel.setVisible(true);
                SystemImageList.this.myRefreshButton.setEnabled(false);
            }
        });
        if (forceRefresh) {
            this.mySdk.clearLocalPkg(PkgType.PKG_ALL);
        }
        List<AvdWizardConstants.SystemImageDescription> items = this.getLocalImages();
        this.updateListModel(items);
        items.addAll(this.getRemoteImages(this.getLocalFingerprints(items)));
        this.updateListModel(items);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                SystemImageList.this.myRefreshPanel.setVisible(false);
                SystemImageList.this.myRefreshButton.setEnabled(true);
            }
        });
    }

    private List<AvdWizardConstants.SystemImageDescription> getRemoteImages(Set<ImageFingerprint> seen) {
        ArrayList items = Lists.newArrayList();
        SdkSources sources = this.myRemoteSdk.fetchSources(86400000L, ILOG);
        Multimap packages = this.myRemoteSdk.fetch(sources, ILOG);
        if (packages.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    SystemImageList.this.myShowRemoteCheckbox.setEnabled(false);
                    SystemImageList.this.myShowRemoteCheckbox.setSelected(false);
                }
            });
        } else {
            for (SdkSource source : sources.getAllSources()) {
                Package[] sourcePackages = source.getPackages();
                if (sourcePackages == null) continue;
                for (Package pack : sourcePackages) {
                    if (!(pack instanceof SystemImagePackage)) continue;
                    AvdWizardConstants.SystemImageDescription desc = new AvdWizardConstants.SystemImageDescription(pack);
                    ImageFingerprint probe = new ImageFingerprint();
                    probe.version = desc.getVersion();
                    probe.tag = desc.getTag();
                    probe.abiType = desc.getAbiType();
                    if (seen.contains(probe) || this.myFilter != null && !this.myFilter.apply((Object)desc)) continue;
                    items.add(desc);
                }
            }
        }
        return items;
    }

    public void refreshLocalImagesSynchronously() {
        this.myModel.setItems(this.getLocalImages());
    }

    private Set<ImageFingerprint> getLocalFingerprints(List<AvdWizardConstants.SystemImageDescription> images) {
        HashSet fingerprints = Sets.newHashSet();
        for (AvdWizardConstants.SystemImageDescription image : images) {
            if (this.myFilter != null && !this.myFilter.apply((Object)image)) continue;
            ImageFingerprint si = new ImageFingerprint();
            si.tag = image.getTag();
            si.abiType = image.getAbiType();
            si.version = image.getTarget().getVersion();
            fingerprints.add(si);
        }
        return fingerprints;
    }

    private List<AvdWizardConstants.SystemImageDescription> getLocalImages() {
        ArrayList items = Lists.newArrayList();
        ArrayList targets = Lists.newArrayList((Object[])this.mySdk.getTargets());
        for (IAndroidTarget target : targets) {
            ISystemImage[] systemImages = target.getSystemImages();
            if (systemImages == null) continue;
            for (ISystemImage image : systemImages) {
                AvdWizardConstants.SystemImageDescription desc = new AvdWizardConstants.SystemImageDescription(target, image);
                if (this.myFilter != null && !this.myFilter.apply((Object)desc)) continue;
                items.add(desc);
            }
        }
        return items;
    }

    private void updateListModel(final @NotNull List<AvdWizardConstants.SystemImageDescription> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/android/tools/idea/avdmanager/SystemImageList", "updateListModel"));
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                AvdWizardConstants.SystemImageDescription selected = (AvdWizardConstants.SystemImageDescription)SystemImageList.this.myTable.getSelectedObject();
                SystemImageList.this.myModel.setItems(items);
                if (selected == null || !items.contains(selected)) {
                    SystemImageList.this.selectDefaultImage();
                } else {
                    SystemImageList.this.setSelectedImage(selected);
                }
            }
        };
        UIUtil.invokeLaterIfNeeded((Runnable)r);
    }

    public void setFilter(Predicate<AvdWizardConstants.SystemImageDescription> filter) {
        this.myFilter = filter;
    }

    public void addSelectionListener(SystemImageSelectionListener listener) {
        this.myListeners.add(listener);
    }

    public void selectDefaultImage() {
        AndroidVersion maxVersion = null;
        AvdWizardConstants.SystemImageDescription best = null;
        for (AvdWizardConstants.SystemImageDescription desc : this.myModel.getItems()) {
            if (desc.isRemote() || maxVersion != null && desc.getVersion().compareTo(maxVersion) <= 0 && (!desc.getVersion().equals((Object)maxVersion) || !desc.getAbiType().equals(Abi.X86.getCpuArch()))) continue;
            best = desc;
            maxVersion = best.getVersion();
        }
        this.setSelectedImage(best);
    }

    public void setSelectedImage(@Nullable AvdWizardConstants.SystemImageDescription selectedImage) {
        if (selectedImage != null) {
            for (AvdWizardConstants.SystemImageDescription listItem : this.myModel.getItems()) {
                if (!selectedImage.getVersion().equals((Object)listItem.getVersion()) || !selectedImage.getAbiType().equals(listItem.getAbiType())) continue;
                this.myTable.setSelection((Collection)ImmutableSet.of((Object)listItem));
                return;
            }
        } else {
            this.myTable.clearSelection();
        }
    }

    private void installForDevice() {
        int apiLevel = 21;
        ArrayList requestedPackages = Lists.newArrayListWithCapacity((int)3);
        requestedPackages.add(PkgDesc.Builder.newSysImg((AndroidVersion)new AndroidVersion(apiLevel, null), (IdDisplay)SystemImage.DEFAULT_TAG, (String)Abi.X86.toString(), (MajorRevision)new MajorRevision(1)).create());
        requestedPackages.add(PkgDesc.Builder.newSysImg((AndroidVersion)new AndroidVersion(apiLevel, null), (IdDisplay)AvdWizardConstants.WEAR_TAG, (String)Abi.X86.toString(), (MajorRevision)new MajorRevision(1)).create());
        requestedPackages.add(PkgDesc.Builder.newSysImg((AndroidVersion)new AndroidVersion(apiLevel, null), (IdDisplay)AvdWizardConstants.TV_TAG, (String)Abi.X86.toString(), (MajorRevision)new MajorRevision(1)).create());
        SdkQuickfixWizard sdkQuickfixWizard = new SdkQuickfixWizard(null, null, requestedPackages);
        sdkQuickfixWizard.init();
        sdkQuickfixWizard.show();
        this.refreshImages(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        AvdWizardConstants.SystemImageDescription selected = (AvdWizardConstants.SystemImageDescription)this.myTable.getSelectedObject();
        if (selected != null && selected.isRemote()) {
            selected = null;
        }
        for (SystemImageSelectionListener listener : this.myListeners) {
            listener.onSystemImageSelected(selected);
        }
    }

    public abstract class SystemImageColumnInfo
    extends ColumnInfo<AvdWizardConstants.SystemImageDescription, String> {
        private final Border myBorder;
        private final int myWidth;
        final /* synthetic */ SystemImageList this$0;

        public SystemImageColumnInfo(@NotNull SystemImageList systemImageList, String name, int width) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/SystemImageList$SystemImageColumnInfo", "<init>"));
            }
            this.this$0 = systemImageList;
            super(name);
            this.myBorder = IdeBorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)10);
            this.myWidth = width;
        }

        public SystemImageColumnInfo(@NotNull SystemImageList systemImageList, String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/avdmanager/SystemImageList$SystemImageColumnInfo", "<init>"));
            }
            this(systemImageList, name, -1);
        }

        public boolean isCellEditable(AvdWizardConstants.SystemImageDescription systemImageDescription) {
            return systemImageDescription.isRemote();
        }

        @Nullable
        public TableCellEditor getEditor(AvdWizardConstants.SystemImageDescription o) {
            return new SystemImageDescriptionRenderer(o);
        }

        @Nullable
        public TableCellRenderer getRenderer(AvdWizardConstants.SystemImageDescription o) {
            return new SystemImageDescriptionRenderer(o);
        }

        private void downloadImage(AvdWizardConstants.SystemImageDescription image) {
            IPkgDesc remote = image.getRemotePackage().getPkgDesc();
            IPkgDesc request = null;
            if (remote.getType().equals((Object)PkgType.PKG_SYS_IMAGE)) {
                request = PkgDesc.Builder.newSysImg((AndroidVersion)remote.getAndroidVersion(), (IdDisplay)remote.getTag(), (String)remote.getPath(), (MajorRevision)remote.getMajorRevision()).create();
            } else if (remote.getType().equals((Object)PkgType.PKG_ADDON_SYS_IMAGE)) {
                request = PkgDesc.Builder.newAddonSysImg((AndroidVersion)image.getVersion(), (IdDisplay)remote.getVendor(), (IdDisplay)image.getTag(), (String)image.getAbiType(), (MajorRevision)((MajorRevision)image.getRemotePackage().getRevision())).create();
            }
            ArrayList requestedPackages = Lists.newArrayList((Object[])new IPkgDesc[]{request});
            SdkQuickfixWizard sdkQuickfixWizard = new SdkQuickfixWizard(null, null, requestedPackages, new DialogWrapperHost(null, DialogWrapper.IdeModalityType.PROJECT));
            sdkQuickfixWizard.init();
            sdkQuickfixWizard.show();
            this.this$0.refreshImages(true);
        }

        @Nullable
        public Comparator<AvdWizardConstants.SystemImageDescription> getComparator() {
            return new Comparator<AvdWizardConstants.SystemImageDescription>(){

                @Override
                public int compare(AvdWizardConstants.SystemImageDescription o1, AvdWizardConstants.SystemImageDescription o2) {
                    String s1 = (String)SystemImageColumnInfo.this.valueOf(o1);
                    String s2 = (String)SystemImageColumnInfo.this.valueOf(o2);
                    return Comparing.compare((Comparable)((Object)s1), (Comparable)((Object)s2));
                }
            };
        }

        public int getWidth(JTable table) {
            return this.myWidth;
        }

        private class SystemImageDescriptionRenderer
        extends AbstractTableCellEditor
        implements TableCellRenderer {
            private AvdWizardConstants.SystemImageDescription image;

            SystemImageDescriptionRenderer(AvdWizardConstants.SystemImageDescription o) {
                this.image = o;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JPanel panel = new JPanel(new FlowLayout(0));
                if (isSelected) {
                    if (this.image.isRemote()) {
                        panel.setBackground(UIUtil.getListUnfocusedSelectionBackground());
                    } else {
                        panel.setBackground(table.getSelectionBackground());
                    }
                    panel.setForeground(table.getSelectionForeground());
                    panel.setOpaque(true);
                } else {
                    panel.setBackground(table.getBackground());
                    panel.setForeground(table.getForeground());
                    panel.setOpaque(true);
                }
                JBLabel label = new JBLabel((String)value);
                Font labelFont = UIUtil.getLabelFont();
                if (column == 0) {
                    label.setFont(labelFont.deriveFont(1));
                }
                if (this.image.isRemote()) {
                    Font font = labelFont.deriveFont(label.getFont().getStyle() | 2);
                    label.setFont(font);
                    label.setForeground(UIUtil.getLabelDisabledForeground());
                    if (!label.getText().isEmpty()) {
                        int fontMetricsWidth = label.getFontMetrics(label.getFont()).stringWidth(label.getText());
                        TextLayout l = new TextLayout(label.getText(), label.getFont(), label.getFontMetrics(label.getFont()).getFontRenderContext());
                        int offset = (int)Math.ceil(l.getBounds().getWidth()) - fontMetricsWidth;
                        if (offset > 0) {
                            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, offset));
                        }
                    }
                    panel.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyTyped(KeyEvent e) {
                            if (e.getKeyChar() == '\n' || e.getKeyChar() == ' ') {
                                SystemImageColumnInfo.this.downloadImage(SystemImageDescriptionRenderer.this.image);
                            }
                        }
                    });
                }
                panel.add((Component)label);
                if (this.image.isRemote() && column == 0) {
                    JBLabel link = new JBLabel("Download");
                    link.setBackground(table.getBackground());
                    link.setCursor(Cursor.getPredefinedCursor(12));
                    link.setForeground((Color)JBColor.BLUE);
                    Font font = link.getFont();
                    if (isSelected) {
                        HashMap attrs = Maps.newHashMap();
                        attrs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                        font = font.deriveFont(attrs);
                    }
                    link.setFont(font);
                    link.addMouseListener((MouseListener)new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            SystemImageColumnInfo.this.downloadImage(SystemImageDescriptionRenderer.this.image);
                        }
                    });
                    panel.add((Component)link);
                }
                return panel;
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return this.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            }

            public Object getCellEditorValue() {
                return null;
            }

            public boolean isCellEditable(EventObject e) {
                return true;
            }
        }
    }

    static class ImageFingerprint {
        IdDisplay tag;
        String abiType;
        AndroidVersion version;

        ImageFingerprint() {
        }

        public int hashCode() {
            return ((this.tag == null ? 0 : this.tag.hashCode()) * 37 + this.abiType.hashCode()) * 37 + this.version.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ImageFingerprint)) {
                return false;
            }
            ImageFingerprint other = (ImageFingerprint)obj;
            return this.tag.equals((Object)other.tag) && this.abiType.equals(other.abiType) && this.version.equals((Object)other.version);
        }
    }

    public static interface SystemImageSelectionListener {
        public void onSystemImageSelected(@Nullable AvdWizardConstants.SystemImageDescription var1);
    }
}

