/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.layout;

import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.dom.layout.Fragment;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FragmentLayoutDomFileDescription
extends LayoutDomFileDescription<Fragment> {
    public static final String FRAGMENT_TAG_NAME = "fragment";

    public FragmentLayoutDomFileDescription() {
        super(Fragment.class, FRAGMENT_TAG_NAME);
    }

    @Override
    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/dom/layout/FragmentLayoutDomFileDescription", "isMyFile"));
        }
        return super.isMyFile(file, module) && FragmentLayoutDomFileDescription.hasFragmentRootTag(file);
    }

    static boolean hasFragmentRootTag(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/dom/layout/FragmentLayoutDomFileDescription", "hasFragmentRootTag"));
        }
        XmlTag rootTag = file.getRootTag();
        return rootTag != null && FRAGMENT_TAG_NAME.equals(rootTag.getName());
    }
}

