/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class Command {
    @NotNull
    private final List<String> myParameters;
    @NotNull
    private final List<String> myOriginalParameters;
    @NotNull
    private final SvnCommandName myName;
    private File workingDirectory;
    @Nullable
    private File myConfigDir;
    @Nullable
    private LineCommandListener myResultBuilder;
    @Nullable
    private volatile SVNURL myRepositoryUrl;
    @NotNull
    private SvnTarget myTarget;
    @Nullable
    private Collection<File> myTargets;
    @Nullable
    private PropertyValue myPropertyValue;
    @Nullable
    private ProgressTracker myCanceller;

    public Command(@NotNull SvnCommandName name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/svn/commandLine/Command", "<init>"));
        }
        this.myParameters = ContainerUtil.newArrayList();
        this.myOriginalParameters = ContainerUtil.newArrayList();
        this.myName = name;
    }

    public void put(@Nullable Depth depth) {
        CommandUtil.put(this.myParameters, depth, false);
    }

    public void put(@NotNull SvnTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/commandLine/Command", "put"));
        }
        CommandUtil.put(this.myParameters, target);
    }

    public void put(@Nullable SVNRevision revision) {
        CommandUtil.put(this.myParameters, revision);
    }

    public void put(@NotNull String parameter, boolean condition) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/idea/svn/commandLine/Command", "put"));
        }
        CommandUtil.put(this.myParameters, condition, parameter);
    }

    public void put(String ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/commandLine/Command", "put"));
        }
        this.put(Arrays.asList(parameters));
    }

    public void put(@NotNull List<String> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/commandLine/Command", "put"));
        }
        this.myParameters.addAll(parameters);
    }

    public void putIfNotPresent(@NotNull String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/idea/svn/commandLine/Command", "putIfNotPresent"));
        }
        if (!this.myParameters.contains(parameter)) {
            this.myParameters.add(parameter);
        }
    }

    @Nullable
    public ProgressTracker getCanceller() {
        return this.myCanceller;
    }

    public void setCanceller(@Nullable ProgressTracker canceller) {
        this.myCanceller = canceller;
    }

    @Nullable
    public File getConfigDir() {
        return this.myConfigDir;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Nullable
    public LineCommandListener getResultBuilder() {
        return this.myResultBuilder;
    }

    @Nullable
    public SVNURL getRepositoryUrl() {
        return this.myRepositoryUrl;
    }

    @NotNull
    public SVNURL requireRepositoryUrl() {
        SVNURL result = this.getRepositoryUrl();
        assert (result != null);
        SVNURL sVNURL = result;
        if (sVNURL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/Command", "requireRepositoryUrl"));
        }
        return sVNURL;
    }

    @NotNull
    public SvnTarget getTarget() {
        SvnTarget svnTarget = this.myTarget;
        if (svnTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/Command", "getTarget"));
        }
        return svnTarget;
    }

    @Nullable
    public List<String> getTargetsPaths() {
        return ContainerUtil.isEmpty(this.myTargets) ? null : ContainerUtil.map(this.myTargets, (Function)new Function<File, String>(){

            public String fun(File file) {
                return file.getAbsolutePath();
            }
        });
    }

    @Nullable
    public PropertyValue getPropertyValue() {
        return this.myPropertyValue;
    }

    @NotNull
    public SvnCommandName getName() {
        SvnCommandName svnCommandName = this.myName;
        if (svnCommandName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/Command", "getName"));
        }
        return svnCommandName;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setConfigDir(@Nullable File configDir) {
        this.myConfigDir = configDir;
    }

    public void setResultBuilder(@Nullable LineCommandListener resultBuilder) {
        this.myResultBuilder = resultBuilder;
    }

    public void setRepositoryUrl(@Nullable SVNURL repositoryUrl) {
        this.myRepositoryUrl = repositoryUrl;
    }

    public void setTarget(@NotNull SvnTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/commandLine/Command", "setTarget"));
        }
        this.myTarget = target;
    }

    public void setTargets(@Nullable Collection<File> targets) {
        this.myTargets = targets;
    }

    public void setPropertyValue(@Nullable PropertyValue propertyValue) {
        this.myPropertyValue = propertyValue;
    }

    public void saveOriginalParameters() {
        this.myOriginalParameters.clear();
        this.myOriginalParameters.addAll(this.myParameters);
    }

    @NotNull
    public List<String> getParameters() {
        ArrayList arrayList = ContainerUtil.newArrayList(this.myParameters);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/Command", "getParameters"));
        }
        return arrayList;
    }

    public String getText() {
        ArrayList<String> data = new ArrayList<String>();
        if (this.myConfigDir != null) {
            data.add("--config-dir");
            data.add(this.myConfigDir.getPath());
        }
        data.add(this.myName.getName());
        data.addAll(this.myOriginalParameters);
        List<String> targetsPaths = this.getTargetsPaths();
        if (!ContainerUtil.isEmpty(targetsPaths)) {
            data.addAll(targetsPaths);
        }
        return StringUtil.join(data, (String)" ");
    }

    public boolean isLocalInfo() {
        return this.is(SvnCommandName.info) && this.hasLocalTarget() && !this.myParameters.contains("--revision");
    }

    public boolean isLocalStatus() {
        return this.is(SvnCommandName.st) && this.hasLocalTarget() && !this.myParameters.contains("-u");
    }

    public boolean isLocalProperty() {
        boolean isPropertyCommand = this.is(SvnCommandName.proplist) || this.is(SvnCommandName.propget) || this.is(SvnCommandName.propset) || this.is(SvnCommandName.propdel);
        return isPropertyCommand && this.hasLocalTarget() && Command.isLocal(this.getRevision());
    }

    public boolean isLocalCat() {
        return this.is(SvnCommandName.cat) && this.hasLocalTarget() && Command.isLocal(this.getRevision());
    }

    @Nullable
    private SVNRevision getRevision() {
        int index = this.myParameters.indexOf("--revision");
        return index >= 0 && index + 1 < this.myParameters.size() ? SVNRevision.parse((String)this.myParameters.get(index + 1)) : null;
    }

    public boolean is(@NotNull SvnCommandName name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/svn/commandLine/Command", "is"));
        }
        return name.equals((Object)this.myName);
    }

    private boolean hasLocalTarget() {
        return this.myTarget.isFile() && Command.isLocal(this.myTarget.getPegRevision());
    }

    private static boolean isLocal(@Nullable SVNRevision revision) {
        return revision == null || SVNRevision.UNDEFINED.equals((Object)revision) || SVNRevision.BASE.equals((Object)revision) || SVNRevision.WORKING.equals((Object)revision);
    }
}

