/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GroovyDslAnnotator
implements Annotator,
DumbAware {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        VirtualFile vfile;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/plugins/groovy/dsl/GroovyDslAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/dsl/GroovyDslAnnotator", "annotate"));
        }
        if (psiElement instanceof GroovyFile && (vfile = ((GroovyFile)psiElement).getVirtualFile()) != null && "gdsl".equals(vfile.getExtension()) && (!GroovyDslFileIndex.isActivated(vfile) || FileDocumentManager.getInstance().isFileModified(vfile))) {
            String reason = GroovyDslFileIndex.getInactivityReason(vfile);
            boolean modified = reason == null || "Modified".equals(reason);
            String message = modified ? "DSL descriptor file has been changed and isn't currently executed." : "DSL descriptor file has been disabled due to a processing error.";
            Annotation annotation = holder.createWarningAnnotation(psiElement, message);
            annotation.setFileLevelAnnotation(true);
            if (!modified) {
                annotation.registerFix(GroovyQuickFixFactory.getInstance().createInvestigateFix(reason));
            }
            annotation.registerFix((IntentionAction)new ActivateFix(vfile));
        }
    }

    private static class ActivateFix
    implements IntentionAction {
        private final VirtualFile myVfile;

        public ActivateFix(VirtualFile vfile) {
            this.myVfile = vfile;
        }

        @NotNull
        public String getText() {
            if ("Activate back" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/GroovyDslAnnotator$ActivateFix", "getText"));
            }
            return "Activate back";
        }

        @NotNull
        public String getFamilyName() {
            if ("Activate DSL descriptor" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/GroovyDslAnnotator$ActivateFix", "getFamilyName"));
            }
            return "Activate DSL descriptor";
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/dsl/GroovyDslAnnotator$ActivateFix", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/dsl/GroovyDslAnnotator$ActivateFix", "invoke"));
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            GroovyDslFileIndex.activateUntilModification(this.myVfile);
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

