/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.AssignmentExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arguments.CommandArguments;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arithmetic.PathExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arithmetic.UnaryExpressionNotPlusMinus;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.PrimaryExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class ExpressionStatement {
    private static IElementType parseExpressionStatement(PsiBuilder builder, GroovyParser parser) {
        if (ExpressionStatement.checkForTypeCast(builder, parser)) {
            return GroovyElementTypes.CAST_EXPRESSION;
        }
        PsiBuilder.Marker marker = builder.mark();
        PathExpression.Result result = PathExpression.parsePathExprQualifierForExprStatement(builder, parser);
        if (!(result == PathExpression.Result.WRONG_WAY || TokenSets.SEPARATORS.contains(builder.getTokenType()) || TokenSets.BINARY_OP_SET.contains(builder.getTokenType()) || TokenSets.POSTFIX_UNARY_OP_SET.contains(builder.getTokenType()))) {
            if (result == PathExpression.Result.METHOD_CALL) {
                marker.drop();
                return GroovyElementTypes.PATH_METHOD_CALL;
            }
            if (result == PathExpression.Result.LITERAL) {
                PsiBuilder.Marker newMarker = marker.precede();
                marker.rollbackTo();
                marker = newMarker;
                PrimaryExpression.parsePrimaryExpression(builder, parser, true);
            }
            if (CommandArguments.parseCommandArguments(builder, parser)) {
                marker.done((IElementType)GroovyElementTypes.CALL_EXPRESSION);
                return GroovyElementTypes.CALL_EXPRESSION;
            }
        }
        marker.drop();
        return GroovyElementTypes.WRONGWAY;
    }

    private static boolean checkForTypeCast(PsiBuilder builder, GroovyParser parser) {
        return UnaryExpressionNotPlusMinus.parse(builder, parser, false);
    }

    public static boolean argParse(PsiBuilder builder, GroovyParser parser) {
        return AssignmentExpression.parse(builder, parser);
    }

    public static Result parse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker exprStatement;
        PsiBuilder.Marker marker = builder.mark();
        IElementType result = ExpressionStatement.parseExpressionStatement(builder, parser);
        if (result != GroovyElementTypes.CALL_EXPRESSION && result != GroovyElementTypes.PATH_METHOD_CALL) {
            marker.drop();
            return result == GroovyElementTypes.WRONGWAY ? Result.WRONG_WAY : Result.EXPRESSION;
        }
        boolean isExprStatement = result == GroovyElementTypes.CALL_EXPRESSION;
        while (true) {
            boolean nameParsed;
            boolean bl = nameParsed = ExpressionStatement.namePartParse(builder, parser) == GroovyElementTypes.REFERENCE_EXPRESSION;
            if (nameParsed) {
                exprStatement = marker.precede();
                marker.done((IElementType)GroovyElementTypes.REFERENCE_EXPRESSION);
            } else {
                exprStatement = marker;
            }
            if (builder.getTokenType() == GroovyTokenTypes.mLPAREN) {
                PrimaryExpression.methodCallArgsParse(builder, parser);
                exprStatement.done((IElementType)GroovyElementTypes.PATH_METHOD_CALL);
            } else if (GroovyTokenTypes.mLBRACK.equals(builder.getTokenType()) && !ParserUtils.lookAhead(builder, GroovyTokenTypes.mLBRACK, GroovyTokenTypes.mCOLON) && !ParserUtils.lookAhead(builder, GroovyTokenTypes.mLBRACK, GroovyTokenTypes.mNLS, GroovyTokenTypes.mCOLON)) {
                PathExpression.indexPropertyArgsParse(builder, parser);
                exprStatement.done((IElementType)GroovyElementTypes.PATH_INDEX_PROPERTY);
                if (GroovyTokenTypes.mLPAREN.equals(builder.getTokenType())) {
                    PrimaryExpression.methodCallArgsParse(builder, parser);
                } else if (GroovyTokenTypes.mLCURLY.equals(builder.getTokenType())) {
                    PsiBuilder.Marker argsMarker = builder.mark();
                    argsMarker.done((IElementType)GroovyElementTypes.ARGUMENTS);
                }
                while (GroovyTokenTypes.mLCURLY.equals(builder.getTokenType())) {
                    OpenOrClosableBlock.parseClosableBlock(builder, parser);
                }
                exprStatement = exprStatement.precede();
                exprStatement.done((IElementType)GroovyElementTypes.PATH_METHOD_CALL);
            } else {
                if (!nameParsed || !CommandArguments.parseCommandArguments(builder, parser)) break;
                isExprStatement = true;
                exprStatement.done((IElementType)GroovyElementTypes.CALL_EXPRESSION);
            }
            marker = exprStatement.precede();
        }
        exprStatement.drop();
        return isExprStatement ? Result.EXPR_STATEMENT : Result.EXPRESSION;
    }

    private static GroovyElementType namePartParse(PsiBuilder builder, GroovyParser parser) {
        if (TokenSets.BINARY_OP_SET.contains(builder.getTokenType())) {
            return GroovyElementTypes.WRONGWAY;
        }
        if (TokenSets.KEYWORDS.contains(builder.getTokenType())) {
            return GroovyElementTypes.WRONGWAY;
        }
        GroovyElementType type = PathExpression.namePartParse(builder, parser);
        if (type == GroovyElementTypes.WRONGWAY && TokenSets.NUMBERS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            return GroovyElementTypes.REFERENCE_EXPRESSION;
        }
        return type;
    }

    static enum Result {
        WRONG_WAY,
        EXPR_STATEMENT,
        EXPRESSION;

    }
}

