/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedXmlDocumentSet {
    private final Map<String, String> nameToDir = new THashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element load(@NotNull String name, boolean refresh) throws IOException, JDOMException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/eclipse/config/CachedXmlDocumentSet", "load"));
        }
        this.assertKnownName(name);
        VirtualFile file = this.getFile(name, refresh);
        if (file == null) {
            return null;
        }
        InputStream inputStream = file.getInputStream();
        try {
            Element element = JDOMUtil.load((InputStream)inputStream);
            return element;
        }
        finally {
            inputStream.close();
        }
    }

    public String getParent(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/eclipse/config/CachedXmlDocumentSet", "getParent"));
        }
        return this.nameToDir.get(name);
    }

    public void register(@NotNull String name, @NotNull String path) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/eclipse/config/CachedXmlDocumentSet", "register"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/eclipse/config/CachedXmlDocumentSet", "register"));
        }
        this.nameToDir.put(name, path);
    }

    protected void assertKnownName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/eclipse/config/CachedXmlDocumentSet", "assertKnownName"));
        }
        assert (this.nameToDir.containsKey(name)) : name;
    }

    public boolean exists(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/eclipse/config/CachedXmlDocumentSet", "exists"));
        }
        return this.getFile(name, false) != null;
    }

    @Nullable
    VirtualFile getFile(@NotNull String name, boolean refresh) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/eclipse/config/CachedXmlDocumentSet", "getFile"));
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(new File(this.getParent(name), name));
        if (file != null && refresh) {
            file.refresh(false, true);
            if (!file.isValid()) {
                return null;
            }
        }
        return file;
    }

    @NotNull
    public List<String> getFileUrls() {
        ArrayList<String> list = new ArrayList<String>(this.nameToDir.size());
        for (String name : this.nameToDir.keySet()) {
            list.add("file://" + this.getParent(name) + '/' + name);
        }
        ArrayList<String> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/config/CachedXmlDocumentSet", "getFileUrls"));
        }
        return arrayList;
    }
}

