/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.refactoring.introduceParameter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.refactoring.RefactoringUtil;
import org.intellij.lang.xpath.xslt.refactoring.introduceParameter.IntroduceParameterOptions;
import org.intellij.lang.xpath.xslt.refactoring.introduceParameter.XPathUsageInfo;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.NotNull;

class IntroduceParameterProcessor
extends BaseRefactoringProcessor {
    private final XPathExpression myExpression;
    private final Set<XPathExpression> myOtherExpressions;
    private final IntroduceParameterOptions mySettings;
    private final XsltTemplate myTemplate;

    public IntroduceParameterProcessor(Project project, XPathExpression expression, Set<XPathExpression> otherExpressions, IntroduceParameterOptions settings) {
        super(project);
        this.mySettings = settings;
        this.myExpression = expression;
        this.myOtherExpressions = settings.isReplaceAll() ? otherExpressions : Collections.emptySet();
        XmlTag templateTag = XsltCodeInsightUtil.getTemplateTag(this.myExpression, true, true);
        this.myTemplate = templateTag != null ? XsltElementFactory.getInstance().wrapElement(templateTag, XsltTemplate.class) : null;
        this.setPreviewUsages(settings.isPreview());
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usageInfos) {
        MyUsageViewDescriptorAdapter myUsageViewDescriptorAdapter = new MyUsageViewDescriptorAdapter();
        if (myUsageViewDescriptorAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/refactoring/introduceParameter/IntroduceParameterProcessor", "createUsageViewDescriptor"));
        }
        return myUsageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        List<PsiElement> callsToUpdate;
        int usageCount = this.myOtherExpressions.size() + 1;
        if (!this.mySettings.isCreateDefault()) {
            assert (this.myTemplate != null);
            Collection references = ReferencesSearch.search((PsiElement)this.myTemplate, (SearchScope)this.myTemplate.getUseScope(), (boolean)false).findAll();
            callsToUpdate = new ArrayList<PsiElement>(references.size());
            for (PsiReference reference : references) {
                PsiElement e = reference.getElement();
                XmlTag tag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)e, XmlTag.class, (boolean)true);
                if (tag == null || !XsltSupport.isTemplateCall(tag)) continue;
                callsToUpdate.add((PsiElement)tag);
            }
            usageCount += callsToUpdate.size();
        } else {
            callsToUpdate = Collections.emptyList();
        }
        UsageInfo[] usageInfos = new UsageInfo[usageCount];
        usageInfos[0] = XPathUsageInfo.create(this.myExpression);
        int i = 1;
        for (XPathExpression expression : this.myOtherExpressions) {
            usageInfos[i++] = XPathUsageInfo.create(expression);
        }
        for (PsiElement o : callsToUpdate) {
            usageInfos[i++] = new UsageInfo(o, false);
        }
        if (usageInfos == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/refactoring/introduceParameter/IntroduceParameterProcessor", "findUsages"));
        }
        return usageInfos;
    }

    protected void refreshElements(PsiElement[] psiElements) {
    }

    protected void performRefactoring(UsageInfo[] usageInfos) {
        XmlTag tag;
        if (this.myTemplate != null) {
            tag = this.myTemplate.getTag();
        } else {
            tag = XsltCodeInsightUtil.getTemplateTag(this.myExpression, true, false);
            if (tag == null) {
                XmlDocument document = (XmlDocument)PsiTreeUtil.getContextOfType((PsiElement)this.myExpression, XmlDocument.class, (boolean)true);
                assert (document != null);
                tag = document.getRootTag();
            }
        }
        assert (tag != null);
        XmlTag param = tag.createChildTag("param", "http://www.w3.org/1999/XSL/Transform", null, false);
        try {
            param.setAttribute("name", this.mySettings.getName());
            if (this.mySettings.isCreateDefault()) {
                param.setAttribute("select", this.myExpression.getText());
            }
            XmlTag anchorParam = null;
            for (UsageInfo info : usageInfos) {
                if (info instanceof XPathUsageInfo) {
                    XPathUsageInfo x = (XPathUsageInfo)info;
                    XPathVariableReference variableReference = XPathChangeUtil.createVariableReference(x.getExpression(), this.mySettings.getName());
                    XmlAttribute attribute = x.getAttribute();
                    assert (attribute != null);
                    x.getExpression().replace(variableReference);
                    if (!XsltSupport.isParam(attribute.getParent())) continue;
                    if (anchorParam == null) {
                        anchorParam = attribute.getParent();
                        continue;
                    }
                    if (attribute.getParent().getTextOffset() >= anchorParam.getTextOffset()) continue;
                    anchorParam = attribute.getParent();
                    continue;
                }
                XmlTag t = (XmlTag)info.getElement();
                if (t == null) continue;
                XmlTag p = t.createChildTag("with-param", t.getNamespace(), null, false);
                p.setAttribute("name", this.mySettings.getName());
                p.setAttribute("select", this.myExpression.getText());
                t.add((PsiElement)p);
            }
            if (anchorParam != null) {
                RefactoringUtil.addParameter(tag, param, (XmlTag)PsiTreeUtil.getPrevSiblingOfType(anchorParam, XmlTag.class));
            } else {
                RefactoringUtil.addParameter(tag, param);
            }
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance((String)((Object)((Object)this)).getClass().getName()).error((Throwable)e);
        }
    }

    protected String getCommandName() {
        return "Introduce XSLT Parameter";
    }

    private class MyUsageViewDescriptorAdapter
    extends UsageViewDescriptorAdapter {
        private MyUsageViewDescriptorAdapter() {
        }

        @NotNull
        public PsiElement[] getElements() {
            PsiElement[] psiElementArray = new PsiElement[]{IntroduceParameterProcessor.this.myTemplate};
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/refactoring/introduceParameter/IntroduceParameterProcessor$MyUsageViewDescriptorAdapter", "getElements"));
            }
            return psiElementArray;
        }

        public String getProcessedElementsHeader() {
            return "Adding parameter to template";
        }
    }
}

