/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.dom.AntDomCustomElement;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomFileReference;
import com.intellij.lang.ant.dom.AntDomNamedElement;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomProperty;
import com.intellij.lang.ant.dom.AntDomPropertyReference;
import com.intellij.lang.ant.dom.AntDomReference;
import com.intellij.lang.ant.dom.AntDomTargetReference;
import com.intellij.lang.ant.dom.AntDomTypeDef;
import com.intellij.lang.ant.quickfix.AntChangeContextLocalFix;
import com.intellij.lang.ant.quickfix.AntCreatePropertyFix;
import com.intellij.lang.ant.quickfix.AntCreateTargetFix;
import com.intellij.lang.ant.validation.AntInspection;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntResolveInspection
extends AntInspection {
    public static final String SHORT_NAME = "AntResolveInspection";

    @NotNull
    public String getDisplayName() {
        if ("Ant references resolve problems" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntResolveInspection", "getDisplayName"));
        }
        return "Ant references resolve problems";
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntResolveInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        AntDomNamedElement declaringElement;
        AntDomCustomElement custom;
        if (element instanceof GenericDomValue) {
            XmlElement valueElement = DomUtil.getValueElement((GenericDomValue)((GenericDomValue)element));
            if (valueElement != null) {
                AntResolveInspection.checkReferences(valueElement, holder, element);
            }
        } else if (element instanceof AntDomTypeDef) {
            AntDomTypeDef typeDef = (AntDomTypeDef)element;
            List<String> errors = typeDef.getErrorDescriptions();
            if (!errors.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                builder.append(AntBundle.message("failed.to.load.types", new Object[0])).append(":");
                for (String error : errors) {
                    builder.append("\n").append(error);
                }
                holder.createProblem((DomElement)typeDef, builder.toString(), new LocalQuickFix[0]);
            }
        } else if (element instanceof AntDomCustomElement && (custom = (AntDomCustomElement)element).getDefinitionClass() == null && (declaringElement = custom.getDeclaringElement()) instanceof AntDomTypeDef) {
            String failedMessage = AntBundle.message("using.definition.which.type.failed.to.load", new Object[0]);
            String error = custom.getLoadError();
            if (error != null) {
                failedMessage = failedMessage + ": " + error;
            }
            holder.createProblem((DomElement)custom, failedMessage, new LocalQuickFix[0]);
        }
    }

    private static void checkReferences(XmlElement xmlElement, @NonNls DomElementAnnotationHolder holder, DomElement domElement) {
        if (xmlElement == null) {
            return;
        }
        Set processed = null;
        Collection<PropertiesFile> propertyFiles = null;
        for (PsiReference ref : xmlElement.getReferences()) {
            AntDomReference antDomRef;
            if (!(ref instanceof AntDomReference) || (antDomRef = (AntDomReference)ref).shouldBeSkippedByAnnotator() || processed != null && processed.contains(ref) || AntResolveInspection.isResolvable(ref)) continue;
            SmartList quickFixList = new SmartList();
            quickFixList.add(new AntChangeContextLocalFix());
            if (ref instanceof AntDomPropertyReference) {
                String canonicalText = ref.getCanonicalText();
                quickFixList.add(new AntCreatePropertyFix(canonicalText, null));
                PsiFile containingFile = xmlElement.getContainingFile();
                if (containingFile != null) {
                    if (propertyFiles == null) {
                        propertyFiles = AntResolveInspection.getPropertyFiles(AntSupport.getAntDomProject(containingFile), xmlElement);
                    }
                    for (PropertiesFile propertyFile : propertyFiles) {
                        quickFixList.add(new AntCreatePropertyFix(canonicalText, propertyFile));
                    }
                }
            } else if (ref instanceof AntDomTargetReference) {
                quickFixList.add(new AntCreateTargetFix(ref.getCanonicalText()));
            }
            holder.createProblem(domElement, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, antDomRef.getUnresolvedMessagePattern(), ref.getRangeInElement(), quickFixList.toArray(new LocalQuickFix[quickFixList.size()]));
            if (!(ref instanceof AntDomFileReference)) continue;
            if (processed == null) {
                processed = new HashSet();
            }
            ContainerUtil.addAll((Collection)processed, (Object[])((AntDomFileReference)ref).getFileReferenceSet().getAllReferences());
        }
    }

    private static boolean isResolvable(PsiReference ref) {
        if (ref.resolve() != null) {
            return true;
        }
        if (ref instanceof PsiPolyVariantReference) {
            return ((PsiPolyVariantReference)ref).multiResolve(false).length > 0;
        }
        return false;
    }

    @NotNull
    private static Collection<PropertiesFile> getPropertyFiles(@Nullable AntDomProject antDomProject, @NotNull XmlElement stopElement) {
        AntDomElement child;
        XmlElement xmlElement;
        if (stopElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopElement", "com/intellij/lang/ant/dom/AntResolveInspection", "getPropertyFiles"));
        }
        if (antDomProject == null) {
            List<PropertiesFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntResolveInspection", "getPropertyFiles"));
            }
            return list;
        }
        java.util.HashSet<PropertiesFile> files = new java.util.HashSet<PropertiesFile>();
        int stopOffset = stopElement.getTextOffset();
        Iterator<AntDomElement> iterator = antDomProject.getAntChildrenIterator();
        while (iterator.hasNext() && ((xmlElement = (child = iterator.next()).getXmlElement()) == null || xmlElement.getTextOffset() < stopOffset)) {
            AntDomProperty property;
            PropertiesFile file;
            if (!(child instanceof AntDomProperty) || (file = (property = (AntDomProperty)child).getPropertiesFile()) == null) continue;
            files.add(file);
        }
        java.util.HashSet<PropertiesFile> hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntResolveInspection", "getPropertyFiles"));
        }
        return hashSet;
    }
}

