/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.model;

import com.android.annotations.Transient;
import com.android.tools.idea.editors.navigation.model.Utilities;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class Properties {
    private static Method[] findGetters(Class c) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : c.getMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length != 0 || !m.getName().startsWith("get") || Properties.isTransient(m)) continue;
            methods.add(m);
        }
        Collections.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                return m1.getName().compareTo(m2.getName());
            }
        });
        return methods.toArray(new Method[methods.size()]);
    }

    private static boolean isTransient(AnnotatedElement e) {
        return e.getAnnotation(Transient.class) != null;
    }

    static Property[] computeProperties(Class c) {
        ArrayList<Property> result = new ArrayList<Property>();
        for (Field field : c.getFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Properties.isTransient(field)) continue;
            result.add(new FieldProperty(field));
        }
        for (AccessibleObject accessibleObject : Properties.findGetters(c)) {
            result.add(new MethodProperty((Method)accessibleObject));
        }
        return result.toArray(new Property[result.size()]);
    }

    static class MethodProperty<T>
    extends Property<T> {
        private final Method method;

        MethodProperty(Method method) {
            this.method = method;
        }

        @Override
        String getName() {
            return Utilities.getPropertyName(this.method);
        }

        @Override
        Class getType() {
            return this.method.getReturnType();
        }

        @Override
        Object getValue(T o) throws PropertyAccessException {
            try {
                return this.method.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new PropertyAccessException(e);
            }
            catch (InvocationTargetException e) {
                throw new PropertyAccessException(e);
            }
        }
    }

    static class FieldProperty<T>
    extends Property<T> {
        private final Field field;

        FieldProperty(Field field) {
            this.field = field;
        }

        @Override
        String getName() {
            return this.field.getName();
        }

        @Override
        Class getType() {
            return this.field.getType();
        }

        @Override
        Object getValue(T o) throws PropertyAccessException {
            try {
                return this.field.get(o);
            }
            catch (IllegalAccessException e) {
                throw new PropertyAccessException(e);
            }
        }
    }

    static abstract class Property<T> {
        Property() {
        }

        abstract String getName();

        abstract Class getType();

        abstract Object getValue(T var1) throws PropertyAccessException;
    }

    static class PropertyAccessException
    extends Exception {
        private PropertyAccessException(Throwable throwable) {
            super(throwable);
        }
    }
}

