/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ConvertReturnStatementsVisitor;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedParameterFix;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReturnTypeFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnBooleanFix");
    private final SmartTypePointer myReturnTypePointer;
    private final boolean myFixWholeHierarchy;
    private final String myName;
    private final String myCanonicalText;

    public MethodReturnTypeFix(@NotNull PsiMethod method, @NotNull PsiType returnType, boolean fixWholeHierarchy) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "<init>"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "<init>"));
        }
        super((PsiElement)method);
        this.myReturnTypePointer = SmartTypePointerManager.getInstance((Project)method.getProject()).createSmartTypePointer(returnType);
        this.myFixWholeHierarchy = fixWholeHierarchy;
        this.myName = method.getName();
        this.myCanonicalText = returnType.getCanonicalText();
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("fix.return.type.text", this.myName, this.myCanonicalText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.return.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "isAvailable"));
        }
        PsiMethod myMethod = (PsiMethod)startElement;
        PsiType myReturnType = this.myReturnTypePointer.getType();
        return myMethod.isValid() && myMethod.getManager().isInProject((PsiElement)myMethod) && myReturnType != null && myReturnType.isValid() && !TypeConversionUtil.isNullType((PsiType)myReturnType) && myMethod.getReturnType() != null && !Comparing.equal((Object)myReturnType, (Object)myMethod.getReturnType());
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Editor editorForMethod;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "invoke"));
        }
        PsiMethod myMethod = (PsiMethod)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(myMethod.getContainingFile())) {
            return;
        }
        PsiType myReturnType = this.myReturnTypePointer.getType();
        if (myReturnType == null) {
            return;
        }
        if (this.myFixWholeHierarchy) {
            PsiType superReturnType;
            PsiMethod superMethod = myMethod.findDeepestSuperMethod();
            PsiType psiType = superReturnType = superMethod == null ? null : superMethod.getReturnType();
            if (superReturnType != null && !Comparing.equal((Object)myReturnType, (Object)superReturnType) && !MethodReturnTypeFix.changeClassTypeArgument(myMethod, project, superReturnType, superMethod.getContainingClass(), editor, myReturnType)) {
                return;
            }
        }
        List<PsiMethod> affectedMethods = this.changeReturnType(myMethod, myReturnType);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiReturnStatement statementToSelect = null;
        if (!PsiType.VOID.equals((Object)myReturnType)) {
            ReturnStatementAdder adder = new ReturnStatementAdder(factory, myReturnType);
            for (PsiMethod affectedMethod : affectedMethods) {
                PsiReturnStatement statement = adder.addReturnForMethod(file, affectedMethod);
                if (statement == null || affectedMethod != myMethod) continue;
                statementToSelect = statement;
            }
        }
        if (statementToSelect != null && (editorForMethod = MethodReturnTypeFix.getEditorForMethod(myMethod, project, editor, statementToSelect.getContainingFile())) != null) {
            MethodReturnTypeFix.selectReturnValueInEditor(statementToSelect, editorForMethod);
        }
    }

    private static Editor getEditorForMethod(PsiMethod myMethod, @NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "getEditorForMethod"));
        }
        PsiFile containingFile = myMethod.getContainingFile();
        if (containingFile != file) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, containingFile.getVirtualFile());
            return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        }
        return editor;
    }

    @Nullable
    private PsiMethod[] getChangeRoots(PsiMethod method, @NotNull PsiType returnType) {
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "getChangeRoots"));
        }
        if (!this.myFixWholeHierarchy) {
            return new PsiMethod[]{method};
        }
        PsiMethod[] methods = method.findDeepestSuperMethods();
        if (methods.length > 0) {
            for (PsiMethod psiMethod : methods) {
                if (!returnType.equals(psiMethod.getReturnType())) continue;
                return new PsiMethod[]{method};
            }
            return methods;
        }
        return new PsiMethod[]{method};
    }

    @NotNull
    private List<PsiMethod> changeReturnType(PsiMethod method, @NotNull PsiType returnType) {
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "changeReturnType"));
        }
        PsiMethod[] methods = this.getChangeRoots(method, returnType);
        if (methods == null) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "changeReturnType"));
            }
            return list;
        }
        MethodSignatureChangeVisitor methodSignatureChangeVisitor = new MethodSignatureChangeVisitor();
        for (PsiMethod targetMethod : methods) {
            methodSignatureChangeVisitor.addBase(targetMethod);
            UsagesAwareChangeSignatureProcessor processor = new UsagesAwareChangeSignatureProcessor(method.getProject(), targetMethod, false, null, this.myName, returnType, RemoveUnusedParameterFix.getNewParametersInfo(targetMethod, null), methodSignatureChangeVisitor);
            processor.run();
        }
        List<PsiMethod> list = methodSignatureChangeVisitor.getAffectedMethods();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix", "changeReturnType"));
        }
        return list;
    }

    static void selectReturnValueInEditor(PsiReturnStatement returnStatement, Editor editor) {
        TextRange range = returnStatement.getReturnValue().getTextRange();
        int offset = range.getStartOffset();
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().setSelection(range.getEndOffset(), range.getStartOffset());
    }

    private static boolean changeClassTypeArgument(PsiMethod myMethod, Project project, PsiType superReturnType, PsiClass superClass, Editor editor, PsiType returnType) {
        if (superClass == null || !superClass.hasTypeParameters()) {
            return true;
        }
        PsiClass superReturnTypeClass = PsiUtil.resolveClassInType((PsiType)superReturnType);
        if (superReturnTypeClass == null || !(superReturnTypeClass instanceof PsiTypeParameter) && !superReturnTypeClass.hasTypeParameters()) {
            return true;
        }
        PsiClass derivedClass = myMethod.getContainingClass();
        if (derivedClass == null) {
            return true;
        }
        PsiReferenceParameterList referenceParameterList = MethodReturnTypeFix.findTypeArgumentsList(superClass, derivedClass);
        if (referenceParameterList == null) {
            return true;
        }
        PsiElement resolve = ((PsiJavaCodeReferenceElement)referenceParameterList.getParent()).resolve();
        if (!(resolve instanceof PsiClass)) {
            return true;
        }
        PsiClass baseClass = (PsiClass)resolve;
        if (returnType instanceof PsiPrimitiveType) {
            returnType = ((PsiPrimitiveType)returnType).getBoxedType((PsiElement)derivedClass);
        }
        PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)baseClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        PsiType superReturnTypeInBaseClassType = superClassSubstitutor.substitute(superReturnType);
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)project).getResolveHelper();
        PsiSubstitutor psiSubstitutor = resolveHelper.inferTypeArguments(baseClass.getTypeParameters(), new PsiType[]{superReturnTypeInBaseClassType}, new PsiType[]{returnType}, PsiUtil.getLanguageLevel((PsiElement)superClass));
        TypeMigrationRules rules = new TypeMigrationRules(TypeMigrationLabeler.getElementType((PsiElement)derivedClass));
        PsiSubstitutor compoundSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)derivedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY).putAll(psiSubstitutor);
        rules.setMigrationRootType((PsiType)JavaPsiFacade.getElementFactory((Project)project).createType(baseClass, compoundSubstitutor));
        rules.setBoundScope((SearchScope)new LocalSearchScope((PsiElement)derivedClass));
        TypeMigrationProcessor.runHighlightingTypeMigration(project, editor, rules, (PsiElement)referenceParameterList);
        return false;
    }

    @Nullable
    private static PsiReferenceParameterList findTypeArgumentsList(PsiClass superClass, PsiClass derivedClass) {
        PsiReferenceParameterList referenceParameterList = null;
        if (derivedClass instanceof PsiAnonymousClass) {
            referenceParameterList = ((PsiAnonymousClass)derivedClass).getBaseClassReference().getParameterList();
        } else {
            PsiReferenceList extendsList;
            PsiReferenceList implementsList = derivedClass.getImplementsList();
            if (implementsList != null) {
                referenceParameterList = MethodReturnTypeFix.extractReferenceParameterList(superClass, implementsList);
            }
            if (referenceParameterList == null && (extendsList = derivedClass.getExtendsList()) != null) {
                referenceParameterList = MethodReturnTypeFix.extractReferenceParameterList(superClass, extendsList);
            }
        }
        return referenceParameterList;
    }

    @Nullable
    private static PsiReferenceParameterList extractReferenceParameterList(PsiClass superClass, PsiReferenceList extendsList) {
        for (PsiJavaCodeReferenceElement referenceElement : extendsList.getReferenceElements()) {
            PsiElement element = referenceElement.resolve();
            if (!(element instanceof PsiClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)element), (PsiClass)superClass, (boolean)true)) continue;
            return referenceElement.getParameterList();
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static class UsagesAwareChangeSignatureProcessor
    extends ChangeSignatureProcessor {
        private final UsageVisitor myUsageVisitor;

        private UsagesAwareChangeSignatureProcessor(Project project, PsiMethod method, boolean generateDelegate, @PsiModifier.ModifierConstant String newVisibility, String newName, PsiType newType, @NotNull ParameterInfoImpl[] parameterInfo, UsageVisitor usageVisitor) {
            if (parameterInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterInfo", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix$UsagesAwareChangeSignatureProcessor", "<init>"));
            }
            super(project, method, generateDelegate, newVisibility, newName, newType, parameterInfo);
            this.myUsageVisitor = usageVisitor;
        }

        @Override
        protected void preprocessCovariantOverriders(List<UsageInfo> covariantOverriderInfos) {
            this.myUsageVisitor.preprocessCovariantOverriders(covariantOverriderInfos);
        }

        @Override
        protected void performRefactoring(UsageInfo[] usages) {
            super.performRefactoring(usages);
            for (UsageInfo usage : usages) {
                this.myUsageVisitor.visit(usage);
            }
        }
    }

    private static interface UsageVisitor {
        public void visit(UsageInfo var1);

        public void preprocessCovariantOverriders(List<UsageInfo> var1);
    }

    private static class MethodSignatureChangeVisitor
    implements UsageVisitor {
        private final List<PsiMethod> myAffectedMethods = new ArrayList<PsiMethod>();

        private MethodSignatureChangeVisitor() {
        }

        public void addBase(PsiMethod baseMethod) {
            this.myAffectedMethods.add(baseMethod);
        }

        @Override
        public void visit(UsageInfo usage) {
            if (usage instanceof OverriderUsageInfo) {
                this.myAffectedMethods.add(((OverriderUsageInfo)usage).getOverridingMethod());
            }
        }

        public List<PsiMethod> getAffectedMethods() {
            return this.myAffectedMethods;
        }

        @Override
        public void preprocessCovariantOverriders(List<UsageInfo> covariantOverriderInfos) {
            Iterator<UsageInfo> usageInfoIterator = covariantOverriderInfos.iterator();
            while (usageInfoIterator.hasNext()) {
                OverriderUsageInfo overrideUsage;
                UsageInfo info = usageInfoIterator.next();
                if (!(info instanceof OverriderUsageInfo) || !this.myAffectedMethods.contains((overrideUsage = (OverriderUsageInfo)info).getOverridingMethod())) continue;
                usageInfoIterator.remove();
            }
        }
    }

    private static class ReturnStatementAdder {
        private final PsiElementFactory factory;
        private final PsiType myTargetType;

        private ReturnStatementAdder(@NotNull PsiElementFactory factory, @NotNull PsiType targetType) {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix$ReturnStatementAdder", "<init>"));
            }
            if (targetType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "com/intellij/codeInsight/daemon/impl/quickfix/MethodReturnTypeFix$ReturnStatementAdder", "<init>"));
            }
            this.factory = factory;
            this.myTargetType = targetType;
        }

        public PsiReturnStatement addReturnForMethod(PsiFile file, PsiMethod method) {
            PsiModifierList modifiers = method.getModifierList();
            if (modifiers.hasModifierProperty("abstract") || method.getBody() == null) {
                return null;
            }
            try {
                ControlFlow controlFlow;
                ConvertReturnStatementsVisitor visitor = new ConvertReturnStatementsVisitor(this.factory, method, this.myTargetType);
                try {
                    controlFlow = HighlightControlFlowUtil.getControlFlowNoConstantEvaluate((PsiElement)method.getBody());
                }
                catch (AnalysisCanceledException e) {
                    return null;
                }
                PsiReturnStatement returnStatement = controlFlow != null && ControlFlowUtil.processReturns(controlFlow, visitor) ? visitor.getLatestReturn() : visitor.createReturnInLastStatement();
                if (method.getContainingFile() != file) {
                    UndoUtil.markPsiFileForUndo((PsiFile)file);
                }
                return returnStatement;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
    }
}

