/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import java.util.Collection;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public abstract class HtmlUnknownElementInspection
extends HtmlLocalInspectionTool
implements XmlEntitiesInspection {
    public JDOMExternalizableStringList myValues;
    public boolean myCustomValuesEnabled;

    public HtmlUnknownElementInspection(@NotNull String defaultValues) {
        if (defaultValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValues", "com/intellij/codeInspection/htmlInspections/HtmlUnknownElementInspection", "<init>"));
        }
        this.myCustomValuesEnabled = true;
        this.myValues = HtmlUnknownElementInspection.reparseProperties(defaultValues);
    }

    protected static JDOMExternalizableStringList reparseProperties(@NotNull String properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/codeInspection/htmlInspections/HtmlUnknownElementInspection", "reparseProperties"));
        }
        JDOMExternalizableStringList result = new JDOMExternalizableStringList();
        StringTokenizer tokenizer = new StringTokenizer(properties, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add((Object)tokenizer.nextToken().toLowerCase().trim());
        }
        return result;
    }

    protected static void registerProblemOnAttributeName(@NotNull XmlAttribute attribute, String message, @NotNull ProblemsHolder holder, LocalQuickFix ... quickfixes) {
        PsiElement nameElement;
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/codeInspection/htmlInspections/HtmlUnknownElementInspection", "registerProblemOnAttributeName"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/htmlInspections/HtmlUnknownElementInspection", "registerProblemOnAttributeName"));
        }
        ASTNode node = attribute.getNode();
        assert (node != null);
        ASTNode nameNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(node);
        if (nameNode != null && (nameElement = nameNode.getPsi()).getTextLength() > 0) {
            holder.registerProblem(nameElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, quickfixes);
        }
    }

    protected boolean isCustomValue(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/htmlInspections/HtmlUnknownElementInspection", "isCustomValue"));
        }
        return this.myValues.contains((Object)value.toLowerCase());
    }

    @Override
    public void addEntry(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInspection/htmlInspections/HtmlUnknownElementInspection", "addEntry"));
        }
        String s = text.trim().toLowerCase();
        if (!this.isCustomValue(s)) {
            this.myValues.add((Object)s);
        }
        if (!this.isCustomValuesEnabled()) {
            this.myCustomValuesEnabled = true;
        }
    }

    public boolean isCustomValuesEnabled() {
        return this.myCustomValuesEnabled;
    }

    @Override
    public String getAdditionalEntries() {
        return StringUtil.join((Collection)this.myValues, (String)",");
    }

    public void enableCustomValues(boolean customValuesEnabled) {
        this.myCustomValuesEnabled = customValuesEnabled;
    }

    public void updateAdditionalEntries(@NotNull String values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/codeInspection/htmlInspections/HtmlUnknownElementInspection", "updateAdditionalEntries"));
        }
        this.myValues = HtmlUnknownElementInspection.reparseProperties(values);
    }

    protected abstract String getCheckboxTitle();

    @NotNull
    protected abstract String getPanelTitle();

    @NotNull
    protected abstract Logger getLogger();
}

