/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.DebuggerEditorImpl;
import com.intellij.debugger.ui.impl.ValueNodeDnD;
import com.intellij.debugger.ui.impl.WatchDebuggerTree;
import com.intellij.debugger.ui.impl.WatchPanel;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XDebuggerBundle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.Nullable;

public abstract class EvaluationDialog
extends DialogWrapper {
    private final MyEvaluationPanel myEvaluationPanel;
    private final Project myProject;
    private final DebuggerContextListener myContextListener;
    private final DebuggerEditorImpl myEditor;
    private final List<Runnable> myDisposeRunnables = new ArrayList<Runnable>();

    public EvaluationDialog(Project project, TextWithImports text) {
        super(project, true);
        this.myProject = project;
        this.setModal(false);
        this.setCancelButtonText(CommonBundle.message((String)"button.close", (Object[])new Object[0]));
        this.setOKButtonText(DebuggerBundle.message((String)"button.evaluate", (Object[])new Object[0]));
        this.myEvaluationPanel = new MyEvaluationPanel(this.myProject);
        this.myEditor = this.createEditor(DefaultCodeFragmentFactory.getInstance());
        this.setDebuggerContext(this.getDebuggerContext());
        this.initDialogData(text);
        this.myContextListener = new DebuggerContextListener(){

            @Override
            public void changeEvent(DebuggerContextImpl newContext, int event) {
                boolean close = true;
                for (DebuggerSession session : DebuggerManagerEx.getInstanceEx(EvaluationDialog.this.myProject).getSessions()) {
                    if (session.isStopped()) continue;
                    close = false;
                    break;
                }
                if (close) {
                    EvaluationDialog.this.close(1);
                } else {
                    EvaluationDialog.this.setDebuggerContext(newContext);
                }
            }
        };
        DebuggerManagerEx.getInstanceEx(this.myProject).getContextManager().addListener(this.myContextListener);
        this.setHorizontalStretch(1.0f);
        this.setVerticalStretch(1.0f);
    }

    protected void doOKAction() {
        if (this.isOKActionEnabled()) {
            this.doEvaluate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doEvaluate() {
        if (this.myEditor == null || this.myEvaluationPanel == null) {
            return;
        }
        this.myEvaluationPanel.clear();
        TextWithImports codeToEvaluate = this.getCodeToEvaluate();
        if (codeToEvaluate == null) {
            return;
        }
        try {
            this.setOKActionEnabled(false);
            NodeDescriptorImpl descriptor = this.myEvaluationPanel.getWatchTree().addWatch(codeToEvaluate, "result").getDescriptor();
            this.myEvaluationPanel.getWatchTree().rebuild(this.getDebuggerContext());
            descriptor.myIsExpanded = true;
        }
        finally {
            this.setOKActionEnabled(true);
        }
        this.getEditor().addRecent(this.getCodeToEvaluate());
        DebuggerSession session = this.myEvaluationPanel.getContextManager().getContext().getDebuggerSession();
        if (session != null) {
            session.refresh(true);
        }
    }

    @Nullable
    protected TextWithImports getCodeToEvaluate() {
        TextWithImports text = this.getEditor().getText();
        String s = text.getText();
        if (s != null) {
            s = s.trim();
        }
        if ("".equals(s)) {
            return null;
        }
        return text;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.debugger.ui.EvaluationDialog2";
    }

    protected void addDisposeRunnable(Runnable runnable) {
        this.myDisposeRunnables.add(runnable);
    }

    public void dispose() {
        for (Runnable runnable : this.myDisposeRunnables) {
            runnable.run();
        }
        this.myDisposeRunnables.clear();
        this.myEditor.dispose();
        DebuggerManagerEx.getInstanceEx(this.myProject).getContextManager().removeListener(this.myContextListener);
        this.myEvaluationPanel.dispose();
        super.dispose();
    }

    protected void setDebuggerContext(DebuggerContextImpl context) {
        PsiElement contextElement = PositionUtil.getContextElement((StackFrameContext)context);
        this.myEditor.setContext(contextElement);
    }

    protected PsiElement getContext() {
        return this.myEditor.getContext();
    }

    protected void initDialogData(TextWithImports text) {
        this.getEditor().setText(text);
        this.myEvaluationPanel.clear();
    }

    public DebuggerContextImpl getDebuggerContext() {
        return DebuggerManagerEx.getInstanceEx(this.myProject).getContext();
    }

    public DebuggerEditorImpl getEditor() {
        return this.myEditor;
    }

    protected abstract DebuggerEditorImpl createEditor(CodeFragmentFactory var1);

    protected MyEvaluationPanel getEvaluationPanel() {
        return this.myEvaluationPanel;
    }

    public Project getProject() {
        return this.myProject;
    }

    protected class MyEvaluationPanel
    extends WatchPanel {
        public MyEvaluationPanel(Project project) {
            super(project, DebuggerManagerEx.getInstanceEx(project).getContextManager());
            final WatchDebuggerTree watchTree = this.getWatchTree();
            final AnAction setValueAction = ActionManager.getInstance().getAction("Debugger.SetValue");
            setValueAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)), (JComponent)((Object)watchTree));
            this.registerDisposable(new Disposable(){

                public void dispose() {
                    setValueAction.unregisterCustomShortcutSet((JComponent)((Object)watchTree));
                }
            });
            this.setUpdateEnabled(true);
            this.getTree().getEmptyText().setText(XDebuggerBundle.message((String)"debugger.no.results", (Object[])new Object[0]));
            new ValueNodeDnD(this.myTree, (Disposable)project);
        }

        @Override
        protected ActionPopupMenu createPopupMenu() {
            ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Debugger.EvaluationDialogPopup");
            return ActionManager.getInstance().createActionPopupMenu("Debugger.EvaluationDialogPopup", group);
        }

        @Override
        protected void changeEvent(DebuggerContextImpl newContext, int event) {
            if (event == 7 || event == 11) {
                TreeModel treeModel = this.getTree().getModel();
                this.updateTree(treeModel, (DebuggerTreeNodeImpl)treeModel.getRoot());
            }
        }

        private void updateTree(TreeModel model, DebuggerTreeNodeImpl node) {
            if (node == null) {
                return;
            }
            if (node.getDescriptor().myIsExpanded) {
                int count = model.getChildCount(node);
                for (int idx = 0; idx < count; ++idx) {
                    DebuggerTreeNodeImpl child = (DebuggerTreeNodeImpl)model.getChild(node, idx);
                    this.updateTree(model, child);
                }
            }
            node.labelChanged();
        }
    }
}

