/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.JavaMarkObjectActionHandler;
import com.intellij.debugger.actions.JvmSmartStepIntoActionHandler;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.XBreakpointGroupingByClassRule;
import com.intellij.debugger.ui.XBreakpointGroupingByPackageRule;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.xdebugger.AbstractDebuggerSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.DebuggerToggleActionHandler;
import com.intellij.xdebugger.impl.actions.EditBreakpointActionHandler;
import com.intellij.xdebugger.impl.actions.MarkObjectActionHandler;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.Point;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class JavaDebuggerSupport
extends DebuggerSupport {
    private final JavaBreakpointPanelProvider myBreakpointPanelProvider = new JavaBreakpointPanelProvider();
    private final DebuggerActionHandler mySmartStepIntoHandler = new JvmSmartStepIntoActionHandler();
    private final JavaMarkObjectActionHandler myMarkObjectActionHandler = new JavaMarkObjectActionHandler();
    private static final DebuggerToggleActionHandler DISABLED_TOGGLE_HANDLER = new DebuggerToggleActionHandler(){

        @Override
        public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/JavaDebuggerSupport$1", "isEnabled"));
            }
            return false;
        }

        @Override
        public boolean isSelected(@NotNull Project project, AnActionEvent event) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/JavaDebuggerSupport$1", "isSelected"));
            }
            return false;
        }

        @Override
        public void setSelected(@NotNull Project project, AnActionEvent event, boolean state) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/JavaDebuggerSupport$1", "setSelected"));
            }
        }
    };
    private static final EditBreakpointActionHandler X_EDIT = new EditBreakpointActionHandler(){

        @Override
        protected void doShowPopup(Project project, JComponent component, Point whereToShow, Object breakpoint) {
            DebuggerUIUtil.showXBreakpointEditorBalloon(project, whereToShow, component, false, (XBreakpoint)breakpoint);
        }

        @Override
        public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/JavaDebuggerSupport$2", "isEnabled"));
            }
            return false;
        }
    };

    @Override
    @NotNull
    public BreakpointPanelProvider<?> getBreakpointPanelProvider() {
        JavaBreakpointPanelProvider javaBreakpointPanelProvider = this.myBreakpointPanelProvider;
        if (javaBreakpointPanelProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getBreakpointPanelProvider"));
        }
        return javaBreakpointPanelProvider;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getStepOverHandler() {
        DebuggerSupport.DisabledActionHandler disabledActionHandler = DebuggerSupport.DisabledActionHandler.INSTANCE;
        if (disabledActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getStepOverHandler"));
        }
        return disabledActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getStepIntoHandler() {
        DebuggerSupport.DisabledActionHandler disabledActionHandler = DebuggerSupport.DisabledActionHandler.INSTANCE;
        if (disabledActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getStepIntoHandler"));
        }
        return disabledActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getSmartStepIntoHandler() {
        DebuggerActionHandler debuggerActionHandler = this.mySmartStepIntoHandler;
        if (debuggerActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getSmartStepIntoHandler"));
        }
        return debuggerActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getStepOutHandler() {
        DebuggerSupport.DisabledActionHandler disabledActionHandler = DebuggerSupport.DisabledActionHandler.INSTANCE;
        if (disabledActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getStepOutHandler"));
        }
        return disabledActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getForceStepOverHandler() {
        DebuggerSupport.DisabledActionHandler disabledActionHandler = DebuggerSupport.DisabledActionHandler.INSTANCE;
        if (disabledActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getForceStepOverHandler"));
        }
        return disabledActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getForceStepIntoHandler() {
        DebuggerSupport.DisabledActionHandler disabledActionHandler = DebuggerSupport.DisabledActionHandler.INSTANCE;
        if (disabledActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getForceStepIntoHandler"));
        }
        return disabledActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getRunToCursorHandler() {
        DebuggerSupport.DisabledActionHandler disabledActionHandler = DebuggerSupport.DisabledActionHandler.INSTANCE;
        if (disabledActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getRunToCursorHandler"));
        }
        return disabledActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getForceRunToCursorHandler() {
        DebuggerSupport.DisabledActionHandler disabledActionHandler = DebuggerSupport.DisabledActionHandler.INSTANCE;
        if (disabledActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getForceRunToCursorHandler"));
        }
        return disabledActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getResumeActionHandler() {
        DebuggerSupport.DisabledActionHandler disabledActionHandler = DebuggerSupport.DisabledActionHandler.INSTANCE;
        if (disabledActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getResumeActionHandler"));
        }
        return disabledActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getPauseHandler() {
        DebuggerSupport.DisabledActionHandler disabledActionHandler = DebuggerSupport.DisabledActionHandler.INSTANCE;
        if (disabledActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getPauseHandler"));
        }
        return disabledActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getToggleLineBreakpointHandler() {
        DebuggerSupport.DisabledActionHandler disabledActionHandler = DebuggerSupport.DisabledActionHandler.INSTANCE;
        if (disabledActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getToggleLineBreakpointHandler"));
        }
        return disabledActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getToggleTemporaryLineBreakpointHandler() {
        DebuggerSupport.DisabledActionHandler disabledActionHandler = DebuggerSupport.DisabledActionHandler.INSTANCE;
        if (disabledActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getToggleTemporaryLineBreakpointHandler"));
        }
        return disabledActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getShowExecutionPointHandler() {
        DebuggerSupport.DisabledActionHandler disabledActionHandler = DebuggerSupport.DisabledActionHandler.INSTANCE;
        if (disabledActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getShowExecutionPointHandler"));
        }
        return disabledActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getEvaluateHandler() {
        DebuggerSupport.DisabledActionHandler disabledActionHandler = DebuggerSupport.DisabledActionHandler.INSTANCE;
        if (disabledActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getEvaluateHandler"));
        }
        return disabledActionHandler;
    }

    @Override
    @NotNull
    public DebuggerActionHandler getAddToWatchesActionHandler() {
        DebuggerSupport.DisabledActionHandler disabledActionHandler = DebuggerSupport.DisabledActionHandler.INSTANCE;
        if (disabledActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getAddToWatchesActionHandler"));
        }
        return disabledActionHandler;
    }

    @Override
    @NotNull
    public DebuggerToggleActionHandler getMuteBreakpointsHandler() {
        DebuggerToggleActionHandler debuggerToggleActionHandler = DISABLED_TOGGLE_HANDLER;
        if (debuggerToggleActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getMuteBreakpointsHandler"));
        }
        return debuggerToggleActionHandler;
    }

    @Override
    @NotNull
    public MarkObjectActionHandler getMarkObjectHandler() {
        JavaMarkObjectActionHandler javaMarkObjectActionHandler = this.myMarkObjectActionHandler;
        if (javaMarkObjectActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getMarkObjectHandler"));
        }
        return javaMarkObjectActionHandler;
    }

    @Override
    public AbstractDebuggerSession getCurrentSession(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/JavaDebuggerSupport", "getCurrentSession"));
        }
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project).getContext();
        return context != null ? context.getDebuggerSession() : null;
    }

    @Override
    @NotNull
    public EditBreakpointActionHandler getEditBreakpointAction() {
        EditBreakpointActionHandler editBreakpointActionHandler = X_EDIT;
        if (editBreakpointActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/JavaDebuggerSupport", "getEditBreakpointAction"));
        }
        return editBreakpointActionHandler;
    }

    public static Project getContextProjectForEditorFieldsInDebuggerConfigurables() {
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        if (project != null) {
            return project;
        }
        return ProjectManager.getInstance().getDefaultProject();
    }

    private static class JavaBreakpointPanelProvider
    extends BreakpointPanelProvider<Breakpoint> {
        private JavaBreakpointPanelProvider() {
        }

        @Override
        public void createBreakpointsGroupingRules(Collection<XBreakpointGroupingRule> rules) {
            rules.add(new XBreakpointGroupingByPackageRule());
            rules.add(new XBreakpointGroupingByClassRule());
        }

        @Override
        public void addListener(BreakpointPanelProvider.BreakpointsListener listener, Project project, Disposable disposable) {
        }

        @Override
        protected void removeListener(BreakpointPanelProvider.BreakpointsListener listener) {
        }

        @Override
        public int getPriority() {
            return 100;
        }

        @Override
        public Breakpoint findBreakpoint(@NotNull Project project, @NotNull Document document, int offset) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/JavaDebuggerSupport$JavaBreakpointPanelProvider", "findBreakpoint"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/debugger/ui/JavaDebuggerSupport$JavaBreakpointPanelProvider", "findBreakpoint"));
            }
            return null;
        }

        @Override
        public GutterIconRenderer getBreakpointGutterIconRenderer(Object breakpoint) {
            return null;
        }

        @Override
        public void onDialogClosed(Project project) {
        }

        @Override
        public void provideBreakpointItems(Project project, Collection<BreakpointItem> items) {
        }
    }
}

