/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.StringProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ExternalDiffSettings", storages={@Storage(file="$APP_CONFIG$/diff.xml")})
public class ExternalDiffSettings
implements PersistentStateComponent<State> {
    private State myState = new State();

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public static ExternalDiffSettings getInstance() {
        return (ExternalDiffSettings)ServiceManager.getService(ExternalDiffSettings.class);
    }

    @NotNull
    private static AbstractProperty.AbstractPropertyContainer getProperties() {
        AbstractProperty.AbstractPropertyContainer abstractPropertyContainer = DiffManagerImpl.getInstanceEx().getProperties();
        if (abstractPropertyContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffSettings", "getProperties"));
        }
        return abstractPropertyContainer;
    }

    @NotNull
    private static String getProperty(@Nullable StringProperty oldProperty, @Nullable String newValue, @NotNull String defaultValue) {
        String oldValue;
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/diff/tools/external/ExternalDiffSettings", "getProperty"));
        }
        if (newValue != null) {
            String string = newValue;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffSettings", "getProperty"));
            }
            return string;
        }
        if (oldProperty != null && !StringUtil.isEmptyOrSpaces((String)(oldValue = (String)oldProperty.get(ExternalDiffSettings.getProperties())))) {
            String string = oldValue;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffSettings", "getProperty"));
            }
            return string;
        }
        String string = defaultValue;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffSettings", "getProperty"));
        }
        return string;
    }

    private static boolean getProperty(@Nullable BooleanProperty oldProperty, @Nullable Boolean newValue, boolean defaultValue) {
        if (newValue != null) {
            return newValue;
        }
        if (oldProperty != null) {
            return oldProperty.value(ExternalDiffSettings.getProperties());
        }
        return defaultValue;
    }

    private static void setProperty(@Nullable StringProperty oldProperty, @NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/diff/tools/external/ExternalDiffSettings", "setProperty"));
        }
        if (oldProperty != null) {
            oldProperty.set(ExternalDiffSettings.getProperties(), (Object)value);
        }
    }

    private static void setProperty(@Nullable BooleanProperty oldProperty, boolean value) {
        if (oldProperty != null) {
            oldProperty.set(ExternalDiffSettings.getProperties(), (Object)value);
        }
    }

    public boolean isDiffEnabled() {
        return ExternalDiffSettings.getProperty(DiffManagerImpl.ENABLE_FILES, this.myState.DIFF_ENABLED, false);
    }

    public void setDiffEnabled(boolean value) {
        this.myState.DIFF_ENABLED = value;
    }

    public boolean isDiffDefault() {
        return ExternalDiffSettings.getProperty(DiffManagerImpl.ENABLE_FILES, this.myState.DIFF_DEFAULT, false);
    }

    public void setDiffDefault(boolean value) {
        this.myState.DIFF_DEFAULT = value;
        ExternalDiffSettings.setProperty(DiffManagerImpl.ENABLE_FILES, value);
    }

    @NotNull
    public String getDiffExePath() {
        String string = ExternalDiffSettings.getProperty(DiffManagerImpl.FILES_TOOL, this.myState.DIFF_EXE_PATH, "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffSettings", "getDiffExePath"));
        }
        return string;
    }

    public void setDiffExePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/tools/external/ExternalDiffSettings", "setDiffExePath"));
        }
        this.myState.DIFF_EXE_PATH = path;
        ExternalDiffSettings.setProperty(DiffManagerImpl.FILES_TOOL, path);
    }

    @NotNull
    public String getDiffParameters() {
        String string = ExternalDiffSettings.getProperty(null, this.myState.DIFF_PARAMETERS, "%1 %2 %3");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffSettings", "getDiffParameters"));
        }
        return string;
    }

    public void setDiffParameters(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/tools/external/ExternalDiffSettings", "setDiffParameters"));
        }
        this.myState.DIFF_PARAMETERS = path;
    }

    public boolean isMergeEnabled() {
        return ExternalDiffSettings.getProperty(DiffManagerImpl.ENABLE_MERGE, this.myState.MERGE_ENABLED, false);
    }

    public void setMergeEnabled(boolean value) {
        this.myState.MERGE_ENABLED = value;
        ExternalDiffSettings.setProperty(DiffManagerImpl.ENABLE_MERGE, value);
    }

    @NotNull
    public String getMergeExePath() {
        String string = ExternalDiffSettings.getProperty(DiffManagerImpl.MERGE_TOOL, this.myState.MERGE_EXE_PATH, "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffSettings", "getMergeExePath"));
        }
        return string;
    }

    public void setMergeExePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/tools/external/ExternalDiffSettings", "setMergeExePath"));
        }
        this.myState.MERGE_EXE_PATH = path;
        ExternalDiffSettings.setProperty(DiffManagerImpl.MERGE_TOOL, path);
    }

    @NotNull
    public String getMergeParameters() {
        String string = ExternalDiffSettings.getProperty(DiffManagerImpl.MERGE_TOOL_PARAMETERS, this.myState.MERGE_PARAMETERS, "%1 %2 %3 %4");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffSettings", "getMergeParameters"));
        }
        return string;
    }

    public void setMergeParameters(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/tools/external/ExternalDiffSettings", "setMergeParameters"));
        }
        this.myState.MERGE_PARAMETERS = path;
        ExternalDiffSettings.setProperty(DiffManagerImpl.MERGE_TOOL_PARAMETERS, path);
    }

    public static class State {
        @Nullable
        public Boolean DIFF_ENABLED = null;
        @Nullable
        public Boolean DIFF_DEFAULT = null;
        @Nullable
        public String DIFF_EXE_PATH = null;
        @Nullable
        public String DIFF_PARAMETERS = null;
        @Nullable
        public Boolean MERGE_ENABLED = null;
        @Nullable
        public String MERGE_EXE_PATH = null;
        @Nullable
        public String MERGE_PARAMETERS = null;
    }
}

