/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.MergeUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleThreesideDiffChange;
import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerBase;
import com.intellij.diff.tools.util.threeside.ThreesideTextDiffViewer;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleThreesideDiffViewer
extends ThreesideTextDiffViewer {
    public static final Logger LOG = Logger.getInstance(SimpleThreesideDiffViewer.class);
    @NotNull
    private final SyncScrollSupport.SyncScrollable mySyncScrollable1;
    @NotNull
    private final SyncScrollSupport.SyncScrollable mySyncScrollable2;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final MyStatusPanel myStatusPanel;
    @NotNull
    private final List<SimpleThreesideDiffChange> myDiffChanges;
    @NotNull
    private final List<SimpleThreesideDiffChange> myInvalidDiffChanges;
    @NotNull
    private final MyFoldingModel myFoldingModel;

    public SimpleThreesideDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "<init>"));
        }
        super(context, (ContentDiffRequest)request);
        this.myDiffChanges = new ArrayList<SimpleThreesideDiffChange>();
        this.myInvalidDiffChanges = new ArrayList<SimpleThreesideDiffChange>();
        this.mySyncScrollable1 = new MySyncScrollable(Side.LEFT);
        this.mySyncScrollable2 = new MySyncScrollable(Side.RIGHT);
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myFoldingModel = new MyFoldingModel(this.myEditors.toArray(new EditorEx[3]), (Disposable)this);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myContentPanel.setPainter(new MyDividerPainter(Side.LEFT), Side.LEFT);
        this.myContentPanel.setPainter(new MyDividerPainter(Side.RIGHT), Side.RIGHT);
        this.myContentPanel.setScrollbarPainter(new MyScrollbarPainter());
    }

    @Override
    protected void onDisposeAwt() {
        this.destroyChangedBlocks();
        super.onDisposeAwt();
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new MyIgnorePolicySettingAction());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)new TextDiffViewerBase.ToggleAutoScrollAction(this));
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new ThreesideTextDiffViewer.ShowLeftBasePartialDiffAction(this));
        group.add((AnAction)new ThreesideTextDiffViewer.ShowBaseRightPartialDiffAction(this));
        group.add((AnAction)new ThreesideTextDiffViewer.ShowLeftRightPartialDiffAction(this));
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "createToolbarActions"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyIgnorePolicySettingAction().getPopupGroup());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new TextDiffViewerBase.ToggleAutoScrollAction(this));
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        return group;
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getTextSettings().isExpandByDefault());
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
        }
        try {
            indicator.checkCanceled();
            List contents = this.myRequest.getContents();
            final Document[] documents = new Document[]{((DocumentContent)contents.get(0)).getDocument(), ((DocumentContent)contents.get(1)).getDocument(), ((DocumentContent)contents.get(2)).getDocument()};
            DocumentData data = (DocumentData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<DocumentData>(){

                public DocumentData compute() {
                    CharSequence[] sequences = new CharSequence[]{documents[0].getImmutableCharSequence(), documents[1].getImmutableCharSequence(), documents[2].getImmutableCharSequence()};
                    long[] stamps = new long[]{documents[0].getModificationStamp(), documents[1].getModificationStamp(), documents[2].getModificationStamp()};
                    return new DocumentData(stamps, sequences);
                }
            });
            CharSequence[] sequences = data.getSequences();
            ComparisonPolicy comparisonPolicy = this.getIgnorePolicy().getComparisonPolicy();
            FairDiffIterable fragments1 = ByLine.compareTwoStepFair(sequences[1], sequences[0], comparisonPolicy, indicator);
            FairDiffIterable fragments2 = ByLine.compareTwoStepFair(sequences[1], sequences[2], comparisonPolicy, indicator);
            List<MergeLineFragment> mergeFragments = MergeUtil.buildFair(fragments1, fragments2, indicator);
            runnable = this.apply(mergeFragments, data.getStamps(), comparisonPolicy);
        }
        catch (DiffTooBigException ignore) {
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    SimpleThreesideDiffViewer.this.clearDiffPresentation();
                    SimpleThreesideDiffViewer.this.myPanel.addTooBigContentNotification();
                }
            };
            if (runnable2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
            }
            return runnable2;
        }
        catch (ProcessCanceledException ignore) {
            Runnable runnable3 = new Runnable(){

                @Override
                public void run() {
                    SimpleThreesideDiffViewer.this.clearDiffPresentation();
                    SimpleThreesideDiffViewer.this.myPanel.addOperationCanceledNotification();
                }
            };
            if (runnable3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
            }
            return runnable3;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable4 = new Runnable(){

                @Override
                public void run() {
                    SimpleThreesideDiffViewer.this.clearDiffPresentation();
                    SimpleThreesideDiffViewer.this.myPanel.addDiffErrorNotification();
                }
            };
            if (runnable4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
            }
            return runnable4;
        }
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "performRediff"));
        }
        return runnable;
    }

    @NotNull
    private Runnable apply(final @NotNull List<MergeLineFragment> fragments, final @NotNull long[] stamps, final @NotNull ComparisonPolicy comparisonPolicy) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "apply"));
        }
        if (stamps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stamps", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "apply"));
        }
        if (comparisonPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparisonPolicy", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "apply"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (((EditorEx)SimpleThreesideDiffViewer.this.myEditors.get(0)).getDocument().getModificationStamp() != stamps[0]) {
                    return;
                }
                if (((EditorEx)SimpleThreesideDiffViewer.this.myEditors.get(1)).getDocument().getModificationStamp() != stamps[1]) {
                    return;
                }
                if (((EditorEx)SimpleThreesideDiffViewer.this.myEditors.get(2)).getDocument().getModificationStamp() != stamps[2]) {
                    return;
                }
                SimpleThreesideDiffViewer.this.myFoldingModel.updateContext((UserDataHolder)SimpleThreesideDiffViewer.this.myRequest, SimpleThreesideDiffViewer.this.getTextSettings().isExpandByDefault());
                SimpleThreesideDiffViewer.this.clearDiffPresentation();
                for (MergeLineFragment fragment : fragments) {
                    SimpleThreesideDiffViewer.this.myDiffChanges.add(new SimpleThreesideDiffChange(fragment, SimpleThreesideDiffViewer.this.myEditors, comparisonPolicy));
                }
                SimpleThreesideDiffViewer.this.myFoldingModel.install(fragments, (UserDataHolder)SimpleThreesideDiffViewer.this.myRequest, SimpleThreesideDiffViewer.this.getTextSettings().isExpandByDefault(), SimpleThreesideDiffViewer.this.getTextSettings().getContextRange());
                SimpleThreesideDiffViewer.this.scrollOnRediff();
                SimpleThreesideDiffViewer.this.myContentPanel.repaintDividers();
                SimpleThreesideDiffViewer.this.myStatusPanel.update();
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "apply"));
        }
        return runnable;
    }

    private void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
        this.destroyChangedBlocks();
    }

    private void destroyChangedBlocks() {
        for (SimpleThreesideDiffChange change : this.myDiffChanges) {
            change.destroyHighlighter();
        }
        this.myDiffChanges.clear();
        for (SimpleThreesideDiffChange change : this.myInvalidDiffChanges) {
            change.destroyHighlighter();
        }
        this.myInvalidDiffChanges.clear();
        this.myContentPanel.repaintDividers();
        this.myStatusPanel.update();
    }

    @Override
    protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
        ThreeSide side;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "onBeforeDocumentChange"));
        }
        super.onBeforeDocumentChange(e);
        if (this.myDiffChanges.isEmpty()) {
            return;
        }
        if (e.getDocument() == ((EditorEx)this.myEditors.get(0)).getDocument()) {
            side = ThreeSide.LEFT;
        } else if (e.getDocument() == ((EditorEx)this.myEditors.get(1)).getDocument()) {
            side = ThreeSide.BASE;
        } else if (e.getDocument() == ((EditorEx)this.myEditors.get(2)).getDocument()) {
            side = ThreeSide.RIGHT;
        } else {
            LOG.warn("Unknown document changed");
            return;
        }
        int offset1 = e.getOffset();
        int offset2 = e.getOffset() + e.getOldLength();
        if (StringUtil.endsWithChar((CharSequence)e.getOldFragment(), (char)'\n') && StringUtil.endsWithChar((CharSequence)e.getNewFragment(), (char)'\n')) {
            --offset2;
        }
        int line1 = e.getDocument().getLineNumber(offset1);
        int line2 = e.getDocument().getLineNumber(offset2) + 1;
        int shift = StringUtil.countNewLines((CharSequence)e.getNewFragment()) - StringUtil.countNewLines((CharSequence)e.getOldFragment());
        ArrayList<SimpleThreesideDiffChange> invalid = new ArrayList<SimpleThreesideDiffChange>();
        for (SimpleThreesideDiffChange change : this.myDiffChanges) {
            if (!change.processChange(line1, line2, shift, side)) continue;
            invalid.add(change);
        }
        if (!invalid.isEmpty()) {
            this.myDiffChanges.removeAll(invalid);
            this.myInvalidDiffChanges.addAll(invalid);
        }
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "onDocumentChange"));
        }
        super.onDocumentChange(e);
        this.myFoldingModel.onDocumentChanged(e);
    }

    @Override
    protected boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy) {
        SimpleThreesideDiffChange targetChange;
        if (scrollToPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollToPolicy", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "doScrollToChange"));
        }
        if (this.myDiffChanges.isEmpty()) {
            return false;
        }
        switch (scrollToPolicy) {
            case FIRST_CHANGE: {
                targetChange = this.myDiffChanges.get(0);
                break;
            }
            case LAST_CHANGE: {
                targetChange = this.myDiffChanges.get(this.myDiffChanges.size() - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException(scrollToPolicy.name());
            }
        }
        EditorEx editor = this.getCurrentEditor();
        int line = targetChange.getStartLine(this.getCurrentSide());
        DiffUtil.scrollEditor((Editor)editor, line);
        return true;
    }

    @NotNull
    private IgnorePolicy getIgnorePolicy() {
        IgnorePolicy policy = this.getTextSettings().getIgnorePolicy();
        if (policy == IgnorePolicy.IGNORE_WHITESPACES_CHUNKS) {
            IgnorePolicy ignorePolicy = IgnorePolicy.IGNORE_WHITESPACES;
            if (ignorePolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getIgnorePolicy"));
            }
            return ignorePolicy;
        }
        IgnorePolicy ignorePolicy = policy;
        if (ignorePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getIgnorePolicy"));
        }
        return ignorePolicy;
    }

    private int getCurrentStartLine(@NotNull SimpleThreesideDiffChange change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getCurrentStartLine"));
        }
        return change.getStartLine(this.getCurrentSide());
    }

    private int getCurrentEndLine(@NotNull SimpleThreesideDiffChange change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getCurrentEndLine"));
        }
        return change.getEndLine(this.getCurrentSide());
    }

    @NotNull
    protected List<SimpleThreesideDiffChange> getDiffChanges() {
        List<SimpleThreesideDiffChange> list = this.myDiffChanges;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getDiffChanges"));
        }
        return list;
    }

    @Override
    @NotNull
    protected SyncScrollSupport.SyncScrollable getSyncScrollable(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getSyncScrollable"));
        }
        SyncScrollSupport.SyncScrollable syncScrollable = (SyncScrollSupport.SyncScrollable)side.select((Object)this.mySyncScrollable1, (Object)this.mySyncScrollable2);
        if (syncScrollable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getSyncScrollable"));
        }
        return syncScrollable;
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        MyStatusPanel myStatusPanel = this.myStatusPanel;
        if (myStatusPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "getStatusPanel"));
        }
        return myStatusPanel;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer", "canShowRequest"));
        }
        return ThreesideTextDiffViewer.canShowRequest(context, request);
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        return super.getData(dataId);
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        private final FoldingModelSupport.MyPaintable myPaintable1;
        private final FoldingModelSupport.MyPaintable myPaintable2;

        public MyFoldingModel(@NotNull EditorEx[] editors, @NotNull Disposable disposable) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyFoldingModel", "<init>"));
            }
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyFoldingModel", "<init>"));
            }
            super(editors, disposable);
            this.myPaintable1 = new FoldingModelSupport.MyPaintable(this, 0, 1);
            this.myPaintable2 = new FoldingModelSupport.MyPaintable(this, 1, 2);
            assert (editors.length == 3);
        }

        public void install(@Nullable List<MergeLineFragment> fragments, @NotNull UserDataHolder context, boolean defaultExpanded, int range) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyFoldingModel", "install"));
            }
            Iterator<int[]> it = MyFoldingModel.map(fragments, new Function<MergeLineFragment, int[]>(){

                public int[] fun(MergeLineFragment fragment) {
                    return new int[]{fragment.getStartLine(ThreeSide.LEFT), fragment.getEndLine(ThreeSide.LEFT), fragment.getStartLine(ThreeSide.BASE), fragment.getEndLine(ThreeSide.BASE), fragment.getStartLine(ThreeSide.RIGHT), fragment.getEndLine(ThreeSide.RIGHT)};
                }
            });
            this.install(it, context, defaultExpanded, range);
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider, @NotNull Side side) {
            if (gg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyFoldingModel", "paintOnDivider"));
            }
            if (divider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyFoldingModel", "paintOnDivider"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyFoldingModel", "paintOnDivider"));
            }
            FoldingModelSupport.MyPaintable paintable = (FoldingModelSupport.MyPaintable)side.select((Object)this.myPaintable1, (Object)this.myPaintable2);
            paintable.paintOnDivider(gg, divider);
        }

        public void paintOnScrollbar(@NotNull Graphics2D gg, int width) {
            if (gg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyFoldingModel", "paintOnScrollbar"));
            }
            this.myPaintable2.paintOnScrollbar(gg, width);
        }
    }

    private static class DocumentData {
        @NotNull
        private final long[] myStamps;
        @NotNull
        private final CharSequence[] mySequences;

        public DocumentData(@NotNull long[] stamps, @NotNull CharSequence[] sequences) {
            if (stamps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stamps", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$DocumentData", "<init>"));
            }
            if (sequences == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequences", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$DocumentData", "<init>"));
            }
            assert (stamps.length == 3);
            assert (sequences.length == 3);
            this.myStamps = stamps;
            this.mySequences = sequences;
        }

        @NotNull
        public long[] getStamps() {
            if (this.myStamps == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$DocumentData", "getStamps"));
            }
            return this.myStamps;
        }

        @NotNull
        public CharSequence[] getSequences() {
            if (this.mySequences == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$DocumentData", "getSequences"));
            }
            return this.mySequences;
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        protected int getChangesCount() {
            return SimpleThreesideDiffViewer.this.myDiffChanges.size() + SimpleThreesideDiffViewer.this.myInvalidDiffChanges.size();
        }
    }

    private class MyScrollbarPainter
    implements ButtonlessScrollBarUI.ScrollbarRepaintCallback {
        @NotNull
        private final MyDividerPaintable myPaintable;

        private MyScrollbarPainter() {
            this.myPaintable = new MyDividerPaintable(Side.RIGHT);
        }

        public void call(Graphics g) {
            EditorEx editor1 = (EditorEx)SimpleThreesideDiffViewer.this.myEditors.get(1);
            EditorEx editor2 = (EditorEx)SimpleThreesideDiffViewer.this.myEditors.get(2);
            int width = editor1.getScrollPane().getVerticalScrollBar().getWidth();
            DiffDividerDrawUtil.paintPolygonsOnScrollbar((Graphics2D)g, width, editor1, editor2, this.myPaintable);
            SimpleThreesideDiffViewer.this.myFoldingModel.paintOnScrollbar((Graphics2D)g, width);
        }
    }

    private class MyDividerPainter
    implements DiffSplitter.Painter {
        @NotNull
        private final Side mySide;
        @NotNull
        private final MyDividerPaintable myPaintable;

        public MyDividerPainter(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyDividerPainter", "<init>"));
            }
            this.mySide = side;
            this.myPaintable = new MyDividerPaintable(side);
        }

        @Override
        public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyDividerPainter", "paint"));
            }
            if (divider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyDividerPainter", "paint"));
            }
            Graphics2D gg = SimpleThreesideDiffViewer.this.getDividerGraphics(g, divider);
            gg.setColor(DiffDrawUtil.getDividerColor((Editor)SimpleThreesideDiffViewer.this.myEditors.get(0)));
            gg.fill(gg.getClipBounds());
            Editor editor1 = (Editor)this.mySide.select(SimpleThreesideDiffViewer.this.myEditors.get(0), SimpleThreesideDiffViewer.this.myEditors.get(1));
            Editor editor2 = (Editor)this.mySide.select(SimpleThreesideDiffViewer.this.myEditors.get(1), SimpleThreesideDiffViewer.this.myEditors.get(2));
            DiffDividerDrawUtil.paintPolygons(gg, divider.getWidth(), editor1, editor2, this.myPaintable);
            SimpleThreesideDiffViewer.this.myFoldingModel.paintOnDivider(gg, divider, this.mySide);
            gg.dispose();
        }
    }

    private class MyDividerPaintable
    implements DiffDividerDrawUtil.DividerPaintable {
        @NotNull
        private final Side mySide;

        public MyDividerPaintable(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyDividerPaintable", "<init>"));
            }
            this.mySide = side;
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler) {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyDividerPaintable", "process"));
            }
            ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
            ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
            for (SimpleThreesideDiffChange diffChange : SimpleThreesideDiffViewer.this.myDiffChanges) {
                if (!diffChange.getType().isChange(this.mySide) || handler.process(diffChange.getStartLine(left), diffChange.getEndLine(left), diffChange.getStartLine(right), diffChange.getEndLine(right), diffChange.getDiffType().getColor((Editor)SimpleThreesideDiffViewer.this.myEditors.get(0)))) continue;
                return;
            }
        }
    }

    private class MySyncScrollable
    extends BaseSyncScrollable {
        @NotNull
        private final Side mySide;

        public MySyncScrollable(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MySyncScrollable", "<init>"));
            }
            this.mySide = side;
        }

        @Override
        public boolean isSyncScrollEnabled() {
            return SimpleThreesideDiffViewer.this.getTextSettings().isEnableSyncScroll();
        }

        @Override
        protected void processHelper(@NotNull BaseSyncScrollable.ScrollHelper helper) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MySyncScrollable", "processHelper"));
            }
            ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
            ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
            if (!helper.process(0, 0)) {
                return;
            }
            for (SimpleThreesideDiffChange diffChange : SimpleThreesideDiffViewer.this.myDiffChanges) {
                if (!helper.process(diffChange.getStartLine(left), diffChange.getStartLine(right))) {
                    return;
                }
                if (helper.process(diffChange.getEndLine(left), diffChange.getEndLine(right))) continue;
                return;
            }
            helper.process(((EditorEx)left.select(SimpleThreesideDiffViewer.this.myEditors)).getDocument().getLineCount(), ((EditorEx)right.select(SimpleThreesideDiffViewer.this.myEditors)).getDocument().getLineCount());
        }
    }

    private class MyIgnorePolicySettingAction
    extends TextDiffViewerBase.IgnorePolicySettingAction {
        private MyIgnorePolicySettingAction() {
            super(SimpleThreesideDiffViewer.this);
        }

        @Override
        @NotNull
        protected IgnorePolicy getCurrentSetting() {
            IgnorePolicy ignorePolicy = SimpleThreesideDiffViewer.this.getIgnorePolicy();
            if (ignorePolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyIgnorePolicySettingAction", "getCurrentSetting"));
            }
            return ignorePolicy;
        }

        @Override
        @NotNull
        protected List<IgnorePolicy> getAvailableSettings() {
            ArrayList settings = ContainerUtil.newArrayList((Object[])IgnorePolicy.values());
            settings.remove((Object)IgnorePolicy.IGNORE_WHITESPACES_CHUNKS);
            ArrayList arrayList = settings;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffViewer$MyIgnorePolicySettingAction", "getAvailableSettings"));
            }
            return arrayList;
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerBase.ToggleExpandByDefaultAction {
        private MyToggleExpandByDefaultAction() {
            super(SimpleThreesideDiffViewer.this);
        }

        @Override
        protected void expandAll(boolean expand) {
            SimpleThreesideDiffViewer.this.myFoldingModel.expandAll(expand);
        }
    }

    private class MyPrevNextDifferenceIterable
    implements PrevNextDifferenceIterable {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        public boolean canGoNext() {
            EditorEx editor;
            if (SimpleThreesideDiffViewer.this.myDiffChanges.isEmpty()) {
                return false;
            }
            int line = editor.getCaretModel().getLogicalPosition().line;
            editor = SimpleThreesideDiffViewer.this.getCurrentEditor();
            if (line == editor.getDocument().getLineCount() - 1) {
                return false;
            }
            SimpleThreesideDiffChange lastChange = (SimpleThreesideDiffChange)SimpleThreesideDiffViewer.this.myDiffChanges.get(SimpleThreesideDiffViewer.this.myDiffChanges.size() - 1);
            return SimpleThreesideDiffViewer.this.getCurrentStartLine(lastChange) > line;
        }

        @Override
        public void goNext() {
            EditorEx editor = SimpleThreesideDiffViewer.this.getCurrentEditor();
            int line = editor.getCaretModel().getLogicalPosition().line;
            SimpleThreesideDiffChange next = null;
            for (int i = 0; i < SimpleThreesideDiffViewer.this.myDiffChanges.size(); ++i) {
                SimpleThreesideDiffChange change = (SimpleThreesideDiffChange)SimpleThreesideDiffViewer.this.myDiffChanges.get(i);
                if (SimpleThreesideDiffViewer.this.getCurrentStartLine(change) <= line) continue;
                next = change;
                break;
            }
            assert (next != null);
            DiffUtil.scrollToLineAnimated(editor, SimpleThreesideDiffViewer.this.getCurrentStartLine(next));
        }

        @Override
        public boolean canGoPrev() {
            if (SimpleThreesideDiffViewer.this.myDiffChanges.isEmpty()) {
                return false;
            }
            EditorEx editor = SimpleThreesideDiffViewer.this.getCurrentEditor();
            int line = editor.getCaretModel().getLogicalPosition().line;
            if (line == 0) {
                return false;
            }
            SimpleThreesideDiffChange firstChange = (SimpleThreesideDiffChange)SimpleThreesideDiffViewer.this.myDiffChanges.get(0);
            if (SimpleThreesideDiffViewer.this.getCurrentEndLine(firstChange) > line) {
                return false;
            }
            return SimpleThreesideDiffViewer.this.getCurrentStartLine(firstChange) < line;
        }

        @Override
        public void goPrev() {
            EditorEx editor = SimpleThreesideDiffViewer.this.getCurrentEditor();
            int line = editor.getCaretModel().getLogicalPosition().line;
            SimpleThreesideDiffChange prev = null;
            for (int i = 0; i < SimpleThreesideDiffViewer.this.myDiffChanges.size(); ++i) {
                SimpleThreesideDiffChange next;
                SimpleThreesideDiffChange change = (SimpleThreesideDiffChange)SimpleThreesideDiffViewer.this.myDiffChanges.get(i);
                SimpleThreesideDiffChange simpleThreesideDiffChange = next = i < SimpleThreesideDiffViewer.this.myDiffChanges.size() - 1 ? (SimpleThreesideDiffChange)SimpleThreesideDiffViewer.this.myDiffChanges.get(i + 1) : null;
                if (next != null && SimpleThreesideDiffViewer.this.getCurrentEndLine(next) <= line && SimpleThreesideDiffViewer.this.getCurrentStartLine(next) < line) continue;
                prev = change;
                break;
            }
            assert (prev != null);
            DiffUtil.scrollToLineAnimated(editor, SimpleThreesideDiffViewer.this.getCurrentStartLine(prev));
        }
    }
}

