/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.icons.AllIcons;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.ToggleBooleanProperty;

public class ScrollToTestSourceAction
extends ToggleBooleanProperty.Disablable {
    private TestFrameworkRunningModel myModel;

    public ScrollToTestSourceAction(TestConsoleProperties properties) {
        super(ExecutionBundle.message((String)"junit.auto.scroll.to.source.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"junit.open.text.in.editor.action.name", (Object[])new Object[0]), AllIcons.General.AutoscrollToSource, (AbstractProperty.AbstractPropertyContainer)properties, TestConsoleProperties.SCROLL_TO_SOURCE);
    }

    protected boolean isEnabled() {
        AbstractProperty.AbstractPropertyContainer properties = this.getProperties();
        TestFrameworkRunningModel model = this.myModel;
        return ScrollToTestSourceAction.isEnabled(properties, model);
    }

    protected boolean isVisible() {
        return true;
    }

    private static boolean isEnabled(AbstractProperty.AbstractPropertyContainer properties, TestFrameworkRunningModel model) {
        if (!TestConsoleProperties.TRACK_RUNNING_TEST.value(properties)) {
            return true;
        }
        return model != null && !model.isRunning();
    }

    public static boolean isScrollEnabled(TestFrameworkRunningModel model) {
        TestConsoleProperties properties = model.getProperties();
        return ScrollToTestSourceAction.isEnabled(properties, model) && TestConsoleProperties.SCROLL_TO_SOURCE.value((AbstractProperty.AbstractPropertyContainer)properties);
    }

    public void setModel(TestFrameworkRunningModel model) {
        this.myModel = model;
    }
}

