/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.wm.impl.SystemDock;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RecentProjectsManagerBase
extends RecentProjectsManager
implements ProjectManagerListener,
PersistentStateComponent<State> {
    private final Object myStateLock = new Object();
    private State myState = new State();
    private final Map<String, String> myNameCache = Collections.synchronizedMap(new THashMap());

    public static RecentProjectsManagerBase getInstanceEx() {
        return (RecentProjectsManagerBase)RecentProjectsManager.getInstance();
    }

    protected RecentProjectsManagerBase(MessageBus messageBus) {
        messageBus.connect().subscribe(AppLifecycleListener.TOPIC, (Object)new MyAppLifecycleListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.validateRecentProjects();
            return this.myState;
        }
    }

    public void loadState(State state) {
        File lastFile;
        if (state.lastPath != null && !new File(state.lastPath).exists()) {
            state.lastPath = null;
        }
        if (state.lastPath != null && (lastFile = new File(state.lastPath)).isDirectory() && !new File(lastFile, ".idea").exists()) {
            state.lastPath = null;
        }
        this.myState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePath(@Nullable String path) {
        if (path == null) {
            return;
        }
        Object object = this.myStateLock;
        synchronized (object) {
            if (SystemInfo.isFileSystemCaseSensitive) {
                this.myState.recentPaths.remove(path);
                this.myState.names.remove(path);
            } else {
                Iterator<String> iterator = this.myState.recentPaths.iterator();
                while (iterator.hasNext()) {
                    if (!path.equalsIgnoreCase(iterator.next())) continue;
                    iterator.remove();
                    this.myState.names.remove(path);
                }
            }
        }
    }

    @Nullable
    public String getLastProjectCreationLocation() {
        return this.myState.lastProjectLocation;
    }

    public void setLastProjectCreationLocation(@Nullable String lastProjectLocation) {
        this.myState.lastProjectLocation = StringUtil.nullize((String)lastProjectLocation, (boolean)true);
    }

    public String getLastProjectPath() {
        return this.myState.lastPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastProjectPath() {
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.openPaths.clear();
            if (openProjects.length == 0) {
                this.myState.lastPath = null;
            } else {
                this.myState.lastPath = this.getProjectPath(openProjects[openProjects.length - 1]);
                for (Project openProject : openProjects) {
                    String path = this.getProjectPath(openProject);
                    if (path == null) continue;
                    this.myState.openPaths.add(path);
                    this.myState.names.put(path, this.getProjectDisplayName(openProject));
                }
            }
        }
    }

    @NotNull
    protected String getProjectDisplayName(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/RecentProjectsManagerBase", "getProjectDisplayName"));
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/RecentProjectsManagerBase", "getProjectDisplayName"));
        }
        return "";
    }

    private Set<String> getDuplicateProjectNames(Set<String> openedPaths, Set<String> recentPaths) {
        HashSet names = ContainerUtil.newHashSet();
        HashSet duplicates = ContainerUtil.newHashSet();
        for (String path : ContainerUtil.concat((Iterable[])new Iterable[]{openedPaths, recentPaths})) {
            if (names.add(this.getProjectName(path))) continue;
            duplicates.add(path);
        }
        return duplicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnAction[] getRecentProjectsActions(boolean addClearListItem) {
        LinkedHashSet paths;
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.validateRecentProjects();
            paths = ContainerUtil.newLinkedHashSet(this.myState.recentPaths);
        }
        THashSet openedPaths = new THashSet();
        for (Project openProject : ProjectManager.getInstance().getOpenProjects()) {
            ContainerUtil.addIfNotNull((Collection)openedPaths, (Object)this.getProjectPath(openProject));
        }
        paths.remove(null);
        paths.removeAll((Collection<?>)openedPaths);
        SmartList actions = new SmartList();
        Set<String> duplicates = this.getDuplicateProjectNames((Set<String>)openedPaths, paths);
        for (String path : paths) {
            String displayName;
            String projectName = this.getProjectName(path);
            Object object2 = this.myStateLock;
            synchronized (object2) {
                displayName = this.myState.names.get(path);
            }
            if (StringUtil.isEmptyOrSpaces((String)displayName)) {
                String string = displayName = duplicates.contains(path) ? path : projectName;
            }
            if (!new File(path).exists()) continue;
            actions.add(new ReopenProjectAction(path, projectName, displayName));
        }
        if (actions.isEmpty()) {
            return AnAction.EMPTY_ARRAY;
        }
        if (addClearListItem) {
            DumbAwareAction clearListAction = new DumbAwareAction(IdeBundle.message((String)"action.clear.list", (Object[])new Object[0])){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/RecentProjectsManagerBase$1", "actionPerformed"));
                    }
                    String message = IdeBundle.message((String)"action.clear.list.message", (Object[])new Object[0]);
                    String title = IdeBundle.message((String)"action.clear.list.title", (Object[])new Object[0]);
                    if (Messages.showOkCancelDialog((Project)e.getProject(), (String)message, (String)title, (Icon)Messages.getQuestionIcon()) == 0) {
                        Object object = RecentProjectsManagerBase.this.myStateLock;
                        synchronized (object) {
                            ((RecentProjectsManagerBase)RecentProjectsManagerBase.this).myState.recentPaths.clear();
                        }
                        WelcomeFrame.clearRecents();
                    }
                }
            };
            actions.add(Separator.getInstance());
            actions.add(clearListAction);
        }
        return actions.toArray(new AnAction[actions.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markPathRecent(String path) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.lastPath = path;
            this.removePath(path);
            this.myState.recentPaths.add(0, path);
        }
    }

    @Nullable
    protected abstract String getProjectPath(@NotNull Project var1);

    protected abstract void doOpenProject(@NotNull String var1, @Nullable Project var2, boolean var3);

    public static boolean isValidProjectPath(String projectPath) {
        File file = new File(projectPath);
        return file.exists() && (!file.isDirectory() || new File(file, ".idea").exists());
    }

    public void projectOpened(Project project) {
        String path = this.getProjectPath(project);
        if (path != null) {
            this.markPathRecent(path);
        }
        SystemDock.updateMenu();
    }

    public final boolean canCloseProject(Project project) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosing(Project project) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.names.put(this.getProjectPath(project), this.getProjectDisplayName(project));
        }
    }

    public void projectClosed(Project project) {
        String path;
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length > 0 && (path = this.getProjectPath(openProjects[openProjects.length - 1])) != null) {
            this.markPathRecent(path);
        }
        SystemDock.updateMenu();
    }

    @NotNull
    private String getProjectName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/RecentProjectsManagerBase", "getProjectName"));
        }
        String cached = this.myNameCache.get(path);
        if (cached != null) {
            String string = cached;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/RecentProjectsManagerBase", "getProjectName"));
            }
            return string;
        }
        String result = RecentProjectsManagerBase.readProjectName(path);
        this.myNameCache.put(path, result);
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/RecentProjectsManagerBase", "getProjectName"));
        }
        return string;
    }

    public void clearNameCache() {
        this.myNameCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readProjectName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/RecentProjectsManagerBase", "readProjectName"));
        }
        File file = new File(path);
        if (!file.isDirectory()) return FileUtilRt.getNameWithoutExtension((String)file.getName());
        File nameFile = new File(new File(path, ".idea"), ".name");
        if (!nameFile.exists()) return file.getName();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(nameFile), CharsetToolkit.UTF8_CHARSET));
            try {
                String name = in.readLine();
                if (StringUtil.isEmpty((String)name)) return file.getName();
                String string = name.trim();
                return string;
            }
            finally {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.getName();
    }

    protected boolean willReopenProjectOnStart() {
        return GeneralSettings.getInstance().isReopenLastProject() && this.getLastProjectPath() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReopenLastProject() {
        GeneralSettings generalSettings = GeneralSettings.getInstance();
        if (generalSettings.isReopenLastProject()) {
            LinkedHashSet openPaths;
            Object object = this.myStateLock;
            synchronized (object) {
                openPaths = ContainerUtil.newLinkedHashSet(this.myState.openPaths);
            }
            if (!openPaths.isEmpty()) {
                for (String openPath : openPaths) {
                    if (!RecentProjectsManagerBase.isValidProjectPath(openPath)) continue;
                    this.doOpenProject(openPath, null, true);
                }
            } else {
                String lastProjectPath = this.getLastProjectPath();
                if (lastProjectPath != null && RecentProjectsManagerBase.isValidProjectPath(lastProjectPath)) {
                    this.doOpenProject(lastProjectPath, null, false);
                }
            }
        }
    }

    private class MyAppLifecycleListener
    extends AppLifecycleListener.Adapter {
        private MyAppLifecycleListener() {
        }

        @Override
        public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
            if (willOpenProject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "willOpenProject", "com/intellij/ide/RecentProjectsManagerBase$MyAppLifecycleListener", "appFrameCreated"));
            }
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)RecentProjectsManagerBase.this);
            }
            if (RecentProjectsManagerBase.this.willReopenProjectOnStart()) {
                willOpenProject.set((Object)Boolean.TRUE);
            }
        }

        @Override
        public void appStarting(Project projectFromCommandLine) {
            if (projectFromCommandLine != null) {
                return;
            }
            RecentProjectsManagerBase.this.doReopenLastProject();
        }

        @Override
        public void projectFrameClosed() {
            RecentProjectsManagerBase.this.updateLastProjectPath();
        }

        @Override
        public void projectOpenFailed() {
            RecentProjectsManagerBase.this.updateLastProjectPath();
        }

        @Override
        public void appClosing() {
            RecentProjectsManagerBase.this.updateLastProjectPath();
        }
    }

    public static class State {
        public List<String> recentPaths = new SmartList();
        public List<String> openPaths = new SmartList();
        public Map<String, String> names = ContainerUtil.newLinkedHashMap();
        public String lastPath;
        public String lastProjectLocation;

        void validateRecentProjects() {
            while (this.recentPaths.remove(null)) {
            }
            Collection<String> displayNames = this.names.values();
            while (displayNames.remove("")) {
            }
            while (this.recentPaths.size() > Registry.intValue((String)"ide.max.recent.projects")) {
                int index = this.recentPaths.size() - 1;
                this.names.remove(this.recentPaths.get(index));
                this.recentPaths.remove(index);
            }
        }
    }
}

