/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.javaee.EditLocationDialog;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.MapExternalResourceDialog;
import com.intellij.javaee.NameLocationPair;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AddEditRemovePanel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.XmlBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.Nullable;

public class ExternalResourceConfigurable
extends BaseConfigurable
implements Configurable.NoScroll {
    private JPanel myPanel;
    private List<NameLocationPair> myPairs;
    private List<String> myIgnoredUrls;
    private AddEditRemovePanel<NameLocationPair> myExtPanel;
    private AddEditRemovePanel<String> myIgnorePanel;
    @Nullable
    private final Project myProject;
    private final List<NameLocationPair> myNewPairs;

    public ExternalResourceConfigurable(@Nullable Project project) {
        this(project, Collections.emptyList());
    }

    public ExternalResourceConfigurable(@Nullable Project project, List<NameLocationPair> newResources) {
        this.myProject = project;
        this.myNewPairs = newResources;
    }

    public String getDisplayName() {
        return XmlBundle.message((String)"display.name.edit.external.resource", (Object[])new Object[0]);
    }

    public JComponent createComponent() {
        this.myPanel = new JPanel(new GridBagLayout()){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(-1, 400);
            }
        };
        this.myExtPanel = new AddEditRemovePanel<NameLocationPair>((AddEditRemovePanel.TableModel)new ExtUrlsTableModel(), this.myPairs, XmlBundle.message((String)"label.edit.external.resource.configure.external.resources", (Object[])new Object[0])){

            protected NameLocationPair addItem() {
                return ExternalResourceConfigurable.this.addExtLocation();
            }

            protected boolean removeItem(NameLocationPair o) {
                ExternalResourceConfigurable.this.setModified(true);
                return true;
            }

            protected NameLocationPair editItem(NameLocationPair o) {
                return ExternalResourceConfigurable.this.editExtLocation(o);
            }
        };
        this.myExtPanel.getTable().setShowColumns(true);
        this.myExtPanel.setRenderer(1, (TableCellRenderer)new PathRenderer());
        JBTable table = this.myExtPanel.getTable();
        if (this.myProject != null) {
            TableColumn column = table.getColumn(table.getColumnName(2));
            column.setMaxWidth(50);
            column.setCellEditor(JBTable.createBooleanEditor());
        }
        table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ExternalResourceConfigurable.this.setModified(true);
            }
        });
        this.myIgnorePanel = new AddEditRemovePanel<String>((AddEditRemovePanel.TableModel)new IgnoredUrlsModel(), this.myIgnoredUrls, XmlBundle.message((String)"label.edit.external.resource.configure.ignored.resources", (Object[])new Object[0])){

            protected String addItem() {
                return ExternalResourceConfigurable.this.addIgnoreLocation();
            }

            protected boolean removeItem(String o) {
                ExternalResourceConfigurable.this.setModified(true);
                return true;
            }

            protected String editItem(String o) {
                return ExternalResourceConfigurable.this.editIgnoreLocation(o);
            }
        };
        this.myPanel.add((Component)this.myExtPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myPanel.add((Component)this.myIgnorePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myExtPanel.setData(this.myPairs);
        this.myIgnorePanel.setData(this.myIgnoredUrls);
        this.myExtPanel.getEmptyText().setText(XmlBundle.message((String)"no.external.resources", (Object[])new Object[0]));
        this.myIgnorePanel.getEmptyText().setText(XmlBundle.message((String)"no.ignored.resources", (Object[])new Object[0]));
        return this.myPanel;
    }

    public void apply() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ExternalResourceManagerEx manager = ExternalResourceManagerEx.getInstanceEx();
                if (ExternalResourceConfigurable.this.myProject == null) {
                    manager.clearAllResources();
                } else {
                    manager.clearAllResources(ExternalResourceConfigurable.this.myProject);
                }
                for (NameLocationPair pair : ExternalResourceConfigurable.this.myPairs) {
                    String s = FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)pair.myLocation));
                    if (ExternalResourceConfigurable.this.myProject == null || pair.myShared) {
                        manager.addResource(pair.myName, s);
                        continue;
                    }
                    manager.addResource(pair.myName, s, ExternalResourceConfigurable.this.myProject);
                }
                Iterator i$ = ExternalResourceConfigurable.this.myIgnoredUrls.iterator();
                while (i$.hasNext()) {
                    String myIgnoredUrl;
                    String url = myIgnoredUrl = (String)i$.next();
                    manager.addIgnoredResource(url);
                }
            }
        });
        this.setModified(false);
    }

    public void reset() {
        String loc;
        String[] urls;
        this.myPairs = new ArrayList<NameLocationPair>(this.myNewPairs);
        ExternalResourceManagerEx manager = ExternalResourceManagerEx.getInstanceEx();
        for (String url : urls = manager.getAvailableUrls()) {
            loc = this.myProject == null ? manager.getResourceLocation(url, null) : manager.getResourceLocation(url, this.myProject);
            this.myPairs.add(new NameLocationPair(url, FileUtil.toSystemDependentName((String)loc), true));
        }
        if (this.myProject != null) {
            for (String url : urls = manager.getAvailableUrls(this.myProject)) {
                loc = manager.getResourceLocation(url, this.myProject);
                this.myPairs.add(new NameLocationPair(url, FileUtil.toSystemDependentName((String)loc), false));
            }
        }
        Collections.sort(this.myPairs);
        this.myIgnoredUrls = new ArrayList<String>();
        Object[] ignoredResources = manager.getIgnoredResources();
        ContainerUtil.addAll(this.myIgnoredUrls, (Object[])ignoredResources);
        Collections.sort(this.myIgnoredUrls);
        if (this.myExtPanel != null) {
            this.myExtPanel.setData(this.myPairs);
            this.myIgnorePanel.setData(this.myIgnoredUrls);
            if (!this.myNewPairs.isEmpty()) {
                ListSelectionModel selectionModel = this.myExtPanel.getTable().getSelectionModel();
                selectionModel.clearSelection();
                for (NameLocationPair newPair : this.myNewPairs) {
                    int index = this.myPairs.indexOf(newPair);
                    selectionModel.addSelectionInterval(index, index);
                }
            }
        }
        this.setModified(!this.myNewPairs.isEmpty());
    }

    public void disposeUIResources() {
        this.myPanel = null;
        this.myExtPanel = null;
        this.myIgnorePanel = null;
    }

    public String getHelpTopic() {
        return "preferences.externalResources";
    }

    @Nullable
    private NameLocationPair addExtLocation() {
        MapExternalResourceDialog dialog = new MapExternalResourceDialog(null, this.myProject, null, null);
        if (!dialog.showAndGet()) {
            return null;
        }
        this.setModified(true);
        return new NameLocationPair(dialog.getUri(), dialog.getResourceLocation(), false);
    }

    @Nullable
    private NameLocationPair editExtLocation(Object o) {
        NameLocationPair pair = (NameLocationPair)o;
        MapExternalResourceDialog dialog = new MapExternalResourceDialog(pair.getName(), this.myProject, null, pair.getLocation());
        if (!dialog.showAndGet()) {
            return null;
        }
        this.setModified(true);
        return new NameLocationPair(dialog.getUri(), dialog.getResourceLocation(), pair.myShared);
    }

    @Nullable
    private String addIgnoreLocation() {
        EditLocationDialog dialog = new EditLocationDialog(null, false);
        if (!dialog.showAndGet()) {
            return null;
        }
        this.setModified(true);
        return dialog.getPair().myName;
    }

    @Nullable
    private String editIgnoreLocation(Object o) {
        EditLocationDialog dialog = new EditLocationDialog(null, false);
        dialog.init(new NameLocationPair(o.toString(), null, false));
        if (!dialog.showAndGet()) {
            return null;
        }
        this.setModified(true);
        return dialog.getPair().myName;
    }

    private class ExtUrlsTableModel
    extends AddEditRemovePanel.TableModel<NameLocationPair> {
        final String[] myNames;

        private ExtUrlsTableModel() {
            ArrayList<String> names = new ArrayList<String>();
            names.add(XmlBundle.message((String)"column.name.edit.external.resource.uri", (Object[])new Object[0]));
            names.add(XmlBundle.message((String)"column.name.edit.external.resource.location", (Object[])new Object[0]));
            if (ExternalResourceConfigurable.this.myProject != null) {
                names.add("Project");
            }
            this.myNames = ArrayUtil.toStringArray(names);
        }

        public int getColumnCount() {
            return this.myNames.length;
        }

        public Object getField(NameLocationPair pair, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return pair.myName;
                }
                case 1: {
                    return pair.myLocation;
                }
                case 2: {
                    return !pair.myShared;
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            return columnIndex == 2 ? Boolean.class : String.class;
        }

        public boolean isEditable(int column) {
            return column == 2;
        }

        public void setValue(Object aValue, NameLocationPair data, int columnIndex) {
            data.myShared = (Boolean)aValue == false;
        }

        public String getColumnName(int column) {
            return this.myNames[column];
        }
    }

    private static class IgnoredUrlsModel
    extends AddEditRemovePanel.TableModel<String> {
        private final String[] myNames = new String[]{XmlBundle.message((String)"column.name.edit.external.resource.uri", (Object[])new Object[0])};

        private IgnoredUrlsModel() {
        }

        public int getColumnCount() {
            return this.myNames.length;
        }

        public Object getField(String o, int columnIndex) {
            return o;
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public boolean isEditable(int column) {
            return false;
        }

        public void setValue(Object aValue, String data, int columnIndex) {
        }

        public String getColumnName(int column) {
            return this.myNames[column];
        }
    }

    private static class PathRenderer
    extends DefaultTableCellRenderer {
        private PathRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                String loc = value.toString().replace('\\', '/');
                int jarDelimIndex = loc.indexOf("!/");
                VirtualFile path = jarDelimIndex != -1 ? JarFileSystem.getInstance().findFileByPath(loc) : LocalFileSystem.getInstance().findFileByPath(loc);
                this.setForeground(path != null ? (isSelected ? UIUtil.getTableSelectionForeground() : Color.black) : new Color(210, 0, 0));
            }
            return rendererComponent;
        }
    }
}

