/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.WeighedFileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileEditorProviderManager", storages={@Storage(file="$APP_CONFIG$/fileEditorProviderManager.xml", roamingType=RoamingType.DISABLED)})
public final class FileEditorProviderManagerImpl
extends FileEditorProviderManager
implements PersistentStateComponent<FileEditorProviderManagerImpl> {
    private final List<FileEditorProvider> myProviders;
    private static final Function<FileEditorProvider, String> EDITOR_PROVIDER_STRING_FUNCTION = new Function<FileEditorProvider, String>(){

        public String fun(FileEditorProvider provider) {
            return provider.getEditorTypeId();
        }
    };
    private final Map<String, String> mySelectedProviders;

    public FileEditorProviderManagerImpl(@NotNull FileEditorProvider[] providers) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/openapi/fileEditor/impl/FileEditorProviderManagerImpl", "<init>"));
        }
        this.myProviders = ContainerUtil.createConcurrentList();
        this.mySelectedProviders = new HashMap<String, String>();
        Extensions.getRootArea().getExtensionPoint(FileEditorProvider.EP_FILE_EDITOR_PROVIDER).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FileEditorProvider>(){

            public void extensionAdded(@NotNull FileEditorProvider extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/fileEditor/impl/FileEditorProviderManagerImpl$1", "extensionAdded"));
                }
                FileEditorProviderManagerImpl.this.registerProvider(extension);
            }

            public void extensionRemoved(@NotNull FileEditorProvider extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/fileEditor/impl/FileEditorProviderManagerImpl$1", "extensionRemoved"));
                }
                FileEditorProviderManagerImpl.this.unregisterProvider(extension);
            }
        });
        for (FileEditorProvider provider : providers) {
            this.registerProvider(provider);
        }
    }

    public FileEditorProviderManagerImpl() {
        this.myProviders = ContainerUtil.createConcurrentList();
        this.mySelectedProviders = new HashMap<String, String>();
    }

    @Override
    @NotNull
    public FileEditorProvider[] getProviders(final @NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/FileEditorProviderManagerImpl", "getProviders"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorProviderManagerImpl", "getProviders"));
        }
        ArrayList<FileEditorProvider> sharedProviders = new ArrayList<FileEditorProvider>();
        boolean doNotShowTextEditor = false;
        for (final FileEditorProvider provider : this.myProviders) {
            if (!((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    if (DumbService.isDumb((Project)project) && !DumbService.isDumbAware((Object)provider)) {
                        return false;
                    }
                    return provider.accept(project, file);
                }
            })).booleanValue()) continue;
            sharedProviders.add(provider);
            doNotShowTextEditor |= provider.getPolicy() == FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        }
        if (doNotShowTextEditor) {
            ContainerUtil.retainAll(sharedProviders, (Condition)new Condition<FileEditorProvider>(){

                public boolean value(FileEditorProvider provider) {
                    return !(provider instanceof TextEditorProvider);
                }
            });
        }
        Collections.sort(sharedProviders, MyComparator.ourInstance);
        FileEditorProvider[] fileEditorProviderArray = sharedProviders.toArray(new FileEditorProvider[sharedProviders.size()]);
        if (fileEditorProviderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorProviderManagerImpl", "getProviders"));
        }
        return fileEditorProviderArray;
    }

    @Override
    @Nullable
    public FileEditorProvider getProvider(@NotNull String editorTypeId) {
        if (editorTypeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorTypeId", "com/intellij/openapi/fileEditor/impl/FileEditorProviderManagerImpl", "getProvider"));
        }
        for (FileEditorProvider provider : this.myProviders) {
            if (!provider.getEditorTypeId().equals(editorTypeId)) continue;
            return provider;
        }
        return null;
    }

    private void registerProvider(@NotNull FileEditorProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/fileEditor/impl/FileEditorProviderManagerImpl", "registerProvider"));
        }
        String editorTypeId = provider.getEditorTypeId();
        if (this.getProvider(editorTypeId) != null) {
            throw new IllegalArgumentException("attempt to register provider with non unique editorTypeId: " + editorTypeId);
        }
        this.myProviders.add(provider);
    }

    private void unregisterProvider(@NotNull FileEditorProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/fileEditor/impl/FileEditorProviderManagerImpl", "unregisterProvider"));
        }
        boolean b = this.myProviders.remove(provider);
        assert (b);
    }

    @Nullable
    public FileEditorProviderManagerImpl getState() {
        return this;
    }

    public void loadState(FileEditorProviderManagerImpl state) {
        this.mySelectedProviders.clear();
        this.mySelectedProviders.putAll(state.mySelectedProviders);
    }

    void providerSelected(EditorComposite composite) {
        if (!(composite instanceof EditorWithProviderComposite)) {
            return;
        }
        FileEditorProvider[] providers = ((EditorWithProviderComposite)composite).getProviders();
        if (providers.length < 2) {
            return;
        }
        this.mySelectedProviders.put(FileEditorProviderManagerImpl.computeKey(providers), ((FileEditorProvider)composite.getSelectedEditorWithProvider().getSecond()).getEditorTypeId());
    }

    private static String computeKey(FileEditorProvider[] providers) {
        return StringUtil.join((Collection)ContainerUtil.map((Object[])providers, EDITOR_PROVIDER_STRING_FUNCTION), (String)",");
    }

    @Nullable
    FileEditorProvider getSelectedFileEditorProvider(EditorHistoryManager editorHistoryManager, VirtualFile file, FileEditorProvider[] providers) {
        FileEditorProvider provider = editorHistoryManager.getSelectedProvider(file);
        if (provider != null || providers.length < 2) {
            return provider;
        }
        String id = this.mySelectedProviders.get(FileEditorProviderManagerImpl.computeKey(providers));
        return id == null ? null : this.getProvider(id);
    }

    @MapAnnotation(surroundKeyWithTag=false, surroundValueWithTag=false)
    public Map<String, String> getSelectedProviders() {
        return this.mySelectedProviders;
    }

    public void setSelectedProviders(Map<String, String> selectedProviders) {
        this.mySelectedProviders.clear();
        this.mySelectedProviders.putAll(selectedProviders);
    }

    public void clearSelectedProviders() {
        this.mySelectedProviders.clear();
    }

    private static final class MyComparator
    implements Comparator<FileEditorProvider> {
        public static final MyComparator ourInstance = new MyComparator();

        private MyComparator() {
        }

        private static double getWeight(FileEditorProvider provider) {
            return provider instanceof WeighedFileEditorProvider ? ((WeighedFileEditorProvider)provider).getWeight() : Double.MAX_VALUE;
        }

        @Override
        public int compare(FileEditorProvider provider1, FileEditorProvider provider2) {
            int i2;
            int i1 = provider1.getPolicy().ordinal();
            if (i1 != (i2 = provider2.getPolicy().ordinal())) {
                return i1 - i2;
            }
            double value = MyComparator.getWeight(provider1) - MyComparator.getWeight(provider2);
            return value > 0.0 ? 1 : (value < 0.0 ? -1 : 0);
        }
    }
}

