/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PlatformProjectViewStructureProvider
implements TreeStructureProvider,
DumbAware {
    private final Project myProject;

    public PlatformProjectViewStructureProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        VirtualFile vFile;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/platform/PlatformProjectViewStructureProvider", "modify"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/platform/PlatformProjectViewStructureProvider", "modify"));
        }
        if (parent instanceof PsiDirectoryNode && (vFile = ((PsiDirectoryNode)parent).getVirtualFile()) != null && Comparing.equal((Object)ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).getContentRootForFile(vFile), (Object)vFile)) {
            Collection<AbstractTreeNode> moduleChildren = ((PsiDirectoryNode)parent).getChildren();
            ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
            for (AbstractTreeNode moduleChild : moduleChildren) {
                PsiDirectory value;
                if (moduleChild instanceof PsiDirectoryNode && (value = (PsiDirectory)((PsiDirectoryNode)moduleChild).getValue()).getName().equals(".idea") && Registry.is((String)"projectView.hide.dot.idea")) continue;
                result.add(moduleChild);
            }
            ArrayList<AbstractTreeNode> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/PlatformProjectViewStructureProvider", "modify"));
            }
            return arrayList;
        }
        Collection<AbstractTreeNode> collection = children;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/PlatformProjectViewStructureProvider", "modify"));
        }
        return collection;
    }

    public Object getData(Collection<AbstractTreeNode> selected, String dataName) {
        return null;
    }
}

