/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.refactoring.introduceField.IntroduceFieldHandler;
import com.intellij.refactoring.introduceParameter.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.ui.JavaVisibilityPanel;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.NameSuggestionsGenerator;
import com.intellij.refactoring.ui.NameSuggestionsManager;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.EnumConstantsUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class IntroduceConstantDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceField.IntroduceConstantDialog");
    @NonNls
    private static final String RECENTS_KEY = "IntroduceConstantDialog.RECENTS_KEY";
    @NonNls
    protected static final String NONNLS_SELECTED_PROPERTY = "INTRODUCE_CONSTANT_NONNLS";
    private final Project myProject;
    private final PsiClass myParentClass;
    private final PsiExpression myInitializerExpression;
    private final PsiLocalVariable myLocalVariable;
    private final boolean myInvokedOnDeclaration;
    private final PsiExpression[] myOccurrences;
    private final String myEnteredName;
    private final int myOccurrencesCount;
    private PsiClass myTargetClass;
    private final TypeSelectorManager myTypeSelectorManager;
    private NameSuggestionsField myNameField;
    private JCheckBox myCbReplaceAll;
    private TypeSelector myTypeSelector;
    private StateRestoringCheckBox myCbDeleteVariable;
    private final JavaCodeStyleManager myCodeStyleManager;
    private ReferenceEditorComboWithBrowseButton myTfTargetClassName;
    private BaseExpressionToFieldHandler.TargetDestination myDestinationClass;
    private JPanel myTypePanel;
    private JPanel myTargetClassNamePanel;
    private JPanel myPanel;
    private JLabel myTypeLabel;
    private JPanel myNameSuggestionPanel;
    private JLabel myNameSuggestionLabel;
    private JLabel myTargetClassNameLabel;
    private JCheckBox myCbNonNls;
    private JPanel myVisibilityPanel;
    private final JavaVisibilityPanel myVPanel;
    private final JCheckBox myIntroduceEnumConstantCb;

    IntroduceConstantDialog(Project project, PsiClass parentClass, PsiExpression initializerExpression, PsiLocalVariable localVariable, boolean isInvokedOnDeclaration, PsiExpression[] occurrences, PsiClass targetClass, TypeSelectorManager typeSelectorManager, String enteredName) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myIntroduceEnumConstantCb = new JCheckBox(RefactoringBundle.message((String)"introduce.constant.enum.cb"), true);
        this.myProject = project;
        this.myParentClass = parentClass;
        this.myInitializerExpression = initializerExpression;
        this.myLocalVariable = localVariable;
        this.myInvokedOnDeclaration = isInvokedOnDeclaration;
        this.myOccurrences = occurrences;
        this.myEnteredName = enteredName;
        this.myOccurrencesCount = occurrences.length;
        this.myTargetClass = targetClass;
        this.myTypeSelectorManager = typeSelectorManager;
        this.myDestinationClass = null;
        this.setTitle(IntroduceConstantHandler.REFACTORING_NAME);
        this.myCodeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        this.myVPanel = new JavaVisibilityPanel(false, true);
        this.myVisibilityPanel.add((Component)this.myVPanel, "Center");
        this.init();
        this.myVPanel.setVisibility(JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_VISIBILITY);
        this.myIntroduceEnumConstantCb.setEnabled(this.isSuitableForEnumConstant());
        this.updateVisibilityPanel();
        this.updateButtons();
    }

    public String getEnteredName() {
        return this.myNameField.getEnteredName();
    }

    private String getTargetClassName() {
        return this.myTfTargetClassName.getText().trim();
    }

    public BaseExpressionToFieldHandler.TargetDestination getDestinationClass() {
        return this.myDestinationClass;
    }

    public boolean introduceEnumConstant() {
        return this.myIntroduceEnumConstantCb.isEnabled() && this.myIntroduceEnumConstantCb.isSelected();
    }

    public String getFieldVisibility() {
        return this.myVPanel.getVisibility();
    }

    public boolean isReplaceAllOccurrences() {
        return this.myOccurrencesCount > 1 && this.myCbReplaceAll.isSelected();
    }

    public PsiType getSelectedType() {
        return this.myTypeSelector.getSelectedType();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceField/IntroduceConstantDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.introduceConstant");
    }

    protected JComponent createNorthPanel() {
        this.myTypeSelector = this.myTypeSelectorManager.getTypeSelector();
        this.myTypePanel.setLayout(new BorderLayout());
        this.myTypePanel.add((Component)this.myTypeSelector.getComponent(), "Center");
        if (this.myTypeSelector.getFocusableComponent() != null) {
            this.myTypeLabel.setLabelFor(this.myTypeSelector.getFocusableComponent());
        }
        this.myNameField = new NameSuggestionsField(this.myProject);
        this.myNameSuggestionPanel.setLayout(new BorderLayout());
        this.myNameField.addDataChangedListener(new NameSuggestionsField.DataChanged(){

            @Override
            public void dataChanged() {
                IntroduceConstantDialog.this.updateButtons();
            }
        });
        this.myNameSuggestionPanel.add((Component)this.myNameField.getComponent(), "Center");
        this.myNameSuggestionLabel.setLabelFor(this.myNameField.getFocusableComponent());
        LinkedHashSet<String> possibleClassNames = new LinkedHashSet<String>();
        for (PsiExpression occurrence : this.myOccurrences) {
            PsiClass parentClass = new IntroduceConstantHandler().getParentClass(occurrence);
            if (parentClass == null || parentClass.getQualifiedName() == null) continue;
            possibleClassNames.add(parentClass.getQualifiedName());
        }
        this.myTfTargetClassName = new ReferenceEditorComboWithBrowseButton(new ChooseClassAction(), "", this.myProject, true, RECENTS_KEY);
        this.myTargetClassNamePanel.setLayout(new BorderLayout());
        this.myTargetClassNamePanel.add((Component)((Object)this.myTfTargetClassName), "Center");
        this.myTargetClassNameLabel.setLabelFor((Component)((Object)this.myTfTargetClassName));
        for (String possibleClassName : possibleClassNames) {
            this.myTfTargetClassName.prependItem(possibleClassName);
        }
        ((EditorComboBox)this.myTfTargetClassName.getChildComponent()).addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                IntroduceConstantDialog.this.targetClassChanged();
                IntroduceConstantDialog.this.enableEnumDependant(IntroduceConstantDialog.this.introduceEnumConstant());
            }
        });
        this.myIntroduceEnumConstantCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntroduceConstantDialog.this.enableEnumDependant(IntroduceConstantDialog.this.introduceEnumConstant());
            }
        });
        JPanel enumPanel = new JPanel(new BorderLayout());
        enumPanel.add((Component)this.myIntroduceEnumConstantCb, "East");
        this.myTargetClassNamePanel.add((Component)enumPanel, "South");
        String propertyName = this.myLocalVariable != null ? this.myCodeStyleManager.variableNameToPropertyName(this.myLocalVariable.getName(), VariableKind.LOCAL_VARIABLE) : null;
        NameSuggestionsManager nameSuggestionsManager = new NameSuggestionsManager(this.myTypeSelector, this.myNameField, IntroduceConstantDialog.createNameSuggestionGenerator(propertyName, this.myInitializerExpression, this.myCodeStyleManager, this.myEnteredName, this.myParentClass));
        nameSuggestionsManager.setLabelsFor(this.myTypeLabel, this.myNameSuggestionLabel);
        if (this.myOccurrencesCount > 1) {
            this.myCbReplaceAll.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    IntroduceConstantDialog.this.updateTypeSelector();
                    IntroduceConstantDialog.this.myNameField.requestFocusInWindow();
                }
            });
            this.myCbReplaceAll.setText(RefactoringBundle.message((String)"replace.all.occurences", (Object[])new Object[]{this.myOccurrencesCount}));
        } else {
            this.myCbReplaceAll.setVisible(false);
        }
        if (this.myLocalVariable != null) {
            if (this.myInvokedOnDeclaration) {
                this.myCbDeleteVariable.setEnabled(false);
                this.myCbDeleteVariable.setSelected(true);
            } else if (this.myCbReplaceAll != null) {
                this.updateCbDeleteVariable();
                this.myCbReplaceAll.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        IntroduceConstantDialog.this.updateCbDeleteVariable();
                    }
                });
            }
        } else {
            this.myCbDeleteVariable.setVisible(false);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        if ((this.myTypeSelectorManager.isSuggestedType("java.lang.String") || this.myLocalVariable != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)this.myLocalVariable, (String)"org.jetbrains.annotations.NonNls", (boolean)false, (boolean)false)) && LanguageLevelProjectExtension.getInstance((Project)psiManager.getProject()).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_5) && JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("org.jetbrains.annotations.NonNls", this.myParentClass.getResolveScope()) != null) {
            final PropertiesComponent component = PropertiesComponent.getInstance((Project)this.myProject);
            this.myCbNonNls.setSelected(component.isTrueValue(NONNLS_SELECTED_PROPERTY));
            this.myCbNonNls.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    component.setValue(IntroduceConstantDialog.NONNLS_SELECTED_PROPERTY, Boolean.toString(IntroduceConstantDialog.this.myCbNonNls.isSelected()));
                }
            });
        } else {
            this.myCbNonNls.setVisible(false);
        }
        this.updateTypeSelector();
        this.enableEnumDependant(this.introduceEnumConstant());
        return this.myPanel;
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        if (this.myCbReplaceAll != null) {
            this.myCbReplaceAll.setSelected(replaceAllOccurrences);
        }
    }

    protected static NameSuggestionsGenerator createNameSuggestionGenerator(final String propertyName, final PsiExpression psiExpression, final JavaCodeStyleManager codeStyleManager, final String enteredName, final PsiClass parentClass) {
        return new NameSuggestionsGenerator(){

            @Override
            public SuggestedNameInfo getSuggestedNameInfo(PsiType type) {
                SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.STATIC_FINAL_FIELD, propertyName, psiExpression, type);
                if (psiExpression != null) {
                    for (String name : nameInfo.names) {
                        if (parentClass.findFieldByName(name, false) == null) continue;
                        names[i] = codeStyleManager.suggestUniqueVariableName(name, (PsiElement)psiExpression, true);
                    }
                }
                String[] strings = AbstractJavaInplaceIntroducer.appendUnresolvedExprName(JavaCompletionUtil.completeVariableNameForRefactoring(codeStyleManager, type, VariableKind.LOCAL_VARIABLE, nameInfo), psiExpression);
                return new SuggestedNameInfo.Delegate(enteredName != null ? ArrayUtil.mergeArrays((String[])new String[]{enteredName}, (String[])strings) : strings, nameInfo);
            }
        };
    }

    private void updateButtons() {
        this.setOKActionEnabled(PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(this.getEnteredName()));
    }

    private void targetClassChanged() {
        String targetClassName = this.getTargetClassName();
        this.myTargetClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(targetClassName, GlobalSearchScope.projectScope((Project)this.myProject));
        this.updateVisibilityPanel();
        this.myIntroduceEnumConstantCb.setEnabled(this.isSuitableForEnumConstant());
    }

    private boolean isSuitableForEnumConstant() {
        return EnumConstantsUtil.isSuitableForEnumConstant(this.getSelectedType(), this.myTargetClass) && PsiTreeUtil.getParentOfType((PsiElement)this.myInitializerExpression, PsiEnumConstant.class) == null;
    }

    private void enableEnumDependant(boolean enable) {
        if (enable) {
            this.myVPanel.disableAllButPublic();
        } else {
            this.updateVisibilityPanel();
        }
        this.myCbNonNls.setEnabled(!enable);
    }

    protected JComponent createCenterPanel() {
        return new JPanel();
    }

    public boolean isDeleteVariable() {
        return this.myInvokedOnDeclaration || this.myCbDeleteVariable != null && this.myCbDeleteVariable.isSelected();
    }

    public boolean isAnnotateAsNonNls() {
        return this.myCbNonNls != null && this.myCbNonNls.isSelected();
    }

    private void updateCbDeleteVariable() {
        if (!this.myCbReplaceAll.isSelected()) {
            this.myCbDeleteVariable.makeUnselectable(false);
        } else {
            this.myCbDeleteVariable.makeSelectable();
        }
    }

    private void updateTypeSelector() {
        if (this.myCbReplaceAll != null) {
            this.myTypeSelectorManager.setAllOccurrences(this.myCbReplaceAll.isSelected());
        } else {
            this.myTypeSelectorManager.setAllOccurrences(false);
        }
    }

    private void updateVisibilityPanel() {
        if (this.myTargetClass != null && this.myTargetClass.isInterface()) {
            this.myVPanel.disableAllButPublic();
        } else {
            UIUtil.setEnabled((Component)this.myVisibilityPanel, (boolean)true, (boolean)true);
            THashSet visible = new THashSet();
            visible.add("private");
            visible.add("protected");
            visible.add("packageLocal");
            visible.add("public");
            for (PsiExpression occurrence : this.myOccurrences) {
                PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
                Iterator iterator = visible.iterator();
                while (iterator.hasNext()) {
                    String modifier = (String)iterator.next();
                    try {
                        String modifierText;
                        String string = modifierText = "packageLocal".equals(modifier) ? "" : modifier + " ";
                        PsiField field = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createFieldFromText(modifierText + "int xxx;", (PsiElement)this.myTargetClass);
                        if (JavaResolveUtil.isAccessible((PsiMember)field, this.myTargetClass, field.getModifierList(), (PsiElement)occurrence, this.myTargetClass, null)) continue;
                        iterator.remove();
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
            if (!visible.contains(this.getFieldVisibility())) {
                if (visible.contains("public")) {
                    this.myVPanel.setVisibility("public");
                }
                if (visible.contains("packageLocal")) {
                    this.myVPanel.setVisibility("packageLocal");
                }
                if (visible.contains("protected")) {
                    this.myVPanel.setVisibility("protected");
                }
                if (visible.contains("private")) {
                    this.myVPanel.setVisibility("private");
                }
            }
        }
    }

    protected void doOKAction() {
        int answer;
        PsiField oldField;
        String targetClassName = this.getTargetClassName();
        PsiClass newClass = this.myParentClass;
        if (!"".equals(targetClassName) && !Comparing.strEqual((String)targetClassName, (String)this.myParentClass.getQualifiedName())) {
            newClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(targetClassName, GlobalSearchScope.projectScope((Project)this.myProject));
            if (newClass == null) {
                if (Messages.showOkCancelDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"class.does.not.exist.in.the.project"), (String)IntroduceConstantHandler.REFACTORING_NAME, (Icon)Messages.getErrorIcon()) != 0) {
                    return;
                }
                this.myDestinationClass = new BaseExpressionToFieldHandler.TargetDestination(targetClassName, this.myParentClass);
            } else {
                this.myDestinationClass = new BaseExpressionToFieldHandler.TargetDestination(newClass);
            }
        }
        String fieldName = this.getEnteredName();
        String errorString = null;
        if ("".equals(fieldName)) {
            errorString = RefactoringBundle.message((String)"no.field.name.specified");
        } else if (!PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(fieldName)) {
            errorString = RefactoringMessageUtil.getIncorrectIdentifierMessage(fieldName);
        } else if (newClass != null && !this.myParentClass.getLanguage().equals(newClass.getLanguage())) {
            errorString = RefactoringBundle.message((String)"move.to.different.language", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)this.myParentClass), this.myParentClass.getQualifiedName(), newClass.getQualifiedName()});
        }
        if (errorString != null) {
            CommonRefactoringUtil.showErrorMessage((String)IntroduceFieldHandler.REFACTORING_NAME, (String)errorString, (String)"refactoring.introduceField", (Project)this.myProject);
            return;
        }
        if (newClass != null && (oldField = newClass.findFieldByName(fieldName, true)) != null && (answer = Messages.showYesNoDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"field.exists", (Object[])new Object[]{fieldName, oldField.getContainingClass().getQualifiedName()}), (String)IntroduceFieldHandler.REFACTORING_NAME, (Icon)Messages.getWarningIcon())) != 0) {
            return;
        }
        JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_VISIBILITY = this.getFieldVisibility();
        RecentsManager.getInstance(this.myProject).registerRecentEntry(RECENTS_KEY, targetClassName);
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField.getFocusableComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        StateRestoringCheckBox stateRestoringCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JLabel jLabel;
        JPanel jPanel3;
        JLabel jLabel2;
        JPanel jPanel4;
        JLabel jLabel3;
        JPanel jPanel5;
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTypeLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/RefactoringBundle").getString("introduce.constant.field.of.type"));
        jPanel6.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTypePanel = jPanel4 = new JPanel();
        jPanel6.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myNameSuggestionLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("name.prompt"));
        jPanel7.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameSuggestionPanel = jPanel3 = new JPanel();
        jPanel7.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myTargetClassNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/RefactoringBundle").getString("introduce.constant.introduce.to.class"));
        jPanel5.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTargetClassNamePanel = jPanel2 = new JPanel();
        jPanel5.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myCbReplaceAll = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("replace.all.occurences.checkbox"));
        jCheckBox2.setSelected(true);
        jCheckBox2.setFocusable(false);
        jPanel5.add((Component)jCheckBox2, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbDeleteVariable = stateRestoringCheckBox = new StateRestoringCheckBox();
        this.$$$loadButtonText$$$(stateRestoringCheckBox, ResourceBundle.getBundle("messages/RefactoringBundle").getString("delete.variable.declaration"));
        jPanel5.add((Component)stateRestoringCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbNonNls = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/RefactoringBundle").getString("annotate.field.as.nonnls.checkbox"));
        jCheckBox.setSelected(false);
        jPanel5.add((Component)jCheckBox, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myVisibilityPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class ChooseClassAction
    implements ActionListener {
        private ChooseClassAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)IntroduceConstantDialog.this.myProject).createWithInnerClassesScopeChooser(RefactoringBundle.message((String)"choose.destination.class"), GlobalSearchScope.projectScope((Project)IntroduceConstantDialog.this.myProject), new ClassFilter(){

                public boolean isAccepted(PsiClass aClass) {
                    return aClass.getParent() instanceof PsiJavaFile || aClass.hasModifierProperty("static");
                }
            }, null);
            if (IntroduceConstantDialog.this.myTargetClass != null) {
                chooser.selectDirectory(IntroduceConstantDialog.this.myTargetClass.getContainingFile().getContainingDirectory());
            }
            chooser.showDialog();
            PsiClass aClass = chooser.getSelected();
            if (aClass != null) {
                IntroduceConstantDialog.this.myTfTargetClassName.setText(aClass.getQualifiedName());
            }
        }
    }
}

