/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsGroup;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseToolManager<T extends Tool>
implements ExportableApplicationComponent {
    @NotNull
    private final ActionManagerEx myActionManager;
    private final SchemesManager<ToolsGroup<T>, ToolsGroup<T>> mySchemesManager;

    public BaseToolManager(@NotNull ActionManagerEx actionManagerEx, SchemesManagerFactory factory) {
        if (actionManagerEx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManagerEx", "com/intellij/tools/BaseToolManager", "<init>"));
        }
        this.myActionManager = actionManagerEx;
        this.mySchemesManager = factory.createSchemesManager(this.getSchemesPath(), this.createProcessor(), RoamingType.PER_USER);
        this.mySchemesManager.loadSchemes();
        this.registerActions();
    }

    protected abstract String getSchemesPath();

    protected abstract SchemeProcessor<ToolsGroup<T>> createProcessor();

    @Nullable
    public static String convertString(String s) {
        return StringUtil.nullize((String)s, (boolean)true);
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{this.mySchemesManager.getRootDirectory()};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/BaseToolManager", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = ToolsBundle.message("tools.settings", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/BaseToolManager", "getPresentableName"));
        }
        return string;
    }

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    public List<T> getTools() {
        SmartList result = new SmartList();
        for (ToolsGroup group : this.mySchemesManager.getAllSchemes()) {
            result.addAll(group.getElements());
        }
        return result;
    }

    @NotNull
    public List<T> getTools(@NotNull String group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/tools/BaseToolManager", "getTools"));
        }
        ToolsGroup groupByName = (ToolsGroup)this.mySchemesManager.findSchemeByName(group);
        if (groupByName == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/BaseToolManager", "getTools"));
            }
            return list;
        }
        List list = groupByName.getElements();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/BaseToolManager", "getTools"));
        }
        return list;
    }

    public String getGroupByActionId(String actionId) {
        for (Tool tool : this.getTools()) {
            if (!Comparing.equal((String)actionId, (String)tool.getActionId())) continue;
            return tool.getGroup();
        }
        return null;
    }

    public List<ToolsGroup<T>> getGroups() {
        return this.mySchemesManager.getAllSchemes();
    }

    public void setTools(ToolsGroup[] tools) {
        this.mySchemesManager.clearAllSchemes();
        for (ToolsGroup newGroup : tools) {
            this.mySchemesManager.addNewScheme((Scheme)newGroup, true);
        }
        this.registerActions();
    }

    void registerActions() {
        this.unregisterActions();
        THashSet registeredIds = new THashSet();
        List<T> tools = this.getTools();
        for (Tool tool : tools) {
            String actionId = tool.getActionId();
            if (!registeredIds.add(actionId)) continue;
            this.myActionManager.registerAction(actionId, (AnAction)this.createToolAction(tool));
        }
    }

    @NotNull
    protected ToolAction createToolAction(@NotNull T tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/tools/BaseToolManager", "createToolAction"));
        }
        ToolAction toolAction = new ToolAction((Tool)tool);
        if (toolAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/BaseToolManager", "createToolAction"));
        }
        return toolAction;
    }

    protected abstract String getActionIdPrefix();

    private void unregisterActions() {
        for (String oldId : this.myActionManager.getActionIds(this.getActionIdPrefix())) {
            this.myActionManager.unregisterAction(oldId);
        }
    }
}

