/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.util;

import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.ui.popup.util.ItemWrapper;
import com.intellij.ui.popup.util.MasterController;
import com.intellij.util.Alarm;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.ListSelectionModel;

public class DetailController {
    private final MasterController myMasterController;
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private DetailView myDetailView;
    private ItemWrapper mySelectedItem;

    public DetailController(MasterController myMasterController) {
        this.myMasterController = myMasterController;
    }

    protected void doUpdateDetailViewWithItem(ItemWrapper wrapper1) {
        if (wrapper1 != null) {
            wrapper1.updateDetailView(this.myDetailView);
        } else {
            this.myDetailView.clearEditor();
            this.myDetailView.setPropertiesPanel(null);
            this.myDetailView.setCurrentItem(null);
        }
    }

    private String getTitle2Text(String fullText) {
        int labelWidth = this.getLabel().getWidth();
        if (fullText == null || fullText.length() == 0) {
            return " ";
        }
        while (this.getLabel().getFontMetrics(this.getLabel().getFont()).stringWidth(fullText) > labelWidth) {
            int sep = fullText.indexOf(File.separatorChar, 4);
            if (sep < 0) {
                return fullText;
            }
            fullText = "..." + fullText.substring(sep);
        }
        return fullText;
    }

    private JLabel getLabel() {
        return this.myMasterController.getPathLabel();
    }

    public ItemWrapper getSelectedItem() {
        return this.mySelectedItem;
    }

    public void doUpdateDetailView(boolean now) {
        ItemWrapper[] values = this.myMasterController.getSelectedItems();
        ItemWrapper wrapper = null;
        if (values != null && values.length == 1) {
            wrapper = values[0];
            this.getLabel().setText(this.getTitle2Text(wrapper.footerText()));
        } else {
            this.getLabel().setText(" ");
        }
        this.mySelectedItem = wrapper;
        this.myUpdateAlarm.cancelAllRequests();
        if (now) {
            this.doUpdateDetailViewWithItem(this.mySelectedItem);
        } else {
            this.myUpdateAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    DetailController.this.doUpdateDetailViewWithItem(DetailController.this.mySelectedItem);
                    DetailController.this.myUpdateAlarm.cancelAllRequests();
                }
            }, 100);
        }
    }

    public void updateDetailView() {
        this.doUpdateDetailView(false);
    }

    public void setList(JBList list) {
        ListSelectionModel listSelectionModel = list.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        if (list.getModel().getSize() == 0) {
            list.clearSelection();
        }
    }

    public void setDetailView(DetailView detailView) {
        this.myDetailView = detailView;
    }
}

