/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTemplateStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowUtils {
    private ControlFlowUtils() {
    }

    public static boolean statementMayCompleteNormally(@Nullable PsiStatement statement) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiReturnStatement || statement instanceof PsiThrowStatement) {
            return false;
        }
        if (statement instanceof PsiExpressionListStatement || statement instanceof PsiEmptyStatement || statement instanceof PsiAssertStatement || statement instanceof PsiDeclarationStatement || statement instanceof PsiSwitchLabelStatement || statement instanceof PsiForeachStatement) {
            return true;
        }
        if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return true;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return true;
            }
            String methodName = method.getName();
            if (!methodName.equals("exit")) {
                return true;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return true;
            }
            String className = aClass.getQualifiedName();
            return !"java.lang.System".equals(className);
        }
        if (statement instanceof PsiForStatement) {
            return ControlFlowUtils.forStatementMayCompleteNormally((PsiForStatement)statement);
        }
        if (statement instanceof PsiWhileStatement) {
            return ControlFlowUtils.whileStatementMayCompleteNormally((PsiWhileStatement)statement);
        }
        if (statement instanceof PsiDoWhileStatement) {
            return ControlFlowUtils.doWhileStatementMayCompleteNormally((PsiDoWhileStatement)statement);
        }
        if (statement instanceof PsiSynchronizedStatement) {
            PsiCodeBlock body = ((PsiSynchronizedStatement)statement).getBody();
            return ControlFlowUtils.codeBlockMayCompleteNormally(body);
        }
        if (statement instanceof PsiBlockStatement) {
            PsiCodeBlock codeBlock = ((PsiBlockStatement)statement).getCodeBlock();
            return ControlFlowUtils.codeBlockMayCompleteNormally(codeBlock);
        }
        if (statement instanceof PsiLabeledStatement) {
            return ControlFlowUtils.labeledStatementMayCompleteNormally((PsiLabeledStatement)statement);
        }
        if (statement instanceof PsiIfStatement) {
            return ControlFlowUtils.ifStatementMayCompleteNormally((PsiIfStatement)statement);
        }
        if (statement instanceof PsiTryStatement) {
            return ControlFlowUtils.tryStatementMayCompleteNormally((PsiTryStatement)statement);
        }
        if (statement instanceof PsiSwitchStatement) {
            return ControlFlowUtils.switchStatementMayCompleteNormally((PsiSwitchStatement)statement);
        }
        if (statement instanceof PsiTemplateStatement || statement instanceof PsiClassLevelDeclarationStatement) {
            return true;
        }
        assert (false) : "unknown statement type: " + statement.getClass();
        return true;
    }

    private static boolean doWhileStatementMayCompleteNormally(@NotNull PsiDoWhileStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "doWhileStatementMayCompleteNormally"));
        }
        PsiExpression condition = loopStatement.getCondition();
        Object value = ExpressionUtils.computeConstantExpression(condition);
        PsiStatement body = loopStatement.getBody();
        return ControlFlowUtils.statementMayCompleteNormally(body) && value != Boolean.TRUE || ControlFlowUtils.statementIsBreakTarget((PsiStatement)loopStatement) || ControlFlowUtils.statementContainsContinueToAncestor((PsiStatement)loopStatement);
    }

    private static boolean whileStatementMayCompleteNormally(@NotNull PsiWhileStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "whileStatementMayCompleteNormally"));
        }
        PsiExpression condition = loopStatement.getCondition();
        Object value = ExpressionUtils.computeConstantExpression(condition);
        return value != Boolean.TRUE || ControlFlowUtils.statementIsBreakTarget((PsiStatement)loopStatement) || ControlFlowUtils.statementContainsContinueToAncestor((PsiStatement)loopStatement);
    }

    private static boolean forStatementMayCompleteNormally(@NotNull PsiForStatement loopStatement) {
        if (loopStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "forStatementMayCompleteNormally"));
        }
        if (ControlFlowUtils.statementIsBreakTarget((PsiStatement)loopStatement)) {
            return true;
        }
        if (ControlFlowUtils.statementContainsContinueToAncestor((PsiStatement)loopStatement)) {
            return true;
        }
        PsiExpression condition = loopStatement.getCondition();
        if (condition == null) {
            return false;
        }
        Object value = ExpressionUtils.computeConstantExpression(condition);
        return Boolean.TRUE != value;
    }

    private static boolean switchStatementMayCompleteNormally(@NotNull PsiSwitchStatement switchStatement) {
        if (switchStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "switchStatementMayCompleteNormally"));
        }
        if (ControlFlowUtils.statementIsBreakTarget((PsiStatement)switchStatement)) {
            return true;
        }
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return true;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            return true;
        }
        int numCases = 0;
        boolean hasDefaultCase = false;
        for (PsiStatement statement : statements) {
            PsiBreakStatement breakStatement;
            PsiSwitchLabelStatement switchLabelStatement;
            if (statement instanceof PsiSwitchLabelStatement && (switchLabelStatement = (PsiSwitchLabelStatement)statement).isDefaultCase()) {
                hasDefaultCase = true;
            }
            if (statement instanceof PsiBreakStatement && (breakStatement = (PsiBreakStatement)statement).getLabelIdentifier() == null) {
                return true;
            }
            ++numCases;
        }
        boolean isEnum = ControlFlowUtils.isEnumSwitch(switchStatement);
        if (!hasDefaultCase && !isEnum) {
            return true;
        }
        if (!hasDefaultCase && isEnum) {
            PsiExpression expression = switchStatement.getExpression();
            if (expression == null) {
                return true;
            }
            PsiClassType type = (PsiClassType)expression.getType();
            if (type == null) {
                return true;
            }
            PsiClass aClass = type.resolve();
            if (aClass == null) {
                return true;
            }
            PsiField[] fields = aClass.getFields();
            int numEnums = 0;
            for (PsiField field : fields) {
                PsiType fieldType = field.getType();
                if (!fieldType.equals(type)) continue;
                ++numEnums;
            }
            if (numEnums != numCases) {
                return true;
            }
        }
        return ControlFlowUtils.statementMayCompleteNormally(statements[statements.length - 1]);
    }

    private static boolean isEnumSwitch(PsiSwitchStatement statement) {
        PsiExpression expression = statement.getExpression();
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass aClass = ((PsiClassType)type).resolve();
        if (aClass == null) {
            return false;
        }
        return aClass.isEnum();
    }

    private static boolean tryStatementMayCompleteNormally(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock[] catchBlocks;
        if (tryStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "tryStatementMayCompleteNormally"));
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null && !ControlFlowUtils.codeBlockMayCompleteNormally(finallyBlock)) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (ControlFlowUtils.codeBlockMayCompleteNormally(tryBlock)) {
            return true;
        }
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            if (!ControlFlowUtils.codeBlockMayCompleteNormally(catchBlock)) continue;
            return true;
        }
        return false;
    }

    private static boolean ifStatementMayCompleteNormally(@NotNull PsiIfStatement ifStatement) {
        if (ifStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "ifStatementMayCompleteNormally"));
        }
        PsiExpression condition = ifStatement.getCondition();
        Object value = ExpressionUtils.computeConstantExpression(condition);
        PsiStatement thenBranch = ifStatement.getThenBranch();
        boolean thenCompletesNormally = ControlFlowUtils.statementMayCompleteNormally(thenBranch);
        if (value == Boolean.TRUE) {
            return thenCompletesNormally;
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        boolean elseCompletesNormally = ControlFlowUtils.statementMayCompleteNormally(elseBranch);
        if (value == Boolean.FALSE) {
            return elseCompletesNormally;
        }
        return thenCompletesNormally || elseCompletesNormally;
    }

    private static boolean labeledStatementMayCompleteNormally(@NotNull PsiLabeledStatement labeledStatement) {
        if (labeledStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labeledStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "labeledStatementMayCompleteNormally"));
        }
        PsiStatement statement = labeledStatement.getStatement();
        if (statement == null) {
            return false;
        }
        return ControlFlowUtils.statementMayCompleteNormally(statement) || ControlFlowUtils.statementIsBreakTarget(statement);
    }

    public static boolean codeBlockMayCompleteNormally(@Nullable PsiCodeBlock block) {
        PsiStatement[] statements;
        if (block == null) {
            return true;
        }
        for (PsiStatement statement : statements = block.getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) continue;
            return false;
        }
        return true;
    }

    private static boolean statementIsBreakTarget(@NotNull PsiStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementIsBreakTarget"));
        }
        BreakFinder breakFinder = new BreakFinder(statement);
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    private static boolean statementContainsContinueToAncestor(@NotNull PsiStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementContainsContinueToAncestor"));
        }
        PsiElement parent = statement.getParent();
        while (parent instanceof PsiLabeledStatement) {
            statement = (PsiStatement)parent;
            parent = parent.getParent();
        }
        ContinueToAncestorFinder continueToAncestorFinder = new ContinueToAncestorFinder(statement);
        statement.accept((PsiElementVisitor)continueToAncestorFinder);
        return continueToAncestorFinder.continueToAncestorFound();
    }

    public static boolean statementContainsReturn(@NotNull PsiStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementContainsReturn"));
        }
        ReturnFinder returnFinder = new ReturnFinder();
        statement.accept((PsiElementVisitor)returnFinder);
        return returnFinder.returnFound();
    }

    public static boolean statementIsContinueTarget(@NotNull PsiStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementIsContinueTarget"));
        }
        ContinueFinder continueFinder = new ContinueFinder(statement);
        statement.accept((PsiElementVisitor)continueFinder);
        return continueFinder.continueFound();
    }

    public static boolean statementContainsSystemExit(@NotNull PsiStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementContainsSystemExit"));
        }
        SystemExitFinder systemExitFinder = new SystemExitFinder();
        statement.accept((PsiElementVisitor)systemExitFinder);
        return systemExitFinder.exitFound();
    }

    public static boolean elementContainsCallToMethod(PsiElement context, String containingClassName, PsiType returnType, String methodName, PsiType ... parameterTypes) {
        MethodCallFinder methodCallFinder = new MethodCallFinder(containingClassName, returnType, methodName, parameterTypes);
        context.accept((PsiElementVisitor)methodCallFinder);
        return methodCallFinder.containsCallToMethod();
    }

    public static boolean isInLoop(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInLoop"));
        }
        PsiLoopStatement loopStatement = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLoopStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
        if (loopStatement == null) {
            return false;
        }
        PsiStatement body = loopStatement.getBody();
        if (body == null) {
            return false;
        }
        return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true);
    }

    public static boolean isInFinallyBlock(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInFinallyBlock"));
        }
        PsiElement currentElement = element;
        PsiTryStatement tryStatement;
        while ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) != null) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock != null && PsiTreeUtil.isAncestor((PsiElement)finallyBlock, (PsiElement)currentElement, (boolean)true)) {
                PsiMethod elementMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiMethod.class);
                PsiMethod finallyMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)finallyBlock, PsiMethod.class);
                return elementMethod != null && elementMethod.equals(finallyMethod);
            }
            currentElement = tryStatement;
        }
        return false;
    }

    public static boolean isInCatchBlock(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInCatchBlock"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiCatchSection.class, (boolean)true, (Class[])new Class[]{PsiClass.class}) != null;
    }

    public static boolean isInExitStatement(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInExitStatement"));
        }
        return ControlFlowUtils.isInReturnStatementArgument(expression) || ControlFlowUtils.isInThrowStatementArgument(expression);
    }

    private static boolean isInReturnStatementArgument(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInReturnStatementArgument"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)expression, PsiReturnStatement.class) != null;
    }

    private static boolean isInThrowStatementArgument(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ControlFlowUtils", "isInThrowStatementArgument"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)expression, PsiThrowStatement.class) != null;
    }

    @Nullable
    public static PsiStatement stripBraces(@Nullable PsiStatement statement) {
        if (statement instanceof PsiBlockStatement) {
            PsiBlockStatement block = (PsiBlockStatement)statement;
            PsiCodeBlock codeBlock = block.getCodeBlock();
            PsiStatement[] statements = codeBlock.getStatements();
            if (statements.length == 1) {
                return statements[0];
            }
            return block;
        }
        return statement;
    }

    public static boolean statementCompletesWithStatement(@NotNull PsiStatement containingStatement, @NotNull PsiStatement statement) {
        if (containingStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingStatement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementCompletesWithStatement"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementCompletesWithStatement"));
        }
        PsiStatement statementToCheck = statement;
        while (!statementToCheck.equals(containingStatement)) {
            PsiElement container = ControlFlowUtils.getContainingStatementOrBlock((PsiElement)statementToCheck);
            if (container == null) {
                return false;
            }
            if (container instanceof PsiCodeBlock && !ControlFlowUtils.statementIsLastInBlock((PsiCodeBlock)container, statementToCheck)) {
                return false;
            }
            if (container instanceof PsiLoopStatement) {
                return false;
            }
            statementToCheck = container;
        }
        return true;
    }

    public static boolean blockCompletesWithStatement(@NotNull PsiCodeBlock body, @NotNull PsiStatement statement) {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/siyeh/ig/psiutils/ControlFlowUtils", "blockCompletesWithStatement"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "blockCompletesWithStatement"));
        }
        PsiStatement statementToCheck = statement;
        while (statementToCheck != null) {
            PsiElement container = ControlFlowUtils.getContainingStatementOrBlock((PsiElement)statementToCheck);
            if (container == null) {
                return false;
            }
            if (container instanceof PsiLoopStatement) {
                return false;
            }
            if (container instanceof PsiCodeBlock) {
                if (!ControlFlowUtils.statementIsLastInBlock((PsiCodeBlock)container, statementToCheck)) {
                    return false;
                }
                if (container.equals(body)) {
                    return true;
                }
                statementToCheck = PsiTreeUtil.getParentOfType((PsiElement)container, PsiStatement.class);
                continue;
            }
            statementToCheck = container;
        }
        return false;
    }

    @Nullable
    private static PsiElement getContainingStatementOrBlock(@NotNull PsiElement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "getContainingStatementOrBlock"));
        }
        return PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiStatement.class, PsiCodeBlock.class});
    }

    private static boolean statementIsLastInBlock(@NotNull PsiCodeBlock block, @NotNull PsiStatement statement) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementIsLastInBlock"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils", "statementIsLastInBlock"));
        }
        PsiStatement[] statements = block.getStatements();
        for (int i = statements.length - 1; i >= 0; --i) {
            PsiStatement childStatement = statements[i];
            if (statement.equals(childStatement)) {
                return true;
            }
            if (statement instanceof PsiEmptyStatement) continue;
            return false;
        }
        return false;
    }

    public static boolean methodAlwaysThrowsException(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/psiutils/ControlFlowUtils", "methodAlwaysThrowsException"));
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return true;
        }
        ReturnFinder returnFinder = new ReturnFinder();
        body.accept((PsiElementVisitor)returnFinder);
        if (returnFinder.returnFound()) {
            return false;
        }
        return !ControlFlowUtils.codeBlockMayCompleteNormally(body);
    }

    public static boolean statementContainsNakedBreak(PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        NakedBreakFinder breakFinder = new NakedBreakFinder();
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    private static class ContinueToAncestorFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiStatement statement;
        private boolean found = false;

        public ContinueToAncestorFinder(PsiStatement statement) {
            this.statement = statement;
        }

        public void visitElement(PsiElement element) {
            if (this.found) {
                return;
            }
            super.visitElement(element);
        }

        public void visitContinueStatement(PsiContinueStatement continueStatement) {
            if (this.found) {
                return;
            }
            super.visitContinueStatement(continueStatement);
            PsiIdentifier labelIdentifier = continueStatement.getLabelIdentifier();
            if (labelIdentifier == null) {
                return;
            }
            PsiStatement continuedStatement = continueStatement.findContinuedStatement();
            if (continuedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)continuedStatement, (PsiElement)this.statement, (boolean)true)) {
                this.found = true;
            }
        }

        public boolean continueToAncestorFound() {
            return this.found;
        }
    }

    private static class MethodCallFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final String containingClassName;
        private final PsiType returnType;
        private final String methodName;
        private final PsiType[] parameterTypeNames;
        private boolean containsCallToMethod = false;

        MethodCallFinder(String containingClassName, PsiType returnType, String methodName, PsiType ... parameterTypeNames) {
            this.containingClassName = containingClassName;
            this.returnType = returnType;
            this.methodName = methodName;
            this.parameterTypeNames = parameterTypeNames;
        }

        public void visitElement(PsiElement element) {
            if (this.containsCallToMethod) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.containsCallToMethod) {
                return;
            }
            super.visitMethodCallExpression(expression);
            if (!MethodCallUtils.isCallToMethod(expression, this.containingClassName, this.returnType, this.methodName, this.parameterTypeNames)) {
                return;
            }
            this.containsCallToMethod = true;
        }

        public boolean containsCallToMethod() {
            return this.containsCallToMethod;
        }
    }

    private static class ContinueFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;
        private final PsiStatement m_target;

        private ContinueFinder(@NotNull PsiStatement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/siyeh/ig/psiutils/ControlFlowUtils$ContinueFinder", "<init>"));
            }
            this.m_found = false;
            this.m_target = target;
        }

        public boolean continueFound() {
            return this.m_found;
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils$ContinueFinder", "visitContinueStatement"));
            }
            if (this.m_found) {
                return;
            }
            super.visitContinueStatement(statement);
            PsiStatement continuedStatement = statement.findContinuedStatement();
            if (continuedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)continuedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }

        public void visitIfStatement(PsiIfStatement statement) {
            PsiStatement elseBranch;
            PsiStatement thenBranch;
            if (this.m_found) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            Object value = ExpressionUtils.computeConstantExpression(condition);
            if (Boolean.FALSE != value && (thenBranch = statement.getThenBranch()) != null) {
                thenBranch.accept((PsiElementVisitor)this);
            }
            if (Boolean.TRUE != value && (elseBranch = statement.getElseBranch()) != null) {
                elseBranch.accept((PsiElementVisitor)this);
            }
        }
    }

    private static class BreakFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;
        private final PsiStatement m_target;

        private BreakFinder(@NotNull PsiStatement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/siyeh/ig/psiutils/ControlFlowUtils$BreakFinder", "<init>"));
            }
            this.m_found = false;
            this.m_target = target;
        }

        public boolean breakFound() {
            return this.m_found;
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ControlFlowUtils$BreakFinder", "visitBreakStatement"));
            }
            if (this.m_found) {
                return;
            }
            super.visitBreakStatement(statement);
            PsiStatement exitedStatement = statement.findExitedStatement();
            if (exitedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)this.m_target, (boolean)false)) {
                this.m_found = true;
            }
        }

        public void visitIfStatement(PsiIfStatement statement) {
            PsiStatement elseBranch;
            PsiStatement thenBranch;
            if (this.m_found) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            Object value = ExpressionUtils.computeConstantExpression(condition);
            if (Boolean.FALSE != value && (thenBranch = statement.getThenBranch()) != null) {
                thenBranch.accept((PsiElementVisitor)this);
            }
            if (Boolean.TRUE != value && (elseBranch = statement.getElseBranch()) != null) {
                elseBranch.accept((PsiElementVisitor)this);
            }
        }
    }

    private static class ReturnFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found = false;

        private ReturnFinder() {
        }

        public boolean returnFound() {
            return this.m_found;
        }

        public void visitClass(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/siyeh/ig/psiutils/ControlFlowUtils$ReturnFinder", "visitClass"));
            }
        }

        public void visitLambdaExpression(PsiLambdaExpression expression) {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
            if (returnStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "com/siyeh/ig/psiutils/ControlFlowUtils$ReturnFinder", "visitReturnStatement"));
            }
            if (this.m_found) {
                return;
            }
            super.visitReturnStatement(returnStatement);
            this.m_found = true;
        }
    }

    private static class SystemExitFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found = false;

        private SystemExitFinder() {
        }

        public boolean exitFound() {
            return this.m_found;
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/ControlFlowUtils$SystemExitFinder", "visitClass"));
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ControlFlowUtils$SystemExitFinder", "visitMethodCallExpression"));
            }
            if (this.m_found) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            String methodName = method.getName();
            if (!methodName.equals("exit")) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (!"java.lang.System".equals(className) && !"java.lang.Runtime".equals(className)) {
                return;
            }
            this.m_found = true;
        }
    }

    private static class NakedBreakFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found = false;

        private NakedBreakFinder() {
        }

        public boolean breakFound() {
            return this.m_found;
        }

        public void visitElement(PsiElement element) {
            if (this.m_found) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
        }

        public void visitBreakStatement(PsiBreakStatement statement) {
            if (statement.getLabelIdentifier() != null) {
                return;
            }
            this.m_found = true;
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        }

        public void visitForStatement(PsiForStatement statement) {
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
        }

        public void visitSwitchStatement(PsiSwitchStatement statement) {
        }
    }
}

