/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AutoCloseableResourceInspectionBase
extends BaseInspection {
    public boolean ignoreFromMethodCall = false;
    final List<String> ignoredTypes = new ArrayList<String>(Arrays.asList("java.util.stream.Stream"));

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("auto.closeable.resource.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("resource" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase", "getID"));
        }
        return "resource";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        PsiType type = expression.getType();
        assert (type != null);
        String text = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("auto.closeable.resource.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase", "buildErrorString"));
        }
        return string;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase", "readSettings"));
        }
        super.readSettings(node);
        for (Element option : node.getChildren("option")) {
            String ignoredTypesString;
            String name = option.getAttributeValue("name");
            if (!"ignoredTypes".equals(name) || (ignoredTypesString = option.getAttributeValue("value")) == null) continue;
            this.ignoredTypes.clear();
            AutoCloseableResourceInspectionBase.parseString(ignoredTypesString, this.ignoredTypes);
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase", "writeSettings"));
        }
        super.writeSettings(node);
        String ignoredTypesString = AutoCloseableResourceInspectionBase.formatString(this.ignoredTypes);
        if (!"java.util.stream.Stream".equals(ignoredTypesString)) {
            node.addContent(new Element("option").setAttribute("name", "ignoredTypes").setAttribute("value", ignoredTypesString));
        }
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel7OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AutoCloseableResourceVisitor();
    }

    private class AutoCloseableResourceVisitor
    extends BaseInspectionVisitor {
        private AutoCloseableResourceVisitor() {
        }

        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            if (!this.isNotSafelyClosedResource((PsiExpression)expression)) {
                return;
            }
            this.registerNewExpressionError(expression, expression);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (AutoCloseableResourceInspectionBase.this.ignoreFromMethodCall) {
                return;
            }
            if (!this.isNotSafelyClosedResource((PsiExpression)expression)) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }

        private boolean isNotSafelyClosedResource(PsiExpression expression) {
            if (!TypeUtils.expressionHasTypeOrSubtype(expression, "java.lang.AutoCloseable")) {
                return false;
            }
            if (TypeUtils.expressionHasTypeOrSubtype(expression, AutoCloseableResourceInspectionBase.this.ignoredTypes)) {
                return false;
            }
            PsiVariable variable = ResourceInspection.getVariable(expression);
            return !(variable instanceof PsiResourceVariable) && !ResourceInspection.isResourceEscapingFromMethod(variable, expression);
        }
    }
}

