/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.ThreeState;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueNode;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.MemberFilterBase;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.ValueModifierUtil;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

public class BasicDebuggerViewSupport
extends MemberFilterBase
implements DebuggerViewSupport {
    protected final Promise<MemberFilter> defaultMemberFilterPromise = Promise.resolve((Object)this);
    public static final DebuggerViewSupport INSTANCE = new BasicDebuggerViewSupport();

    @Override
    @Nullable
    public SourceInfo getSourceInfo(@Nullable Script script, @NotNull CallFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "org/jetbrains/debugger/BasicDebuggerViewSupport", "getSourceInfo"));
        }
        return null;
    }

    @Override
    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull String scriptUrl, int line, int column) {
        if (scriptUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptUrl", "org/jetbrains/debugger/BasicDebuggerViewSupport", "getSourceInfo"));
        }
        return null;
    }

    @Override
    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull Script script, int line, int column) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/debugger/BasicDebuggerViewSupport", "getSourceInfo"));
        }
        return null;
    }

    @Override
    public Vm getVm() {
        return null;
    }

    @Override
    @NotNull
    public String propertyNamesToString(@NotNull List<String> list, boolean quotedAware) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/debugger/BasicDebuggerViewSupport", "propertyNamesToString"));
        }
        String string = ValueModifierUtil.propertyNamesToString(list, quotedAware);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/BasicDebuggerViewSupport", "propertyNamesToString"));
        }
        return string;
    }

    @Override
    public void computeObjectPresentation(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeObjectPresentation"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeObjectPresentation"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeObjectPresentation"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeObjectPresentation"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeObjectPresentation"));
        }
        VariableView.setObjectPresentation(value, icon, node);
    }

    @Override
    public void computeArrayPresentation(@NotNull Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeArrayPresentation"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeArrayPresentation"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeArrayPresentation"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeArrayPresentation"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeArrayPresentation"));
        }
        VariableView.setArrayPresentation(value, context, icon, node);
    }

    @Override
    @NotNull
    public XDebuggerEvaluator createFrameEvaluator(@NotNull CallFrameView frameView) {
        if (frameView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameView", "org/jetbrains/debugger/BasicDebuggerViewSupport", "createFrameEvaluator"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canNavigateToSource(@NotNull Variable variable, @NotNull VariableContext context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/debugger/BasicDebuggerViewSupport", "canNavigateToSource"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/BasicDebuggerViewSupport", "canNavigateToSource"));
        }
        return false;
    }

    @Override
    public void computeSourcePosition(@NotNull String name, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XNavigatable navigatable) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeSourcePosition"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeSourcePosition"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeSourcePosition"));
        }
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeSourcePosition"));
        }
    }

    @Override
    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull String name, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XInlineDebuggerDataCallback callback) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeInlineDebuggerData"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeInlineDebuggerData"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeInlineDebuggerData"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeInlineDebuggerData"));
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeInlineDebuggerData"));
        }
        return threeState;
    }

    @Override
    @Nullable
    public Promise<Void> computeAdditionalObjectProperties(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XCompositeNode node) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeAdditionalObjectProperties"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeAdditionalObjectProperties"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeAdditionalObjectProperties"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/BasicDebuggerViewSupport", "computeAdditionalObjectProperties"));
        }
        return null;
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter(@NotNull VariableContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/BasicDebuggerViewSupport", "getMemberFilter"));
        }
        Promise<MemberFilter> promise = this.defaultMemberFilterPromise;
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/BasicDebuggerViewSupport", "getMemberFilter"));
        }
        return promise;
    }

    @NotNull
    public List<Variable> getAdditionalVariables() {
        List<Variable> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/BasicDebuggerViewSupport", "getAdditionalVariables"));
        }
        return list;
    }

    @Override
    @Nullable
    public Value transformErrorOnGetUsedReferenceValue(@Nullable Value value, @Nullable String error) {
        return value;
    }

    @Override
    public boolean isInLibraryContent(@NotNull SourceInfo sourceInfo, @Nullable Script script) {
        if (sourceInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceInfo", "org/jetbrains/debugger/BasicDebuggerViewSupport", "isInLibraryContent"));
        }
        return false;
    }
}

