/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.DefaultJavaProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import org.jetbrains.annotations.NotNull;

public class JavaCommandLineStateUtil {
    private JavaCommandLineStateUtil() {
    }

    @NotNull
    public static OSProcessHandler startProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/configurations/JavaCommandLineStateUtil", "startProcess"));
        }
        OSProcessHandler oSProcessHandler = JavaCommandLineStateUtil.startProcess(commandLine, false);
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/JavaCommandLineStateUtil", "startProcess"));
        }
        return oSProcessHandler;
    }

    @NotNull
    public static OSProcessHandler startProcess(@NotNull GeneralCommandLine commandLine, boolean ansiColoring) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/configurations/JavaCommandLineStateUtil", "startProcess"));
        }
        OSProcessHandler processHandler = ansiColoring ? new ColoredProcessHandler(commandLine) : new DefaultJavaProcessHandler(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        OSProcessHandler oSProcessHandler = processHandler;
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/JavaCommandLineStateUtil", "startProcess"));
        }
        return oSProcessHandler;
    }
}

