/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ColoredProcessHandler
extends OSProcessHandler
implements AnsiEscapeDecoder.ColoredTextAcceptor {
    private final AnsiEscapeDecoder myAnsiEscapeDecoder;
    private final List<AnsiEscapeDecoder.ColoredTextAcceptor> myColoredTextListeners;

    public ColoredProcessHandler(GeneralCommandLine commandLine) throws ExecutionException {
        super(commandLine.createProcess(), commandLine.getCommandLineString(), commandLine.getCharset());
        this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        this.myColoredTextListeners = ContainerUtil.newArrayList();
        this.setHasPty(commandLine instanceof PtyCommandLine);
    }

    public ColoredProcessHandler(Process process, String commandLine) {
        super(process, commandLine);
        this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        this.myColoredTextListeners = ContainerUtil.newArrayList();
    }

    public ColoredProcessHandler(Process process, String commandLine, @NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/execution/process/ColoredProcessHandler", "<init>"));
        }
        super(process, commandLine, charset);
        this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        this.myColoredTextListeners = ContainerUtil.newArrayList();
    }

    public final void notifyTextAvailable(String text, Key outputType) {
        this.myAnsiEscapeDecoder.escapeText(text, outputType, this);
    }

    @Override
    public void coloredTextAvailable(String text, Key attributes) {
        this.textAvailable(text, attributes);
        this.notifyColoredListeners(text, attributes);
    }

    protected void notifyColoredListeners(String text, Key attributes) {
        for (AnsiEscapeDecoder.ColoredTextAcceptor listener : this.myColoredTextListeners) {
            listener.coloredTextAvailable(text, attributes);
        }
    }

    public void addColoredTextListener(AnsiEscapeDecoder.ColoredTextAcceptor listener) {
        this.myColoredTextListeners.add(listener);
    }

    public void removeColoredTextListener(AnsiEscapeDecoder.ColoredTextAcceptor listener) {
        this.myColoredTextListeners.remove(listener);
    }

    protected void textAvailable(String text, Key attributes) {
        super.notifyTextAvailable(text, attributes);
    }
}

