/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenTestRunningSettings;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;

public class MavenJUnitPatcher
extends JUnitPatcher {
    public static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{(.+?)\\}");

    public void patchJavaParameters(@Nullable Module module, JavaParameters javaParameters) {
        Element argLine;
        Element environmentVariables;
        String value;
        Element systemPropertyVariables;
        if (module == null) {
            return;
        }
        MavenProject mavenProject = MavenProjectsManager.getInstance(module.getProject()).findProject(module);
        if (mavenProject == null) {
            return;
        }
        Element config = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-surefire-plugin");
        if (config == null) {
            return;
        }
        MavenDomProjectModel domModel = MavenDomUtil.getMavenDomProjectModel(module.getProject(), mavenProject.getFile());
        MavenTestRunningSettings testRunningSettings = MavenProjectSettings.getInstance(module.getProject()).getTestRunningSettings();
        List<String> paths = MavenJDOMUtil.findChildrenValuesByPath(config, "additionalClasspathElements", "additionalClasspathElement");
        if (paths.size() > 0) {
            for (String path : paths) {
                javaParameters.getClassPath().add(MavenJUnitPatcher.resolveSurefireProperties(path, domModel));
            }
        }
        if (testRunningSettings.isPassSystemProperties() && MavenJUnitPatcher.isEnabled("systemPropertyVariables") && (systemPropertyVariables = config.getChild("systemPropertyVariables")) != null) {
            for (Element element : systemPropertyVariables.getChildren()) {
                String propertyName = element.getName();
                if (javaParameters.getVMParametersList().hasProperty(propertyName)) continue;
                value = MavenJUnitPatcher.resolveSurefireProperties(element.getValue(), domModel);
                value = MavenJUnitPatcher.resolveVmProperties(javaParameters.getVMParametersList(), value);
                if (!MavenJUnitPatcher.isResolved(value)) continue;
                javaParameters.getVMParametersList().addProperty(propertyName, value);
            }
        }
        if (testRunningSettings.isPassEnvironmentVariables() && MavenJUnitPatcher.isEnabled("environmentVariables") && (environmentVariables = config.getChild("environmentVariables")) != null) {
            for (Element element : environmentVariables.getChildren()) {
                String variableName = element.getName();
                if (javaParameters.getEnv().containsKey(variableName)) continue;
                value = MavenJUnitPatcher.resolveSurefireProperties(element.getValue(), domModel);
                value = MavenJUnitPatcher.resolveVmProperties(javaParameters.getVMParametersList(), value);
                if (!MavenJUnitPatcher.isResolved(value)) continue;
                javaParameters.addEnv(variableName, value);
            }
        }
        if (testRunningSettings.isPassArgLine() && MavenJUnitPatcher.isEnabled("argLine") && (argLine = config.getChild("argLine")) != null) {
            String value2 = MavenJUnitPatcher.resolveSurefireProperties(argLine.getTextTrim(), domModel);
            value2 = MavenJUnitPatcher.resolveVmProperties(javaParameters.getVMParametersList(), value2);
            if (StringUtil.isNotEmpty((String)value2) && MavenJUnitPatcher.isResolved(value2)) {
                javaParameters.getVMParametersList().addParametersString(value2);
            }
        }
    }

    private static String resolveSurefireProperties(@NotNull String value, @Nullable MavenDomProjectModel domModel) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/maven/execution/MavenJUnitPatcher", "resolveSurefireProperties"));
        }
        if (domModel != null) {
            value = MavenPropertyResolver.resolve(value, domModel);
        }
        return value.replaceAll("\\$\\{surefire\\.(forkNumber|threadNumber)\\}", "1");
    }

    private static String resolveVmProperties(@NotNull ParametersList vmParameters, @NotNull String value) {
        if (vmParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmParameters", "org/jetbrains/idea/maven/execution/MavenJUnitPatcher", "resolveVmProperties"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/maven/execution/MavenJUnitPatcher", "resolveVmProperties"));
        }
        Matcher matcher = PROPERTY_PATTERN.matcher(value);
        HashMap toReplace = ContainerUtil.newHashMap();
        while (matcher.find()) {
            String finding = matcher.group();
            String propertyValue = vmParameters.getPropertyValue(finding.substring(2, finding.length() - 1));
            if (propertyValue == null) continue;
            toReplace.put(finding, propertyValue);
        }
        for (Map.Entry entry : toReplace.entrySet()) {
            value = value.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return value;
    }

    private static boolean isEnabled(String s) {
        return Boolean.valueOf(System.getProperty("idea.maven.surefire.disable." + s)) == false;
    }

    private static boolean isResolved(String s) {
        return !s.contains("${") || Boolean.valueOf(System.getProperty("idea.maven.surefire.allPropertiesAreResolved")) != false;
    }
}

