/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.impl.InvokeTemplateAction;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IterateOverIterableIntention
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + IterateOverIterableIntention.class.getName()));

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/IterateOverIterableIntention", "isAvailable"));
        }
        TemplateImpl template = IterateOverIterableIntention.getTemplate();
        if (template != null) {
            int offset;
            int startOffset = offset = editor.getCaretModel().getOffset();
            if (editor.getSelectionModel().hasSelection()) {
                int selStart = editor.getSelectionModel().getSelectionStart();
                int selEnd = editor.getSelectionModel().getSelectionEnd();
                startOffset = offset == selStart ? selEnd : selStart;
            }
            PsiElement element = file.findElementAt(startOffset);
            while (element instanceof PsiWhiteSpace) {
                element = element.getPrevSibling();
            }
            PsiStatement psiStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class, (boolean)false);
            if (psiStatement != null) {
                startOffset = psiStatement.getTextRange().getStartOffset();
            }
            if (!template.isDeactivated() && (TemplateManagerImpl.isApplicable(file, offset, template) || TemplateManagerImpl.isApplicable(file, startOffset, template))) {
                return IterateOverIterableIntention.getIterableExpression(editor, file) != null;
            }
        }
        return false;
    }

    @Nullable
    private static TemplateImpl getTemplate() {
        return TemplateSettings.getInstance().getTemplate("I", "surround");
    }

    @NotNull
    public String getText() {
        if ("Iterate" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/IterateOverIterableIntention", "getText"));
        }
        return "Iterate";
    }

    @Nullable
    private static PsiExpression getIterableExpression(Editor editor, PsiFile file) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            PsiElement elementAtStart = file.findElementAt(selectionModel.getSelectionStart());
            PsiElement elementAtEnd = file.findElementAt(selectionModel.getSelectionEnd() - 1);
            if ((elementAtStart == null || elementAtStart instanceof PsiWhiteSpace || elementAtStart instanceof PsiComment) && (elementAtStart = PsiTreeUtil.skipSiblingsForward((PsiElement)elementAtStart, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) == null) {
                return null;
            }
            if ((elementAtEnd == null || elementAtEnd instanceof PsiWhiteSpace || elementAtEnd instanceof PsiComment) && (elementAtEnd = PsiTreeUtil.skipSiblingsBackward((PsiElement)elementAtEnd, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) == null) {
                return null;
            }
            PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)elementAtStart, (PsiElement)elementAtEnd);
            if (parent instanceof PsiExpression) {
                PsiType type = ((PsiExpression)parent).getType();
                return type instanceof PsiArrayType || InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.Iterable") ? (PsiExpression)parent : null;
            }
            return null;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        while (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (element instanceof PsiExpressionStatement) {
            element = ((PsiExpressionStatement)element).getExpression().getLastChild();
        }
        while ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class, (boolean)true)) != null) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiMethodCallExpression) continue;
            if (!(parent instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiType type = ((PsiExpression)element).getType();
            if (!(type instanceof PsiArrayType) && !InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.Iterable")) continue;
            return (PsiExpression)element;
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/IterateOverIterableIntention", "invoke"));
        }
        TemplateImpl template = IterateOverIterableIntention.getTemplate();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            PsiExpression iterableExpression = IterateOverIterableIntention.getIterableExpression(editor, file);
            LOG.assertTrue(iterableExpression != null);
            TextRange textRange = iterableExpression.getTextRange();
            selectionModel.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
        }
        new InvokeTemplateAction(template, editor, project, new HashSet<Character>()).perform();
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/IterateOverIterableIntention", "getFamilyName"));
        }
        return string;
    }
}

