/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CodeBlockUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import gnu.trove.TIntHashSet;

public class MatchBraceAction
extends EditorAction {
    private static final TIntHashSet OPEN_BRACES = new TIntHashSet(new int[]{40, 91, 123, 60});
    private static final TIntHashSet CLOSE_BRACES = new TIntHashSet(new int[]{41, 93, 125, 62});

    public MatchBraceAction() {
        super((EditorActionHandler)new MyHandler());
    }

    private static class MyHandler
    extends EditorActionHandler {
        public MyHandler() {
            super(true);
        }

        public void execute(Editor editor, DataContext dataContext) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return;
            }
            CaretModel caretModel = editor.getCaretModel();
            int offset = caretModel.getOffset();
            CharSequence text = editor.getDocument().getCharsSequence();
            char c = text.charAt(offset);
            if (!OPEN_BRACES.contains((int)c) && !CLOSE_BRACES.contains((int)c)) {
                boolean canContinue = false;
                --offset;
                while (offset >= 0) {
                    c = text.charAt(offset);
                    if (OPEN_BRACES.contains((int)c) || CLOSE_BRACES.contains((int)c)) {
                        canContinue = true;
                        caretModel.moveToOffset(offset);
                        break;
                    }
                    --offset;
                }
                if (!canContinue) {
                    return;
                }
            }
            if (OPEN_BRACES.contains((int)c)) {
                CodeBlockUtil.moveCaretToCodeBlockEnd(project, editor, false);
            } else if (CLOSE_BRACES.contains((int)c)) {
                CodeBlockUtil.moveCaretToCodeBlockStart(project, editor, false);
            }
        }
    }
}

