/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.CommentUtil;
import com.intellij.codeInsight.actions.MultiCaretCodeInsightActionHandler;
import com.intellij.codeInsight.generation.CommentByBlockCommentHandler;
import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.CommenterWithLineSuffix;
import com.intellij.codeInsight.generation.IndentedCommenter;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.InjectedCaret;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentByLineCommentHandler
extends MultiCaretCodeInsightActionHandler {
    private Project myProject;
    private CodeStyleManager myCodeStyleManager;
    private final List<Block> myBlocks = new ArrayList<Block>();

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull Caret caret, @NotNull PsiFile file) {
        boolean startingNewLineComment;
        Block currentBlock;
        Block lastBlock;
        String s;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/CommentByLineCommentHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/CommentByLineCommentHandler", "invoke"));
        }
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/generation/CommentByLineCommentHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/CommentByLineCommentHandler", "invoke"));
        }
        this.myProject = project;
        if (!CodeInsightUtilBase.prepareEditorForWrite(editor)) {
            return;
        }
        PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)(file = file.getViewProvider().getPsi(file.getViewProvider().getBaseLanguage())).getProject()).getInjectionHost((PsiElement)file);
        if (context != null && (context.textContains('\'') || context.textContains('\"')) && (StringUtil.startsWith((CharSequence)(s = context.getText()), (CharSequence)"\"") || StringUtil.startsWith((CharSequence)s, (CharSequence)"'"))) {
            file = context.getContainingFile();
            editor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
            caret = caret instanceof InjectedCaret ? ((InjectedCaret)caret).getDelegate() : caret;
        }
        Document document = editor.getDocument();
        if (!FileDocumentManager.getInstance().requestWriting(document, project)) {
            return;
        }
        boolean hasSelection = caret.hasSelection();
        int startOffset = caret.getSelectionStart();
        int endOffset = caret.getSelectionEnd();
        FoldRegion fold = editor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        if (fold != null && fold.shouldNeverExpand() && fold.getStartOffset() == startOffset && fold.getEndOffset() == endOffset) {
            hasSelection = false;
        }
        if (document.getTextLength() == 0) {
            return;
        }
        while (true) {
            int regionEndOffset;
            int lastLineEnd = document.getLineEndOffset(document.getLineNumber(endOffset));
            FoldRegion collapsedAt = editor.getFoldingModel().getCollapsedRegionAtOffset(lastLineEnd);
            if (collapsedAt == null || (regionEndOffset = collapsedAt.getEndOffset()) <= endOffset) break;
            endOffset = regionEndOffset;
        }
        int startLine = document.getLineNumber(startOffset);
        int endLine = document.getLineNumber(endOffset);
        if (endLine > startLine && document.getLineStartOffset(endLine) == endOffset) {
            --endLine;
        }
        Block block = lastBlock = this.myBlocks.isEmpty() ? null : this.myBlocks.get(this.myBlocks.size() - 1);
        if (lastBlock == null || lastBlock.editor != editor || lastBlock.psiFile != file || startLine > lastBlock.endLine + 1) {
            currentBlock = new Block();
            currentBlock.editor = editor;
            currentBlock.psiFile = file;
            currentBlock.startLine = startLine;
            this.myBlocks.add(currentBlock);
        } else {
            currentBlock = lastBlock;
        }
        currentBlock.carets.add(caret);
        currentBlock.endLine = endLine;
        boolean wholeLinesSelected = !hasSelection || startOffset == document.getLineStartOffset(document.getLineNumber(startOffset)) && endOffset == document.getLineEndOffset(document.getLineNumber(endOffset - 1)) + 1;
        boolean bl = startingNewLineComment = !hasSelection && CommentByLineCommentHandler.isLineEmpty(document, document.getLineNumber(startOffset)) && !Comparing.equal((String)"CommentByLineComment", (String)ActionManagerEx.getInstanceEx().getPrevPreformedActionId());
        currentBlock.caretUpdate = startingNewLineComment ? CaretUpdate.PUT_AT_COMMENT_START : (!hasSelection ? CaretUpdate.SHIFT_DOWN : (wholeLinesSelected ? CaretUpdate.RESTORE_SELECTION : null));
    }

    @Override
    public void postInvoke() {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.comment.line");
        this.myCodeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
        boolean allLinesCommented = true;
        block5: for (Block block : this.myBlocks) {
            int startLine = block.startLine;
            int endLine = block.endLine;
            Document document = block.editor.getDocument();
            PsiFile psiFile = block.psiFile;
            Block.access$702(block, new int[endLine - startLine + 1]);
            Block.access$802(block, new int[endLine - startLine + 1]);
            Block.access$902(block, new Commenter[endLine - startLine + 1]);
            block.commenterStateMap = (Map)new THashMap();
            CharSequence chars = document.getCharsSequence();
            boolean singleline = startLine == endLine;
            int offset = document.getLineStartOffset(startLine);
            offset = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t");
            int endOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)document.getLineEndOffset(endLine), (String)" \t\n");
            block.blockSuitableCommenter = CommentByLineCommentHandler.getBlockSuitableCommenter(psiFile, offset, endOffset);
            block.commentWithIndent = !CodeStyleSettingsManager.getSettings((Project)this.myProject).getCommonSettings((Language)psiFile.getLanguage()).LINE_COMMENT_AT_FIRST_COLUMN;
            for (int line = startLine; line <= endLine; ++line) {
                Boolean value;
                Commenter commenter;
                Commenter commenter2 = commenter = block.blockSuitableCommenter != null ? block.blockSuitableCommenter : CommentByLineCommentHandler.findCommenter(block.editor, psiFile, line);
                if (commenter == null || commenter.getLineCommentPrefix() == null && (commenter.getBlockCommentPrefix() == null || commenter.getBlockCommentSuffix() == null)) {
                    block.skip = true;
                    continue block5;
                }
                if (commenter instanceof SelfManagingCommenter && block.commenterStateMap.get(commenter) == null) {
                    SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
                    Object state = selfManagingCommenter.createLineCommentingState(startLine, endLine, document, psiFile);
                    if (state == null) {
                        state = SelfManagingCommenter.EMPTY_STATE;
                    }
                    block.commenterStateMap.put(selfManagingCommenter, state);
                }
                ((Block)block).commenters[line - startLine] = commenter;
                if (CommentByLineCommentHandler.isLineCommented(block, line, commenter) || !singleline && CommentByLineCommentHandler.isLineEmpty(document, line)) continue;
                allLinesCommented = false;
                if (!(commenter instanceof IndentedCommenter) || (value = ((IndentedCommenter)commenter).forceIndentedLineComment()) == null) continue block5;
                block.commentWithIndent = value;
                continue block5;
            }
        }
        boolean moveCarets = true;
        for (Block block : this.myBlocks) {
            if (block.carets.size() <= 1 || block.startLine == block.endLine) continue;
            moveCarets = false;
            break;
        }
        Collections.reverse(this.myBlocks);
        for (Block block : this.myBlocks) {
            if (!block.skip) {
                if (!allLinesCommented) {
                    if (!block.commentWithIndent) {
                        this.doDefaultCommenting(block);
                    } else {
                        this.doIndentCommenting(block);
                    }
                } else {
                    for (int line = block.endLine; line >= block.startLine; --line) {
                        CommentByLineCommentHandler.uncommentLine(block, line);
                    }
                }
            }
            if (!moveCarets || block.caretUpdate == null) continue;
            Document document = block.editor.getDocument();
            for (Caret caret : block.carets) {
                switch (block.caretUpdate) {
                    case PUT_AT_COMMENT_START: {
                        String prefix;
                        Commenter commenter = block.commenters[0];
                        if (commenter == null) break;
                        if (commenter instanceof SelfManagingCommenter) {
                            prefix = ((SelfManagingCommenter)commenter).getCommentPrefix(block.startLine, document, (CommenterDataHolder)((Object)block.commenterStateMap.get((SelfManagingCommenter)commenter)));
                            if (prefix == null) {
                                prefix = "";
                            }
                        } else {
                            prefix = commenter.getLineCommentPrefix();
                            if (prefix == null) {
                                prefix = commenter.getBlockCommentPrefix();
                            }
                        }
                        int lineStart = document.getLineStartOffset(block.startLine);
                        lineStart = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)lineStart, (String)" \t");
                        lineStart += prefix.length();
                        lineStart = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)lineStart, (String)" \t");
                        if (lineStart > document.getTextLength()) {
                            lineStart = document.getTextLength();
                        }
                        caret.moveToOffset(lineStart);
                        break;
                    }
                    case SHIFT_DOWN: {
                        LogicalPosition position = caret.getLogicalPosition();
                        if (position.line >= document.getLineCount() - 1) break;
                        int verticalShift = 1 + block.editor.getSoftWrapModel().getSoftWrapsForLine(position.line).size() - position.softWrapLinesOnCurrentLogicalLine;
                        caret.moveCaretRelatively(0, verticalShift, false, true);
                        break;
                    }
                    case RESTORE_SELECTION: {
                        caret.setSelection(document.getLineStartOffset(document.getLineNumber(caret.getSelectionStart())), caret.getSelectionEnd());
                    }
                }
            }
        }
    }

    private static Commenter getBlockSuitableCommenter(final PsiFile file, int offset, int endOffset) {
        Commenter blockSuitableCommenter;
        PsiElement element;
        Object languageSuitableForCompleteFragment = offset >= endOffset ? ((element = file.findElementAt(offset)) != null ? element.getParent().getLanguage() : null) : PsiUtilBase.reallyEvaluateLanguageInRange((int)offset, (int)endOffset, (PsiFile)file);
        Commenter commenter = blockSuitableCommenter = languageSuitableForCompleteFragment == null ? (Commenter)LanguageCommenters.INSTANCE.forLanguage(file.getLanguage()) : null;
        if (blockSuitableCommenter == null && file.getFileType() instanceof CustomSyntaxTableFileType) {
            blockSuitableCommenter = new Commenter(){
                final SyntaxTable mySyntaxTable;
                {
                    this.mySyntaxTable = ((CustomSyntaxTableFileType)file.getFileType()).getSyntaxTable();
                }

                @Nullable
                public String getLineCommentPrefix() {
                    return this.mySyntaxTable.getLineComment();
                }

                @Nullable
                public String getBlockCommentPrefix() {
                    return this.mySyntaxTable.getStartComment();
                }

                @Nullable
                public String getBlockCommentSuffix() {
                    return this.mySyntaxTable.getEndComment();
                }

                public String getCommentedBlockCommentPrefix() {
                    return null;
                }

                public String getCommentedBlockCommentSuffix() {
                    return null;
                }
            };
        }
        return blockSuitableCommenter;
    }

    private static boolean isLineEmpty(Document document, int line) {
        CharSequence chars = document.getCharsSequence();
        int start = document.getLineStartOffset(line);
        int end = Math.min(document.getLineEndOffset(line), document.getTextLength() - 1);
        for (int i = start; i <= end; ++i) {
            if (Character.isWhitespace(chars.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isLineCommented(Block block, int line, Commenter commenter) {
        boolean commented;
        int lineEndForBlockCommenting = -1;
        Document document = block.editor.getDocument();
        int lineStart = document.getLineStartOffset(line);
        CharSequence chars = document.getCharsSequence();
        lineStart = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStart, (String)" \t");
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            commented = selfManagingCommenter.isLineCommented(line, lineStart, document, (CommenterDataHolder)((Object)block.commenterStateMap.get(selfManagingCommenter)));
        } else {
            String prefix = commenter.getLineCommentPrefix();
            if (prefix != null) {
                commented = CharArrayUtil.regionMatches((CharSequence)chars, (int)lineStart, (CharSequence)StringUtil.trimTrailing((String)prefix));
            } else {
                prefix = commenter.getBlockCommentPrefix();
                String suffix = commenter.getBlockCommentSuffix();
                int textLength = document.getTextLength();
                lineEndForBlockCommenting = document.getLineEndOffset(line);
                if (lineEndForBlockCommenting == textLength) {
                    int shifted = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(textLength - 1), (String)" \t");
                    if (shifted < textLength - 1) {
                        lineEndForBlockCommenting = shifted;
                    }
                } else {
                    lineEndForBlockCommenting = CharArrayUtil.shiftBackward((CharSequence)chars, (int)lineEndForBlockCommenting, (String)" \t");
                }
                boolean bl = commented = lineStart == lineEndForBlockCommenting && block.startLine != block.endLine || CharArrayUtil.regionMatches((CharSequence)chars, (int)lineStart, (CharSequence)prefix) && CharArrayUtil.regionMatches((CharSequence)chars, (int)(lineEndForBlockCommenting - suffix.length()), (CharSequence)suffix);
            }
        }
        if (commented) {
            ((Block)block).startOffsets[line - ((Block)block).startLine] = lineStart;
            ((Block)block).endOffsets[line - ((Block)block).startLine] = lineEndForBlockCommenting;
        }
        return commented;
    }

    @Nullable
    private static Commenter findCommenter(Editor editor, PsiFile file, int line) {
        FileType fileType = file.getFileType();
        if (fileType instanceof AbstractFileType) {
            return ((AbstractFileType)fileType).getCommenter();
        }
        Document document = editor.getDocument();
        int lineStartOffset = document.getLineStartOffset(line);
        int lineEndOffset = document.getLineEndOffset(line) - 1;
        CharSequence charSequence = document.getCharsSequence();
        lineStartOffset = CharArrayUtil.shiftForward((CharSequence)charSequence, (int)lineStartOffset, (String)" \t");
        lineEndOffset = CharArrayUtil.shiftBackward((CharSequence)charSequence, (int)(lineEndOffset < 0 ? 0 : lineEndOffset), (String)" \t");
        Language lineStartLanguage = PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)lineStartOffset);
        Language lineEndLanguage = PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)lineEndOffset);
        return CommentByBlockCommentHandler.getCommenter(file, editor, lineStartLanguage, lineEndLanguage);
    }

    private Indent computeMinIndent(Editor editor, PsiFile psiFile, int line1, int line2, FileType fileType) {
        int commentOffset;
        Document document = editor.getDocument();
        Indent minIndent = CommentUtil.getMinLineIndent(this.myProject, document, line1, line2, fileType);
        if (line1 > 0 && (commentOffset = CommentByLineCommentHandler.getCommentStart(editor, psiFile, line1 - 1)) >= 0) {
            int lineStart = document.getLineStartOffset(line1 - 1);
            String space = ((Object)document.getCharsSequence().subSequence(lineStart, commentOffset)).toString();
            Indent indent = this.myCodeStyleManager.getIndent(space, fileType);
            Indent indent2 = minIndent = minIndent != null ? indent.min(minIndent) : indent;
        }
        if (minIndent == null) {
            minIndent = this.myCodeStyleManager.zeroIndent();
        }
        return minIndent;
    }

    private static int getCommentStart(Editor editor, PsiFile psiFile, int line) {
        int offset = editor.getDocument().getLineStartOffset(line);
        CharSequence chars = editor.getDocument().getCharsSequence();
        offset = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t");
        Commenter commenter = CommentByLineCommentHandler.findCommenter(editor, psiFile, line);
        if (commenter == null) {
            return -1;
        }
        String prefix = commenter.getLineCommentPrefix();
        if (prefix == null) {
            prefix = commenter.getBlockCommentPrefix();
        }
        if (prefix == null) {
            return -1;
        }
        return CharArrayUtil.regionMatches((CharSequence)chars, (int)offset, (CharSequence)prefix) ? offset : -1;
    }

    public void doDefaultCommenting(final Block block) {
        final Document document = block.editor.getDocument();
        DocumentUtil.executeInBulk(document, block.endLine - block.startLine >= Registry.intValue((String)"comment.by.line.bulk.lines.trigger"), new Runnable(){

            @Override
            public void run() {
                for (int line = block.endLine; line >= block.startLine; --line) {
                    int offset = document.getLineStartOffset(line);
                    CommentByLineCommentHandler.commentLine(block, line, offset);
                }
            }
        });
    }

    private void doIndentCommenting(final Block block) {
        final Document document = block.editor.getDocument();
        final CharSequence chars = document.getCharsSequence();
        final FileType fileType = block.psiFile.getFileType();
        final Indent minIndent = this.computeMinIndent(block.editor, block.psiFile, block.startLine, block.endLine, fileType);
        DocumentUtil.executeInBulk(document, block.endLine - block.startLine > Registry.intValue((String)"comment.by.line.bulk.lines.trigger"), new Runnable(){

            @Override
            public void run() {
                for (int line = block.endLine; line >= block.startLine; --line) {
                    int lineStart;
                    int offset = lineStart = document.getLineStartOffset(line);
                    StringBuilder buffer = new StringBuilder();
                    while (true) {
                        String space = buffer.toString();
                        Indent indent = CommentByLineCommentHandler.this.myCodeStyleManager.getIndent(space, fileType);
                        if (indent.isGreaterThan(minIndent) || indent.equals(minIndent)) break;
                        char c = chars.charAt(offset);
                        if (c != ' ' && c != '\t') {
                            String newSpace = CommentByLineCommentHandler.this.myCodeStyleManager.fillIndent(minIndent, fileType);
                            document.replaceString(lineStart, offset, (CharSequence)newSpace);
                            offset = lineStart + newSpace.length();
                            break;
                        }
                        buffer.append(c);
                        ++offset;
                    }
                    CommentByLineCommentHandler.commentLine(block, line, offset);
                }
            }
        });
    }

    private static void uncommentRange(Document document, int startOffset, int endOffset, @NotNull Commenter commenter) {
        if (commenter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commenter", "com/intellij/codeInsight/generation/CommentByLineCommentHandler", "uncommentRange"));
        }
        String commentedSuffix = commenter.getCommentedBlockCommentSuffix();
        String commentedPrefix = commenter.getCommentedBlockCommentPrefix();
        String prefix = commenter.getBlockCommentPrefix();
        String suffix = commenter.getBlockCommentSuffix();
        if (prefix == null || suffix == null) {
            return;
        }
        if (endOffset >= suffix.length() && CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)(endOffset - suffix.length()), (CharSequence)suffix)) {
            document.deleteString(endOffset - suffix.length(), endOffset);
            endOffset -= suffix.length();
        }
        if (commentedPrefix != null && commentedSuffix != null) {
            CommentByBlockCommentHandler.commentNestedComments(document, new TextRange(startOffset, endOffset), commenter);
        }
        document.deleteString(startOffset, startOffset + prefix.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uncommentLine(Block block, int line) {
        Document document = block.editor.getDocument();
        Commenter commenter = block.commenters[line - block.startLine];
        if (commenter == null) {
            commenter = CommentByLineCommentHandler.findCommenter(block.editor, block.psiFile, line);
        }
        if (commenter == null) {
            return;
        }
        int startOffset = block.startOffsets[line - block.startLine];
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            selfManagingCommenter.uncommentLine(line, startOffset, document, (CommenterDataHolder)((Object)block.commenterStateMap.get(selfManagingCommenter)));
            return;
        }
        int endOffset = block.endOffsets[line - block.startLine];
        if (startOffset == endOffset) {
            return;
        }
        RangeMarker marker = endOffset > startOffset ? block.editor.getDocument().createRangeMarker(startOffset, endOffset) : null;
        try {
            if (CommentByLineCommentHandler.doUncommentLine(line, document, commenter, startOffset, endOffset)) {
                return;
            }
            if (marker != null) {
                CommentByBlockCommentHandler.processDocument(document, marker, commenter, false);
            }
        }
        finally {
            if (marker != null) {
                marker.dispose();
            }
        }
    }

    private static boolean doUncommentLine(int line, Document document, Commenter commenter, int startOffset, int endOffset) {
        int prefixPos;
        String prefix = commenter.getLineCommentPrefix();
        if (prefix != null) {
            boolean commented;
            CharSequence chars = document.getCharsSequence();
            if (commenter instanceof CommenterWithLineSuffix) {
                int theEnd;
                CommenterWithLineSuffix commenterWithLineSuffix = (CommenterWithLineSuffix)commenter;
                String suffix = commenterWithLineSuffix.getLineCommentSuffix();
                int n = theEnd = endOffset > 0 ? endOffset : document.getLineEndOffset(line);
                while (theEnd > startOffset && Character.isWhitespace(chars.charAt(theEnd - 1))) {
                    --theEnd;
                }
                String lineText = document.getText(new TextRange(startOffset, theEnd));
                if (lineText.indexOf(suffix) != -1) {
                    int start = startOffset + lineText.indexOf(suffix);
                    document.deleteString(start, start + suffix.length());
                }
            }
            boolean matchesTrimmed = false;
            boolean bl = CharArrayUtil.regionMatches((CharSequence)chars, (int)startOffset, (CharSequence)prefix) || (matchesTrimmed = prefix.endsWith(" ") && CharArrayUtil.regionMatches((CharSequence)chars, (int)startOffset, (CharSequence)prefix.trim())) ? true : (commented = false);
            assert (commented);
            int charsToDelete = matchesTrimmed ? prefix.trim().length() : prefix.length();
            document.deleteString(startOffset, startOffset + charsToDelete);
            return true;
        }
        String text = ((Object)document.getCharsSequence().subSequence(startOffset, endOffset)).toString();
        prefix = commenter.getBlockCommentPrefix();
        String suffix = commenter.getBlockCommentSuffix();
        if (prefix == null || suffix == null) {
            return true;
        }
        IntArrayList prefixes = new IntArrayList();
        IntArrayList suffixes = new IntArrayList();
        int position = 0;
        while (position < text.length() && (prefixPos = text.indexOf(prefix, position)) != -1) {
            prefixes.add(prefixPos);
            position = prefixPos + prefix.length();
            int suffixPos = text.indexOf(suffix, position);
            if (suffixPos == -1) {
                suffixPos = text.length() - suffix.length();
            }
            suffixes.add(suffixPos);
            position = suffixPos + suffix.length();
        }
        assert (prefixes.size() == suffixes.size());
        for (int i = prefixes.size() - 1; i >= 0; --i) {
            CommentByLineCommentHandler.uncommentRange(document, startOffset + prefixes.get(i), Math.min(startOffset + suffixes.get(i) + suffix.length(), endOffset), commenter);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void commentLine(Block block, int line, int offset) {
        Commenter commenter = block.blockSuitableCommenter;
        Document document = block.editor.getDocument();
        if (commenter == null) {
            commenter = CommentByLineCommentHandler.findCommenter(block.editor, block.psiFile, line);
        }
        if (commenter == null) {
            return;
        }
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            selfManagingCommenter.commentLine(line, offset, document, (CommenterDataHolder)((Object)block.commenterStateMap.get(selfManagingCommenter)));
            return;
        }
        int endOffset = document.getLineEndOffset(line);
        RangeMarker marker = document.createRangeMarker(offset, endOffset);
        marker.setGreedyToLeft(true);
        marker.setGreedyToRight(true);
        try {
            if (CommentByLineCommentHandler.doCommentLine(block, line, offset, endOffset, commenter, document)) {
                return;
            }
            CommentByBlockCommentHandler.processDocument(document, marker, commenter, true);
        }
        finally {
            marker.dispose();
        }
    }

    private static boolean doCommentLine(Block block, int line, int offset, int endOffset, Commenter commenter, Document document) {
        String prefix = commenter.getLineCommentPrefix();
        if (prefix != null) {
            if (commenter instanceof CommenterWithLineSuffix) {
                endOffset = CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)endOffset, (String)" \t");
                int shiftedStartOffset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)offset, (String)" \t");
                String lineSuffix = ((CommenterWithLineSuffix)commenter).getLineCommentSuffix();
                if (!CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)shiftedStartOffset, (CharSequence)prefix)) {
                    if (!CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)(endOffset - lineSuffix.length()), (CharSequence)lineSuffix)) {
                        document.insertString(endOffset, (CharSequence)lineSuffix);
                    }
                    document.insertString(offset, (CharSequence)prefix);
                }
            } else {
                document.insertString(offset, (CharSequence)prefix);
            }
        } else {
            prefix = commenter.getBlockCommentPrefix();
            String suffix = commenter.getBlockCommentSuffix();
            if (prefix == null || suffix == null) {
                return true;
            }
            if (endOffset == offset && block.startLine != block.endLine) {
                return true;
            }
            int textLength = document.getTextLength();
            CharSequence chars = document.getCharsSequence();
            offset = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t");
            if (endOffset == textLength) {
                int shifted = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(textLength - 1), (String)" \t") + 1;
                if (shifted < textLength) {
                    endOffset = shifted;
                }
            } else {
                endOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)endOffset, (String)" \t");
            }
            if (endOffset < offset || offset == textLength - 1 && line != document.getLineCount() - 1) {
                return true;
            }
            String text = ((Object)chars.subSequence(offset, endOffset)).toString();
            IntArrayList prefixes = new IntArrayList();
            IntArrayList suffixes = new IntArrayList();
            String commentedSuffix = commenter.getCommentedBlockCommentSuffix();
            String commentedPrefix = commenter.getCommentedBlockCommentPrefix();
            int position = 0;
            while (position < text.length()) {
                int nearestSuffix;
                int nearestPrefix = text.indexOf(prefix, position);
                if (nearestPrefix == -1) {
                    nearestPrefix = text.length();
                }
                if ((nearestSuffix = text.indexOf(suffix, position)) == -1) {
                    nearestSuffix = text.length();
                }
                if (Math.min(nearestPrefix, nearestSuffix) == text.length()) break;
                if (nearestPrefix < nearestSuffix) {
                    prefixes.add(nearestPrefix);
                    position = nearestPrefix + prefix.length();
                    continue;
                }
                suffixes.add(nearestSuffix);
                position = nearestSuffix + suffix.length();
            }
            if (commentedSuffix != null || suffixes.isEmpty() || offset + suffixes.get(suffixes.size() - 1) + suffix.length() < endOffset) {
                document.insertString(endOffset, (CharSequence)suffix);
            }
            int nearestPrefix = prefixes.size() - 1;
            int nearestSuffix = suffixes.size() - 1;
            while (nearestPrefix >= 0 || nearestSuffix >= 0) {
                int position2;
                if (nearestSuffix == -1 || nearestPrefix != -1 && prefixes.get(nearestPrefix) > suffixes.get(nearestSuffix)) {
                    position2 = prefixes.get(nearestPrefix);
                    --nearestPrefix;
                    if (commentedPrefix != null) {
                        document.replaceString(offset + position2, offset + position2 + prefix.length(), (CharSequence)commentedPrefix);
                        continue;
                    }
                    if (position2 == 0) continue;
                    document.insertString(offset + position2, (CharSequence)suffix);
                    continue;
                }
                position2 = suffixes.get(nearestSuffix);
                --nearestSuffix;
                if (commentedSuffix != null) {
                    document.replaceString(offset + position2, offset + position2 + suffix.length(), (CharSequence)commentedSuffix);
                    continue;
                }
                if (offset + position2 + suffix.length() >= endOffset) continue;
                document.insertString(offset + position2 + suffix.length(), (CharSequence)prefix);
            }
            if (commentedPrefix != null || prefixes.isEmpty() || prefixes.get(0) != 0) {
                document.insertString(offset, (CharSequence)prefix);
            }
        }
        return false;
    }

    private static enum CaretUpdate {
        PUT_AT_COMMENT_START,
        SHIFT_DOWN,
        RESTORE_SELECTION;

    }

    private static class Block {
        private Editor editor;
        private PsiFile psiFile;
        private List<Caret> carets = new ArrayList<Caret>();
        private int startLine;
        private int endLine;
        private int[] startOffsets;
        private int[] endOffsets;
        private Commenter blockSuitableCommenter;
        private Commenter[] commenters;
        private Map<SelfManagingCommenter, CommenterDataHolder> commenterStateMap;
        private boolean commentWithIndent;
        private CaretUpdate caretUpdate;
        private boolean skip;

        private Block() {
        }

        static /* synthetic */ int[] access$702(Block x0, int[] x1) {
            x0.startOffsets = x1;
            return x1;
        }

        static /* synthetic */ int[] access$802(Block x0, int[] x1) {
            x0.endOffsets = x1;
            return x1;
        }

        static /* synthetic */ Commenter[] access$902(Block x0, Commenter[] x1) {
            x0.commenters = x1;
            return x1;
        }
    }
}

