/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.lang.CodeInsightActions;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GotoSuperAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler,
DumbAware {
    @NonNls
    public static final String FEATURE_ID = "navigation.goto.super";

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        GotoSuperAction gotoSuperAction = this;
        if (gotoSuperAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/actions/GotoSuperAction", "getHandler"));
        }
        return gotoSuperAction;
    }

    public void invoke(final @NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/navigation/actions/GotoSuperAction", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/actions/GotoSuperAction", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/navigation/actions/GotoSuperAction", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file, (int)offset);
        final CodeInsightActionHandler codeInsightActionHandler = (CodeInsightActionHandler)CodeInsightActions.GOTO_SUPER.forLanguage(language);
        if (codeInsightActionHandler != null) {
            DumbService.getInstance((Project)project).withAlternativeResolveEnabled(new Runnable(){

                @Override
                public void run() {
                    codeInsightActionHandler.invoke(project, editor, file);
                }
            });
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void update(AnActionEvent event) {
        if (CodeInsightActions.GOTO_SUPER.hasAnyExtensions()) {
            event.getPresentation().setVisible(true);
            super.update(event);
        } else {
            event.getPresentation().setVisible(false);
        }
    }
}

