/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.DebuggerExpressionComboBox;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiElement;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CompletedInputDialog
extends DialogWrapper {
    JPanel myPanel;
    DebuggerExpressionComboBox myCombo;
    PsiElement myContext;
    Project myProject;
    private JLabel myLabel;

    public CompletedInputDialog(String title, String okText, Project project) {
        super(project, false);
        this.setTitle(title);
        this.setOKButtonText(okText);
        this.myProject = project;
        this.setModal(false);
        DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(project).getContext();
        this.myContext = PositionUtil.getContextElement((StackFrameContext)debuggerContext);
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCombo.getPreferredFocusedComponent();
    }

    protected JComponent createCenterPanel() {
        this.myPanel = new JPanel(new GridBagLayout());
        this.myLabel = new JLabel(DebuggerBundle.message((String)"label.complete.input.dialog.expression", (Object[])new Object[0]));
        this.myPanel.add((Component)this.myLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 0, new Insets(0, 1, 0, 1), 0, 0));
        this.myCombo = new DebuggerExpressionComboBox(this.myProject, this.myContext, "evaluation", DefaultCodeFragmentFactory.getInstance());
        this.myCombo.selectAll();
        this.myPanel.add((Component)this.myCombo, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 1, 0, 1), 0, 0));
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)200, (int)50));
        return this.myPanel;
    }

    public TextWithImports getExpressionText() {
        return this.myCombo.getText();
    }

    public DebuggerExpressionComboBox getCombo() {
        return this.myCombo;
    }

    public void setExpressionLabel(String text) {
        this.myLabel.setText(text);
    }

    public void dispose() {
        this.myCombo.dispose();
        super.dispose();
    }
}

