/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.util.Side;
import org.jetbrains.annotations.NotNull;

public abstract class BaseSyncScrollable
implements SyncScrollSupport.SyncScrollable {
    protected abstract void processHelper(@NotNull ScrollHelper var1);

    @Override
    public int transfer(@NotNull Side side, int line) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/BaseSyncScrollable", "transfer"));
        }
        ScrollHelper helper = new ScrollHelper(side, line);
        this.processHelper(helper);
        int master1 = helper.getMaster1();
        int master2 = helper.getMaster2();
        int slave1 = helper.getSlave1();
        int slave2 = helper.getSlave2();
        if (master1 == line) {
            return slave1;
        }
        if (master2 == line) {
            return slave2;
        }
        if (master2 < line) {
            return line - master2 + slave2;
        }
        assert (master1 != master2);
        return Math.min(slave1 + (line - master1), slave2);
    }

    protected static class ScrollHelper {
        @NotNull
        private final Side mySide;
        private final int myLine;
        private int myLeft1;
        private int myLeft2;
        private int myRight1;
        private int myRight2;

        public ScrollHelper(@NotNull Side side, int line) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/BaseSyncScrollable$ScrollHelper", "<init>"));
            }
            this.myLeft1 = 0;
            this.myLeft2 = 0;
            this.myRight1 = 0;
            this.myRight2 = 0;
            this.mySide = side;
            this.myLine = line;
        }

        public boolean process(int left, int right) {
            this.myLeft1 = this.myLeft2;
            this.myRight1 = this.myRight2;
            this.myLeft2 = left;
            this.myRight2 = right;
            return this.myLine > this.mySide.select(left, right);
        }

        public int getMaster1() {
            return this.mySide.select(this.myLeft1, this.myRight1);
        }

        public int getMaster2() {
            return this.mySide.select(this.myLeft2, this.myRight2);
        }

        public int getSlave1() {
            return this.mySide.select(this.myRight1, this.myLeft1);
        }

        public int getSlave2() {
            return this.mySide.select(this.myRight2, this.myLeft2);
        }
    }
}

