/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorNotificationPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffPanelBase
extends JPanel
implements DataProvider {
    @NotNull
    protected final JPanel CONTENTS_EQUAL_NOTIFICATION;
    @NotNull
    protected final JPanel CANT_CALCULATE_DIFF;
    @NotNull
    protected final JPanel CONTENTS_OPERATION_CANCELED_NOTIFICATION;
    @NotNull
    protected final JPanel CONTENTS_TOO_BIG_NOTIFICATION;
    @Nullable
    protected final Project myProject;
    @NotNull
    private final DataProvider myDataProvider;
    @NotNull
    protected final DiffContext myContext;
    @NotNull
    protected final JPanel myContentPanel;
    @NotNull
    protected final JPanel myNotificationsPanel;
    @NotNull
    protected final CardLayout myCardLayout;
    @NotNull
    protected String myCurrentCard;

    public DiffPanelBase(@Nullable Project project, @NotNull DataProvider provider, @NotNull DiffContext context) {
        JComponent bottomPanel;
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/diff/tools/util/base/DiffPanelBase", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/DiffPanelBase", "<init>"));
        }
        super(new BorderLayout());
        this.CONTENTS_EQUAL_NOTIFICATION = DiffPanelBase.createNotification(DiffBundle.message((String)"diff.contents.are.identical.message.text", (Object[])new Object[0]));
        this.CANT_CALCULATE_DIFF = DiffPanelBase.createNotification("Can not calculate diff");
        this.CONTENTS_OPERATION_CANCELED_NOTIFICATION = DiffPanelBase.createNotification("Can not calculate diff. Operation canceled.");
        this.CONTENTS_TOO_BIG_NOTIFICATION = DiffPanelBase.createNotification("Can not calculate diff. File is too big and there are too many changes.");
        this.myProject = project;
        this.myDataProvider = provider;
        this.myContext = context;
        this.myCardLayout = new CardLayout();
        this.myContentPanel = new JPanel(this.myCardLayout);
        this.myNotificationsPanel = new JPanel();
        this.myNotificationsPanel.setLayout(new BoxLayout(this.myNotificationsPanel, 1));
        this.add((Component)this.myContentPanel, "Center");
        JComponent topPanel = this.createTopPanel();
        if (topPanel != null) {
            this.add((Component)topPanel, "North");
        }
        if ((bottomPanel = this.createBottomPanel()) != null) {
            this.add((Component)bottomPanel, "South");
        }
    }

    @Nullable
    public JComponent createTopPanel() {
        return null;
    }

    @Nullable
    public JComponent createBottomPanel() {
        return null;
    }

    public boolean isWindowFocused() {
        return this.myContext.isWindowFocused();
    }

    public boolean isFocused() {
        return this.myContext.isFocused();
    }

    @Override
    public void requestFocus() {
        this.myContext.requestFocus();
    }

    protected void setCurrentCard(@NotNull String card) {
        if (card == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "card", "com/intellij/diff/tools/util/base/DiffPanelBase", "setCurrentCard"));
        }
        this.setCurrentCard(card, true);
    }

    protected void setCurrentCard(@NotNull String card, boolean keepFocus) {
        if (card == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "card", "com/intellij/diff/tools/util/base/DiffPanelBase", "setCurrentCard"));
        }
        boolean restoreFocus = keepFocus && this.isFocused();
        this.myCardLayout.show(this.myContentPanel, card);
        this.myCurrentCard = card;
        this.myContentPanel.revalidate();
        if (restoreFocus) {
            this.requestFocus();
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return this.myDataProvider.getData(dataId);
    }

    @Nullable
    public abstract JComponent getPreferredFocusedComponent();

    public void addContentsEqualNotification() {
        this.myNotificationsPanel.add(this.CONTENTS_EQUAL_NOTIFICATION);
        this.myNotificationsPanel.revalidate();
    }

    public void addTooBigContentNotification() {
        this.myNotificationsPanel.add(this.CONTENTS_TOO_BIG_NOTIFICATION);
        this.myNotificationsPanel.revalidate();
    }

    public void addOperationCanceledNotification() {
        this.myNotificationsPanel.add(this.CONTENTS_OPERATION_CANCELED_NOTIFICATION);
        this.myNotificationsPanel.revalidate();
    }

    public void addDiffErrorNotification() {
        this.myNotificationsPanel.add(this.CANT_CALCULATE_DIFF);
        this.myNotificationsPanel.revalidate();
    }

    public void resetNotifications() {
        this.myNotificationsPanel.removeAll();
        this.myNotificationsPanel.revalidate();
    }

    @NotNull
    public static JPanel createNotification(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/util/base/DiffPanelBase", "createNotification"));
        }
        EditorNotificationPanel editorNotificationPanel = new EditorNotificationPanel().text(text);
        if (editorNotificationPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/DiffPanelBase", "createNotification"));
        }
        return editorNotificationPanel;
    }

    @NotNull
    public static JPanel createNotification(@NotNull String text, final @NotNull Color background) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/util/base/DiffPanelBase", "createNotification"));
        }
        if (background == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/intellij/diff/tools/util/base/DiffPanelBase", "createNotification"));
        }
        EditorNotificationPanel editorNotificationPanel = new EditorNotificationPanel(){

            public Color getBackground() {
                return background;
            }
        }.text(text);
        if (editorNotificationPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/DiffPanelBase", "createNotification"));
        }
        return editorNotificationPanel;
    }
}

