/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.CommonBundle;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExecutableValidator {
    private static final Logger LOG = Logger.getInstance(ExecutableValidator.class);
    private static final NotificationGroup ourNotificationGroup = new NotificationGroup("External Executable Critical Failures", NotificationDisplayType.STICKY_BALLOON, true);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final NotificationsManager myNotificationManager;
    @NotNull
    private final String myNotificationErrorTitle;
    @NotNull
    private final String myNotificationErrorDescription;

    public ExecutableValidator(@NotNull Project project, @NotNull String notificationErrorTitle, @NotNull String notificationErrorDescription) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutableValidator", "<init>"));
        }
        if (notificationErrorTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationErrorTitle", "com/intellij/execution/ExecutableValidator", "<init>"));
        }
        if (notificationErrorDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationErrorDescription", "com/intellij/execution/ExecutableValidator", "<init>"));
        }
        this.myProject = project;
        this.myNotificationErrorTitle = notificationErrorTitle;
        this.myNotificationErrorDescription = notificationErrorDescription;
        this.myNotificationManager = NotificationsManager.getNotificationsManager();
    }

    protected abstract String getCurrentExecutable();

    @NotNull
    protected abstract String getConfigurableDisplayName();

    @Nullable
    protected Notification validate(@NotNull String executable) {
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "com/intellij/execution/ExecutableValidator", "validate"));
        }
        return !this.isExecutableValid(executable) ? this.createDefaultNotification() : null;
    }

    @NotNull
    protected ExecutableNotValidNotification createDefaultNotification() {
        ExecutableNotValidNotification executableNotValidNotification = new ExecutableNotValidNotification(this);
        if (executableNotValidNotification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutableValidator", "createDefaultNotification"));
        }
        return executableNotValidNotification;
    }

    protected boolean isExecutableValid(@NotNull String executable) {
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "com/intellij/execution/ExecutableValidator", "isExecutableValid"));
        }
        return ExecutableValidator.doCheckExecutable(executable, Collections.<String>emptyList());
    }

    protected static boolean doCheckExecutable(@NotNull String executable, @NotNull List<String> processParameters) {
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "com/intellij/execution/ExecutableValidator", "doCheckExecutable"));
        }
        if (processParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processParameters", "com/intellij/execution/ExecutableValidator", "doCheckExecutable"));
        }
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine();
            commandLine.setExePath(executable);
            commandLine.addParameters(processParameters);
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine.createProcess(), CharsetToolkit.getDefaultSystemCharset());
            ProcessOutput result = handler.runProcess(Registry.intValue((String)"vcs.executable.validator.timeout.sec", (int)60) * 1000);
            boolean timeout = result.isTimeout();
            int exitCode = result.getExitCode();
            String stderr = result.getStderr();
            if (timeout) {
                LOG.warn("Validation of " + executable + " failed with a timeout");
            }
            if (exitCode != 0) {
                LOG.warn("Validation of " + executable + " failed with a non-zero exit code: " + exitCode);
            }
            if (!stderr.isEmpty()) {
                LOG.warn("Validation of " + executable + " failed with a non-empty error output: " + stderr);
            }
            return !timeout && exitCode == 0 && stderr.isEmpty();
        }
        catch (Throwable t) {
            LOG.warn(t);
            return false;
        }
    }

    private void showExecutableNotConfiguredNotification(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/execution/ExecutableValidator", "showExecutableNotConfiguredNotification"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        LOG.info("Executable is not valid: " + this.getCurrentExecutable());
        if (this.myNotificationManager.getNotificationsOfType(notification.getClass(), this.myProject).length == 0) {
            notification.notify(this.myProject.isDefault() ? null : this.myProject);
        }
    }

    @NotNull
    protected String prepareDescription(@NotNull String description, boolean appendFixIt) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/execution/ExecutableValidator", "prepareDescription"));
        }
        StringBuilder result = new StringBuilder();
        String executable = this.getCurrentExecutable();
        if (executable.isEmpty()) {
            result.append(String.format("<b>%s</b>%s", this.myNotificationErrorTitle, description));
        } else {
            result.append(String.format("<b>%s:</b> <b>%s</b><br/>%s", this.myNotificationErrorTitle, executable, description));
        }
        if (appendFixIt) {
            result.append(" <a href=''>Fix it.</a>");
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutableValidator", "prepareDescription"));
        }
        return string;
    }

    protected void showSettingsAndExpireIfFixed(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/execution/ExecutableValidator", "showSettingsAndExpireIfFixed"));
        }
        this.showSettings();
        if (this.validate(this.getCurrentExecutable()) == null) {
            notification.expire();
        }
    }

    protected void showSettings() {
        ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, this.getConfigurableDisplayName());
    }

    public boolean checkExecutableAndNotifyIfNeeded() {
        if (this.myProject.isDisposed()) {
            return false;
        }
        Notification notification = this.validate(this.getCurrentExecutable());
        return this.notify(notification);
    }

    protected boolean notify(@Nullable Notification notification) {
        if (notification != null) {
            this.showExecutableNotConfiguredNotification(notification);
            return false;
        }
        return true;
    }

    public boolean checkExecutableAndShowMessageIfNeeded(@Nullable Component parentComponent) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (!this.isExecutableValid(this.getCurrentExecutable())) {
            if (0 == this.showMessage(parentComponent)) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExecutableValidator.this.showSettings();
                    }
                });
            }
            return false;
        }
        return true;
    }

    private int showMessage(@Nullable Component parentComponent) {
        String okText = "Fix it";
        String cancelText = CommonBundle.getCancelButtonText();
        Icon icon = Messages.getErrorIcon();
        String title = this.myNotificationErrorTitle;
        String description = this.myNotificationErrorDescription;
        return parentComponent != null ? Messages.showOkCancelDialog((Component)parentComponent, (String)description, (String)title, (String)okText, (String)cancelText, (Icon)icon) : Messages.showOkCancelDialog((Project)this.myProject, (String)description, (String)title, (String)okText, (String)cancelText, (Icon)icon);
    }

    public boolean isExecutableValid() {
        return this.isExecutableValid(this.getCurrentExecutable());
    }

    public class ExecutableNotValidNotification
    extends Notification {
        final /* synthetic */ ExecutableValidator this$0;

        public ExecutableNotValidNotification(ExecutableValidator executableValidator) {
            this(executableValidator, executableValidator.myNotificationErrorDescription);
        }

        public ExecutableNotValidNotification(@NotNull ExecutableValidator executableValidator, String description) {
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/execution/ExecutableValidator$ExecutableNotValidNotification", "<init>"));
            }
            this(executableValidator, executableValidator.prepareDescription(description, true), NotificationType.ERROR);
        }

        public ExecutableNotValidNotification(@NotNull ExecutableValidator executableValidator, @NotNull String preparedDescription, NotificationType type) {
            if (preparedDescription == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preparedDescription", "com/intellij/execution/ExecutableValidator$ExecutableNotValidNotification", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/execution/ExecutableValidator$ExecutableNotValidNotification", "<init>"));
            }
            this.this$0 = executableValidator;
            super(ourNotificationGroup.getDisplayId(), "", preparedDescription, type, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/execution/ExecutableValidator$ExecutableNotValidNotification$1", "hyperlinkActivated"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/ExecutableValidator$ExecutableNotValidNotification$1", "hyperlinkActivated"));
                    }
                    ExecutableValidator.this.showSettingsAndExpireIfFixed(notification);
                }
            });
        }
    }
}

