/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.ComponentSerializationUtil;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooser;
import com.intellij.openapi.components.StateStorageChooserEx;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.components.impl.stores.IApplicationStore;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.StateStorageBase;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.components.store.ReadOnlyModificationException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.xmlb.JDOMXIncluder;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComponentStoreImpl
implements IComponentStore.Reloadable {
    private static final Logger LOG = Logger.getInstance(ComponentStoreImpl.class);
    private final Map<String, Object> myComponents = Collections.synchronizedMap(new THashMap());
    private final List<SettingsSavingComponent> mySettingsSavingComponents = new CopyOnWriteArrayList<SettingsSavingComponent>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initComponent(@NotNull Object component, boolean service) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "initComponent"));
        }
        if (component instanceof SettingsSavingComponent) {
            this.mySettingsSavingComponents.add((SettingsSavingComponent)component);
        }
        if (!(component instanceof JDOMExternalizable) && !(component instanceof PersistentStateComponent)) {
            return;
        }
        AccessToken token = ReadAction.start();
        try {
            if (component instanceof PersistentStateComponent) {
                this.initPersistentComponent((PersistentStateComponent)component, null, false);
            } else {
                this.initJdomExternalizable((JDOMExternalizable)component);
            }
        }
        catch (StateStorageException e) {
            throw e;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            token.finish();
        }
    }

    @Override
    public final void save(@NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
        StateStorageManager.ExternalizationSession externalizationSession;
        if (readonlyFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readonlyFiles", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "save"));
        }
        StateStorageManager.ExternalizationSession externalizationSession2 = externalizationSession = this.myComponents.isEmpty() ? null : this.getStateStorageManager().startExternalization();
        if (externalizationSession != null) {
            Object[] names = ArrayUtilRt.toStringArray(this.myComponents.keySet());
            Arrays.sort(names);
            for (Object name : names) {
                this.commitComponent(externalizationSession, this.myComponents.get(name), (String)name);
            }
        }
        SmartList errors = null;
        for (SettingsSavingComponent settingsSavingComponent : this.mySettingsSavingComponents) {
            try {
                settingsSavingComponent.save();
            }
            catch (Throwable e) {
                if (errors == null) {
                    errors = new SmartList();
                }
                errors.add((Throwable)e);
            }
        }
        errors = this.doSave(externalizationSession == null ? null : externalizationSession.createSaveSessions(), readonlyFiles, (List<Throwable>)errors);
        CompoundRuntimeException.doThrow(errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveApplicationComponent(@NotNull Object component) {
        File file;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "saveApplicationComponent"));
        }
        StateStorageManager.ExternalizationSession externalizationSession = this.getStateStorageManager().startExternalization();
        if (externalizationSession == null) {
            return;
        }
        this.commitComponent(externalizationSession, component, null);
        List<StateStorage.SaveSession> sessions = externalizationSession.createSaveSessions();
        if (sessions.isEmpty()) {
            return;
        }
        State state = StoreUtil.getStateSpec(component.getClass());
        if (state != null) {
            file = new File(this.getStateStorageManager().expandMacros(ComponentStoreImpl.findNonDeprecated(state.storages()).file()));
        } else if (component instanceof ExportableApplicationComponent && component instanceof NamedJDOMExternalizable) {
            file = PathManager.getOptionsFile((NamedJDOMExternalizable)((NamedJDOMExternalizable)component));
        } else {
            throw new AssertionError((Object)(component.getClass() + " doesn't have @State annotation and doesn't implement ExportableApplicationComponent"));
        }
        AccessToken token = WriteAction.start();
        try {
            VfsRootAccess.allowRootAccess(file.getAbsolutePath());
            CompoundRuntimeException.doThrow(this.doSave(sessions, Collections.<Pair<StateStorage.SaveSession, VirtualFile>>emptyList(), null));
        }
        catch (Throwable throwable) {
            try {
                VfsRootAccess.disallowRootAccess(file.getAbsolutePath());
            }
            finally {
                token.finish();
            }
            throw throwable;
        }
        try {
            VfsRootAccess.disallowRootAccess(file.getAbsolutePath());
        }
        finally {
            token.finish();
        }
    }

    private static Storage findNonDeprecated(Storage[] storages) {
        for (Storage storage : storages) {
            if (storage.deprecated()) continue;
            return storage;
        }
        throw new AssertionError((Object)"All storages are deprecated");
    }

    private void commitComponent(@NotNull StateStorageManager.ExternalizationSession externalizationSession, @NotNull Object component, @Nullable String componentName) {
        if (externalizationSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizationSession", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "commitComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "commitComponent"));
        }
        if (component instanceof PersistentStateComponent) {
            this.commitPersistentComponent((PersistentStateComponent)component, externalizationSession, componentName);
        } else if (component instanceof JDOMExternalizable) {
            externalizationSession.setStateInOldStorage(component, componentName == null ? ComponentManagerImpl.getComponentName(component) : componentName, component);
        }
    }

    @Nullable
    protected List<Throwable> doSave(@Nullable List<StateStorage.SaveSession> saveSessions, @NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles, @Nullable List<Throwable> errors) {
        if (readonlyFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readonlyFiles", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "doSave"));
        }
        if (saveSessions != null) {
            for (StateStorage.SaveSession session : saveSessions) {
                errors = ComponentStoreImpl.executeSave(session, readonlyFiles, errors);
            }
        }
        return errors;
    }

    @Nullable
    protected static List<Throwable> executeSave(@NotNull StateStorage.SaveSession session, @NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles, @Nullable List<Throwable> errors) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "executeSave"));
        }
        if (readonlyFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readonlyFiles", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "executeSave"));
        }
        try {
            session.save();
        }
        catch (ReadOnlyModificationException e) {
            LOG.warn((Throwable)e);
            readonlyFiles.add((Pair<StateStorage.SaveSession, VirtualFile>)Pair.create((Object)(e.getSession() == null ? session : e.getSession()), (Object)e.getFile()));
        }
        catch (Exception e) {
            if (errors == null) {
                errors = new SmartList();
            }
            errors.add((Throwable)e);
        }
        return errors;
    }

    private <T> void commitPersistentComponent(@NotNull PersistentStateComponent<T> component, @NotNull StateStorageManager.ExternalizationSession session, @Nullable String componentName) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "commitPersistentComponent"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "commitPersistentComponent"));
        }
        Object state = component.getState();
        if (state != null) {
            Storage[] storageSpecs = this.getComponentStorageSpecs(component, StoreUtil.getStateSpec(component), StateStorageOperation.WRITE);
            session.setState(storageSpecs, component, componentName == null ? ComponentStoreImpl.getComponentName(component) : componentName, state);
        }
    }

    private void initJdomExternalizable(@NotNull JDOMExternalizable component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "initJdomExternalizable"));
        }
        String componentName = ComponentManagerImpl.getComponentName(component);
        this.doAddComponent(componentName, component);
        if (this.optimizeTestLoading()) {
            return;
        }
        this.loadJdomDefaults(component, componentName);
        StateStorage stateStorage = this.getStateStorageManager().getOldStorage(component, componentName, StateStorageOperation.READ);
        if (stateStorage == null) {
            return;
        }
        Element element = (Element)stateStorage.getState((Object)component, componentName, Element.class, null);
        if (element == null) {
            return;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading configuration for " + component.getClass());
            }
            component.readExternal(element);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
            return;
        }
        this.validateUnusedMacros(componentName, true);
    }

    private void doAddComponent(String componentName, Object component) {
        Object existing = this.myComponents.get(componentName);
        if (existing != null && existing != component) {
            LOG.error("Conflicting component name '" + componentName + "': " + existing.getClass() + " and " + component.getClass());
        }
        this.myComponents.put(componentName, component);
    }

    private void loadJdomDefaults(@NotNull JDOMExternalizable component, @NotNull String componentName) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "loadJdomDefaults"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "loadJdomDefaults"));
        }
        try {
            Element defaultState = this.getDefaultState(component, componentName, Element.class);
            if (defaultState != null) {
                component.readExternal(defaultState);
            }
        }
        catch (Exception e) {
            LOG.error("Cannot load defaults for " + component.getClass(), (Throwable)e);
        }
    }

    @Nullable
    protected Project getProject() {
        return null;
    }

    private void validateUnusedMacros(@Nullable String componentName, boolean service) {
        TrackingPathMacroSubstitutor substitutor;
        Project project = this.getProject();
        if (project == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode() && service && componentName != null && project.isInitialized() && (substitutor = this.getStateStorageManager().getMacroSubstitutor()) != null) {
            StorageUtil.notifyUnknownMacros(substitutor, project, componentName);
        }
    }

    private <T> String initPersistentComponent(@NotNull PersistentStateComponent<T> component, @Nullable Set<StateStorage> changedStorages, boolean reloadData) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "initPersistentComponent"));
        }
        State stateSpec = StoreUtil.getStateSpec(component);
        String name = stateSpec.name();
        if (changedStorages == null || !reloadData) {
            this.doAddComponent(name, component);
        }
        if (this.optimizeTestLoading()) {
            return name;
        }
        Class stateClass = ComponentSerializationUtil.getStateClass(component.getClass());
        if (!stateSpec.defaultStateAsResource() && LOG.isDebugEnabled() && this.getDefaultState(component, name, stateClass) != null) {
            LOG.error(name + " has default state, but not marked to load it");
        }
        Object state = stateSpec.defaultStateAsResource() ? (Object)this.getDefaultState(component, name, stateClass) : null;
        Storage[] storageSpecs = this.getComponentStorageSpecs(component, stateSpec, StateStorageOperation.READ);
        StateStorageChooserEx stateStorageChooser = component instanceof StateStorageChooserEx ? (StateStorageChooserEx)component : null;
        for (Storage storageSpec : storageSpecs) {
            StateStorage stateStorage;
            StateStorageChooserEx.Resolution resolution;
            StateStorageChooserEx.Resolution resolution2 = resolution = stateStorageChooser == null ? StateStorageChooserEx.Resolution.DO : stateStorageChooser.getResolution(storageSpec, StateStorageOperation.READ);
            if (resolution == StateStorageChooserEx.Resolution.SKIP || (stateStorage = this.getStateStorageManager().getStateStorage(storageSpec)) == null || !stateStorage.hasState(component, name, stateClass, reloadData) && (changedStorages == null || !changedStorages.contains(stateStorage))) continue;
            state = stateStorage.getState(component, name, stateClass, state);
            break;
        }
        if (state != null) {
            component.loadState(state);
        }
        this.validateUnusedMacros(name, true);
        return name;
    }

    @Nullable
    protected abstract PathMacroManager getPathMacroManagerForDefaults();

    @Nullable
    protected <T> T getDefaultState(@NotNull Object component, @NotNull String componentName, @NotNull Class<T> stateClass) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getDefaultState"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getDefaultState"));
        }
        if (stateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateClass", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getDefaultState"));
        }
        URL url = DecodeDefaultsUtil.getDefaults(component, componentName);
        if (url == null) {
            return null;
        }
        try {
            Element documentElement = JDOMXIncluder.resolve((Document)JDOMUtil.loadDocument((URL)url), (String)url.toExternalForm()).detachRootElement();
            PathMacroManager pathMacroManager = this.getPathMacroManagerForDefaults();
            if (pathMacroManager != null) {
                pathMacroManager.expandPaths(documentElement);
            }
            return DefaultStateSerializer.deserializeState(documentElement, stateClass, null);
        }
        catch (IOException e) {
            throw new StateStorageException("Error loading state from " + url, (Throwable)e);
        }
        catch (JDOMException e) {
            throw new StateStorageException("Error loading state from " + url, (Throwable)e);
        }
    }

    @NotNull
    public static String getComponentName(@NotNull PersistentStateComponent<?> persistentStateComponent) {
        if (persistentStateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentStateComponent", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentName"));
        }
        String string = StoreUtil.getStateSpec(persistentStateComponent).name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentName"));
        }
        return string;
    }

    @NotNull
    protected <T> Storage[] getComponentStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
        }
        if (stateSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateSpec", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
        }
        Storage[] storages = stateSpec.storages();
        if (storages.length == 1) {
            if (storages == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
            }
            return storages;
        }
        assert (storages.length > 0);
        Class storageChooserClass = stateSpec.storageChooser();
        if (storageChooserClass != StateStorageChooser.class) {
            StateStorageChooser storageChooser = (StateStorageChooser)ReflectionUtil.newInstance((Class)storageChooserClass, (Class[])new Class[0]);
            Storage[] storageArray = storageChooser.selectStorages(storages, component, operation);
            if (storageArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
            }
            return storageArray;
        }
        StateStorageChooser<PersistentStateComponent<?>> defaultStateStorageChooser = this.getDefaultStateStorageChooser();
        if (defaultStateStorageChooser != null) {
            Storage[] storageArray = defaultStateStorageChooser.selectStorages(storages, component, operation);
            if (storageArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
            }
            return storageArray;
        }
        if (component instanceof StateStorageChooserEx) {
            if (storages == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
            }
            return storages;
        }
        int actualStorageCount = 0;
        for (Storage storage : storages) {
            if (storage.deprecated()) continue;
            ++actualStorageCount;
        }
        if (actualStorageCount > 1) {
            LOG.error("State chooser not specified for: " + component.getClass());
        }
        if (!storages[0].deprecated()) {
            boolean othersAreDeprecated = true;
            for (int i = 1; i < storages.length; ++i) {
                if (storages[i].deprecated()) continue;
                othersAreDeprecated = false;
                break;
            }
            if (othersAreDeprecated) {
                if (storages == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
                }
                return storages;
            }
        }
        Storage[] sorted = Arrays.copyOf(storages, storages.length);
        Arrays.sort(sorted, new Comparator<Storage>(){

            @Override
            public int compare(Storage o1, Storage o2) {
                int w1 = o1.deprecated() ? 1 : 0;
                int w2 = o2.deprecated() ? 1 : 0;
                return w1 - w2;
            }
        });
        if (sorted == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getComponentStorageSpecs"));
        }
        return sorted;
    }

    protected boolean optimizeTestLoading() {
        return false;
    }

    @Nullable
    protected StateStorageChooser<PersistentStateComponent<?>> getDefaultStateStorageChooser() {
        return null;
    }

    @Override
    public boolean isReloadPossible(@NotNull Set<String> componentNames) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "isReloadPossible"));
        }
        for (String componentName : componentNames) {
            Object component = this.myComponents.get(componentName);
            if (component == null || component instanceof PersistentStateComponent && StoreUtil.getStateSpec((PersistentStateComponent)component).reloadable()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public final Collection<String> getNotReloadableComponents(@NotNull Collection<String> componentNames) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getNotReloadableComponents"));
        }
        LinkedHashSet<String> notReloadableComponents = null;
        for (String componentName : componentNames) {
            Object component = this.myComponents.get(componentName);
            if (component == null || component instanceof PersistentStateComponent && StoreUtil.getStateSpec((PersistentStateComponent)component).reloadable()) continue;
            if (notReloadableComponents == null) {
                notReloadableComponents = new LinkedHashSet<String>();
            }
            notReloadableComponents.add(componentName);
        }
        Set<String> set = notReloadableComponents == null ? Collections.emptySet() : notReloadableComponents;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "getNotReloadableComponents"));
        }
        return set;
    }

    @Override
    public void reinitComponents(@NotNull Set<String> componentNames, boolean reloadData) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reinitComponents"));
        }
        this.reinitComponents(componentNames, Collections.<String>emptySet(), Collections.<StateStorage>emptySet());
    }

    protected boolean reinitComponent(@NotNull String componentName, @NotNull Set<StateStorage> changedStorages) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reinitComponent"));
        }
        if (changedStorages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedStorages", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reinitComponent"));
        }
        PersistentStateComponent component = (PersistentStateComponent)this.myComponents.get(componentName);
        if (component == null) {
            return false;
        }
        boolean changedStoragesEmpty = changedStorages.isEmpty();
        this.initPersistentComponent(component, changedStoragesEmpty ? null : changedStorages, changedStoragesEmpty);
        return true;
    }

    @NotNull
    protected abstract MessageBus getMessageBus();

    @Override
    @Nullable
    public final Collection<String> reload(@NotNull MultiMap<StateStorage, VirtualFile> changedStorages) {
        if (changedStorages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedStorages", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reload"));
        }
        if (changedStorages.isEmpty()) {
            return Collections.emptySet();
        }
        SmartHashSet componentNames = new SmartHashSet();
        for (StateStorage storage : changedStorages.keySet()) {
            try {
                storage.analyzeExternalChangesAndUpdateIfNeed(changedStorages.get((Object)storage), (Set)componentNames);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        if (componentNames.isEmpty()) {
            return Collections.emptySet();
        }
        Collection<String> notReloadableComponents = this.getNotReloadableComponents((Collection<String>)componentNames);
        this.reinitComponents((Set<String>)componentNames, notReloadableComponents, changedStorages.keySet());
        return notReloadableComponents.isEmpty() ? null : notReloadableComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitComponents(@NotNull Set<String> componentNames, @NotNull Collection<String> notReloadableComponents, @NotNull Set<StateStorage> changedStorages) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reinitComponents"));
        }
        if (notReloadableComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notReloadableComponents", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reinitComponents"));
        }
        if (changedStorages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedStorages", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reinitComponents"));
        }
        MessageBus messageBus = this.getMessageBus();
        ((BatchUpdateListener)messageBus.syncPublisher(BatchUpdateListener.TOPIC)).onBatchUpdateStarted();
        try {
            for (String componentName : componentNames) {
                if (notReloadableComponents.contains(componentName)) continue;
                this.reinitComponent(componentName, changedStorages);
            }
        }
        finally {
            ((BatchUpdateListener)messageBus.syncPublisher(BatchUpdateListener.TOPIC)).onBatchUpdateFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static ReloadComponentStoreStatus reloadStore(@NotNull Collection<Pair<VirtualFile, StateStorage>> changedStorages, @NotNull IComponentStore.Reloadable store) {
        Collection<String> notReloadableComponents;
        if (changedStorages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedStorages", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reloadStore"));
        }
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reloadStore"));
        }
        MultiMap storageToFiles = MultiMap.createLinkedSet();
        for (Pair<VirtualFile, StateStorage> pair : changedStorages) {
            storageToFiles.putValue(pair.second, pair.first);
        }
        boolean willBeReloaded = false;
        AccessToken token = WriteAction.start();
        try {
            notReloadableComponents = store.reload((MultiMap<StateStorage, VirtualFile>)storageToFiles);
        }
        catch (Throwable e) {
            ReloadComponentStoreStatus reloadComponentStoreStatus;
            block17: {
                try {
                    Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                    reloadComponentStoreStatus = ReloadComponentStoreStatus.ERROR;
                    if (willBeReloaded) break block17;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    token.finish();
                }
                for (StateStorage storage : storageToFiles.keySet()) {
                    if (!(storage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)storage).enableSaving();
                }
            }
            ReloadComponentStoreStatus reloadComponentStoreStatus2 = reloadComponentStoreStatus;
            if (reloadComponentStoreStatus2 != null) return reloadComponentStoreStatus2;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reloadStore"));
        }
        token.finish();
        if (ContainerUtil.isEmpty(notReloadableComponents)) {
            ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.SUCCESS;
            ReloadComponentStoreStatus reloadComponentStoreStatus3 = reloadComponentStoreStatus;
            if (reloadComponentStoreStatus3 != null) return reloadComponentStoreStatus3;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reloadStore"));
        }
        willBeReloaded = ComponentStoreImpl.askToRestart(store, notReloadableComponents, changedStorages);
        ReloadComponentStoreStatus reloadComponentStoreStatus = willBeReloaded ? ReloadComponentStoreStatus.RESTART_AGREED : ReloadComponentStoreStatus.RESTART_CANCELLED;
        ReloadComponentStoreStatus reloadComponentStoreStatus4 = reloadComponentStoreStatus;
        if (reloadComponentStoreStatus4 != null) return reloadComponentStoreStatus4;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "reloadStore"));
        finally {
            if (!willBeReloaded) {
                for (StateStorage storage : storageToFiles.keySet()) {
                    if (!(storage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)storage).enableSaving();
                }
            }
        }
    }

    public static boolean askToRestart(@NotNull IComponentStore.Reloadable store, @NotNull Collection<String> notReloadableComponents, @Nullable Collection<Pair<VirtualFile, StateStorage>> changedStorages) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "askToRestart"));
        }
        if (notReloadableComponents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notReloadableComponents", "com/intellij/openapi/components/impl/stores/ComponentStoreImpl", "askToRestart"));
        }
        StringBuilder message = new StringBuilder();
        String storeName = store instanceof IApplicationStore ? "Application" : "Project";
        message.append(storeName).append(' ');
        message.append("components were changed externally and cannot be reloaded:\n\n");
        int count = 0;
        for (String string : notReloadableComponents) {
            if (count == 10) {
                message.append('\n').append("and ").append(notReloadableComponents.size() - count).append(" more").append('\n');
                continue;
            }
            message.append(string).append('\n');
            ++count;
        }
        message.append("\nWould you like to ");
        if (store instanceof IApplicationStore) {
            message.append(ApplicationManager.getApplication().isRestartCapable() ? "restart" : "shutdown").append(' ');
            message.append(ApplicationNamesInfo.getInstance().getProductName()).append('?');
        } else {
            message.append("reload project?");
        }
        if (Messages.showYesNoDialog((String)message.toString(), (String)(storeName + " Files Changed"), (Icon)Messages.getQuestionIcon()) == 0) {
            if (changedStorages != null) {
                for (Pair pair : changedStorages) {
                    StateStorage storage = (StateStorage)pair.getSecond();
                    if (!(storage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)storage).disableSaving();
                }
            }
            return true;
        }
        return false;
    }

    public static enum ReloadComponentStoreStatus {
        RESTART_AGREED,
        RESTART_CANCELLED,
        ERROR,
        SUCCESS;

    }
}

