/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.ex.SweepProcessor;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Segment;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class RangeMarkerTree<T extends RangeMarkerEx>
extends IntervalTreeImpl<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.RangeMarkerTree");
    private static final boolean DEBUG = LOG.isDebugEnabled() || ApplicationManager.getApplication() != null && (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal());
    private final PrioritizedDocumentListener myListener;
    private final Document myDocument;
    private static final int DUPLICATE_LIMIT = 30;

    protected RangeMarkerTree(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/RangeMarkerTree", "<init>"));
        }
        this.myDocument = document;
        this.myListener = new PrioritizedInternalDocumentListener(){

            @Override
            public int getPriority() {
                return 40;
            }

            public void beforeDocumentChange(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent e) {
                RangeMarkerTree.this.updateMarkersOnChange(e);
            }

            @Override
            public void moveTextHappened(int start, int end, int newBase) {
                RangeMarkerTree.this.reTarget(start, end, newBase);
            }
        };
        document.addDocumentListener((DocumentListener)this.myListener);
    }

    @Override
    protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<T> i1, @NotNull IntervalTreeImpl.IntervalNode<T> i2) {
        boolean greedyR2;
        int o2Length;
        boolean greedyL2;
        if (i1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i1", "com/intellij/openapi/editor/impl/RangeMarkerTree", "compareEqualStartIntervals"));
        }
        if (i2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i2", "com/intellij/openapi/editor/impl/RangeMarkerTree", "compareEqualStartIntervals"));
        }
        RMNode o1 = (RMNode)i1;
        RMNode o2 = (RMNode)i2;
        boolean greedyL1 = o1.isGreedyToLeft();
        if (greedyL1 != (greedyL2 = o2.isGreedyToLeft())) {
            return greedyL1 ? -1 : 1;
        }
        int o1Length = o1.intervalEnd() - o1.intervalStart();
        int d = o1Length - (o2Length = o2.intervalEnd() - o2.intervalStart());
        if (d != 0) {
            return d;
        }
        boolean greedyR1 = o1.isGreedyToRight();
        if (greedyR1 != (greedyR2 = o2.isGreedyToRight())) {
            return greedyR1 ? -1 : 1;
        }
        return 0;
    }

    public void dispose() {
        this.myDocument.removeDocumentListener((DocumentListener)this.myListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMNode<T> addInterval(@NotNull T interval, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (interval == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interval", "com/intellij/openapi/editor/impl/RangeMarkerTree", "addInterval"));
        }
        RangeMarkerImpl marker = (RangeMarkerImpl)interval;
        marker.setValid(true);
        RMNode node = (RMNode)super.addInterval(interval, start, end, greedyToLeft, greedyToRight, layer);
        if (DEBUG && !ApplicationInfoImpl.isInPerformanceTest() && node.intervals.size() > 30) {
            this.l.readLock().lock();
            try {
                String msg = this.errMsg(node);
                if (msg != null) {
                    LOG.warn(msg);
                }
            }
            finally {
                this.l.readLock().unlock();
            }
        }
        return node;
    }

    private String errMsg(@NotNull RMNode<T> node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/editor/impl/RangeMarkerTree", "errMsg"));
        }
        final AtomicInteger alive = new AtomicInteger();
        node.processAliveKeys(new Processor<Object>(){

            public boolean process(Object t) {
                alive.incrementAndGet();
                return true;
            }
        });
        if (alive.get() > 30) {
            return "Too many range markers (" + alive + ") registered for interval " + node + "\n";
        }
        return null;
    }

    @Override
    @NotNull
    protected RMNode<T> createNewNode(@NotNull T key, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/RangeMarkerTree", "createNewNode"));
        }
        RMNode<T> rMNode = new RMNode<T>(this, key, start, end, greedyToLeft, greedyToRight);
        if (rMNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/RangeMarkerTree", "createNewNode"));
        }
        return rMNode;
    }

    @Override
    protected void checkBelongsToTheTree(T interval, boolean assertInvalid) {
        assert (((RangeMarkerImpl)interval).myDocument == this.myDocument);
        super.checkBelongsToTheTree(interval, assertInvalid);
    }

    @Override
    protected RMNode<T> lookupNode(@NotNull T key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/RangeMarkerTree", "lookupNode"));
        }
        return ((RangeMarkerImpl)key).myNode;
    }

    @Override
    protected void setNode(@NotNull T key, IntervalTreeImpl.IntervalNode<T> intervalNode) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/RangeMarkerTree", "setNode"));
        }
        ((RangeMarkerImpl)key).myNode = (RMNode)intervalNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMarkersOnChange(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/RangeMarkerTree", "updateMarkersOnChange"));
        }
        try {
            this.l.writeLock().lock();
            if (this.size() == 0) {
                return;
            }
            this.checkMax(true);
            ++this.modCount;
            SmartList affected = new SmartList();
            this.collectAffectedMarkersAndShiftSubtrees(this.getRoot(), e, (List<IntervalTreeImpl.IntervalNode<T>>)affected);
            this.checkMax(false);
            if (!affected.isEmpty()) {
                for (IntervalTreeImpl.IntervalNode node : affected) {
                    int startOffset = node.intervalStart();
                    int endOffset = node.intervalEnd();
                    this.removeNode(node);
                    this.checkMax(false);
                    node.clearDelta();
                    node.setParent(null);
                    node.setLeft(null);
                    node.setRight(null);
                    node.setValid(true);
                    assert (node.intervalStart() == startOffset);
                    assert (node.intervalEnd() == endOffset);
                }
                this.checkMax(true);
                for (IntervalTreeImpl.IntervalNode node : affected) {
                    List keys = node.intervals;
                    if (keys.isEmpty()) continue;
                    RangeMarkerImpl marker = null;
                    for (int i = keys.size() - 1; i >= 0; --i) {
                        Getter key = keys.get(i);
                        marker = (RangeMarkerImpl)key.get();
                        if (marker == null) continue;
                        if (marker.isValid()) break;
                        node.removeIntervalInternal(i);
                        marker = null;
                    }
                    if (marker == null) continue;
                    marker.documentChanged(e);
                    if (marker.isValid()) {
                        RMNode insertedNode = (RMNode)this.findOrInsert(node);
                        if (insertedNode != node) {
                            for (Getter key : keys) {
                                RangeMarkerEx interval = (RangeMarkerEx)key.get();
                                if (interval == null) continue;
                                insertedNode.addInterval(interval);
                            }
                        }
                        assert (marker.isValid());
                        continue;
                    }
                    node.setValid(false);
                }
            }
            this.checkMax(true);
            IntervalTreeImpl.IntervalNode root = this.getRoot();
            assert (root == null || root.maxEnd + root.delta <= this.myDocument.getTextLength());
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    private boolean collectAffectedMarkersAndShiftSubtrees(IntervalTreeImpl.IntervalNode<T> root, @NotNull DocumentEvent e, @NotNull List<IntervalTreeImpl.IntervalNode<T>> affected) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/RangeMarkerTree", "collectAffectedMarkersAndShiftSubtrees"));
        }
        if (affected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affected", "com/intellij/openapi/editor/impl/RangeMarkerTree", "collectAffectedMarkersAndShiftSubtrees"));
        }
        if (root == null) {
            return true;
        }
        boolean norm = this.pushDelta(root);
        int maxEnd = root.maxEnd;
        assert (root.isValid());
        int offset = e.getOffset();
        int affectedEndOffset = offset + e.getOldLength();
        boolean hasAliveKeys = root.hasAliveKey(false);
        if (!hasAliveKeys) {
            affected.add(root);
        }
        if (offset <= maxEnd) {
            if (affectedEndOffset < root.intervalStart()) {
                int lengthDelta = e.getNewLength() - e.getOldLength();
                int newD = root.changeDelta(lengthDelta);
                norm &= newD == 0;
                RedBlackTree.Node left = root.getLeft();
                if (left != null) {
                    int newL = ((IntervalTreeImpl.IntervalNode)left).changeDelta(-lengthDelta);
                    norm &= newL == 0;
                }
                norm &= this.pushDelta(root);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)left, e, affected);
                this.correctMax(root, 0);
            } else {
                if (offset <= root.intervalEnd()) {
                    if (hasAliveKeys) {
                        affected.add(root);
                    }
                    root.setValid(false);
                }
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root.getLeft(), e, affected);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root.getRight(), e, affected);
                this.correctMax(root, 0);
            }
        }
        return norm;
    }

    public boolean sweep(final int start, final int end, @NotNull SweepProcessor<T> sweepProcessor) {
        if (sweepProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sweepProcessor", "com/intellij/openapi/editor/impl/RangeMarkerTree", "sweep"));
        }
        return RangeMarkerTree.sweep(new Generator<T>(){

            @Override
            public boolean generateInStartOffsetOrder(@NotNull Processor<T> processor) {
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/RangeMarkerTree$3", "generateInStartOffsetOrder"));
                }
                return RangeMarkerTree.this.processOverlappingWith(start, end, processor);
            }
        }, sweepProcessor);
    }

    public static <T extends Segment> boolean sweep(@NotNull Generator<T> generator, final @NotNull SweepProcessor<T> sweepProcessor) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/openapi/editor/impl/RangeMarkerTree", "sweep"));
        }
        if (sweepProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sweepProcessor", "com/intellij/openapi/editor/impl/RangeMarkerTree", "sweep"));
        }
        final PriorityQueue ends = new PriorityQueue(5, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.getEndOffset() - o2.getEndOffset();
            }
        });
        final ArrayList starts = new ArrayList();
        if (!generator.generateInStartOffsetOrder(new Processor<T>(){

            public boolean process(T marker) {
                int start;
                block4: {
                    boolean removed;
                    start = marker.getStartOffset();
                    while (true) {
                        int prevEnd;
                        assert (ends.size() == starts.size());
                        Segment previous = (Segment)ends.peek();
                        if (previous == null || (prevEnd = previous.getEndOffset()) > start) break block4;
                        if (!sweepProcessor.process(prevEnd, previous, false, ends)) {
                            return false;
                        }
                        ends.remove();
                        removed = starts.remove(previous);
                        assert (removed);
                    }
                }
                if (!sweepProcessor.process(start, marker, true, ends)) {
                    return false;
                }
                starts.add(marker);
                ends.offer(marker);
                return true;
            }
        })) {
            return false;
        }
        while (!ends.isEmpty()) {
            assert (ends.size() == starts.size());
            Segment previous = (Segment)ends.remove();
            int prevEnd = previous.getEndOffset();
            if (!sweepProcessor.process(prevEnd, previous, false, ends)) {
                return false;
            }
            boolean removed = starts.remove(previous);
            assert (removed);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reTarget(int start, int end, int newBase) {
        this.l.writeLock().lock();
        try {
            this.checkMax(true);
            ArrayList<IntervalTreeImpl.IntervalNode<T>> affected = new ArrayList<IntervalTreeImpl.IntervalNode<T>>();
            this.collectNodesToRetarget(this.getRoot(), start, end, affected);
            if (affected.isEmpty()) {
                return;
            }
            int shift = newBase - start;
            for (IntervalTreeImpl.IntervalNode intervalNode : affected) {
                this.removeNode(intervalNode);
                intervalNode.setLeft(null);
                intervalNode.setRight(null);
                intervalNode.setParent(null);
                intervalNode.changeDelta(shift);
                intervalNode.setValid(true);
                this.pushDelta(intervalNode);
                this.findOrInsert(intervalNode);
            }
        }
        finally {
            this.checkMax(true);
            this.l.writeLock().unlock();
        }
    }

    private void collectNodesToRetarget(IntervalTreeImpl.IntervalNode<T> root, int start, int end, @NotNull List<IntervalTreeImpl.IntervalNode<T>> affected) {
        if (affected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affected", "com/intellij/openapi/editor/impl/RangeMarkerTree", "collectNodesToRetarget"));
        }
        if (root == null) {
            return;
        }
        this.pushDelta(root);
        int maxEnd = root.maxEnd;
        assert (root.isValid());
        if (start > maxEnd) {
            return;
        }
        this.collectNodesToRetarget((IntervalTreeImpl.IntervalNode<T>)root.getLeft(), start, end, affected);
        if (start <= root.intervalStart() && root.intervalEnd() <= end) {
            affected.add(root);
        }
        if (end < root.intervalStart()) {
            return;
        }
        this.collectNodesToRetarget((IntervalTreeImpl.IntervalNode<T>)root.getRight(), start, end, affected);
    }

    public static interface Generator<T> {
        public boolean generateInStartOffsetOrder(@NotNull Processor<T> var1);
    }

    static class RMNode<T extends RangeMarkerEx>
    extends IntervalTreeImpl.IntervalNode<T> {
        private static final byte EXPAND_TO_LEFT_FLAG = 8;
        private static final byte EXPAND_TO_RIGHT_FLAG = 16;

        public RMNode(@NotNull RangeMarkerTree<T> rangeMarkerTree, @NotNull T key, int start, int end, boolean greedyToLeft, boolean greedyToRight) {
            if (rangeMarkerTree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarkerTree", "com/intellij/openapi/editor/impl/RangeMarkerTree$RMNode", "<init>"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/RangeMarkerTree$RMNode", "<init>"));
            }
            super(rangeMarkerTree, key, start, end);
            this.setFlag((byte)8, greedyToLeft);
            this.setFlag((byte)16, greedyToRight);
        }

        public boolean isGreedyToLeft() {
            return this.isFlagSet((byte)8);
        }

        public boolean isGreedyToRight() {
            return this.isFlagSet((byte)16);
        }

        @Override
        public String toString() {
            return (this.isGreedyToLeft() ? "[" : "(") + this.intervalStart() + "," + this.intervalEnd() + (this.isGreedyToRight() ? "]" : ")");
        }
    }
}

