/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemShortcutsManager
implements Disposable {
    private static final String ACTION_ID_PREFIX = "ExternalSystem_";
    @NotNull
    private final Project myProject;
    private ExternalSystemKeyMapListener myKeyMapListener;
    private final List<Listener> myListeners;

    public ExternalSystemShortcutsManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemShortcutsManager", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
    }

    public void init() {
        this.myKeyMapListener = new ExternalSystemKeyMapListener();
    }

    public String getActionId(@Nullable String projectPath, @Nullable String taskName) {
        StringBuilder result = new StringBuilder(ACTION_ID_PREFIX);
        result.append(this.myProject.getLocationHash());
        if (projectPath != null) {
            String portablePath = FileUtil.toSystemIndependentName((String)projectPath);
            File file = new File(portablePath);
            result.append(file.isFile() && file.getParentFile() != null ? file.getParentFile().getName() : file.getName());
            result.append(Integer.toHexString(portablePath.hashCode()));
            if (taskName != null) {
                result.append(taskName);
            }
        }
        return result.toString();
    }

    public String getDescription(@Nullable String projectPath, @Nullable String taskName) {
        String actionId = this.getActionId(projectPath, taskName);
        if (actionId == null) {
            return "";
        }
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = activeKeymap.getShortcuts(actionId);
        if (shortcuts == null || shortcuts.length == 0) {
            return "";
        }
        return KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
    }

    private void fireShortcutsUpdated() {
        for (Listener listener : this.myListeners) {
            listener.shortcutsUpdated();
        }
    }

    public void addListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void scheduleKeymapUpdate(Collection<DataNode<TaskData>> taskData) {
        ExternalSystemKeymapExtension.updateActions(this.myProject, taskData);
    }

    public void scheduleRunConfigurationKeymapUpdate(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemShortcutsManager", "scheduleRunConfigurationKeymapUpdate"));
        }
        ExternalSystemKeymapExtension.updateRunConfigurationActions(this.myProject, externalSystemId);
    }

    public void dispose() {
        if (this.myKeyMapListener != null) {
            this.myKeyMapListener.stopListen();
        }
        ExternalSystemKeymapExtension.clearActions(this.myProject);
    }

    private class ExternalSystemKeyMapListener
    implements KeymapManagerListener,
    Keymap.Listener {
        private Keymap myCurrentKeymap = null;

        public ExternalSystemKeyMapListener() {
            KeymapManager keymapManager = KeymapManager.getInstance();
            this.listenTo(keymapManager.getActiveKeymap());
            keymapManager.addKeymapManagerListener((KeymapManagerListener)this);
        }

        public void activeKeymapChanged(Keymap keymap) {
            this.listenTo(keymap);
            ExternalSystemShortcutsManager.this.fireShortcutsUpdated();
        }

        private void listenTo(Keymap keymap) {
            if (this.myCurrentKeymap != null) {
                this.myCurrentKeymap.removeShortcutChangeListener((Keymap.Listener)this);
            }
            this.myCurrentKeymap = keymap;
            if (this.myCurrentKeymap != null) {
                this.myCurrentKeymap.addShortcutChangeListener((Keymap.Listener)this);
            }
        }

        public void onShortcutChanged(String actionId) {
            ExternalSystemShortcutsManager.this.fireShortcutsUpdated();
        }

        public void stopListen() {
            this.listenTo(null);
            KeymapManagerEx.getInstanceEx().removeKeymapManagerListener(this);
        }
    }

    public static interface Listener {
        public void shortcutsUpdated();
    }
}

