/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerAdapter;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.openapi.externalSystem.action.ExternalSystemViewGearAction;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemTaskLocation;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerAdapter;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewState;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ExternalSystemViewContributor;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.externalSystem.view.TaskNode;
import com.intellij.openapi.externalSystem.view.TasksNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.Consumer;
import com.intellij.util.DisposeAwareRunnable;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalProjectsViewImpl
extends SimpleToolWindowPanel
implements DataProvider,
ExternalProjectsView {
    public static final Logger LOG = Logger.getInstance(ExternalProjectsViewImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExternalProjectsManager myProjectsManager;
    @NotNull
    private final ToolWindowEx myToolWindow;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final ExternalSystemUiAware myUiAware;
    @NotNull
    private final Set<ExternalProjectsView.Listener> listeners;
    @Nullable
    private ExternalProjectsStructure myStructure;
    private SimpleTree myTree;
    @NotNull
    private final NotificationGroup myNotificationGroup;
    private ExternalProjectsViewState myState;

    public ExternalProjectsViewImpl(@NotNull Project project, @NotNull ToolWindowEx toolWindow, @NotNull ProjectSystemId externalSystemId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl", "<init>"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl", "<init>"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl", "<init>"));
        }
        super(true, true);
        this.listeners = ContainerUtil.newHashSet();
        this.myState = new ExternalProjectsViewState();
        this.myProject = project;
        this.myToolWindow = toolWindow;
        this.myExternalSystemId = externalSystemId;
        this.myUiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
        this.myProjectsManager = ExternalProjectsManager.getInstance(this.myProject);
        String toolWindowId = toolWindow instanceof ToolWindowImpl ? ((ToolWindowImpl)toolWindow).getId() : this.myExternalSystemId.getReadableName();
        String notificationId = "notification.group.id." + externalSystemId.getId().toLowerCase(Locale.ENGLISH);
        NotificationGroup registeredGroup = NotificationGroup.findRegisteredGroup((String)notificationId);
        this.myNotificationGroup = registeredGroup != null ? registeredGroup : NotificationGroup.toolWindowGroup((String)notificationId, (String)toolWindowId);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (ExternalSystemDataKeys.VIEW.is(dataId)) {
            return this;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.toolwindows.gradle";
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.extractVirtualFile();
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return this.extractVirtualFiles();
        }
        if (Location.DATA_KEY.is(dataId)) {
            return this.extractLocation();
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.extractNavigatables();
        }
        if (ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.is(dataId)) {
            return this.myExternalSystemId;
        }
        if (ExternalSystemDataKeys.UI_AWARE.is(dataId)) {
            return this.myUiAware;
        }
        if (ExternalSystemDataKeys.SELECTED_PROJECT_NODE.is(dataId)) {
            return this.getSelectedProjectNode();
        }
        if (ExternalSystemDataKeys.SELECTED_NODES.is(dataId)) {
            return this.getSelectedNodes(ExternalSystemNode.class);
        }
        if (ExternalSystemDataKeys.PROJECTS_TREE.is(dataId)) {
            return this.myTree;
        }
        if (ExternalSystemDataKeys.NOTIFICATION_GROUP.is(dataId)) {
            return this.myNotificationGroup;
        }
        return super.getData(dataId);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl", "getProject"));
        }
        return project;
    }

    @Override
    @NotNull
    public ExternalSystemUiAware getUiAware() {
        ExternalSystemUiAware externalSystemUiAware = this.myUiAware;
        if (externalSystemUiAware == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl", "getUiAware"));
        }
        return externalSystemUiAware;
    }

    @Override
    public ExternalSystemShortcutsManager getShortcutsManager() {
        return this.myProjectsManager.getShortcutsManager();
    }

    @Override
    public ExternalSystemTaskActivator getTaskActivator() {
        return this.myProjectsManager.getTaskActivator();
    }

    @Override
    @NotNull
    public ProjectSystemId getSystemId() {
        ProjectSystemId projectSystemId = this.myExternalSystemId;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl", "getSystemId"));
        }
        return projectSystemId;
    }

    @NotNull
    public NotificationGroup getNotificationGroup() {
        NotificationGroup notificationGroup = this.myNotificationGroup;
        if (notificationGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl", "getNotificationGroup"));
        }
        return notificationGroup;
    }

    public void init() {
        this.initTree();
        final ToolWindowManagerEx manager = ToolWindowManagerEx.getInstanceEx(this.myProject);
        final ToolWindowManagerAdapter listener = new ToolWindowManagerAdapter(){
            boolean wasVisible = false;

            @Override
            public void stateChanged() {
                if (ExternalProjectsViewImpl.this.myToolWindow.isDisposed()) {
                    return;
                }
                boolean visible = ExternalProjectsViewImpl.this.myToolWindow.isVisible();
                if (!visible || this.wasVisible) {
                    this.wasVisible = visible;
                    return;
                }
                ExternalProjectsViewImpl.this.scheduleStructureUpdate();
                this.wasVisible = true;
            }
        };
        manager.addToolWindowManagerListener(listener);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                manager.removeToolWindowManagerListener(listener);
            }
        });
        this.getShortcutsManager().addListener(new ExternalSystemShortcutsManager.Listener(){

            @Override
            public void shortcutsUpdated() {
                ExternalProjectsViewImpl.this.scheduleTasksUpdate();
                ExternalProjectsViewImpl.this.scheduleStructureRequest(new Runnable(){

                    @Override
                    public void run() {
                        assert (ExternalProjectsViewImpl.this.myStructure != null);
                        ExternalProjectsViewImpl.this.myStructure.updateNodes(RunConfigurationNode.class);
                    }
                });
            }
        });
        this.getTaskActivator().addListener(new ExternalSystemTaskActivator.Listener(){

            @Override
            public void tasksActivationChanged() {
                ExternalProjectsViewImpl.this.scheduleTasksUpdate();
                ExternalProjectsViewImpl.this.scheduleStructureRequest(new Runnable(){

                    @Override
                    public void run() {
                        assert (ExternalProjectsViewImpl.this.myStructure != null);
                        ExternalProjectsViewImpl.this.myStructure.updateNodes(RunConfigurationNode.class);
                    }
                });
            }
        });
        ((RunManagerEx)RunManager.getInstance((Project)this.myProject)).addRunManagerListener(new RunManagerAdapter(){

            private void changed() {
                ExternalProjectsViewImpl.this.scheduleStructureRequest(new Runnable(){

                    @Override
                    public void run() {
                        assert (ExternalProjectsViewImpl.this.myStructure != null);
                        ExternalProjectsViewImpl.this.myStructure.visitNodes(ModuleNode.class, new Consumer<ModuleNode>(){

                            public void consume(ModuleNode node) {
                                node.updateRunConfigurations();
                            }
                        });
                    }
                });
            }

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl$5", "runConfigurationAdded"));
                }
                this.changed();
            }

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl$5", "runConfigurationRemoved"));
                }
                this.changed();
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl$5", "runConfigurationChanged"));
                }
                this.changed();
            }
        });
        ExternalSystemApiUtil.subscribe((Project)this.myProject, (ProjectSystemId)this.myExternalSystemId, (ExternalSystemSettingsListener)new ExternalSystemSettingsListenerAdapter(){

            public void onUseAutoImportChange(boolean currentValue, final @NotNull String linkedProjectPath) {
                if (linkedProjectPath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPath", "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl$6", "onUseAutoImportChange"));
                }
                ExternalProjectsViewImpl.this.scheduleStructureRequest(new Runnable(){

                    @Override
                    public void run() {
                        assert (ExternalProjectsViewImpl.this.myStructure != null);
                        List<ProjectNode> projectNodes = ExternalProjectsViewImpl.this.myStructure.getNodes(ProjectNode.class);
                        for (ProjectNode projectNode : projectNodes) {
                            ProjectData projectData = (ProjectData)projectNode.getData();
                            if (projectData == null || !projectData.getLinkedExternalProjectPath().equals(linkedProjectPath)) continue;
                            projectNode.updateProject();
                            break;
                        }
                    }
                });
            }
        });
        this.myToolWindow.setAdditionalGearActions(this.createAdditionalGearActionsGroup());
        this.scheduleStructureUpdate();
    }

    @Override
    public void handleDoubleClickOrEnter(@NotNull ExternalSystemNode node, @Nullable String actionId, InputEvent inputEvent) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl", "handleDoubleClickOrEnter"));
        }
        if (actionId != null) {
            ExternalSystemActionUtil.executeAction(actionId, inputEvent);
        }
        for (ExternalProjectsView.Listener listener : this.listeners) {
            listener.onDoubleClickOrEnter(node, inputEvent);
        }
    }

    @Override
    public void addListener(@NotNull ExternalProjectsView.Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl", "addListener"));
        }
        this.listeners.add(listener);
    }

    private ActionGroup createAdditionalGearActionsGroup() {
        String[] ids;
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        for (String id : ids = new String[]{"ExternalSystem.GroupTasks", "ExternalSystem.ShowInheritedTasks"}) {
            AnAction gearAction = actionManager.getAction(id);
            if (!(gearAction instanceof ExternalSystemViewGearAction)) continue;
            ((ExternalSystemViewGearAction)gearAction).setView(this);
            group.add(gearAction);
        }
        return group;
    }

    private void initStructure() {
        this.myStructure = new ExternalProjectsStructure(this.myProject, this.myTree);
        this.myStructure.init(this);
    }

    private void initTree() {
        this.myTree = new SimpleTree();
        this.myTree.getSelectionModel().setSelectionMode(4);
        final ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar actionToolbar = actionManager.createActionToolbar(this.myExternalSystemId.getReadableName() + " View Toolbar", (ActionGroup)((DefaultActionGroup)actionManager.getAction("ExternalSystemView.ActionsToolbar")), true);
        actionToolbar.setTargetComponent((JComponent)this.myTree);
        this.setToolbar(actionToolbar.getComponent());
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myTree));
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup actionGroup;
                String id = this.getMenuId(ExternalProjectsViewImpl.this.getSelectedNodes(ExternalSystemNode.class));
                if (id != null && (actionGroup = (ActionGroup)actionManager.getAction(id)) != null) {
                    actionManager.createActionPopupMenu("", actionGroup).getComponent().show(comp, x, y);
                }
            }

            @Nullable
            private String getMenuId(Collection<? extends ExternalSystemNode> nodes) {
                String id = null;
                for (ExternalSystemNode externalSystemNode : nodes) {
                    String menuId = externalSystemNode.getMenuId();
                    if (menuId == null) {
                        return null;
                    }
                    if (id == null) {
                        id = menuId;
                        continue;
                    }
                    if (id.equals(menuId)) continue;
                    return null;
                }
                return id;
            }
        });
    }

    public void scheduleStructureUpdate() {
        this.scheduleStructureRequest(new Runnable(){

            @Override
            public void run() {
                Collection<ExternalProjectInfo> projectsData = ProjectDataManager.getInstance().getExternalProjectsData(ExternalProjectsViewImpl.this.myProject, ExternalProjectsViewImpl.this.myExternalSystemId);
                List toImport = ContainerUtil.mapNotNull(projectsData, (Function)new Function<ExternalProjectInfo, DataNode<ProjectData>>(){

                    public DataNode<ProjectData> fun(ExternalProjectInfo info) {
                        return info.getExternalProjectStructure();
                    }
                });
                assert (ExternalProjectsViewImpl.this.myStructure != null);
                ExternalProjectsViewImpl.this.myStructure.updateProjects(toImport);
            }
        });
    }

    protected boolean isUnitTestMode() {
        return ApplicationManager.getApplication().isUnitTestMode();
    }

    public static void invokeLater(Project p, Runnable r) {
        ExternalProjectsViewImpl.invokeLater(p, ModalityState.defaultModalityState(), r);
    }

    public static void invokeLater(Project p, ModalityState state, Runnable r) {
        if (ExternalProjectsViewImpl.isNoBackgroundMode()) {
            r.run();
        } else {
            ApplicationManager.getApplication().invokeLater(DisposeAwareRunnable.create((Runnable)r, (Project)p), state);
        }
    }

    public static boolean isNoBackgroundMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    @Override
    public void updateUpTo(ExternalSystemNode node) {
        ExternalProjectsStructure structure = this.getStructure();
        if (structure != null) {
            structure.updateUpTo(node);
        }
    }

    @Override
    @Nullable
    public ExternalProjectsStructure getStructure() {
        return this.myStructure;
    }

    @Override
    @NotNull
    public List<ExternalSystemNode<?>> createNodes(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode<?> parent, @NotNull DataNode<?> dataNode) {
        if (externalProjectsView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectsView", "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl", "createNodes"));
        }
        if (dataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNode", "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl", "createNodes"));
        }
        SmartList result = new SmartList();
        Map groups = ExternalSystemApiUtil.group((Collection)dataNode.getChildren());
        for (ExternalSystemViewContributor contributor : (ExternalSystemViewContributor[])ExternalSystemViewContributor.EP_NAME.getExtensions()) {
            List<Key<?>> keys = contributor.getKeys();
            MultiMap dataNodes = MultiMap.create();
            for (Key<?> key : keys) {
                List values = (List)groups.get(key);
                if (key == null || values == null) continue;
                dataNodes.put(key, (Collection)values);
            }
            if (dataNodes.isEmpty()) continue;
            List<ExternalSystemNode<?>> childNodes = contributor.createNodes(externalProjectsView, dataNodes);
            result.addAll(childNodes);
            if (parent == null) continue;
            for (ExternalSystemNode<?> childNode : childNodes) {
                childNode.setParent(parent);
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/view/ExternalProjectsViewImpl", "createNodes"));
        }
        return smartList;
    }

    @Nullable
    public ExternalProjectsViewState getState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myStructure != null) {
            try {
                this.myState.treeState = new Element("root");
                TreeState.createOn((JTree)this.myTree).writeExternal(this.myState.treeState);
            }
            catch (WriteExternalException e) {
                LOG.warn((Throwable)e);
            }
        }
        return this.myState;
    }

    public void loadState(ExternalProjectsViewState state) {
        this.myState = state;
    }

    @Override
    public boolean getGroupTasks() {
        return this.myState.groupTasks;
    }

    public void setGroupTasks(boolean value) {
        if (this.myState.groupTasks != value) {
            this.myState.groupTasks = value;
            this.scheduleTasksRebuild();
        }
    }

    @Override
    public boolean showInheritedTasks() {
        return this.myState.showInheritedTasks;
    }

    public void setShowInheritedTasks(boolean value) {
        if (this.myState.showInheritedTasks != value) {
            this.myState.showInheritedTasks = value;
            this.scheduleStructureUpdate();
        }
    }

    private void scheduleTasksRebuild() {
        this.scheduleStructureRequest(new Runnable(){

            @Override
            public void run() {
                assert (ExternalProjectsViewImpl.this.myStructure != null);
                List<TasksNode> tasksNodes = ExternalProjectsViewImpl.this.myStructure.getNodes(TasksNode.class);
                for (TasksNode tasksNode : tasksNodes) {
                    tasksNode.cleanUpCache();
                    ExternalProjectsViewImpl.this.updateUpTo(tasksNode);
                }
            }
        });
    }

    private void scheduleTasksUpdate() {
        this.scheduleStructureRequest(new Runnable(){

            @Override
            public void run() {
                assert (ExternalProjectsViewImpl.this.myStructure != null);
                ExternalProjectsViewImpl.this.myStructure.updateNodes(TaskNode.class);
            }
        });
    }

    private void scheduleStructureRequest(final Runnable r) {
        if (this.isUnitTestMode()) {
            r.run();
            return;
        }
        ExternalProjectsViewImpl.invokeLater(this.myProject, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean shouldCreate;
                if (!ExternalProjectsViewImpl.this.myToolWindow.isVisible()) {
                    return;
                }
                boolean bl = shouldCreate = ExternalProjectsViewImpl.this.myStructure == null;
                if (shouldCreate) {
                    ExternalProjectsViewImpl.this.initStructure();
                }
                ExternalProjectsViewImpl.this.myTree.setPaintBusy(true);
                try {
                    r.run();
                    if (shouldCreate) {
                        ExternalProjectsViewImpl.this.restoreTreeState();
                    }
                }
                finally {
                    ExternalProjectsViewImpl.this.myTree.setPaintBusy(false);
                }
            }
        });
    }

    private void restoreTreeState() {
        if (this.myState.treeState != null) {
            TreeState treeState = new TreeState();
            try {
                treeState.readExternal(this.myState.treeState);
                treeState.applyTo((JTree)this.myTree);
            }
            catch (InvalidDataException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    private <T extends ExternalSystemNode> List<T> getSelectedNodes(Class<T> aClass) {
        return this.myStructure != null ? this.myStructure.getSelectedNodes(this.myTree, aClass) : ContainerUtil.emptyList();
    }

    private List<ProjectNode> getSelectedProjectNodes() {
        return this.getSelectedNodes(ProjectNode.class);
    }

    @Nullable
    private ProjectNode getSelectedProjectNode() {
        List<ProjectNode> projectNodes = this.getSelectedProjectNodes();
        return projectNodes.size() == 1 ? projectNodes.get(0) : null;
    }

    @Nullable
    private Location extractLocation() {
        List<ExternalSystemNode> selectedNodes = this.getSelectedNodes(ExternalSystemNode.class);
        if (selectedNodes.isEmpty()) {
            return null;
        }
        List tasks = ContainerUtil.newSmartList();
        ExternalTaskExecutionInfo taskExecutionInfo = new ExternalTaskExecutionInfo();
        String projectPath = null;
        for (ExternalSystemNode node : selectedNodes) {
            Object data = node.getData();
            if (!(data instanceof TaskData)) continue;
            TaskData taskData = (TaskData)data;
            if (projectPath == null) {
                projectPath = taskData.getLinkedExternalProjectPath();
            } else if (!taskData.getLinkedExternalProjectPath().equals(projectPath)) {
                return null;
            }
            taskExecutionInfo.getSettings().getTaskNames().add(taskData.getName());
            taskExecutionInfo.getSettings().getTaskDescriptions().add(taskData.getDescription());
            tasks.add(taskData);
        }
        if (tasks.isEmpty()) {
            return null;
        }
        taskExecutionInfo.getSettings().setExternalSystemIdString(this.myExternalSystemId.toString());
        taskExecutionInfo.getSettings().setExternalProjectPath(projectPath);
        String name = this.myExternalSystemId.getReadableName() + projectPath + StringUtil.join((Collection)taskExecutionInfo.getSettings().getTaskNames(), (String)" ");
        PsiFile file = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(name, (FileType)PlainTextFileType.INSTANCE, (CharSequence)"");
        return new ExternalSystemTaskLocation(this.myProject, file, taskExecutionInfo);
    }

    private VirtualFile extractVirtualFile() {
        for (ExternalSystemNode each : this.getSelectedNodes(ExternalSystemNode.class)) {
            VirtualFile file = each.getVirtualFile();
            if (file == null || !file.isValid()) continue;
            return file;
        }
        ProjectNode projectNode = this.getSelectedProjectNode();
        if (projectNode == null) {
            return null;
        }
        VirtualFile file = projectNode.getVirtualFile();
        if (file == null || !file.isValid()) {
            return null;
        }
        return file;
    }

    private Object extractVirtualFiles() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (ExternalSystemNode each : this.getSelectedNodes(ExternalSystemNode.class)) {
            VirtualFile file = each.getVirtualFile();
            if (file == null || !file.isValid()) continue;
            files.add(file);
        }
        return files.isEmpty() ? null : VfsUtilCore.toVirtualFileArray(files);
    }

    private Object extractNavigatables() {
        ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
        for (ExternalSystemNode each : this.getSelectedNodes(ExternalSystemNode.class)) {
            Navigatable navigatable = each.getNavigatable();
            if (navigatable == null) continue;
            navigatables.add(navigatable);
        }
        return navigatables.isEmpty() ? null : navigatables.toArray(new Navigatable[navigatables.size()]);
    }
}

