/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeRequestChain;
import com.intellij.openapi.vcs.changes.actions.ChangeDiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentableProxy;
import com.intellij.openapi.vcs.changes.actions.ShowChangeAbstractAction;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.ui.awt.RelativePoint;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSelectedChangeAction
extends ShowChangeAbstractAction {
    private static final Logger LOG = Logger.getInstance(ShowSelectedChangeAction.class);
    private JBPopup myPopup;

    @Override
    protected boolean isEnabled(@NotNull ChangeRequestChain chain) {
        if (chain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chain", "com/intellij/openapi/vcs/changes/actions/ShowSelectedChangeAction", "isEnabled"));
        }
        return ShowSelectedChangeAction.getChangesFromRequests(chain.getAllRequests()).size() > 1;
    }

    @Override
    protected void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull ChangeRequestChain chain, @NotNull DiffViewer diffViewer) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/ShowSelectedChangeAction", "actionPerformed"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/ShowSelectedChangeAction", "actionPerformed"));
        }
        if (chain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chain", "com/intellij/openapi/vcs/changes/actions/ShowSelectedChangeAction", "actionPerformed"));
        }
        if (diffViewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffViewer", "com/intellij/openapi/vcs/changes/actions/ShowSelectedChangeAction", "actionPerformed"));
        }
        List requests = chain.getAllRequests();
        List<Change> changes = ShowSelectedChangeAction.getChangesFromRequests(requests);
        MyChangesBrowser cb = new MyChangesBrowser(project, changes, requests, chain, diffViewer);
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)cb, cb.getPreferredFocusedComponent()).setResizable(true).setModalContext(false).setFocusable(true).setRequestFocus(true).setCancelOnWindowDeactivation(true).setCancelOnOtherWindowOpen(true).setMovable(true).setCancelKeyEnabled(true).setCancelOnClickOutside(true).createPopup();
        InputEvent event = e.getInputEvent();
        if (event instanceof MouseEvent) {
            this.myPopup.show(new RelativePoint((MouseEvent)event));
        } else {
            this.myPopup.showInBestPositionFor(e.getDataContext());
        }
    }

    @NotNull
    private static List<Change> getChangesFromRequests(@NotNull List<DiffRequestPresentable> requests) {
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/openapi/vcs/changes/actions/ShowSelectedChangeAction", "getChangesFromRequests"));
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        for (DiffRequestPresentable step : requests) {
            Change change = ShowSelectedChangeAction.getChange(step);
            if (change == null) continue;
            changes.add(change);
        }
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ShowSelectedChangeAction", "getChangesFromRequests"));
        }
        return arrayList;
    }

    @Nullable
    private static Change getChange(@NotNull DiffRequestPresentable presentable) {
        if (presentable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentable", "com/intellij/openapi/vcs/changes/actions/ShowSelectedChangeAction", "getChange"));
        }
        if (presentable instanceof DiffRequestPresentableProxy) {
            try {
                presentable = ((DiffRequestPresentableProxy)presentable).init();
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
        if (presentable instanceof ChangeDiffRequestPresentable) {
            return ((ChangeDiffRequestPresentable)presentable).getChange();
        }
        return null;
    }

    private class MyChangesBrowser
    extends ChangesBrowser
    implements Runnable {
        private final List<DiffRequestPresentable> myRequests;
        private final ChangeRequestChain myChain;
        private final DiffViewer myDiffViewer;

        public MyChangesBrowser(@NotNull Project project, @NotNull List<Change> changes, @NotNull List<DiffRequestPresentable> requests, @NotNull ChangeRequestChain chain, DiffViewer diffViewer) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/ShowSelectedChangeAction$MyChangesBrowser", "<init>"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/ShowSelectedChangeAction$MyChangesBrowser", "<init>"));
            }
            if (requests == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/openapi/vcs/changes/actions/ShowSelectedChangeAction$MyChangesBrowser", "<init>"));
            }
            if (chain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chain", "com/intellij/openapi/vcs/changes/actions/ShowSelectedChangeAction$MyChangesBrowser", "<init>"));
            }
            if (diffViewer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffViewer", "com/intellij/openapi/vcs/changes/actions/ShowSelectedChangeAction$MyChangesBrowser", "<init>"));
            }
            super(project, null, changes, null, false, false, null, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
            this.myRequests = requests;
            this.myChain = chain;
            this.myDiffViewer = diffViewer;
            this.setSelectionMode(0);
            this.setChangesToDisplay(changes);
        }

        @Override
        protected void buildToolBar(DefaultActionGroup toolBarGroup) {
        }

        @Override
        @NotNull
        protected Runnable getDoubleClickHandler() {
            MyChangesBrowser myChangesBrowser = this;
            if (myChangesBrowser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ShowSelectedChangeAction$MyChangesBrowser", "getDoubleClickHandler"));
            }
            return myChangesBrowser;
        }

        @Override
        public void run() {
            Change change = this.getSelectedChanges().get(0);
            DiffRequestPresentable selectedStep = this.findSelectedStep(change);
            if (selectedStep != null) {
                DiffRequest newRequest = this.myChain.moveTo(selectedStep);
                ShowSelectedChangeAction.this.openRequest(this.myDiffViewer, newRequest);
            }
            ShowSelectedChangeAction.this.myPopup.cancel();
        }

        @Nullable
        private DiffRequestPresentable findSelectedStep(@Nullable Change change) {
            for (DiffRequestPresentable step : this.myRequests) {
                Change c = ShowSelectedChangeAction.getChange(step);
                if (c == null || !c.equals((Object)change)) continue;
                return step;
            }
            return null;
        }
    }
}

