/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Range {
    private static final Logger LOG = Logger.getInstance(Range.class);
    public static final byte EQUAL = 0;
    public static final byte MODIFIED = 1;
    public static final byte INSERTED = 2;
    public static final byte DELETED = 3;
    private int myLine1;
    private int myLine2;
    private final int myVcsLine1;
    private final int myVcsLine2;
    private final byte myType;
    @Nullable
    private RangeHighlighter myRangeHighlighter;
    @Nullable
    private final List<InnerRange> myInnerRanges;
    private boolean myValid;

    public Range(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/Range", "<init>"));
        }
        this(range.getLine1(), range.getLine2(), range.getVcsLine1(), range.getVcsLine2(), range.getType());
    }

    public Range(int line1, int line2, int vcsLine1, int vcsLine2, byte type) {
        this(line1, line2, vcsLine1, vcsLine2, type, null);
    }

    public Range(int line1, int line2, int vcsLine1, int vcsLine2, byte type, @Nullable List<InnerRange> innerRanges) {
        this.myValid = true;
        this.myLine1 = line1;
        this.myLine2 = line2;
        this.myVcsLine1 = vcsLine1;
        this.myVcsLine2 = vcsLine2;
        this.myType = type;
        this.myInnerRanges = innerRanges;
    }

    public int hashCode() {
        return this.myVcsLine1 ^ this.myVcsLine2 ^ this.myType ^ this.myLine1 ^ this.myLine2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Range)) {
            return false;
        }
        Range other = (Range)object;
        if (this.myInnerRanges != null) {
            if (other.myInnerRanges == null) {
                return false;
            }
            if (this.myInnerRanges.size() != other.myInnerRanges.size()) {
                return false;
            }
            for (int i = 0; i < this.myInnerRanges.size(); ++i) {
                if (this.myInnerRanges.get(i).equals(other.myInnerRanges.get(i))) continue;
                return false;
            }
        } else if (other.myInnerRanges != null) {
            return false;
        }
        return this.myVcsLine1 == other.myVcsLine1 && this.myVcsLine2 == other.myVcsLine2 && this.myLine1 == other.myLine1 && this.myLine2 == other.myLine2 && this.myType == other.myType;
    }

    public String toString() {
        return String.format("%s, %s, %s, %s, %s", this.myLine1, this.myLine2, this.myVcsLine1, this.myVcsLine2, this.getTypeName());
    }

    @NonNls
    private String getTypeName() {
        switch (this.myType) {
            case 1: {
                return "MODIFIED";
            }
            case 2: {
                return "INSERTED";
            }
            case 3: {
                return "DELETED";
            }
        }
        return "UNKNOWN";
    }

    public byte getType() {
        return this.myType;
    }

    public int getUpToDateRangeLength() {
        return this.myVcsLine2 - this.myVcsLine1;
    }

    public void shift(int shift) {
        this.myLine1 += shift;
        this.myLine2 += shift;
        if (this.myInnerRanges != null) {
            for (InnerRange range : this.myInnerRanges) {
                range.shift(shift);
            }
        }
    }

    @Nullable
    public List<InnerRange> getInnerRanges() {
        return this.myInnerRanges;
    }

    public int getLine1() {
        return this.myLine1;
    }

    public int getLine2() {
        return this.myLine2;
    }

    public int getVcsLine1() {
        return this.myVcsLine1;
    }

    public int getVcsLine2() {
        return this.myVcsLine2;
    }

    public boolean rightBefore(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/Range", "rightBefore"));
        }
        return this.myLine2 == range.myLine1;
    }

    public boolean hasHighlighter() {
        return this.myRangeHighlighter != null;
    }

    public void setHighlighter(RangeHighlighter highlighter) {
        this.myRangeHighlighter = highlighter;
    }

    @Nullable
    public RangeHighlighter getHighlighter() {
        return this.myRangeHighlighter;
    }

    public boolean isValid() {
        return this.myValid;
    }

    public void invalidate() {
        this.myValid = false;
    }

    public boolean isSelectedByLine(int line) {
        if (this.getType() == 3 && line == this.myLine1) {
            return true;
        }
        return line >= this.myLine1 && line < this.myLine2;
    }

    public static class InnerRange {
        private int myLine1;
        private int myLine2;
        private final byte myType;

        public InnerRange(int line1, int line2, byte type) {
            this.myLine1 = line1;
            this.myLine2 = line2;
            this.myType = type;
        }

        public int getLine1() {
            return this.myLine1;
        }

        public int getLine2() {
            return this.myLine2;
        }

        public byte getType() {
            return this.myType;
        }

        public void shift(int shift) {
            this.myLine1 += shift;
            this.myLine2 += shift;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InnerRange range = (InnerRange)o;
            if (this.myLine2 != range.myLine2) {
                return false;
            }
            if (this.myLine1 != range.myLine1) {
                return false;
            }
            return this.myType == range.myType;
        }

        public int hashCode() {
            int result = this.myLine1;
            result = 31 * result + this.myLine2;
            result = 31 * result + this.myType;
            return result;
        }

        public String toString() {
            return String.format("%s, %s, %s", this.myLine1, this.myLine2, this.getTypeName());
        }

        @NonNls
        private String getTypeName() {
            switch (this.myType) {
                case 1: {
                    return "MODIFIED";
                }
                case 2: {
                    return "INSERTED";
                }
                case 3: {
                    return "DELETED";
                }
                case 0: {
                    return "EQUAL";
                }
            }
            return "UNKNOWN";
        }
    }
}

