/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.makeStatic;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.makeStatic.MakeClassStaticProcessor;
import com.intellij.refactoring.makeStatic.MakeMethodStaticProcessor;
import com.intellij.refactoring.makeStatic.Settings;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.VariableData;
import com.intellij.usageView.UsageViewUtil;
import javax.swing.JLabel;

public abstract class AbstractMakeStaticDialog
extends RefactoringDialog {
    protected final PsiTypeParameterListOwner myMember;
    protected final String myMemberName;

    public AbstractMakeStaticDialog(Project project, PsiTypeParameterListOwner member) {
        super(project, true);
        this.myMember = member;
        this.myMemberName = member.getName();
    }

    @Override
    protected void doAction() {
        if (!this.validateData()) {
            return;
        }
        Settings settings = new Settings(this.isReplaceUsages(), this.isMakeClassParameter() ? this.getClassParameterName() : null, this.getVariableData(), this.isGenerateDelegate());
        if (this.myMember instanceof PsiMethod) {
            this.invokeRefactoring(new MakeMethodStaticProcessor(this.getProject(), (PsiMethod)this.myMember, settings));
        } else {
            this.invokeRefactoring(new MakeClassStaticProcessor(this.getProject(), (PsiClass)this.myMember, settings));
        }
    }

    protected boolean isGenerateDelegate() {
        return false;
    }

    protected abstract boolean validateData();

    public abstract boolean isMakeClassParameter();

    public abstract String getClassParameterName();

    public abstract VariableData[] getVariableData();

    public abstract boolean isReplaceUsages();

    protected JLabel createDescriptionLabel() {
        String type = UsageViewUtil.getType((PsiElement)this.myMember);
        return new JLabel(RefactoringBundle.message((String)"make.static.description.label", (Object[])new Object[]{type, this.myMemberName}));
    }
}

